/* $Header: /fridge/cvs/xscorch/sgtk/swidgets/sbar.c,v 1.2 2001/04/07 19:46:50 justins Exp $ */
/*
   
   xscorch - sbar.c           Copyright(c) 2001,2000 Justin David Smith
   justins(at)chaos2.org      http://chaos2.org/
    
   Draw a colored bar
    

   This program is free software; you can redistribute it and/or modify 
   it under the terms of the GNU General Public License as published by 
   the Free Software Foundation; either version 2 of the License, or 
   (at your option) any later version.

   This program is distributed in the hope that it will be useful, 
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation, 
   Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#include <sbar.h>



static ScDrawbufClass *parent_class;



static void _sc_bar_draw(ScBar *bar) {
   
   ScDrawbuf *draw = SC_DRAWBUF(bar);
   gint width = GTK_WIDGET(bar)->allocation.width;
   gint height= GTK_WIDGET(bar)->allocation.height;
   
   if(draw->screen_buffer == NULL) return;

   gdk_draw_rectangle(draw->screen_buffer, 
                      GTK_WIDGET(bar)->style->black_gc,
                      TRUE,
                      0, 0,
                      width, height);

   gdk_draw_rectangle(draw->screen_buffer,
                      draw->screen_gc,
                      TRUE,
                      0, 0,
                      width * bar->value / bar->max, height);

   sc_drawbuf_queue_draw(draw, 0, 0, width, height);
   
}



static gint _sc_bar_configure(GtkWidget *widget, GdkEventConfigure *event) {

   /* Call parent class handler? */
   if(GTK_WIDGET_CLASS(parent_class)->configure_event != NULL) {
      if(GTK_WIDGET_CLASS(parent_class)->configure_event(widget, event)) {
         /* We must halt. */
         return(TRUE);
      } /* Can we continue? */
   } /* Call parent handler? */

   _sc_bar_draw(SC_BAR(widget));
   return(FALSE);

}



static void _sc_bar_class_init(ScBarClass *klass) {

   /* Determine the parent class */
   parent_class = gtk_type_class(sc_drawbuf_get_type());
   
   /* Latch default hooks */
   GTK_WIDGET_CLASS(klass)->configure_event = _sc_bar_configure;
   
}



static void _sc_bar_init_obj(ScBar *bar) {

   /* Initialise data members */
   bar->value = 0;
   bar->max = 1;

}



GtkType sc_bar_get_type(void) {

   static GtkType sc_bar_type = 0;
   
   if(sc_bar_type == 0) {
      static const GtkTypeInfo sc_bar_info = {
         (char *)"ScBar",
         sizeof(ScBar),
         sizeof(ScBarClass),
         (GtkClassInitFunc)_sc_bar_class_init,
         (GtkObjectInitFunc)_sc_bar_init_obj,
         (GtkArgSetFunc)NULL,
         (GtkArgGetFunc)NULL
      };
      sc_bar_type = gtk_type_unique(sc_drawbuf_get_type(), &sc_bar_info);
   }

   return(sc_bar_type);

}



GtkWidget *sc_bar_new(long max) {

   ScBar *bar;

   /* Allocate the object */
   bar = gtk_type_new(sc_bar_get_type());
   g_return_val_if_fail(bar != NULL, NULL);

   /* Initialise maximum value */
   bar->max = max;

   /* Return the new object */
   return(GTK_WIDGET(bar));

}



void sc_bar_set_value(ScBar *bar, long value) {

   if(value < 0)        value = 0;
   if(value > bar->max) value = bar->max;
   bar->value = value;
   _sc_bar_draw(bar);

}



void sc_bar_set_foreground(ScBar *bar, GdkColor *color) {

   gdk_gc_set_foreground(SC_DRAWBUF(bar)->screen_gc, color);
   _sc_bar_draw(bar);

}
