/* $Header: /fridge/cvs/xscorch/sgame/shelp.c,v 1.2 2001/07/16 02:54:11 justins Exp $ */
/*
  
   xscorch - shelp.c          Copyright(c) 2001 Justin David Smith
   justins(at)chaos2.org      http://chaos2.org/

   Scorched simple help system


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#include <stdio.h>
#include <stdlib.h>
#include <xscorch.h>
#include <shelp.h>
#include <sstr.h>



static void _unmunge_line(char *buf) {

   char *d = buf;
   char *s = buf;
   while(*s != '\0') {
      if(strncmpn(s, "\\-", 2)) {
         *d = '-';
         ++d;
         ++s;
      } else if(strncmpn(s, "\\f", 2)) {
         s += 2;
      } else {
         *d = *s;
         ++d;
      }
      ++s;
   }
   *d = '\0';

}



static void _trim_line(char *buf) {

   bool countedspace = true;
   char *d = buf;
   char *s = buf;
   while(*s != '\0') {
      if(*s == ' ' || *s == '\t' || *s == '\n') {
         if(!countedspace) {
            countedspace = true;
            *d = ' ';
            ++d;
         }
      } else {
         countedspace = false;
         *d = *s;
         ++d;
      }
      ++s;
   }
   if(countedspace && d > buf) --d;
   *d = '\0';
   
}



void sc_help_text(char *res, int size, const char *idphrase) {
/* sc_help_text */

   char buf[0x1000];
   char key[0x1000];
   int keysize;
   bool match;
   bool done;
   FILE *f;

   /* Sanity checks */
   if(res == NULL || size <= 0 || idphrase == NULL) return;
   
   /* Prep and size the ID string */
   snprintfn(key, sizeof(key), "\\fB%s\\fP", idphrase);
   keysize = strlen(key);

   /* Attempt to open help file */
   if((f = fopen(SC_GROFF_MANUAL_FILE, "r")) == NULL) {
      snprintfn(res, size, "Cannot open help file %s.", SC_GROFF_MANUAL_FILE);
      return;
   }
   
   /* Scan help file for the requested text */
   match = false;
   while(!match && fgets(buf, sizeof(buf), f) != NULL) {
      match = strncmpn(buf, key, keysize);
   }
   
   /* Make sure we found something */
   if(!match) {
      snprintfn(res, size, "Cannot find help text for %s.", idphrase);
      fclose(f);
      return;
   }
   
   /* Start writing data to the result buffer until we reach a blank line */
   done = false;
   strncpyn(res, idphrase, size);
   strncatn(res, ": ", size);
   while(!done && fgets(buf, sizeof(buf), f) != NULL) {
      if(*buf == '.' && !strncmpn(buf, ".\\\"", 3)) done = true;
      else {
         /* Copy this line (unmunged) into the help buffer */
         strncatn(res, buf, size);
      }
   }
   
   /* We are done! */
   _unmunge_line(res);
   _trim_line(res);
   fclose(f);
   
}

