/*
 * Copyright (c) 2001-2009 XORP, Inc.
 * See the XORP LICENSE.lgpl file for licensing, conditions, and warranties
 * on use.
 *
 * DO NOT EDIT THIS FILE - IT IS PROGRAMMATICALLY GENERATED
 *
 * Generated by 'clnt-gen'.
 *
 * $XORP: xorp/xrl/interfaces/olsr4_xif.hh,v 1.5 2009/01/05 18:31:13 jtc Exp $
 */

#ifndef __XRL_INTERFACES_OLSR4_XIF_HH__
#define __XRL_INTERFACES_OLSR4_XIF_HH__

#undef XORP_LIBRARY_NAME
#define XORP_LIBRARY_NAME "XifOlsr4"

#include "libxorp/xlog.h"
#include "libxorp/callback.hh"

#include "libxipc/xrl.hh"
#include "libxipc/xrl_error.hh"
#include "libxipc/xrl_sender.hh"


class XrlOlsr4V0p1Client {
public:
    XrlOlsr4V0p1Client(XrlSender* s) : _sender(s) {}
    virtual ~XrlOlsr4V0p1Client() {}

    typedef XorpCallback1<void, const XrlError&>::RefPtr TraceCB;
    /**
     *  Send Xrl intended to:
     *
     *  Enable/Disable tracing.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param tvar trace variable.
     *
     *  @param enable set to true to enable, false to disable.
     */
    bool send_trace(
	const char*	dst_xrl_target_name,
	const string&	tvar,
	const bool&	enable,
	const TraceCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr ClearDatabaseCB;
    /**
     *  Send Xrl intended to:
     *
     *  Clear all OLSR protocol databases.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     */
    bool send_clear_database(
	const char*	dst_xrl_target_name,
	const ClearDatabaseCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SetWillingnessCB;
    /**
     *  Send Xrl intended to:
     *
     *  Set the willingness-to-forward.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param willingness the new willingness-to-forward.
     */
    bool send_set_willingness(
	const char*	dst_xrl_target_name,
	const uint32_t&	willingness,
	const SetWillingnessCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr GetWillingnessCB;
    /**
     *  Send Xrl intended to:
     *
     *  Get the willingness-to-forward.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     */
    bool send_get_willingness(
	const char*	dst_xrl_target_name,
	const GetWillingnessCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SetMprCoverageCB;
    /**
     *  Send Xrl intended to:
     *
     *  Set the MPR_COVERAGE.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param coverage the new MPR_COVERAGE value.
     */
    bool send_set_mpr_coverage(
	const char*	dst_xrl_target_name,
	const uint32_t&	coverage,
	const SetMprCoverageCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr GetMprCoverageCB;
    /**
     *  Send Xrl intended to:
     *
     *  Get the MPR_COVERAGE.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     */
    bool send_get_mpr_coverage(
	const char*	dst_xrl_target_name,
	const GetMprCoverageCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SetTcRedundancyCB;
    /**
     *  Send Xrl intended to:
     *
     *  Set the TC_REDUNDANCY.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     */
    bool send_set_tc_redundancy(
	const char*	dst_xrl_target_name,
	const string&	redundancy,
	const SetTcRedundancyCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const string*>::RefPtr GetTcRedundancyCB;
    /**
     *  Send Xrl intended to:
     *
     *  Get the TC_REDUNDANCY.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     */
    bool send_get_tc_redundancy(
	const char*	dst_xrl_target_name,
	const GetTcRedundancyCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SetTcFisheyeCB;
    /**
     *  Send Xrl intended to:
     *
     *  Enable/disable TC fisheye mode.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param enabled true to enable fisheye, false to disable it.
     */
    bool send_set_tc_fisheye(
	const char*	dst_xrl_target_name,
	const bool&	enabled,
	const SetTcFisheyeCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const bool*>::RefPtr GetTcFisheyeCB;
    /**
     *  Send Xrl intended to:
     *
     *  Get the current TC fisheye mode.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     */
    bool send_get_tc_fisheye(
	const char*	dst_xrl_target_name,
	const GetTcFisheyeCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SetHnaBaseCostCB;
    /**
     *  Send Xrl intended to:
     *
     *  Set the current HNA base cost metric.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     */
    bool send_set_hna_base_cost(
	const char*	dst_xrl_target_name,
	const uint32_t&	metric,
	const SetHnaBaseCostCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr GetHnaBaseCostCB;
    /**
     *  Send Xrl intended to:
     *
     *  Get the current HNA base cost metric.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     */
    bool send_get_hna_base_cost(
	const char*	dst_xrl_target_name,
	const GetHnaBaseCostCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SetHelloIntervalCB;
    /**
     *  Send Xrl intended to:
     *
     *  Set the HELLO_INTERVAL.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param interval the new HELLO_INTERVAL.
     */
    bool send_set_hello_interval(
	const char*	dst_xrl_target_name,
	const uint32_t&	interval,
	const SetHelloIntervalCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr GetHelloIntervalCB;
    /**
     *  Send Xrl intended to:
     *
     *  Get the HELLO_INTERVAL.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     */
    bool send_get_hello_interval(
	const char*	dst_xrl_target_name,
	const GetHelloIntervalCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SetRefreshIntervalCB;
    /**
     *  Send Xrl intended to:
     *
     *  Set the REFRESH_INTERVAL.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param interval the new REFRESH_INTERVAL.
     */
    bool send_set_refresh_interval(
	const char*	dst_xrl_target_name,
	const uint32_t&	interval,
	const SetRefreshIntervalCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr GetRefreshIntervalCB;
    /**
     *  Send Xrl intended to:
     *
     *  Get the REFRESH_INTERVAL.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     */
    bool send_get_refresh_interval(
	const char*	dst_xrl_target_name,
	const GetRefreshIntervalCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SetTcIntervalCB;
    /**
     *  Send Xrl intended to:
     *
     *  Set the TC_INTERVAL.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param interval the new TC_INTERVAL.
     */
    bool send_set_tc_interval(
	const char*	dst_xrl_target_name,
	const uint32_t&	interval,
	const SetTcIntervalCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr GetTcIntervalCB;
    /**
     *  Send Xrl intended to:
     *
     *  Get the TC_INTERVAL.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     */
    bool send_get_tc_interval(
	const char*	dst_xrl_target_name,
	const GetTcIntervalCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SetMidIntervalCB;
    /**
     *  Send Xrl intended to:
     *
     *  Set the MID_INTERVAL.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param interval the new MID_INTERVAL.
     */
    bool send_set_mid_interval(
	const char*	dst_xrl_target_name,
	const uint32_t&	interval,
	const SetMidIntervalCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr GetMidIntervalCB;
    /**
     *  Send Xrl intended to:
     *
     *  Get the MID_INTERVAL.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     */
    bool send_get_mid_interval(
	const char*	dst_xrl_target_name,
	const GetMidIntervalCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SetHnaIntervalCB;
    /**
     *  Send Xrl intended to:
     *
     *  Set the HNA_INTERVAL.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param interval the new HNA_INTERVAL.
     */
    bool send_set_hna_interval(
	const char*	dst_xrl_target_name,
	const uint32_t&	interval,
	const SetHnaIntervalCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr GetHnaIntervalCB;
    /**
     *  Send Xrl intended to:
     *
     *  Get the HNA_INTERVAL.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     */
    bool send_get_hna_interval(
	const char*	dst_xrl_target_name,
	const GetHnaIntervalCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SetDupHoldTimeCB;
    /**
     *  Send Xrl intended to:
     *
     *  Set the DUP_HOLD_TIME.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param dup_hold_time the new DUP_HOLD_TIME.
     */
    bool send_set_dup_hold_time(
	const char*	dst_xrl_target_name,
	const uint32_t&	dup_hold_time,
	const SetDupHoldTimeCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const uint32_t*>::RefPtr GetDupHoldTimeCB;
    /**
     *  Send Xrl intended to:
     *
     *  Get the DUP_HOLD_TIME.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     */
    bool send_get_dup_hold_time(
	const char*	dst_xrl_target_name,
	const GetDupHoldTimeCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SetMainAddressCB;
    /**
     *  Send Xrl intended to:
     *
     *  Set the main address.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param addr Our main IPv4 address which OLSR uses as a router ID.
     */
    bool send_set_main_address(
	const char*	dst_xrl_target_name,
	const IPv4&	addr,
	const SetMainAddressCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const IPv4*>::RefPtr GetMainAddressCB;
    /**
     *  Send Xrl intended to:
     *
     *  Get the main address.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     */
    bool send_get_main_address(
	const char*	dst_xrl_target_name,
	const GetMainAddressCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr BindAddressCB;
    /**
     *  Send Xrl intended to:
     *
     *  Create an IPv4 address binding for OLSR. OLSR must be bound to a given
     *  protocol address on each interface, which means interface bindings in
     *  OLSRv1 must be keyed by interface name as well as protocol address.
     *  Only a single IPv4 address may be thus bound, and the address must be
     *  supplied when the binding is created. This is to workaround the lack of
     *  RFC 3927 link-scoped IPv4 capability in most IPv4 implementations. The
     *  addition of address is not instantaneous. OLSR has to instantiate state
     *  in the FEA to send and receive packets. Once instantiated, the address
     *  must be explicitly enabled with the set_binding_enabled XRL.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param ifname the interface that owns vif that has addr
     *
     *  @param vifname virtual interface owning addr
     *
     *  @param local_addr the address to be added.
     *
     *  @param local_port the port to listen for control traffic on.
     *
     *  @param all_nodes_addr the address to use for transmission.
     *
     *  @param all_nodes_port the port to use for transmission.
     */
    bool send_bind_address(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const IPv4&	local_addr,
	const uint32_t&	local_port,
	const IPv4&	all_nodes_addr,
	const uint32_t&	all_nodes_port,
	const BindAddressCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr UnbindAddressCB;
    /**
     *  Send Xrl intended to:
     *
     *  Destroy an IPv4 address binding for OLSR.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param ifname the interface to unbind.
     *
     *  @param vifname the vif to unbind.
     */
    bool send_unbind_address(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const UnbindAddressCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SetBindingEnabledCB;
    /**
     *  Send Xrl intended to:
     *
     *  Set the enabled state of an IPv4 address binding for OLSR.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param ifname the interface to set enabled state for.
     *
     *  @param vifname the vif to set enabled state for.
     *
     *  @param enabled true if OLSR is to be configured administratively up on
     *  the interface, false if it is to be configured down.
     */
    bool send_set_binding_enabled(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const bool&	enabled,
	const SetBindingEnabledCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const bool*>::RefPtr GetBindingEnabledCB;
    /**
     *  Send Xrl intended to:
     *
     *  Get the state of an IPv4 address binding for OLSR.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param ifname the interface to query.
     *
     *  @param vifname the vif to qurery
     */
    bool send_get_binding_enabled(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const GetBindingEnabledCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr ChangeLocalAddrPortCB;
    /**
     *  Send Xrl intended to:
     *
     *  Change the UDP address and port where OLSR listens for control traffic
     *  on this interface. In order to do this the process must tell the FEA to
     *  tear down and re-bind the control traffic socket.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param ifname the name of the interface.
     *
     *  @param vifname the name of the vif.
     *
     *  @param local_addr the new local IPv4 address.
     *
     *  @param local_port the new local port number.
     */
    bool send_change_local_addr_port(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const IPv4&	local_addr,
	const uint32_t&	local_port,
	const ChangeLocalAddrPortCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr ChangeAllNodesAddrPortCB;
    /**
     *  Send Xrl intended to:
     *
     *  Change the address where OLSR sends control traffic on the given
     *  interface. By default OLSR will attempt to use the all-ones broadcast
     *  address. Currently multicast addresses are NOT supported.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param ifname the name of the interface.
     *
     *  @param vifname the name of the vif.
     *
     *  @param all_nodes_addr the address to use.
     *
     *  @param all_nodes_port the port to use.
     */
    bool send_change_all_nodes_addr_port(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const IPv4&	all_nodes_addr,
	const uint32_t&	all_nodes_port,
	const ChangeAllNodesAddrPortCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const XrlAtomList*>::RefPtr GetInterfaceListCB;
    /**
     *  Send Xrl intended to:
     *
     *  Get the list of interfaces currently configured for OLSR. Return a list
     *  of u32 type values. Each value is an internal ID that can be used with
     *  the get_interface_info XRL.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     */
    bool send_get_interface_list(
	const char*	dst_xrl_target_name,
	const GetInterfaceListCB&	cb
    );

    typedef XorpCallback7<void, const XrlError&, const string*, const string*, const IPv4*, const uint32_t*, const IPv4*, const uint32_t*>::RefPtr GetInterfaceInfoCB;
    /**
     *  Send Xrl intended to:
     *
     *  Get the per-interface information for the given interface.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param faceid interface ID returned by get_interface_list.
     */
    bool send_get_interface_info(
	const char*	dst_xrl_target_name,
	const uint32_t&	faceid,
	const GetInterfaceInfoCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr SetInterfaceCostCB;
    /**
     *  Send Xrl intended to:
     *
     *  Set the edge cost of an interface/vif.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param ifname the name of the interface.
     *
     *  @param vifname the name of the vif.
     *
     *  @param cost the new edge cost of the interface.
     */
    bool send_set_interface_cost(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const uint32_t&	cost,
	const SetInterfaceCostCB&	cb
    );

    typedef XorpCallback7<void, const XrlError&, const uint32_t*, const uint32_t*, const uint32_t*, const uint32_t*, const uint32_t*, const uint32_t*>::RefPtr GetInterfaceStatsCB;
    /**
     *  Send Xrl intended to:
     *
     *  Get the per-interface statistics for the given interface.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param ifname the interface to query.
     *
     *  @param vifname the vif to qurery
     */
    bool send_get_interface_stats(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const GetInterfaceStatsCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const XrlAtomList*>::RefPtr GetLinkListCB;
    /**
     *  Send Xrl intended to:
     *
     *  Get the list of one-hop links. Return a list of u32 type values. Each
     *  value is an internal ID that can be used with the get_link_info XRL.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     */
    bool send_get_link_list(
	const char*	dst_xrl_target_name,
	const GetLinkListCB&	cb
    );

    typedef XorpCallback8<void, const XrlError&, const IPv4*, const IPv4*, const IPv4*, const uint32_t*, const uint32_t*, const uint32_t*, const uint32_t*>::RefPtr GetLinkInfoCB;
    /**
     *  Send Xrl intended to:
     *
     *  Get the information for a one-hop link. TODO: Add ETX support.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param linkid Link entry ID returned by get_link_list.
     */
    bool send_get_link_info(
	const char*	dst_xrl_target_name,
	const uint32_t&	linkid,
	const GetLinkInfoCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const XrlAtomList*>::RefPtr GetNeighborListCB;
    /**
     *  Send Xrl intended to:
     *
     *  Get the list of one-hop neighbors. Return a list of u32 type values.
     *  Each value is an internal ID that can be used with the
     *  get_neighbor_info XRL.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     */
    bool send_get_neighbor_list(
	const char*	dst_xrl_target_name,
	const GetNeighborListCB&	cb
    );

    typedef XorpCallback10<void, const XrlError&, const IPv4*, const uint32_t*, const uint32_t*, const uint32_t*, const uint32_t*, const bool*, const bool*, const bool*, const bool*>::RefPtr GetNeighborInfoCB;
    /**
     *  Send Xrl intended to:
     *
     *  Get the information for a one-hop neighbor.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param nid Neighbor entry ID returned by get_neighbor_list.
     */
    bool send_get_neighbor_info(
	const char*	dst_xrl_target_name,
	const uint32_t&	nid,
	const GetNeighborInfoCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const XrlAtomList*>::RefPtr GetTwohopLinkListCB;
    /**
     *  Send Xrl intended to:
     *
     *  Get the list of two-hop links. Return a list of u32 type values. Each
     *  value is an internal ID that can be used with the get_twohop_link_info
     *  XRL.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     */
    bool send_get_twohop_link_list(
	const char*	dst_xrl_target_name,
	const GetTwohopLinkListCB&	cb
    );

    typedef XorpCallback5<void, const XrlError&, const uint32_t*, const IPv4*, const IPv4*, const uint32_t*>::RefPtr GetTwohopLinkInfoCB;
    /**
     *  Send Xrl intended to:
     *
     *  Get the information for a two-hop link. TODO: Add ETX support.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param tlid two-hop link ID returned by get_twohop_link_list.
     */
    bool send_get_twohop_link_info(
	const char*	dst_xrl_target_name,
	const uint32_t&	tlid,
	const GetTwohopLinkInfoCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const XrlAtomList*>::RefPtr GetTwohopNeighborListCB;
    /**
     *  Send Xrl intended to:
     *
     *  Get the list of two-hop neighbors. Return a list of u32 type values.
     *  Each value is an internal ID that can be used with the
     *  get_twohop_neighbor_info XRL.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     */
    bool send_get_twohop_neighbor_list(
	const char*	dst_xrl_target_name,
	const GetTwohopNeighborListCB&	cb
    );

    typedef XorpCallback6<void, const XrlError&, const IPv4*, const bool*, const uint32_t*, const uint32_t*, const uint32_t*>::RefPtr GetTwohopNeighborInfoCB;
    /**
     *  Send Xrl intended to:
     *
     *  Get the information for a two-hop neighbor.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param tnid two-hop neighbor ID returned by get_twohop_neighbor_list.
     */
    bool send_get_twohop_neighbor_info(
	const char*	dst_xrl_target_name,
	const uint32_t&	tnid,
	const GetTwohopNeighborInfoCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const XrlAtomList*>::RefPtr GetMidEntryListCB;
    /**
     *  Send Xrl intended to:
     *
     *  Get the list of learned Multiple Interface Declaration (MID) entries.
     *  Return a list of u32 type values. Each value is an internal ID that can
     *  be used with the get_mid_entry XRL.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     */
    bool send_get_mid_entry_list(
	const char*	dst_xrl_target_name,
	const GetMidEntryListCB&	cb
    );

    typedef XorpCallback5<void, const XrlError&, const IPv4*, const IPv4*, const uint32_t*, const uint32_t*>::RefPtr GetMidEntryCB;
    /**
     *  Send Xrl intended to:
     *
     *  Get the information contained in a MID entry.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param midid MID entry ID returned by get_mid_entry_list.
     */
    bool send_get_mid_entry(
	const char*	dst_xrl_target_name,
	const uint32_t&	midid,
	const GetMidEntryCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const XrlAtomList*>::RefPtr GetTcEntryListCB;
    /**
     *  Send Xrl intended to:
     *
     *  Get the list of learned Topology Control (TC) entries. Return a list of
     *  u32 type values. Each value is an internal ID that can be used with the
     *  get_tc_entry XRL.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     */
    bool send_get_tc_entry_list(
	const char*	dst_xrl_target_name,
	const GetTcEntryListCB&	cb
    );

    typedef XorpCallback6<void, const XrlError&, const IPv4*, const IPv4*, const uint32_t*, const uint32_t*, const uint32_t*>::RefPtr GetTcEntryCB;
    /**
     *  Send Xrl intended to:
     *
     *  Get the information contained in a TC entry.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param tcid TC entry ID returned by get_tc_entry_list.
     */
    bool send_get_tc_entry(
	const char*	dst_xrl_target_name,
	const uint32_t&	tcid,
	const GetTcEntryCB&	cb
    );

    typedef XorpCallback2<void, const XrlError&, const XrlAtomList*>::RefPtr GetHnaEntryListCB;
    /**
     *  Send Xrl intended to:
     *
     *  Get the list of learned external route (HNA) entries. Return a list of
     *  u32 type values. Each value is an internal ID that can be used with the
     *  get_hna_entry XRL.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     */
    bool send_get_hna_entry_list(
	const char*	dst_xrl_target_name,
	const GetHnaEntryListCB&	cb
    );

    typedef XorpCallback5<void, const XrlError&, const IPv4Net*, const IPv4*, const uint32_t*, const uint32_t*>::RefPtr GetHnaEntryCB;
    /**
     *  Send Xrl intended to:
     *
     *  Get the information contained in a HNA entry.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param hnaid HNA entry ID returned by get_hna_entry_list.
     */
    bool send_get_hna_entry(
	const char*	dst_xrl_target_name,
	const uint32_t&	hnaid,
	const GetHnaEntryCB&	cb
    );

protected:
    XrlSender* _sender;

private:
    void unmarshall_trace(
	const XrlError&	e,
	XrlArgs*	a,
	TraceCB		cb
    );

    void unmarshall_clear_database(
	const XrlError&	e,
	XrlArgs*	a,
	ClearDatabaseCB		cb
    );

    void unmarshall_set_willingness(
	const XrlError&	e,
	XrlArgs*	a,
	SetWillingnessCB		cb
    );

    void unmarshall_get_willingness(
	const XrlError&	e,
	XrlArgs*	a,
	GetWillingnessCB		cb
    );

    void unmarshall_set_mpr_coverage(
	const XrlError&	e,
	XrlArgs*	a,
	SetMprCoverageCB		cb
    );

    void unmarshall_get_mpr_coverage(
	const XrlError&	e,
	XrlArgs*	a,
	GetMprCoverageCB		cb
    );

    void unmarshall_set_tc_redundancy(
	const XrlError&	e,
	XrlArgs*	a,
	SetTcRedundancyCB		cb
    );

    void unmarshall_get_tc_redundancy(
	const XrlError&	e,
	XrlArgs*	a,
	GetTcRedundancyCB		cb
    );

    void unmarshall_set_tc_fisheye(
	const XrlError&	e,
	XrlArgs*	a,
	SetTcFisheyeCB		cb
    );

    void unmarshall_get_tc_fisheye(
	const XrlError&	e,
	XrlArgs*	a,
	GetTcFisheyeCB		cb
    );

    void unmarshall_set_hna_base_cost(
	const XrlError&	e,
	XrlArgs*	a,
	SetHnaBaseCostCB		cb
    );

    void unmarshall_get_hna_base_cost(
	const XrlError&	e,
	XrlArgs*	a,
	GetHnaBaseCostCB		cb
    );

    void unmarshall_set_hello_interval(
	const XrlError&	e,
	XrlArgs*	a,
	SetHelloIntervalCB		cb
    );

    void unmarshall_get_hello_interval(
	const XrlError&	e,
	XrlArgs*	a,
	GetHelloIntervalCB		cb
    );

    void unmarshall_set_refresh_interval(
	const XrlError&	e,
	XrlArgs*	a,
	SetRefreshIntervalCB		cb
    );

    void unmarshall_get_refresh_interval(
	const XrlError&	e,
	XrlArgs*	a,
	GetRefreshIntervalCB		cb
    );

    void unmarshall_set_tc_interval(
	const XrlError&	e,
	XrlArgs*	a,
	SetTcIntervalCB		cb
    );

    void unmarshall_get_tc_interval(
	const XrlError&	e,
	XrlArgs*	a,
	GetTcIntervalCB		cb
    );

    void unmarshall_set_mid_interval(
	const XrlError&	e,
	XrlArgs*	a,
	SetMidIntervalCB		cb
    );

    void unmarshall_get_mid_interval(
	const XrlError&	e,
	XrlArgs*	a,
	GetMidIntervalCB		cb
    );

    void unmarshall_set_hna_interval(
	const XrlError&	e,
	XrlArgs*	a,
	SetHnaIntervalCB		cb
    );

    void unmarshall_get_hna_interval(
	const XrlError&	e,
	XrlArgs*	a,
	GetHnaIntervalCB		cb
    );

    void unmarshall_set_dup_hold_time(
	const XrlError&	e,
	XrlArgs*	a,
	SetDupHoldTimeCB		cb
    );

    void unmarshall_get_dup_hold_time(
	const XrlError&	e,
	XrlArgs*	a,
	GetDupHoldTimeCB		cb
    );

    void unmarshall_set_main_address(
	const XrlError&	e,
	XrlArgs*	a,
	SetMainAddressCB		cb
    );

    void unmarshall_get_main_address(
	const XrlError&	e,
	XrlArgs*	a,
	GetMainAddressCB		cb
    );

    void unmarshall_bind_address(
	const XrlError&	e,
	XrlArgs*	a,
	BindAddressCB		cb
    );

    void unmarshall_unbind_address(
	const XrlError&	e,
	XrlArgs*	a,
	UnbindAddressCB		cb
    );

    void unmarshall_set_binding_enabled(
	const XrlError&	e,
	XrlArgs*	a,
	SetBindingEnabledCB		cb
    );

    void unmarshall_get_binding_enabled(
	const XrlError&	e,
	XrlArgs*	a,
	GetBindingEnabledCB		cb
    );

    void unmarshall_change_local_addr_port(
	const XrlError&	e,
	XrlArgs*	a,
	ChangeLocalAddrPortCB		cb
    );

    void unmarshall_change_all_nodes_addr_port(
	const XrlError&	e,
	XrlArgs*	a,
	ChangeAllNodesAddrPortCB		cb
    );

    void unmarshall_get_interface_list(
	const XrlError&	e,
	XrlArgs*	a,
	GetInterfaceListCB		cb
    );

    void unmarshall_get_interface_info(
	const XrlError&	e,
	XrlArgs*	a,
	GetInterfaceInfoCB		cb
    );

    void unmarshall_set_interface_cost(
	const XrlError&	e,
	XrlArgs*	a,
	SetInterfaceCostCB		cb
    );

    void unmarshall_get_interface_stats(
	const XrlError&	e,
	XrlArgs*	a,
	GetInterfaceStatsCB		cb
    );

    void unmarshall_get_link_list(
	const XrlError&	e,
	XrlArgs*	a,
	GetLinkListCB		cb
    );

    void unmarshall_get_link_info(
	const XrlError&	e,
	XrlArgs*	a,
	GetLinkInfoCB		cb
    );

    void unmarshall_get_neighbor_list(
	const XrlError&	e,
	XrlArgs*	a,
	GetNeighborListCB		cb
    );

    void unmarshall_get_neighbor_info(
	const XrlError&	e,
	XrlArgs*	a,
	GetNeighborInfoCB		cb
    );

    void unmarshall_get_twohop_link_list(
	const XrlError&	e,
	XrlArgs*	a,
	GetTwohopLinkListCB		cb
    );

    void unmarshall_get_twohop_link_info(
	const XrlError&	e,
	XrlArgs*	a,
	GetTwohopLinkInfoCB		cb
    );

    void unmarshall_get_twohop_neighbor_list(
	const XrlError&	e,
	XrlArgs*	a,
	GetTwohopNeighborListCB		cb
    );

    void unmarshall_get_twohop_neighbor_info(
	const XrlError&	e,
	XrlArgs*	a,
	GetTwohopNeighborInfoCB		cb
    );

    void unmarshall_get_mid_entry_list(
	const XrlError&	e,
	XrlArgs*	a,
	GetMidEntryListCB		cb
    );

    void unmarshall_get_mid_entry(
	const XrlError&	e,
	XrlArgs*	a,
	GetMidEntryCB		cb
    );

    void unmarshall_get_tc_entry_list(
	const XrlError&	e,
	XrlArgs*	a,
	GetTcEntryListCB		cb
    );

    void unmarshall_get_tc_entry(
	const XrlError&	e,
	XrlArgs*	a,
	GetTcEntryCB		cb
    );

    void unmarshall_get_hna_entry_list(
	const XrlError&	e,
	XrlArgs*	a,
	GetHnaEntryListCB		cb
    );

    void unmarshall_get_hna_entry(
	const XrlError&	e,
	XrlArgs*	a,
	GetHnaEntryCB		cb
    );

};

#endif /* __XRL_INTERFACES_OLSR4_XIF_HH__ */
