#ifndef FLIST_H
#define FLIST_H

#define FLIST_NAME        160  //Maximum filename

#define FILE_TIMESTAMP 18
#define L_MAGIC        100
#define L_USER         9        //User [8] + '\0'
#define L_GROUP        9        //Group[8] + '\0'

extern int    sort_order;


struct FList
{
 FList        *next,
              *prev;
 char         name[FLIST_NAME];
 unsigned int mode;
 int          size,gid,uid;
 time_t       time;
 char         chr_time[FILE_TIMESTAMP];   // DD-MMM-YYYY/HH:MM
 int          options;
 FList*       link;
 struct stat  st;
 char         magic[L_MAGIC];
 char         user[L_USER];
 char         group[L_GROUP];
 
 FList() 
    {
        prev=next=link=NULL;
        mode=0;
        name[0]=0;
        size=0;
        options=0;
        user[0]=0;
        group[0]=0;
        magic[0]=0;
    };
 FList(char *iname,int imode=0,int is=0,int iuid=0,int igid=0,time_t t=0, struct stat *ist=NULL);
 void init(char *iname,int imode=0,int is=0,int iuid=0,int igid=0,time_t t=0, struct stat *ist=NULL);
 void add(FList*);
 void add_magic(char *);
 void set_user_group_names(char *fromuser, char *fromgroup);
 void out();
};

#define S_FList        sizeof(FList)

extern void   simple_flist_add(FList * base, FList * it);

extern int    extcmp   (char *, int, int, char *, int, int);
extern int    sizecmp  (char *, int, int, char *, int, int);
extern int    timecmp  (char *, int, int, char *, int, int);
extern int    mystrcmp (char *, int, int, char *, int, int);
extern int    unsortcmp(char *, int, int, char *, int, int);

extern int    (*compare)(char*,int,int,char*,int,int);


#endif


/* ------------ End of file -------------- */

