/****************************************************************************
*  Copyright (C) 1997 by Leo Khramov
*  email:   leo@xnc.dubna.su
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
 ****************************************************************************/

#include "panel.h"
#include "c_externs.h"
#include "ftpcfg.h"
///////////////////////////////Cmdline class/////////////////////////////

void   Cmdline::show()
{
  if(main_pixmap)
    XSetWindowBackgroundPixmap(disp, w, main_pixmap);
  Gui::show();
  if(default_dnd_man)
  {
    default_dnd_man->add_dnd_object(this,w);
    dndwin->add_type("text/uri-list");
  }
}

void   Cmdline::setpath(char *path)
{
  strcpy(name, host);
  strcat(name, path);
  if (getuid() != 0)
    strcat(name, "$");
  else
    strcat(name, "#");
  tl = strlen(name);
  if (hflg)
    expose();
}

void   Cmdline::init(Window ip)
{
  parent = ip;
  bbp = bp = 0;
  h=20;
  for (int i = 0; i < 9; i++)
    bak[i][0] = 0;
  w = XCreateSimpleWindow(disp, parent, x, y, l, 21, 0, 0, keyscol[1]);
  gcw = XCreateGC(disp, w, 0, NULL);
  XSetFont(disp, gcw, fixfontstr->fid);
  XSetForeground(disp, gcw, cols[col]);

  gl.init(w, ExposureMask | ButtonPressMask);
  tl = strlen(name);
  ty = (21 + fixfontstr->max_bounds.ascent - fixfontstr->max_bounds.descent) / 2;
  ll = XTextWidth(fixfontstr, "MMMMMMMMMM",10)/10;
//fixfontstr->max_bounds.rbearing - fixfontstr->min_bounds.lbearing;
  hflg = 0;
}


void   clear_cmdbuf(int bl)
{
  char chr[1024];
  for(int n=0;n<bl;n++)
    chr[n]='\b';
  tt_write((unsigned char*)chr, bl);
}


void   Cmdline::look_for_cd()
{
  int    i, j;
  i = 0;
  char   tmp[256];
  while (buf[i])
    {
      if (buf[i] == 'c' && buf[i + 1] == 'd')
        {
          if (i > 0)
            if (buf[i - 1] != ';' && buf[i - 1] != ' ')
              {
                i++;
                continue;
              };
          if (buf[i + 2] == 0)
          {
            panel->change_dir(getenv("HOME"));
            if(!panel->vfs->pass_cd_to_terminal())
	      clear_cmdbuf(bl);
          }
          else if (buf[i + 2] == ' ')
            {
              j = 0;
              i += 2;
              while (buf[i] == ' ')
                i++;
	      if(strncmp(&buf[i],"ftp://",6)==0)  //make cd to FTP
	      {
		char ftpsite[1024];
		int  j=0;
		clear_cmdbuf(bl);
		i+=6; //Skipping 'ftp://'
		while(buf[i] && buf[i]!=' ' && buf[i]!=';')
		  ftpsite[j++]=buf[i++];
		ftpsite[j]=0;
		xncdprintf(("Got chdir to FTP site: [%s]\n",ftpsite));
		if(ftprec.init(ftpsite))
		  panel->funcs(FFTPCON);
		else
		  newtextfile("Enter your password",panel,FFTPCONPWD,0);
	      } else
              if (buf[i] == 0)
              {
                panel->change_dir(getenv("HOME"));
                if(!panel->vfs->pass_cd_to_terminal())
		  clear_cmdbuf(bl);
              }
              else
                {
                  while (buf[i + j] != ';' && buf[i + j] != 0)
                    {
                      tmp[j] = buf[i + j];
                      j++;
                    };
                  tmp[j] = 0;
                  while(j>0)
                  {
                      j--;
                      if(tmp[j]!=' ')
                      {
                          j++;
                          break;
                      }
                      tmp[j]=0;
                  }
                  if (j == 0)
                    panel->change_dir(getenv("HOME"));
                  else
                    panel->change_dir(tmp);
                  if(!panel->vfs->pass_cd_to_terminal())
		    clear_cmdbuf(bl);
                }
            }
        }
      i++;
    }
}

void   Cmdline::flush()
{
  if (bl != 0)
    backup();
  look_for_cd();
  bl = cp = base = 0;
  buf[0] = 0;
  expose();
}

void   Cmdline::backup()
{
  bp++;
  if (bp > 9)
    bp = 0;
  bbp = bp;
  strcpy(bak[bp], buf);
  bbp++;
  if (bbp > 9)
    bbp = 0;
}

void   Cmdline::reconfigure(int ix, int iy, int il, int ih)
{
  x = ix;
  y = iy;
  l = il;
  XMoveWindow(disp, w, x, y);
  XResizeWindow(disp, w, l, 21);
  expose();
}

void   Cmdline::hide()
{
  XUnmapWindow(disp, w);
  foc = 0;
  hflg = 0;
  delfrom_exp(this);
  if(default_dnd_man)
    default_dnd_man->del_dnd_win(w);
}

int  Cmdline::dnd_drop(DndData* dd, int, int, Atom)
{
  int i=0;
  if(!strncmp(dd->data,"file:",5))
    i=5;
  for(;dd->data[i] && dd->data[i]!='\r' && dd->data[i]!='\n';i++)
    insert(dd->data[i]);
  delete dd;
  return 1;
}

void   Cmdline::expose()
{
  XClearWindow(disp, w);
  prect(w, gcw, 0, 0, l - 1, h);
  XSetForeground(disp, gcw, cols[col]);
  XDrawString(disp, w, gcw, 4, ty, name, tl);
  tw = XTextWidth(fixfontstr, name, tl) + 9;
  el = (l - tw - 4) / ll;
  visl=el;
  if(bl>visl)
  {
    cp+=base;
    base=bl-visl-1;
    cp-=base;
  }
  showbuf();
  hflg = 1;
}

void   Cmdline::save_input()
{
   int i;
   store[0]=0;
   if(bl)
     {
	strncpy(store, buf, bl);
	store_cp=cp; store_base=base;
        for(i=0;i<bl;i++)
	  tt_printf("%c", 8);
	bl=cp=base=0;
     }
}

void   Cmdline::restore_input()
{
   if(store[0])
     {
	strcpy(buf, store);
	bl=strlen(buf);
	cp=store_cp;
	base=store_base;
	store[0]=0;	
	tt_write((unsigned char*)buf, bl);
     }
}

void   Cmdline::insert(char ch)
{
  int    i;
  for (i = (int)bl; i >= cp+base; i--)
    buf[i + 1] = buf[i];
  buf[cp+base] = ch;
  cp++;
  if(cp>visl)
    cp--,base++;
  bl++;
  showbuf();
}

void   Cmdline::press(int k)
{
  int    i;
  KeySym ks;
  XComposeStatus cs;
  Status st;
  char   sym[4];
  gl.LookupString(&ev.xkey, sym, 4, &ks, &cs, &st);
  if (k < 256 && k > 31 && bl < el && (ev.xkey.state & ControlMask)==0)
    insert(sym[0]);
  else
    switch (k)
      {
      case XK_BackSpace:
      case XK_Delete:
        if (cp != 0)
          {
            cp--;
            for (i = cp+base; i < bl; i++)
              buf[i] = buf[i + 1];
            bl--;
            showbuf();
          } else
             if(base!=0)
             {
                base--;
                for (i = cp+base; i < bl; i++)
                     buf[i] = buf[i + 1];
                bl--;
                showbuf();
             }
        break;
      case XK_Left:
        if (cp != 0)
          {
            XSetForeground(disp, gcw, keyscol[1]);
            XDrawRectangle(disp, w, gcw, tw + cp * ll, 1, ll, 18);
            cp--;
            XSetForeground(disp, gcw, cols[col]);
            XDrawRectangle(disp, w, gcw, tw + cp * ll, 1, ll, 18);
          } else
             if(base!=0)
             {
                 base--;
                 showbuf();
             }
        break;
      case XK_Right:
        if (cp != bl)
          {
            XSetForeground(disp, gcw, keyscol[1]);
            XDrawRectangle(disp, w, gcw, tw + cp * ll, 1, ll, 18);
            cp++;
            XSetForeground(disp, gcw, cols[col]);
            XDrawRectangle(disp, w, gcw, tw + cp * ll, 1, ll, 18);
          };
        break;
      case XK_Up:
        for (i = 0; i < bl; i++)
          tt_printf("%c", 8);
        bbp--;
        if (bbp < 0)
          bbp = 9;
        strcpy(buf, bak[bbp]);
        bl = strlen(buf);
        tt_write((unsigned char*)buf, bl);
        if(bl>visl)
          base=bl-visl-1;
        else
          base=0;
        cp=bl-base;
        showbuf();
        break;
      case XK_Down:
        for (i = 0; i < bl; i++)
          tt_printf("%c", 8);
        bbp++;
        if (bbp > 9)
          bbp = 0;
        strcpy(buf, bak[bbp]);
        bl = cp = strlen(buf);
        if(bl>visl)
          base=bl-visl-1;
        else
          base=0;
        cp=bl-base;
        tt_write((unsigned char*)buf, bl);
        showbuf();
        break;
       case XK_u:
       case XK_U:
	 flush();
	 break;
      }
}

void   Cmdline::showbuf()
{
/*XFR
  XSetForeground(disp, gcw, keyscol[1]);
  XFillRectangle(disp, w, gcw, tw, 1, l - tw - 1, 19);
*/
  XClearArea(disp, w, tw, 1, l - tw - 1, 19, 0);
  XSetForeground(disp, gcw, cols[col]);
  XDrawString(disp, w, gcw, tw, ty, buf+base, bl-base);
  XDrawRectangle(disp, w, gcw, tw + cp * ll, 1, ll, 18);
}

void   Cmdline::click()
{
  if (ev.xany.window == w && ev.type == Expose)
    expose();
  if (ev.xany.window == w && ev.type == ButtonPress &&
      ev.xbutton.button != Button1)
  {
    char *cutbuf;
    int cl;
    cutbuf=XFetchBytes(disp,&cl);
    if(cl>0)
    {
      for(int i=0;cutbuf[i]!=0 && cutbuf[i]!='\n' && cutbuf[i]!='\r';i++)
	insert(cutbuf[i]);
    }
  }
}
