/*
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Brian W. Barrett, Arun F. Rodrigues, Jeffrey M. Squyres,
 * 	 and Andrew Lumsdaine
 *
 * This file is part of XMPI
 *
 * You should have received a copy of the License Agreement for XMPI 
 * along with the software; see the file LICENSE.  If not, contact 
 * Office of Research, University of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 *
 * Additional copyrights may follow.

 *
 *	$Id: xmpi_options.c,v 1.2 1999/11/08 06:20:25 bbarrett Exp $
 * 
 *	Function:	- option setting
 */

#define _NO_PROTO

#include <Xm/DialogS.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/PanedW.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/RowColumn.h>
#include <Xm/TextF.h>
#include <Xm/ToggleBG.h>

#include <ctype.h>
#include "lam.h"
#include "xmpi.h"

#include "Bitmaps/tack.xbm"

/*
 * private definitions
 */
#define XMPI_TON	((XtPointer) 0)
#define XMPI_TOFF	((XtPointer) 1)

/*
 * public functions
 */
void 			xmpi_options_set();
void			xmpi_options_busy();
void			xmpi_options_unbusy();

/*
 * external functions
 */
extern int4		stoi();
extern Widget		xmpi_wmshell();

/*
 * private functions
 */
static void		check_cb();
static void		radio_cb();
static void		tack_cb();

/*
 * public variables
 */
int			xmpi_c2c = 0;
int			xmpi_homog = 0;
int			xmpi_nger = 0;
int			xmpi_trace = 1;
int			xmpi_trinit = 1;
Widget			xmpi_options_w = 0;

/*
 * private variables
 */
static Widget		optform;
static Widget		ton;
static Widget		toff;
static Widget		trace;
static Pixmap		tackpix = XmUNSPECIFIED_PIXMAP;
static Pixmap		armtackpix = XmUNSPECIFIED_PIXMAP;

/*
 *	xmpi_options_create
 *
 *	Function:	- create options setting dialog
 *	Accepts:	- parent widget
 */
static void
xmpi_options_create(parent)

Widget			parent;

{
	Widget		rc;
	Widget		radio;
	Widget		lbl;
	Widget		w;
	Widget		v;
	XmString	str0, str1, str2, str3;
	Dimension	width, height;

	xmpi_options_w = XtVaCreatePopupShell("options",
                xmDialogShellWidgetClass, xmpi_wmshell(parent),
                XmNdeleteResponse, XmUNMAP,
		XmNallowShellResize, True,
                XmNtitle, "XMPI",
                NULL);

        optform = XtVaCreateWidget("form",
                xmFormWidgetClass, xmpi_options_w, NULL);
 
	rc = XtVaCreateWidget("rc",
		xmRowColumnWidgetClass, optform,
                XmNtopAttachment, XmATTACH_FORM,
                XmNbottomAttachment, XmATTACH_FORM,
                XmNleftAttachment, XmATTACH_FORM,
                XmNrightAttachment, XmATTACH_FORM,
		NULL);
/*
 * Create the label area window.
 */
	lbl = XtVaCreateWidget("opt_label",
		xmFormWidgetClass, rc,
		NULL);
/*
 * tack button (cache and re-use pixmaps)
 */
	if (tackpix == XmUNSPECIFIED_PIXMAP) {
		w = xmpi_mkpixbutton(lbl, tack_cb, NULL,
			(void (*)()) 0, NULL, (void (*)()) 0, NULL,
			tack_bits, tack_width, tack_height, False);

		XtVaGetValues(w, XmNlabelPixmap, &tackpix,
			XmNarmPixmap, &armtackpix, NULL);
	} else {
		w = xmpi_mkpixbutton(lbl, tack_cb, NULL,
			(void (*)()) 0, NULL, (void (*)()) 0, NULL,
			NULL, 0, 0, False);

		XtVaSetValues(w, XmNlabelType, XmPIXMAP,
			XmNlabelPixmap, tackpix,
			XmNarmPixmap, armtackpix, NULL);
	}

	XtVaSetValues(w, XmNtopAttachment, XmATTACH_FORM,
		XmNleftAttachment, XmATTACH_FORM,
		NULL);

	v = xmpi_mklabel(lbl, "banner", XmALIGNMENT_CENTER, False);
	XtVaSetValues(v,
		XmNtopAttachment, XmATTACH_FORM,
		XmNbottomAttachment, XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_FORM,
		XmNleftAttachment, XmATTACH_WIDGET,
		XmNleftWidget, w,
		XmNleftOffset, 3,
		NULL);
	xmpi_setlabel(v, "Runtime Options");
	XtManageChild(lbl);
/*
 * Create the option checkbuttons.
 */
	str0 = 	XmStringCreateSimple("Client-to-Client");
	str1 = 	XmStringCreateSimple("Homogeneous LAM");
	str2 = 	XmStringCreateSimple("No GER");
	str3 = 	XmStringCreateSimple("Tracing");

	w = XmVaCreateSimpleCheckBox(rc, "checkopts", check_cb,
		XmVaCHECKBUTTON, str0, NULL, NULL, NULL,
		XmVaCHECKBUTTON, str1, NULL, NULL, NULL,
		XmVaCHECKBUTTON, str2, NULL, NULL, NULL,
		XmVaCHECKBUTTON, str3, NULL, NULL, NULL,
		NULL);

	v = XtNameToWidget(w, "button_3");
	XtVaSetValues(v, XmNset, xmpi_trace, NULL);

	XtManageChild(w);
	XmStringFree(str0);
	XmStringFree(str1);
	XmStringFree(str2);
	XmStringFree(str3);

	trace = XtVaCreateWidget("form", xmFormWidgetClass, rc,
		XmNfractionBase, 5,
		NULL);

	str0 = 	XmStringCreateSimple("Initially On");
	str1 = 	XmStringCreateSimple("Initially Off");
	
	radio = XmCreateRadioBox(trace, "trace_radio", NULL, 0);
	XtVaSetValues(radio,
		XmNtopAttachment, XmATTACH_FORM,
		XmNbottomAttachment, XmATTACH_FORM,
		XmNleftAttachment, XmATTACH_POSITION,
		XmNleftPosition, 1,
		XmNrightAttachment, XmATTACH_FORM,
		NULL);

	ton = XtVaCreateManagedWidget("radioopt",
		xmToggleButtonGadgetClass, radio,
		XmNlabelString, str0,
		XmNset, xmpi_trinit,
		XmNsensitive, False,
		NULL);
	XtAddCallback(ton, XmNvalueChangedCallback, radio_cb, XMPI_TON);

	toff = XtVaCreateManagedWidget("radioopt",
		xmToggleButtonGadgetClass, radio,
		XmNlabelString, str1,
		XmNsensitive, False,
		NULL);
	XtAddCallback(toff, XmNvalueChangedCallback, radio_cb, XMPI_TOFF);

	XmStringFree(str0);
	XmStringFree(str1);
	XtManageChild(radio);
	if (xmpi_trace) {
		XtSetSensitive(ton, xmpi_trace);
		XtSetSensitive(toff, xmpi_trace);
		XtManageChild(trace);
	}
	XtManageChild(rc);
	XtManageChild(optform);

	XtPopup(xmpi_options_w, XtGrabNone);

	XtVaGetValues(xmpi_options_w, XmNwidth, &width, XmNheight, &height, NULL);
	XtVaSetValues(xmpi_options_w,
		XmNminWidth, width, XmNmaxWidth, width,
		XmNmaxHeight, height, NULL);
}

/*
 *	xmpi_options_set
 *
 *	Function:	- create/pop up an mpirun options setting dialog
 *	Accepts:	- parent widget
 */
void
xmpi_options_set(parent)

Widget			parent;

{
	if (xmpi_options_w == 0) {
		xmpi_options_create(parent);
	} else {
		XtPopup(xmpi_options_w, XtGrabNone);
		XtManageChild(optform);
	}
}

/*
 *	check_cb
 *
 *	Function:	- checkbutton callback
 *	Accepts:	- checkbutton callback data
 */
static void
check_cb(widget, which, state)

Widget 			widget;
int 			which;
XmToggleButtonCallbackStruct
			*state;

{
	switch (which) {

	case 0: xmpi_c2c = state->set;
		break;

	case 1: xmpi_homog = state->set;
		break;

	case 2: xmpi_nger = state->set;
		break;

	case 3:	xmpi_trace = state->set;
		XtSetSensitive(ton, xmpi_trace);
		XtSetSensitive(toff, xmpi_trace);
		if (xmpi_trace) {
			XtManageChild(trace);
		} else {
			XtUnmanageChild(trace);
		}
		
		break;
	}
}

/*
 *	radio_cb
 *
 *	Function:	- radiobutton callback
 *	Accepts:	- radiobutton callback data
 */
static void
radio_cb(widget, which, state)

Widget 			widget;
XtPointer		which;
XmToggleButtonCallbackStruct
			*state;

{
	if (which == XMPI_TON) {
		xmpi_trinit = state->set;
	}
}

/*
 *	tack_cb
 *
 *	Function:	- callback to unmap the options window
 */
static void
tack_cb()

{
	XtPopdown(xmpi_options_w);
}

/*
 *	xmpi_options_busy
 *
 *	Function:	- set the busy cursor for the Options window
 */
void
xmpi_options_busy()

{
	if (xmpi_options_w) xmpi_busy_widget(xmpi_options_w);
}

/*
 *	xmpi_options_unbusy
 *
 *	Function:	- set the normal cursor for the Options window
 */
void
xmpi_options_unbusy()

{
	if (xmpi_options_w) xmpi_unbusy_widget(xmpi_options_w);
}
