/*
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Brian W. Barrett, Arun F. Rodrigues, Jeffrey M. Squyres,
 * 	 and Andrew Lumsdaine
 *
 * This file is part of XMPI
 *
 * You should have received a copy of the License Agreement for XMPI 
 * along with the software; see the file LICENSE.  If not, contact 
 * Office of Research, University of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 *
 * Additional copyrights may follow.

 *
 *	$Id: ndi.h,v 1.3 1999/11/08 07:15:41 arodrig6 Exp $
 * 
 *	Function:	- node identifier parsing
 */

#ifndef _NDI_H
#define _NDI_H

#include <xmpi_config.h>
#include "all_list.h"
#include "lam.h"

/*
 * node identifier list entry
 */
struct ndi {
	int4		ndi_node;	/* ID itself */
	int4		ndi_flags;	/* descriptive flags */
	int4		ndi_count;	/* # IDs actually represented */
	int4		ndi_index;	/* position in list (legacy) */
};

#ifdef __cplusplus
extern "C" {
#endif

extern LIST *	ndi_parse __ARGS((int argc, char ** argv, char *** othersv));
extern LIST *	ndi_resolve __ARGS((LIST * nodelist));
extern void	ndi_fmt __ARGS((int4 node, char * fmt_str));
extern int4	ndi_parse1 __ARGS((char * s));
extern void	ndi_usage __ARGS((void));

#ifdef __cplusplus
}
#endif

#endif	/* _NDI_H */
