//
// $COPYRIGHT$
//
// $Id: xmpi_getline.h,v 1.3 2001/07/11 15:43:54 bbarrett Exp $
//
// FUNCTION: Replacement for std::getline(std::istream&,
// std::string&), which is broken in some releases of the Sun Workshop
// 5.0 compilers.  This is only used when the getline in std::string
// is broken.
//


#ifndef XMPI_GETLINE_H_
#define XMPI_GETLINE_H_

#include "xmpi_config.h"

#if XMPI_HAVE_BROKEN_GETLINE
#define XMPI_GETLINE XMPI_getline

#include <iostream>
#include <fstream>
#include <string>

inline std::iostream&
XMPI_getline(std::iostream &is, std::string &str, char delim)
{
  // clear the string and all...
  str.resize(0);
  char ch;
  int count = 0;

  while(1) {
    ch = is.get();

    if (ch == EOF) {
      if (count == 0)
	is.setstate(std::ios::failbit|std::ios::eofbit);
      else
	is.setstate(std::ios::eofbit);
      
      break;
    }

    ++count;

    if (ch == delim)
      break;

    str += ch;

    // do we have space for another char?  if not, we need to fail...
    if (str.length() == str.npos - 1) {
      is.setstate(std::ios::failbit);
      break;
    }
  }

  return is;
}

#else // #if XMPI_HAVE_BROKEN_GETLINE

#define XMPI_GETLINE getline

#endif

#endif // #ifndef XMPI_GETLINE_H_
