/*
 *      $COPYRIGHT$
 *
 *	$Id: lam.h,v 1.5 1999/11/08 06:20:20 bbarrett Exp $
 *
 */

#ifndef _LAM_H
#define _LAM_H

#include "xmpi_config.h"

#include <errno.h>
#include <string.h>

/*
 * LAM constants used in portable code.
 */
#define	LAMERROR	(-1)
#define ERROR		(-1)
#define LOCAL		0x80000001	/* on the local node */
#define NOTNODEID	0x80000000	/* not a valid node ID */
#define HOST2ALL	0x80000002	/* origin otb to all nodes */
#define HOST2ITB	0x80000003	/* origin otb to all ITB nodes */
#define HOST2OTB	0x80000005	/* origin otb to all OTB nodes */
#define HOST2COMP	0x80000006	/* origin otb to all compute nodes */
#define NT_CAST		0x02		/* a multicast of nodes */
#define NT_ME		0x80		/* my local node */

typedef unsigned int	unint;

/*
 * errors
 */
#define XMPI_ERR_LOW	1024

#define EUSAGE		1024
#define EDELETE		1025
#define EMAGIC		1026
#define EBADIDSPEC	1027
#define EIMPOSSIBLE	1028

#define XMPI_ERR_HIGH	1028

/*
 * Path name separator.
 */
#ifndef DOS
#define STRDIR		'/'
#define STRSDIR		"/"
#else
#define STRDIR		'\\'
#define STRSDIR		"\\"
#endif

/*
 * To const or not to const.
 */
#ifndef XMPI_CONST
#if __STDC__ || defined(c_plusplus) || defined(__cplusplus)
#define XMPI_CONST const
#else
#define XMPI_CONST
#endif
#endif

/*
 * macros
 */
#define max(a,b)	(((a) > (b)) ? (a) : (b))
#define min(a,b)	(((a) < (b)) ? (a) : (b))


/*
 * Portable datatypes.
 */
#if SIZEOF_INT == 4
typedef int		int4;
#elif SIZEOF_SHORT == 4
typedef short		int4;
#endif

#if SIZEOF_FLOAT == 8
typedef float		float8;
#elif SIZEOF_DOUBLE == 8
typedef double		float8;
#endif

/*
 * Integer conversions.
 */
#if WORDS_BIGENDIAN

#define ltoti4(x, y)	*((int4 *) (y)) = *((int4 *) (x))
#define ttoli4(x, y)	*((int4 *) (y)) = *((int4 *) (x))
#define mltoti4(x, l)
#define mttoli4(x, l)

#else /* not WORDS_BIGENDIAN */

#define ltoti4(x, y)	rev4(x, y)
#define ttoli4(x, y)	rev4(x, y)
#define mltoti4(x, l)	mrev4(x, l)
#define mttoli4(x, l)	mrev4(x, l)

#endif /* not WORDS_BIGENDIAN */

/*
 * Floating point conversions.
 */
#if WORDS_BIGENDIAN

#define ltotf8(x, y)	*((float8 *) (y)) = *((float8 *) (x))
#define ttolf8(x, y)	*((float8 *) (y)) = *((float8 *) (x))
#define mltotf8(x, l)
#define mttolf8(x, l)

#else /* not WORDS_BIGENDIAN */

#define ltotf8(x, y)	rev8(x, y)
#define ttolf8(x, y)	rev8(x, y)
#define mltotf8(x, l)	mrev8(x, l)
#define mttolf8(x, l)	mrev8(x, l)

#endif /* not WORDS_BIGENDIAN */

#define __ARGS(a)	a

/*
 * prototypes
 */
#ifdef __cplusplus
extern "C" {
#endif

void rev4(void *src, void *dest);
void rev8(void *src, void *dest);
void mrev4(void *array, int num);
void mrev8(void *array, int num);

int4 stoi(unsigned char *);

#ifdef __cplusplus
}
#endif

#endif	/* _LAM_H */
