# -*- shell-script -*-
#
# $COPYRIGHT$
#
# spec file for XMPI rpm
#


Summary: XMPI is an X/Motif based graphical user interface for running, debugging and visualizing MPI programs. Extensive MPI information is extracted from a running application on demand, or from a cummulative log of communication. Both sources are tightly integrated with an application overview window and any number of single process focus windows.

Name: xmpi

%define version XMPIVERSION
%define shortlibver SHORTLIBVERSION
%define revision XMPIREVISION
%define libversion LIBVERSION
Version: %{version}

Release: %{revision}
Copyright: University of Notre Dame/LAM Team (Open Source)
Group: Development/Applications
Source: http://www.mpi.nd.edu/lam/download/xmpi-%{version}-%{shortlibver}.tar.gz
URL: http://www.mpi.nd.edu/lam/software/xmpi/
Vendor: University of Notre Dame/LAM Team
Packager: LAM Team
Requires: lam = %{libversion}

%description 
XMPI is an X/Motif based graphical user interface for running,
debugging and visualizing MPI programs. Extensive MPI information is
extracted from a running application on demand, or from a cummulative
log of communication. Both sources are tightly integrated with an
application overview window and any number of single process focus
windows.

XMPI can acquire and display extensive detail on an application's MPI
communication, including the following:
        o process synchronization status: running, system or blocked
        o message queue contents
        o source, destination, root ranks
        o MPI function name
        o communicator
        o datatype
        o message count
        o tag
The above information is acquired from on-demand snapshots of
application status using debugging hooks in the MPI implementation or
from a trace log of communication activity.

XMPI is a great tool for teaching MPI in a hands-on setting.  Students
run example code and can see and verify each MPI operation.  XMPI has an
application "wizard" to help assemble programs and assign processors to
MIMD and SPMD applications.  Furthermore, it is not tedious to generate,
acquire and display information.  A typical development cycle begins by
assembling an application and continues in the following manner.
        o press the snapshot button to see what's going on now
        o popup focus windows for a few interesting processes
        o press the snapshot button a few (or a few dozen!) more times
        o see the application completed, hung, deadlocked, etc...
        o press the trace button once and the timeline window is displayed
        o review the previous execution with trace log snapshots
        o make application changes and press the rerun button
No recompiles or special libraries are required to snapshot the
application or obtain a trace log.

%prep

rm -rf $RPM_BUILD_DIR/xmpi-%{version}
zcat $RPM_SOURCE_DIR/xmpi-%{version}-%{shortlibver}.tar.gz | tar -xvvf -
mv $RPM_BUILD_DIR/xmpi-%{version}-%{shortlibver} $RPM_BUILD_DIR/xmpi-%{version}
cd $RPM_BUILD_DIR/xmpi-%{version}
chown -R root:root .

./configure --with-lam --prefix=/usr/local/lam-%{libversion}

# build xmpi
%build
cd $RPM_BUILD_DIR/xmpi-%{version}
make

# install xmpi (into default prefix /usr/local/)
%install
cd $RPM_BUILD_DIR/xmpi-%{version}
make install

# as part of the install, make some symlinks
ln -s /usr/local/lam-%{libversion}/bin/xmpi /usr/bin/.
ln -s /usr/local/lam-%{libversion}/man/man1/xmpi.1 /usr/man/man1/.



%files
# xmpi documentation (to be installed in /usr/doc/xmpi-ver}
%doc $RPM_BUILD_DIR/xmpi-%{version}/INSTALL
%doc $RPM_BUILD_DIR/xmpi-%{version}/LICENSE
%doc $RPM_BUILD_DIR/xmpi-%{version}/README
%doc $RPM_BUILD_DIR/xmpi-%{version}/

/usr/local/lam-%{libversion}/app-defaults/XMPI
/usr/local/lam-%{libversion}/bin/xmpi
/usr/local/lam-%{libversion}/man/man1/xmpi.1

/usr/bin/xmpi
/usr/man/man1/.






