dnl -*- shell-script -*-
dnl
dnl $Id: cxx_find_depdirs.m4,v 1.1 2000/09/08 01:46:53 bbarrett Exp $
dnl

define([LSC_CXX_FIND_DEPDIRS],[
#
# Arguments: prefix (optional)
#
# Dependencies: os_find_depdirs.m4
#               cxx_have_stl.m4
#
# Looks for the include directories of the C++ compiler
# Will call LSC_CXX_HAVE_STL and AC_PROG_CXXCPP if they haven't been 
# called already.
#
# Sets prefix_CXX_DEPDIRS to "-Idir1 -Idir2..." or blank
# Must call AC_SUBST manually.
#

# Figure out what prefix to use
lsc_cxx_prefix="$1"
if test "$lsc_cxx_prefix" = ""; then
    lsc_cxx_prefix="LSC"
fi

# First we need to see if we need to check for STL
if test "$LSC_CXX_STL" = ""; then
    LSC_CXX_HAVE_STL
fi

# No go look
AC_LANG_SAVE
AC_LANG_CPLUSPLUS
lsc_temp="iostream.h new stdarg.h"
if test "$LSC_CXX_STL" = "1"; then
    lsc_temp="$lsc_temp map"
fi

AC_MSG_CHECKING([for C++ include directories])
LSC_OS_FIND_DEPDIRS([$lsc_temp], lsc_internal)
AC_MSG_RESULT([$lsc_internal_OS_DEPDIRS])

# Save results
lsc_name="${lsc_cxx_prefix}_CXX_DEPDIRS"
lsc_str="${lsc_name}=\"$lsc_internal_OS_DEPDIRS\""
eval $lsc_str

# Clean up
unset lsc_cxx_prefix lsc_name lsc_internal_OS_DEPDIRS lsc_str])dnl

