#include <gtk/gtk.h>
#include "libply.h"
#include "math.h"

extern float ply_angle_tilt,ply_angle_pan;

 void project(PlySurface *PS ,
		    float *x,float *y,float *z,
		    int size)
{
  *x= *x - PS->avg_x;
  *y= *y - PS->avg_y;
  *z= *z - PS->avg_z;

  *x = *x * size / PS->max_box;
  *y = *y * size / PS->max_box;
  *z = *z * size / PS->max_box;
  
  *y = *y * cos(ply_angle_tilt*(M_PI/180)) +  *z *  sin(ply_angle_tilt*(M_PI/180)) ;
  *x = atan2f((float)*x,(float)*z) / M_PI * size  ;
}

int render_ply_flat(PlySurface *PS ,
		    GdkDrawable *window,GdkGC*  gc,
		    // center of rendering
		    const int w, const int h)
{

  int p,fp,th,tw,trs,tc;
  float x,y,z,rho;
  GdkColor color;
  // this is useless
  //gdk_window_clear  (window); void
  gdk_draw_rectangle              (window,//GdkDrawable *drawable,
				   gc,//GdkGC *gc,
				   1,//gboolean filled,
				   0,//gint x,
				   0,//gint y,
				   2*w,//gint width,
				   2*h);//gint height);
  //extern GdkPixbuf* texture;
  //extern float PS->avg_z;

  guchar*  pixels=NULL;
  if(PS->texture) {  
    th=gdk_pixbuf_get_height (PS->texture);
    tw=gdk_pixbuf_get_width (PS->texture);
    trs=gdk_pixbuf_get_rowstride(PS->texture);
    tc=gdk_pixbuf_get_n_channels(PS->texture);
    pixels=gdk_pixbuf_get_pixels(PS->texture);
  }

 
  for(fp=0;fp<PS->flist_len;fp++) {
    gint npoints=PS->flist[fp] -> nverts;
    GdkPoint points[npoints];
    
    {
      int l;
      for(l=0;l<npoints;l++) {
	p=PS->flist[fp] -> verts[l];

	x= PS->vlist[p]->x;
	y= PS->vlist[p]->y;
	z= PS->vlist[p]->z;

	if(z < PS->avg_z - PS->max_box/2) goto loop;	
	project(PS, &x , &y, &z, (w+h)/2);

	rho=sqrt(x*x+z*z);
	//back culling

	if( rho < 2) goto loop;

	points[l].x= x+w;
	points[l].y=-y+h;
      }
    }
  
    {
      color.red=PS->vlist[p]->red;
      color.green=PS->vlist[p]->green;
      color.blue=PS->vlist[p]->blue;
      if(PS->texture &&
	 ((color.red==0 && color.green == 0 &&
	   color.blue == 0 ) ||
	  (color.red==255 && color.green == 255 &&
	   color.blue == 255 )
	  ) &&	 PS->flist[fp]->ntexcoord > 2 ) {
	int tx=  (double)tw*  ( PS->flist[fp]->texcoord[0])
	  ,ty=   (double)th*  (1-PS->flist[fp]->texcoord[1]) ;
	//tx=CLAMP(tx,0,tw);
	  //ty=CLAMP(ty,0,th);
	color.red  =pixels[tx*tc+ty*trs];
	color.green=pixels[tx*tc+ty*trs+1];
	color.blue =pixels[tx*tc+ty*trs+2];
      }
      else  //depth coloring
	color.red=color.blue=color.green=rho+ 4*(4&(int)rho);
    
      //printf("%d %d %d / ",color.red,color.green,color.blue);
      color.red *= 256;
      color.blue *= 256;
      color.green *= 256;

      gdk_colormap_alloc_color(gdk_colormap_get_system (),
			       &color,//GdkColor *color,
			       TRUE,TRUE);//gboolean writeable,
      //   gboolean best_match);    
      gdk_gc_set_foreground  (gc,&color);

    gdk_draw_polygon(window,//GdkDrawable *drawable,
		     gc,
		     TRUE,//gboolean filled,
		     points,
		     npoints);

    loop:
    }
  }
}

