/*
 * FILE : morph_wrap.c
 * 
 * This file was automatically generated by :
 * Simplified Wrapper and Interface Generator (SWIG)
 * Version 1.1  (Beta 5)
 * 
 * Copyright (c) 1995-1997
 * The University of Utah and The Regents of the University of California
 * 
 * Do not make changes to this file--changes will be lost!
 *
 */

/* Implementation : TCL 7.x */

#define INCLUDE_TCL    <tcl.h>
#define INCLUDE_TK     <tk.h>
#include INCLUDE_TCL
#include <string.h>
#include <stdlib.h>
#define SWIGTCL
/*
 * $Header: /cvsroot/xmorph/tkmorph/morph_wrap.c,v 20010421.1 2001/05/15 14:09:30 mennucc Exp $
 * 
 * swigtcl.cfg
 *
 * This file is modified from a platform independent file provided
 * by Sun.   With any luck this will allow SWIG generated wrapper
 * files to work on Unix, Windows, and Macintosh.
 *
 * Revision History
 * $Log: morph_wrap.c,v $
 * Revision 20010421.1  2001/05/15 14:09:30  mennucc
 * new version
 *
 * Revision 1.1.1.1  2000/11/10 18:15:22  mennucc
 * import . vendor start
 *
 * Revision 1.1  1996/05/22 19:47:45  beazley
 * Initial revision
 *
 *
 * -- Dave Beazley, May 2, 1996.
 *
 *	This file is an example of a Tcl dynamically loadable extension.
 *
 * Copyright (c) 1996 by Sun Microsystems, Inc.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 */

#if defined(__WIN32__)
#   define WIN32_LEAN_AND_MEAN
#   include <windows.h>
#   undef WIN32_LEAN_AND_MEAN

/*
 * VC++ has an alternate entry point called DllMain, so we need to rename
 * our entry point.
 */

#   if defined(_MSC_VER)
#	define EXPORT(a,b) __declspec(dllexport) a b
#	define DllEntryPoint DllMain
#   else
#	if defined(__BORLANDC__)
#	    define EXPORT(a,b) a _export b
#	else
#	    define EXPORT(a,b) a b
#	endif
#   endif
#else
#   define EXPORT(a,b) a b
#endif

/*
 *----------------------------------------------------------------------
 *
 * DllEntryPoint --
 *
 *	This wrapper function is used by Windows to invoke the
 *	initialization code for the DLL.  If we are compiling
 *	with Visual C++, this routine will be renamed to DllMain.
 *	routine.
 *
 * Results:
 *	Returns TRUE;
 *
 * Side effects:
 *	None.
 *
 *----------------------------------------------------------------------
 */

#ifdef __WIN32__
BOOL APIENTRY
DllEntryPoint(HINSTANCE hInst, DWORD reason, LPVOID reserved)
{
    return TRUE;
}
#endif

/*****************************************************************************
 * $Header: /cvsroot/xmorph/tkmorph/morph_wrap.c,v 20010421.1 2001/05/15 14:09:30 mennucc Exp $
 *
 * swigptr.swg
 *
 * This file contains supporting code for the SWIG run-time type checking
 * mechanism.  The following functions are available :
 *
 * SWIG_RegisterMapping(char *origtype, char *newtype, void *(*cast)(void *));
 *
 *      Registers a new type-mapping with the type-checker.  origtype is the
 *      original datatype and newtype is an equivalent type.  cast is optional
 *      pointer to a function to cast pointer values between types (this
 *      is typically used to cast pointers from derived classes to base classes in C++)
 *      
 * SWIG_MakePtr(char *buffer, void *ptr, char *typestring);
 *     
 *      Makes a pointer string from a pointer and typestring.  The result is returned
 *      in buffer which is assumed to hold enough space for the result.
 *
 * char * SWIG_GetPtr(char *buffer, void **ptr, char *type)
 *
 *      Gets a pointer value from a string.  If there is a type-mismatch, returns
 *      a character string to the received type.  On success, returns NULL.
 *
 *
 * You can remap these functions by making a file called "swigptr.swg" in
 * your the same directory as the interface file you are wrapping.
 *
 * These functions are normally declared static, but this file can be
 * can be used in a multi-module environment by redefining the symbol
 * SWIGSTATIC.
 *****************************************************************************/

#include <stdlib.h>

#ifdef SWIG_GLOBAL
#ifdef __cplusplus
#define SWIGSTATIC extern "C"
#else
#define SWIGSTATIC
#endif
#endif

#ifndef SWIGSTATIC
#define SWIGSTATIC static
#endif


/* SWIG pointer structure */

typedef struct SwigPtrType {
  char               *name;               /* Datatype name                  */
  int                 len;                /* Length (used for optimization) */
  void               *(*cast)(void *);    /* Pointer casting function       */
  struct SwigPtrType *next;               /* Linked list pointer            */
} SwigPtrType;

/* Pointer cache structure */

typedef struct {
  int                 stat;               /* Status (valid) bit             */
  SwigPtrType        *tp;                 /* Pointer to type structure      */
  char                name[256];          /* Given datatype name            */
  char                mapped[256];        /* Equivalent name                */
} SwigCacheType;

/* Some variables  */

static int SwigPtrMax  = 64;           /* Max entries that can be currently held */
                                       /* This value may be adjusted dynamically */
static int SwigPtrN    = 0;            /* Current number of entries              */
static int SwigPtrSort = 0;            /* Status flag indicating sort            */

/* Pointer table */
static SwigPtrType *SwigPtrTable = 0;  /* Table containing pointer equivalences  */

/* Cached values */

#define SWIG_CACHESIZE  8
#define SWIG_CACHEMASK  0x7
static SwigCacheType SwigCache[SWIG_CACHESIZE];  
static int SwigCacheIndex = 0;
static int SwigLastCache = 0;

/* Sort comparison function */
static int swigsort(const void *data1, const void *data2) {
	SwigPtrType *d1 = (SwigPtrType *) data1;
	SwigPtrType *d2 = (SwigPtrType *) data2;
	return strcmp(d1->name,d2->name);
}

/* Binary Search function */
static int swigcmp(const void *key, const void *data) {
  char *k = (char *) key;
  SwigPtrType *d = (SwigPtrType *) data;
  return strncmp(k,d->name,d->len);
}

/* Register a new datatype with the type-checker */

SWIGSTATIC 
void SWIG_RegisterMapping(char *origtype, char *newtype, void *(*cast)(void *)) {

  int i;
  SwigPtrType *t = 0,*t1;

  /* Allocate the pointer table if necessary */

  if (!SwigPtrTable) {     
    SwigPtrTable = (SwigPtrType *) malloc(SwigPtrMax*sizeof(SwigPtrType));
    SwigPtrN = 0;
  }
  /* Grow the table */
  if (SwigPtrN >= SwigPtrMax) {
    SwigPtrMax = 2*SwigPtrMax;
    SwigPtrTable = (SwigPtrType *) realloc(SwigPtrTable,SwigPtrMax*sizeof(SwigPtrType));
  }
  for (i = 0; i < SwigPtrN; i++)
    if (strcmp(SwigPtrTable[i].name,origtype) == 0) {
      t = &SwigPtrTable[i];
      break;
    }
  if (!t) {
    t = &SwigPtrTable[SwigPtrN];
    t->name = origtype;
    t->len = strlen(t->name);
    t->cast = 0;
    t->next = 0;
    SwigPtrN++;
  }

  /* Check for existing entry */

  while (t->next) {
    if ((strcmp(t->name,newtype) == 0)) {
      if (cast) t->cast = cast;
      return;
    }
    t = t->next;
  }
  
  /* Now place entry (in sorted order) */

  t1 = (SwigPtrType *) malloc(sizeof(SwigPtrType));
  t1->name = newtype;
  t1->len = strlen(t1->name);
  t1->cast = cast;
  t1->next = 0;            
  t->next = t1;           
  SwigPtrSort = 0;
}

/* Make a pointer value string */

SWIGSTATIC 
void SWIG_MakePtr(char *_c, const void *_ptr, char *type) {
  static char _hex[16] =
  {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
   'a', 'b', 'c', 'd', 'e', 'f'};
  unsigned long _p, _s;
  char _result[20], *_r;    /* Note : a 64-bit hex number = 16 digits */
  _r = _result;
  _p = (unsigned long) _ptr;
  if (_p > 0) {
    while (_p > 0) {
      _s = _p & 0xf;
      *(_r++) = _hex[_s];
      _p = _p >> 4;
    }
    *_r = '_';
    while (_r >= _result)
      *(_c++) = *(_r--);
  } else {
    strcpy (_c, "NULL");
  }
  if (_ptr)
    strcpy (_c, type);
}

/* Define for backwards compatibility */

#define _swig_make_hex   SWIG_MakePtr 

/* Function for getting a pointer value */

SWIGSTATIC 
char *SWIG_GetPtr(char *_c, void **ptr, char *_t)
{
  unsigned long _p;
  char temp_type[256];
  char *name;
  int  i, len;
  SwigPtrType *sp,*tp;
  SwigCacheType *cache;

  _p = 0;

  /* Pointer values must start with leading underscore */
  if (*_c == '_') {
      _c++;
      /* Extract hex value from pointer */
      while (*_c) {
	  if ((*_c >= '0') && (*_c <= '9'))
	    _p = (_p << 4) + (*_c - '0');
	  else if ((*_c >= 'a') && (*_c <= 'f'))
	    _p = (_p << 4) + ((*_c - 'a') + 10);
	  else
	    break;
	  _c++;
      }

      if (_t) {
	if (strcmp(_t,_c)) { 
	  if (!SwigPtrSort) {
	    qsort((void *) SwigPtrTable, SwigPtrN, sizeof(SwigPtrType), swigsort); 
	    SwigPtrSort = 1;
	    for (i = 0; i < SWIG_CACHESIZE; i++)  
	      SwigCache[i].stat = 0;
	  }
	  
	  /* First check cache for matches.  Uses last cache value as starting point */
	  cache = &SwigCache[SwigLastCache];
	  for (i = 0; i < SWIG_CACHESIZE; i++) {
	    if (cache->stat) {
	      if (strcmp(_t,cache->name) == 0) {
		if (strcmp(_c,cache->mapped) == 0) {
		  cache->stat++;
		  *ptr = (void *) _p;
		  if (cache->tp->cast) *ptr = (*(cache->tp->cast))(*ptr);
		  return (char *) 0;
		}
	      }
	    }
	    SwigLastCache = (SwigLastCache+1) & SWIG_CACHEMASK;
	    if (!SwigLastCache) cache = SwigCache;
	    else cache++;
	  }
	  /* We have a type mismatch.  Will have to look through our type
	     mapping table to figure out whether or not we can accept this datatype */

	  sp = (SwigPtrType *) bsearch(_t,SwigPtrTable,SwigPtrN,sizeof(SwigPtrType),swigcmp);
	  if (sp) {
	    while ((sp >= SwigPtrTable) && (swigcmp(_t,sp) == 0)) sp--;
	    sp++;
	    name = sp->name;
	    len = sp->len;
	    while (swigcmp(_t,sp) == 0) {
	      tp = sp->next;
	      /* Try to find entry for our given datatype */
	      while(tp) {
		if (tp->len >= 255) {
		  return _c;
		}
		strncpy(temp_type,tp->name,255);
		strncat(temp_type,_t+len,255-tp->len);
		if (strcmp(_c,temp_type) == 0) {
		  
		  strcpy(SwigCache[SwigCacheIndex].mapped,_c);
		  strcpy(SwigCache[SwigCacheIndex].name,_t);
		  SwigCache[SwigCacheIndex].stat = 1;
		  SwigCache[SwigCacheIndex].tp = tp;
		  SwigCacheIndex = SwigCacheIndex & SWIG_CACHEMASK;
		  
		  /* Get pointer value */
		  *ptr = (void *) _p;
		  if (tp->cast) *ptr = (*(tp->cast))(*ptr);
		  return (char *) 0;
		}
		tp = tp->next;
	      }
	      sp++;
	      /* Hmmm. Didn't find it this time */
	    }
	  }
	  /* Didn't find any sort of match for this data.  
	     Get the pointer value and return the received type */
	  *ptr = (void *) _p;
	  return _c;
	} else {
	  /* Found a match on the first try.  Return pointer value */
	  *ptr = (void *) _p;
	  return (char *) 0;
	}
      } else {
	/* No type specified.  Good luck */
	*ptr = (void *) _p;
	return (char *) 0;
      }
  } else {
#ifdef ALLOW_NULL
    if (strcmp (_c, "NULL") == 0)
      {
	*ptr = (void *) 0;
	return (char *) 0;
      }
#endif
    *ptr = (void *) 0;	
    return _c;
  }
}

/* Compatibility mode */

#define _swig_get_hex  SWIG_GetPtr

#define SWIG_init    Morph_Init


EXPORT(int,Morph_Init)(Tcl_Interp *);


  #include <limits.h>

  /* Create a new integer array */

  static int *int_array(int size) {
#ifdef __cplusplus
    return new int[size];
#else
    return (int *) malloc(size*sizeof(int));
#endif
  }

  /* Destroy an integer array */

  static void int_destroy(int *array) {
    if (array) {
#ifdef __cplusplus
      delete array;
#else
      free(array);
#endif
    }
  }

  /* Return an element */

  static int int_get(int *array, int index) {
    if (array) {
      return array[index];
    } else {
      return INT_MIN;
    }
  }
   
  /* Set an element */
  
  static int int_set(int *array, int index, int value) {
    if (array) {
      return (array[index] = value);
    } else {
      return INT_MIN;
    }
  }


  #include <float.h>

  /* Create a new float array */

  static float *float_array(int size) {
#ifdef __cplusplus
    return new float[size];
#else
    return (float *) malloc(size*sizeof(float));
#endif
  }

  /* Destroy an array */

  static void float_destroy(float *array) {
    if (array) {
#ifdef __cplusplus
      delete array;
#else
      free(array);
#endif
    }
  }

  /* Return an element */

  static float float_get(float *array, int index) {
    if (array) {
      return array[index];
    } else {
      return FLT_MIN;
    }
  }
   
  /* Set an element */
  
  static float float_set(float *array, int index, float value) {
    if (array) {
      return (array[index] = value);
    } else {
      return FLT_MIN;
    }
  }

  /* Create a new double array */

  static double *double_array(int size) {
#ifdef __cplusplus
    return new double[size];
#else
    return (double *) malloc(size*sizeof(double));
#endif
  }

  /* Destroy an array */

  static void double_destroy(double *array) {
    if (array) {
#ifdef __cplusplus
      delete array;
#else
      free(array);
#endif
    }
  }

  /* Return an element */

  static double double_get(double *array, int index) {
    if (array) {
      return array[index];
    } else {
      return FLT_MIN;
    }
  }
   
  /* Set an element */
  
  static double double_set(double *array, int index, double value) {
    if (array) {
      return (array[index] = value);
    } else {
      return FLT_MIN;
    }
  }


/* Create character string arrays */

static char **string_array(int size) {
  char **a;
  int i;
#ifdef __cplusplus
  a = new char *[size];
#else
  a = (char **) malloc(size*sizeof(char *));
#endif
  for (i = 0; i < size; i++)
    a[i] = 0;
  return a;
}

/* Destroy a string array */

static void string_destroy(char **array) {
  int i = 0;
  if (array) {
      while (array[i]) {
#ifdef __cplusplus
            delete array[i];
#else
            free(array[i]);
#endif
            i++;
      }          	
#ifdef __cplusplus
     delete array;
#else
     free(array);
#endif
   }      
}

/* Get an element */

static char *string_get(char **array_string, int index) {
  if (array_string) 
    if (array_string[index]) return (array_string[index]);
    else return "";
  else 
    return "";
}

/* Set an element */

static char *string_set(char **array_string, int index, char * val) {
  if (array_string) {
    if (array_string[index]) {
#ifdef __cplusplus
	delete array_string[index];
#else
        free(array_string[index]);
#endif
    }	
    if (strlen(val) > 0) {
#ifdef __cplusplus
      array_string[index] = new char[strlen(val)+1];
#else
      array_string[index] = (char *) malloc(strlen(val)+1);
#endif
      strcpy(array_string[index],val);
      return array_string[index];
    } else {
      array_string[index] = 0;
      return val;
    }
  } else return val;
}



#include <string.h>

/* Create an integer array of given size */

static int *array_int(int size) {
  return (int *) malloc(size*sizeof(int));
}

static int get_int(int *array_int, int index) {
  if (array_int) 
    return (array_int[index]);
  else 
    return 0;
}

static int set_int(int *array_int, int index, int val) {
  if (array_int)
    return (array_int[index] = val);
  else
    return 0;
}

/* Create double precision arrays */

static double *array_double(int size) {
  return (double *) malloc(size*sizeof(double));
}

static double get_double(double *array_double, int index) {
  if (array_double) 
    return (array_double[index]);
  else 
    return 0;
}

static double set_double(double *array_double, int index, double val) {
  if (array_double)
    return (array_double[index] = val);
  else
    return 0;
}

/* Create byte arrays */

typedef unsigned char byte;

static byte *array_byte(int size) {
  return (byte *) malloc(size*sizeof(byte));
}

static byte get_byte(byte *array_byte, int index) {
  if (array_byte) 
    return (array_byte[index]);
  else 
    return 0;
}

static byte set_byte(byte *array_byte, int index, byte val) {
  if (array_byte)
    return (array_byte[index] = val);
  else
    return 0;
}

/* Create character string arrays */

static char **array_string(int size) {
  char **a;
  int i;

  a = (char **) malloc(size*sizeof(char *));
  for (i = 0; i < size; i++)
    a[i] = 0;
  return a;
}

static char *get_string(char **array_string, int index) {
  if (array_string) 
    return (array_string[index]);
  else 
    return "";
}

static char *set_string(char **array_string, int index, char * val) {
  if (array_string) {
    if (array_string[index]) free(array_string[index]);
    if (strlen(val) > 0) {
      array_string[index] = (char *) malloc(strlen(val)+1);
      strcpy(array_string[index],val);
      return array_string[index];
    } else {
      array_string[index] = 0;
      return val;
    }
  }
  else
    return val;
  }


#include <stdlib.h>

#include <math.h>
extern double cos(double );
extern double sin(double );
extern double tan(double );
extern double acos(double );
extern double asin(double );
extern double atan(double );
extern double atan2(double ,double );
extern double cosh(double );
extern double sinh(double );
extern double tanh(double );
extern double exp(double );
extern double log(double );
extern double log10(double );
extern double pow(double ,double );
extern double sqrt(double );
extern double fabs(double );
extern double ceil(double );
extern double floor(double );
extern double fmod(double ,double );
static double  _wrap_const_M_E = 2.7182818284590452354;
static double  _wrap_const_M_LOG2E = 1.4426950408889634074;
static double  _wrap_const_M_LOG10E = 0.43429448190325182765;
static double  _wrap_const_M_LN2 = 0.69314718055994530942;
static double  _wrap_const_M_LN10 = 2.30258509299404568402;
static double  _wrap_const_M_PI = 3.14159265358979323846;
static double  _wrap_const_M_PI_2 = 1.57079632679489661923;
static double  _wrap_const_M_PI_4 = 0.78539816339744830962;
static double  _wrap_const_M_1_PI = 0.31830988618379067154;
static double  _wrap_const_M_2_PI = 0.63661977236758134308;
static double  _wrap_const_M_2_SQRTPI = 1.12837916709551257390;
static double  _wrap_const_M_SQRT2 = 1.41421356237309504880;
static double  _wrap_const_M_SQRT1_2 = 0.70710678118654752440;

#include "RgbaImage.h"
#include "mesh.h"
static int  _wrap_const_BITS_PER_CHANNEL = 8;
static int  _wrap_const_RGBA_IMAGE_MAXVAL = ((1<<(8))-1);
static int  _wrap_const_RGBA_IMAGE_OPAQUE = (((1<<(8))-1));

#include "mesh.h"



/* mesh_tcl_result: TCL Result string for mesh functions
//
// DESCRIPTION
// This is a sneaky way to return character string results to TCL while
// not having to worry about memory leaks, and while still using SWIG's
// wrapping abilities.  I.e., I don't have to worry about writing my
// own TCL wrapper code and registering it with TCL.
//
// NOTES
// The drawback to this method is potentially that returning a pointer to
// a string could cause problems if that pointer is abused, i.e., if the
// contents of that string are assumed to remain constant by the TCL code.
*/
#define MESH_TCL_RESULT_MAX_LEN 2048
static char mesh_tcl_result[MESH_TCL_RESULT_MAX_LEN];



/* NAME
//   meshLine: return a line of mesh point coordinate pairs as a string
//
//
// ARGUMENTS
//   this (in): mesh pointer
//
//   line_index (in): index of the row or column, depending on 'direction'
//
//   direction (in): 1 for row (horizontal line), 2 for column (vertical line)
//
//
// DESCRIPTION
//   meshLine returns a list of coordinate pairs of all of the mesh
//   points along a line of the given line_index and direction.
//
//
// RETURN VALUE
//   Returns the address of the result string, which is assumed to be
//   passed back to the TCL interpretter as a TCL list.
//   The string used is the global string mesh_tcl_result.  Using a
//   constant address eliminated potential memory leak problems.
//
//
// SEE ALSO
//   mesh_tcl_result
*/
char *
meshLine(const MeshT *this, const int line_index, const int direction)
{
  int vi;
  int nv;
  int str_len = 0;
  char float_string[64];
  int point_index = -10000;

  if(line_index < 0) {
    /* line_index is out of range */
    return NULL;
  }

  if(1 == direction) {
    nv = this->nx;
    if(line_index >= this->ny) {
      /* line_index is out of range */
      return NULL;
    }
  } else if (2 == direction) {
    nv = this->ny;
    if(line_index >= this->nx) {
      /* line_index is out of range */
      return NULL;
    }
  } else {
    /* Invalid value for direction */
    return NULL;
  }

  /* Empty the result string */
  mesh_tcl_result[0] = '\0';

  for(vi = 0; vi < nv; vi++) {
    if(1 == direction) {
      point_index = line_index * this->nx + vi;
    } else if (2 == direction) {
      point_index = vi * this->nx + line_index;
    }
    sprintf(float_string, " %.0f %.0f",
      this->x[point_index], this->y[point_index]);
    str_len += strlen(float_string);
    if(str_len >= MESH_TCL_RESULT_MAX_LEN) {
      fprintf(stderr, "meshLine: mesh_tcl_result length exceeded\n");
      return NULL;
    }
    strcat(mesh_tcl_result, float_string);
  }
  return mesh_tcl_result;
}
static int  _wrap_const_MP_PICK_DIST = 8;
static int _wrap_int_array(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    int * _result;
    int  _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. int_array nitems ",TCL_STATIC);
        return TCL_ERROR;
    }
    _arg0 = (int ) atol(argv[1]);
    _result = (int *)int_array(_arg0);
    SWIG_MakePtr(interp->result, (void *) _result,"_int_p");
    return TCL_OK;
}
static int _wrap_int_destroy(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    int * _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. int_destroy array ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_int_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of int_destroy. Expected _int_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    int_destroy(_arg0);
    return TCL_OK;
}
static int _wrap_int_get(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    int  _result;
    int * _arg0;
    int  _arg1;

    if ((argc < 3) || (argc > 3)) {
        Tcl_SetResult(interp, "Wrong # args. int_get array index ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_int_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of int_get. Expected _int_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = (int ) atol(argv[2]);
    _result = (int )int_get(_arg0,_arg1);
    sprintf(interp->result,"%ld", (long) _result);
    return TCL_OK;
}
static int _wrap_int_set(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    int  _result;
    int * _arg0;
    int  _arg1;
    int  _arg2;

    if ((argc < 4) || (argc > 4)) {
        Tcl_SetResult(interp, "Wrong # args. int_set array index value ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_int_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of int_set. Expected _int_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = (int ) atol(argv[2]);
    _arg2 = (int ) atol(argv[3]);
    _result = (int )int_set(_arg0,_arg1,_arg2);
    sprintf(interp->result,"%ld", (long) _result);
    return TCL_OK;
}
static int _wrap_double_array(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    double * _result;
    int  _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. double_array nitems ",TCL_STATIC);
        return TCL_ERROR;
    }
    _arg0 = (int ) atol(argv[1]);
    _result = (double *)double_array(_arg0);
    SWIG_MakePtr(interp->result, (void *) _result,"_double_p");
    return TCL_OK;
}
static int _wrap_double_destroy(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    double * _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. double_destroy array ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_double_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of double_destroy. Expected _double_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    double_destroy(_arg0);
    return TCL_OK;
}
static int _wrap_double_get(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    double  _result;
    double * _arg0;
    int  _arg1;

    if ((argc < 3) || (argc > 3)) {
        Tcl_SetResult(interp, "Wrong # args. double_get array index ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_double_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of double_get. Expected _double_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = (int ) atol(argv[2]);
    _result = (double )double_get(_arg0,_arg1);
    Tcl_PrintDouble(interp,(double) _result, interp->result);
    return TCL_OK;
}
static int _wrap_double_set(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    double  _result;
    double * _arg0;
    int  _arg1;
    double  _arg2;

    if ((argc < 4) || (argc > 4)) {
        Tcl_SetResult(interp, "Wrong # args. double_set array index value ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_double_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of double_set. Expected _double_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = (int ) atol(argv[2]);
    _arg2 = (double ) atof(argv[3]);
    _result = (double )double_set(_arg0,_arg1,_arg2);
    Tcl_PrintDouble(interp,(double) _result, interp->result);
    return TCL_OK;
}
static int _wrap_float_array(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    float * _result;
    int  _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. float_array nitems ",TCL_STATIC);
        return TCL_ERROR;
    }
    _arg0 = (int ) atol(argv[1]);
    _result = (float *)float_array(_arg0);
    SWIG_MakePtr(interp->result, (void *) _result,"_float_p");
    return TCL_OK;
}
static int _wrap_float_destroy(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    float * _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. float_destroy array ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_float_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of float_destroy. Expected _float_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    float_destroy(_arg0);
    return TCL_OK;
}
static int _wrap_float_get(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    float  _result;
    float * _arg0;
    int  _arg1;

    if ((argc < 3) || (argc > 3)) {
        Tcl_SetResult(interp, "Wrong # args. float_get array index ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_float_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of float_get. Expected _float_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = (int ) atol(argv[2]);
    _result = (float )float_get(_arg0,_arg1);
    Tcl_PrintDouble(interp,(double) _result, interp->result);
    return TCL_OK;
}
static int _wrap_float_set(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    float  _result;
    float * _arg0;
    int  _arg1;
    float  _arg2;

    if ((argc < 4) || (argc > 4)) {
        Tcl_SetResult(interp, "Wrong # args. float_set array index value ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_float_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of float_set. Expected _float_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = (int ) atol(argv[2]);
    _arg2 = (float ) atof(argv[3]);
    _result = (float )float_set(_arg0,_arg1,_arg2);
    Tcl_PrintDouble(interp,(double) _result, interp->result);
    return TCL_OK;
}
static int _wrap_string_array(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    char ** _result;
    int  _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. string_array nitems ",TCL_STATIC);
        return TCL_ERROR;
    }
    _arg0 = (int ) atol(argv[1]);
    _result = (char **)string_array(_arg0);
    SWIG_MakePtr(interp->result, (void *) _result,"_char_pp");
    return TCL_OK;
}
static int _wrap_string_destroy(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    char ** _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. string_destroy array ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_char_pp")) {
        Tcl_SetResult(interp, "Type error in argument 1 of string_destroy. Expected _char_pp, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    string_destroy(_arg0);
    return TCL_OK;
}
static int _wrap_string_get(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    char * _result;
    char ** _arg0;
    int  _arg1;

    if ((argc < 3) || (argc > 3)) {
        Tcl_SetResult(interp, "Wrong # args. string_get array index ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_char_pp")) {
        Tcl_SetResult(interp, "Type error in argument 1 of string_get. Expected _char_pp, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = (int ) atol(argv[2]);
    _result = (char *)string_get(_arg0,_arg1);
    Tcl_SetResult(interp, (char *) _result, TCL_VOLATILE);
    return TCL_OK;
}
static int _wrap_string_set(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    char * _result;
    char ** _arg0;
    int  _arg1;
    char * _arg2;

    if ((argc < 4) || (argc > 4)) {
        Tcl_SetResult(interp, "Wrong # args. string_set array index value ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_char_pp")) {
        Tcl_SetResult(interp, "Type error in argument 1 of string_set. Expected _char_pp, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = (int ) atol(argv[2]);
    _arg2 = argv[3];
    _result = (char *)string_set(_arg0,_arg1,_arg2);
    Tcl_SetResult(interp, (char *) _result, TCL_VOLATILE);
    return TCL_OK;
}
static int _wrap_array_int(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    int * _result;
    int  _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. array_int size ",TCL_STATIC);
        return TCL_ERROR;
    }
    _arg0 = (int ) atol(argv[1]);
    _result = (int *)array_int(_arg0);
    SWIG_MakePtr(interp->result, (void *) _result,"_int_p");
    return TCL_OK;
}
static int _wrap_get_int(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    int  _result;
    int * _arg0;
    int  _arg1;

    if ((argc < 3) || (argc > 3)) {
        Tcl_SetResult(interp, "Wrong # args. get_int array_int index ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_int_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of get_int. Expected _int_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = (int ) atol(argv[2]);
    _result = (int )get_int(_arg0,_arg1);
    sprintf(interp->result,"%ld", (long) _result);
    return TCL_OK;
}
static int _wrap_set_int(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    int  _result;
    int * _arg0;
    int  _arg1;
    int  _arg2;

    if ((argc < 4) || (argc > 4)) {
        Tcl_SetResult(interp, "Wrong # args. set_int array_int index ival ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_int_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of set_int. Expected _int_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = (int ) atol(argv[2]);
    _arg2 = (int ) atol(argv[3]);
    _result = (int )set_int(_arg0,_arg1,_arg2);
    sprintf(interp->result,"%ld", (long) _result);
    return TCL_OK;
}
static int _wrap_array_double(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    double * _result;
    int  _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. array_double size ",TCL_STATIC);
        return TCL_ERROR;
    }
    _arg0 = (int ) atol(argv[1]);
    _result = (double *)array_double(_arg0);
    SWIG_MakePtr(interp->result, (void *) _result,"_double_p");
    return TCL_OK;
}
static int _wrap_get_double(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    double  _result;
    double * _arg0;
    int  _arg1;

    if ((argc < 3) || (argc > 3)) {
        Tcl_SetResult(interp, "Wrong # args. get_double array_double index ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_double_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of get_double. Expected _double_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = (int ) atol(argv[2]);
    _result = (double )get_double(_arg0,_arg1);
    Tcl_PrintDouble(interp,(double) _result, interp->result);
    return TCL_OK;
}
static int _wrap_set_double(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    double  _result;
    double * _arg0;
    int  _arg1;
    double  _arg2;

    if ((argc < 4) || (argc > 4)) {
        Tcl_SetResult(interp, "Wrong # args. set_double array_double index dval ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_double_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of set_double. Expected _double_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = (int ) atol(argv[2]);
    _arg2 = (double ) atof(argv[3]);
    _result = (double )set_double(_arg0,_arg1,_arg2);
    Tcl_PrintDouble(interp,(double) _result, interp->result);
    return TCL_OK;
}
static int _wrap_array_byte(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    byte * _result;
    int  _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. array_byte nbytes ",TCL_STATIC);
        return TCL_ERROR;
    }
    _arg0 = (int ) atol(argv[1]);
    _result = (byte *)array_byte(_arg0);
    SWIG_MakePtr(interp->result, (void *) _result,"_byte_p");
    return TCL_OK;
}
static int _wrap_get_byte(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    byte  _result;
    byte * _arg0;
    int  _arg1;

    if ((argc < 3) || (argc > 3)) {
        Tcl_SetResult(interp, "Wrong # args. get_byte array_byte index ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_byte_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of get_byte. Expected _byte_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = (int ) atol(argv[2]);
    _result = (byte )get_byte(_arg0,_arg1);
    sprintf(interp->result,"%lu", (unsigned long) _result);
    return TCL_OK;
}
static int _wrap_set_byte(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    byte  _result;
    byte * _arg0;
    int  _arg1;
    byte  _arg2;

    if ((argc < 4) || (argc > 4)) {
        Tcl_SetResult(interp, "Wrong # args. set_byte array_byte index val ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_byte_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of set_byte. Expected _byte_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = (int ) atol(argv[2]);
    _arg2 = (byte ) strtoul(argv[3],(char **) NULL,0);
    _result = (byte )set_byte(_arg0,_arg1,_arg2);
    sprintf(interp->result,"%lu", (unsigned long) _result);
    return TCL_OK;
}
static int _wrap_array_string(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    char ** _result;
    int  _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. array_string size ",TCL_STATIC);
        return TCL_ERROR;
    }
    _arg0 = (int ) atol(argv[1]);
    _result = (char **)array_string(_arg0);
    SWIG_MakePtr(interp->result, (void *) _result,"_char_pp");
    return TCL_OK;
}
static int _wrap_get_string(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    char * _result;
    char ** _arg0;
    int  _arg1;

    if ((argc < 3) || (argc > 3)) {
        Tcl_SetResult(interp, "Wrong # args. get_string array_string index ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_char_pp")) {
        Tcl_SetResult(interp, "Type error in argument 1 of get_string. Expected _char_pp, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = (int ) atol(argv[2]);
    _result = (char *)get_string(_arg0,_arg1);
    Tcl_SetResult(interp, (char *) _result, TCL_VOLATILE);
    return TCL_OK;
}
static int _wrap_set_string(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    char * _result;
    char ** _arg0;
    int  _arg1;
    char * _arg2;

    if ((argc < 4) || (argc > 4)) {
        Tcl_SetResult(interp, "Wrong # args. set_string array_string index string ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_char_pp")) {
        Tcl_SetResult(interp, "Type error in argument 1 of set_string. Expected _char_pp, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = (int ) atol(argv[2]);
    _arg2 = argv[3];
    _result = (char *)set_string(_arg0,_arg1,_arg2);
    Tcl_SetResult(interp, (char *) _result, TCL_VOLATILE);
    return TCL_OK;
}
static int _wrap_atof(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    double  _result;
    char * _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. atof s ",TCL_STATIC);
        return TCL_ERROR;
    }
    _arg0 = argv[1];
    _result = (double )atof(_arg0);
    Tcl_PrintDouble(interp,(double) _result, interp->result);
    return TCL_OK;
}
static int _wrap_atoi(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    int  _result;
    char * _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. atoi s ",TCL_STATIC);
        return TCL_ERROR;
    }
    _arg0 = argv[1];
    _result = (int )atoi(_arg0);
    sprintf(interp->result,"%ld", (long) _result);
    return TCL_OK;
}
static int _wrap_atol(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    long  _result;
    char * _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. atol s ",TCL_STATIC);
        return TCL_ERROR;
    }
    _arg0 = argv[1];
    _result = (long )atol(_arg0);
    sprintf(interp->result,"%ld", (long) _result);
    return TCL_OK;
}
static int _wrap_rand(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    int  _result;

    if ((argc < 1) || (argc > 1)) {
        Tcl_SetResult(interp, "Wrong # args. rand ",TCL_STATIC);
        return TCL_ERROR;
    }
    _result = (int )rand();
    sprintf(interp->result,"%ld", (long) _result);
    return TCL_OK;
}
static int _wrap_srand(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    unsigned int  _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. srand seed ",TCL_STATIC);
        return TCL_ERROR;
    }
    _arg0 = (unsigned int ) strtoul(argv[1],(char **) NULL,0);
    srand(_arg0);
    return TCL_OK;
}
static int _wrap_calloc(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    void * _result;
    size_t  _arg0;
    size_t  _arg1;

    if ((argc < 3) || (argc > 3)) {
        Tcl_SetResult(interp, "Wrong # args. calloc nobj size ",TCL_STATIC);
        return TCL_ERROR;
    }
    _arg0 = (size_t ) strtoul(argv[1],(char **) NULL,0);
    _arg1 = (size_t ) strtoul(argv[2],(char **) NULL,0);
    _result = (void *)calloc(_arg0,_arg1);
    SWIG_MakePtr(interp->result, (void *) _result,"_void_p");
    return TCL_OK;
}
static int _wrap_malloc(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    void * _result;
    size_t  _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. malloc size ",TCL_STATIC);
        return TCL_ERROR;
    }
    _arg0 = (size_t ) strtoul(argv[1],(char **) NULL,0);
    _result = (void *)malloc(_arg0);
    SWIG_MakePtr(interp->result, (void *) _result,"_void_p");
    return TCL_OK;
}
static int _wrap_realloc(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    void * _result;
    void * _arg0;
    size_t  _arg1;

    if ((argc < 3) || (argc > 3)) {
        Tcl_SetResult(interp, "Wrong # args. realloc ptr size ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,(char *) 0)) {
        Tcl_SetResult(interp, "Type error in argument 1 of realloc. Expected _void_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = (size_t ) strtoul(argv[2],(char **) NULL,0);
    _result = (void *)realloc(_arg0,_arg1);
    SWIG_MakePtr(interp->result, (void *) _result,"_void_p");
    return TCL_OK;
}
static int _wrap_free(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    void * _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. free ptr ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,(char *) 0)) {
        Tcl_SetResult(interp, "Type error in argument 1 of free. Expected _void_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    free(_arg0);
    return TCL_OK;
}
static int _wrap_abort(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {


    if ((argc < 1) || (argc > 1)) {
        Tcl_SetResult(interp, "Wrong # args. abort ",TCL_STATIC);
        return TCL_ERROR;
    }
    abort();
    return TCL_OK;
}
static int _wrap_system(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    int  _result;
    char * _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. system s ",TCL_STATIC);
        return TCL_ERROR;
    }
    _arg0 = argv[1];
    _result = (int )system(_arg0);
    sprintf(interp->result,"%ld", (long) _result);
    return TCL_OK;
}
static int _wrap_getenv(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    char * _result;
    char * _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. getenv name ",TCL_STATIC);
        return TCL_ERROR;
    }
    _arg0 = argv[1];
    _result = (char *)getenv(_arg0);
    Tcl_SetResult(interp, (char *) _result, TCL_VOLATILE);
    return TCL_OK;
}
static int _wrap_abs(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    int  _result;
    int  _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. abs n ",TCL_STATIC);
        return TCL_ERROR;
    }
    _arg0 = (int ) atol(argv[1]);
    _result = (int )abs(_arg0);
    sprintf(interp->result,"%ld", (long) _result);
    return TCL_OK;
}
static int _wrap_labs(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    long  _result;
    long  _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. labs n ",TCL_STATIC);
        return TCL_ERROR;
    }
    _arg0 = (long ) atol(argv[1]);
    _result = (long )labs(_arg0);
    sprintf(interp->result,"%ld", (long) _result);
    return TCL_OK;
}
static int _wrap_cos(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    double  _result;
    double  _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. cos x ",TCL_STATIC);
        return TCL_ERROR;
    }
    _arg0 = (double ) atof(argv[1]);
    _result = (double )cos(_arg0);
    Tcl_PrintDouble(interp,(double) _result, interp->result);
    return TCL_OK;
}
static int _wrap_sin(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    double  _result;
    double  _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. sin x ",TCL_STATIC);
        return TCL_ERROR;
    }
    _arg0 = (double ) atof(argv[1]);
    _result = (double )sin(_arg0);
    Tcl_PrintDouble(interp,(double) _result, interp->result);
    return TCL_OK;
}
static int _wrap_tan(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    double  _result;
    double  _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. tan x ",TCL_STATIC);
        return TCL_ERROR;
    }
    _arg0 = (double ) atof(argv[1]);
    _result = (double )tan(_arg0);
    Tcl_PrintDouble(interp,(double) _result, interp->result);
    return TCL_OK;
}
static int _wrap_acos(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    double  _result;
    double  _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. acos x ",TCL_STATIC);
        return TCL_ERROR;
    }
    _arg0 = (double ) atof(argv[1]);
    _result = (double )acos(_arg0);
    Tcl_PrintDouble(interp,(double) _result, interp->result);
    return TCL_OK;
}
static int _wrap_asin(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    double  _result;
    double  _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. asin x ",TCL_STATIC);
        return TCL_ERROR;
    }
    _arg0 = (double ) atof(argv[1]);
    _result = (double )asin(_arg0);
    Tcl_PrintDouble(interp,(double) _result, interp->result);
    return TCL_OK;
}
static int _wrap_atan(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    double  _result;
    double  _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. atan x ",TCL_STATIC);
        return TCL_ERROR;
    }
    _arg0 = (double ) atof(argv[1]);
    _result = (double )atan(_arg0);
    Tcl_PrintDouble(interp,(double) _result, interp->result);
    return TCL_OK;
}
static int _wrap_atan2(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    double  _result;
    double  _arg0;
    double  _arg1;

    if ((argc < 3) || (argc > 3)) {
        Tcl_SetResult(interp, "Wrong # args. atan2 y x ",TCL_STATIC);
        return TCL_ERROR;
    }
    _arg0 = (double ) atof(argv[1]);
    _arg1 = (double ) atof(argv[2]);
    _result = (double )atan2(_arg0,_arg1);
    Tcl_PrintDouble(interp,(double) _result, interp->result);
    return TCL_OK;
}
static int _wrap_cosh(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    double  _result;
    double  _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. cosh x ",TCL_STATIC);
        return TCL_ERROR;
    }
    _arg0 = (double ) atof(argv[1]);
    _result = (double )cosh(_arg0);
    Tcl_PrintDouble(interp,(double) _result, interp->result);
    return TCL_OK;
}
static int _wrap_sinh(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    double  _result;
    double  _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. sinh x ",TCL_STATIC);
        return TCL_ERROR;
    }
    _arg0 = (double ) atof(argv[1]);
    _result = (double )sinh(_arg0);
    Tcl_PrintDouble(interp,(double) _result, interp->result);
    return TCL_OK;
}
static int _wrap_tanh(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    double  _result;
    double  _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. tanh x ",TCL_STATIC);
        return TCL_ERROR;
    }
    _arg0 = (double ) atof(argv[1]);
    _result = (double )tanh(_arg0);
    Tcl_PrintDouble(interp,(double) _result, interp->result);
    return TCL_OK;
}
static int _wrap_exp(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    double  _result;
    double  _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. exp x ",TCL_STATIC);
        return TCL_ERROR;
    }
    _arg0 = (double ) atof(argv[1]);
    _result = (double )exp(_arg0);
    Tcl_PrintDouble(interp,(double) _result, interp->result);
    return TCL_OK;
}
static int _wrap_log(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    double  _result;
    double  _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. log x ",TCL_STATIC);
        return TCL_ERROR;
    }
    _arg0 = (double ) atof(argv[1]);
    _result = (double )log(_arg0);
    Tcl_PrintDouble(interp,(double) _result, interp->result);
    return TCL_OK;
}
static int _wrap_log10(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    double  _result;
    double  _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. log10 x ",TCL_STATIC);
        return TCL_ERROR;
    }
    _arg0 = (double ) atof(argv[1]);
    _result = (double )log10(_arg0);
    Tcl_PrintDouble(interp,(double) _result, interp->result);
    return TCL_OK;
}
static int _wrap_pow(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    double  _result;
    double  _arg0;
    double  _arg1;

    if ((argc < 3) || (argc > 3)) {
        Tcl_SetResult(interp, "Wrong # args. pow x y ",TCL_STATIC);
        return TCL_ERROR;
    }
    _arg0 = (double ) atof(argv[1]);
    _arg1 = (double ) atof(argv[2]);
    _result = (double )pow(_arg0,_arg1);
    Tcl_PrintDouble(interp,(double) _result, interp->result);
    return TCL_OK;
}
static int _wrap_sqrt(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    double  _result;
    double  _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. sqrt x ",TCL_STATIC);
        return TCL_ERROR;
    }
    _arg0 = (double ) atof(argv[1]);
    _result = (double )sqrt(_arg0);
    Tcl_PrintDouble(interp,(double) _result, interp->result);
    return TCL_OK;
}
static int _wrap_fabs(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    double  _result;
    double  _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. fabs x ",TCL_STATIC);
        return TCL_ERROR;
    }
    _arg0 = (double ) atof(argv[1]);
    _result = (double )fabs(_arg0);
    Tcl_PrintDouble(interp,(double) _result, interp->result);
    return TCL_OK;
}
static int _wrap_ceil(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    double  _result;
    double  _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. ceil x ",TCL_STATIC);
        return TCL_ERROR;
    }
    _arg0 = (double ) atof(argv[1]);
    _result = (double )ceil(_arg0);
    Tcl_PrintDouble(interp,(double) _result, interp->result);
    return TCL_OK;
}
static int _wrap_floor(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    double  _result;
    double  _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. floor x ",TCL_STATIC);
        return TCL_ERROR;
    }
    _arg0 = (double ) atof(argv[1]);
    _result = (double )floor(_arg0);
    Tcl_PrintDouble(interp,(double) _result, interp->result);
    return TCL_OK;
}
static int _wrap_fmod(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    double  _result;
    double  _arg0;
    double  _arg1;

    if ((argc < 3) || (argc > 3)) {
        Tcl_SetResult(interp, "Wrong # args. fmod x y ",TCL_STATIC);
        return TCL_ERROR;
    }
    _arg0 = (double ) atof(argv[1]);
    _arg1 = (double ) atof(argv[2]);
    _result = (double )fmod(_arg0,_arg1);
    Tcl_PrintDouble(interp,(double) _result, interp->result);
    return TCL_OK;
}
static int _wrap_rgbaImageInit(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    RgbaImageT * _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. rgbaImageInit self ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_RgbaImageT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of rgbaImageInit. Expected _RgbaImageT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    rgbaImageInit(_arg0);
    return TCL_OK;
}
static int _wrap_rgbaImageNew(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    RgbaImageT * _result;

    if ((argc < 1) || (argc > 1)) {
        Tcl_SetResult(interp, "Wrong # args. rgbaImageNew ",TCL_STATIC);
        return TCL_ERROR;
    }
    _result = (RgbaImageT *)rgbaImageNew();
    SWIG_MakePtr(interp->result, (void *) _result,"_RgbaImageT_p");
    return TCL_OK;
}
static int _wrap_rgbaImageDelete(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    RgbaImageT * _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. rgbaImageDelete self ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_RgbaImageT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of rgbaImageDelete. Expected _RgbaImageT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    rgbaImageDelete(_arg0);
    return TCL_OK;
}
static int _wrap_rgbaImageFree(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    RgbaImageT * _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. rgbaImageFree self ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_RgbaImageT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of rgbaImageFree. Expected _RgbaImageT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    rgbaImageFree(_arg0);
    return TCL_OK;
}
static int _wrap_rgbaImageAlloc(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    int  _result;
    RgbaImageT * _arg0;
    int  _arg1;
    int  _arg2;

    if ((argc < 4) || (argc > 4)) {
        Tcl_SetResult(interp, "Wrong # args. rgbaImageAlloc self nx ny ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_RgbaImageT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of rgbaImageAlloc. Expected _RgbaImageT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = (int ) atol(argv[2]);
    _arg2 = (int ) atol(argv[3]);
    _result = (int )rgbaImageAlloc(_arg0,_arg1,_arg2);
    sprintf(interp->result,"%ld", (long) _result);
    return TCL_OK;
}
static int _wrap_rgbaImageDissolve(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    int  _result;
    RgbaImageT * _arg0;
    RgbaImageT * _arg1;
    RgbaImageT * _arg2;
    float  _arg3;

    if ((argc < 5) || (argc > 5)) {
        Tcl_SetResult(interp, "Wrong # args. rgbaImageDissolve self siP diP dissolve ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_RgbaImageT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of rgbaImageDissolve. Expected _RgbaImageT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[2],(void **) &_arg1,"_RgbaImageT_p")) {
        Tcl_SetResult(interp, "Type error in argument 2 of rgbaImageDissolve. Expected _RgbaImageT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[2], (char *) NULL);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[3],(void **) &_arg2,"_RgbaImageT_p")) {
        Tcl_SetResult(interp, "Type error in argument 3 of rgbaImageDissolve. Expected _RgbaImageT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[3], (char *) NULL);
        return TCL_ERROR;
    }
    _arg3 = (float ) atof(argv[4]);
    _result = (int )rgbaImageDissolve(_arg0,_arg1,_arg2,_arg3);
    sprintf(interp->result,"%ld", (long) _result);
    return TCL_OK;
}
static int _wrap_rgbaImageRead(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    int  _result;
    RgbaImageT * _arg0;
    char * _arg1;

    if ((argc < 3) || (argc > 3)) {
        Tcl_SetResult(interp, "Wrong # args. rgbaImageRead self filename ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_RgbaImageT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of rgbaImageRead. Expected _RgbaImageT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = argv[2];
    _result = (int )rgbaImageRead(_arg0,_arg1);
    sprintf(interp->result,"%ld", (long) _result);
    return TCL_OK;
}
static int _wrap_rgbaImageWrite(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    int  _result;
    char * _arg0;
    RgbaImageT * _arg1;
    RgbaImageT * _arg2;
    float  _arg3;

    if ((argc < 5) || (argc > 5)) {
        Tcl_SetResult(interp, "Wrong # args. rgbaImageWrite filename siP diP dissolve ",TCL_STATIC);
        return TCL_ERROR;
    }
    _arg0 = argv[1];
    if (SWIG_GetPtr(argv[2],(void **) &_arg1,"_RgbaImageT_p")) {
        Tcl_SetResult(interp, "Type error in argument 2 of rgbaImageWrite. Expected _RgbaImageT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[2], (char *) NULL);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[3],(void **) &_arg2,"_RgbaImageT_p")) {
        Tcl_SetResult(interp, "Type error in argument 3 of rgbaImageWrite. Expected _RgbaImageT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[3], (char *) NULL);
        return TCL_ERROR;
    }
    _arg3 = (float ) atof(argv[4]);
    _result = (int )rgbaImageWrite(_arg0,_arg1,_arg2,_arg3);
    sprintf(interp->result,"%ld", (long) _result);
    return TCL_OK;
}
static int _wrap_rgbaImageTestCreate(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    int  _result;
    RgbaImageT * _arg0;
    int  _arg1;

    if ((argc < 3) || (argc > 3)) {
        Tcl_SetResult(interp, "Wrong # args. rgbaImageTestCreate self type ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_RgbaImageT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of rgbaImageTestCreate. Expected _RgbaImageT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = (int ) atol(argv[2]);
    _result = (int )rgbaImageTestCreate(_arg0,_arg1);
    sprintf(interp->result,"%ld", (long) _result);
    return TCL_OK;
}
static int _wrap_meshInit(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    MeshT * _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. meshInit this ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of meshInit. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    meshInit(_arg0);
    return TCL_OK;
}
static int _wrap_meshAlloc(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    int  _result;
    MeshT * _arg0;
    int  _arg1;
    int  _arg2;

    if ((argc < 4) || (argc > 4)) {
        Tcl_SetResult(interp, "Wrong # args. meshAlloc this nx ny ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of meshAlloc. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = (int ) atol(argv[2]);
    _arg2 = (int ) atol(argv[3]);
    _result = (int )meshAlloc(_arg0,_arg1,_arg2);
    sprintf(interp->result,"%ld", (long) _result);
    return TCL_OK;
}
static int _wrap_meshNew(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    MeshT * _result;
    int  _arg0;
    int  _arg1;

    if ((argc < 3) || (argc > 3)) {
        Tcl_SetResult(interp, "Wrong # args. meshNew nx ny ",TCL_STATIC);
        return TCL_ERROR;
    }
    _arg0 = (int ) atol(argv[1]);
    _arg1 = (int ) atol(argv[2]);
    _result = (MeshT *)meshNew(_arg0,_arg1);
    SWIG_MakePtr(interp->result, (void *) _result,"_MeshT_p");
    return TCL_OK;
}
static int _wrap_meshFree(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    MeshT * _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. meshFree this ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of meshFree. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    meshFree(_arg0);
    return TCL_OK;
}
static int _wrap_meshDelete(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    MeshT * _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. meshDelete this ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of meshDelete. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    meshDelete(_arg0);
    return TCL_OK;
}
static int _wrap_meshPrint(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    MeshT * _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. meshPrint this ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of meshPrint. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    meshPrint(_arg0);
    return TCL_OK;
}
static int _wrap_meshCompatibilityCheck(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    int  _result;
    MeshT * _arg0;
    MeshT * _arg1;

    if ((argc < 3) || (argc > 3)) {
        Tcl_SetResult(interp, "Wrong # args. meshCompatibilityCheck this other ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of meshCompatibilityCheck. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[2],(void **) &_arg1,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 2 of meshCompatibilityCheck. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[2], (char *) NULL);
        return TCL_ERROR;
    }
    _result = (int )meshCompatibilityCheck(_arg0,_arg1);
    sprintf(interp->result,"%ld", (long) _result);
    return TCL_OK;
}
static int _wrap_meshInterpolate(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    MeshT * _arg0;
    MeshT * _arg1;
    MeshT * _arg2;
    float  _arg3;

    if ((argc < 5) || (argc > 5)) {
        Tcl_SetResult(interp, "Wrong # args. meshInterpolate moP m1P m2P tween_param ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of meshInterpolate. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[2],(void **) &_arg1,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 2 of meshInterpolate. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[2], (char *) NULL);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[3],(void **) &_arg2,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 3 of meshInterpolate. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[3], (char *) NULL);
        return TCL_ERROR;
    }
    _arg3 = (float ) atof(argv[4]);
    meshInterpolate(_arg0,_arg1,_arg2,_arg3);
    return TCL_OK;
}
static int _wrap_meshReset(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    MeshT * _arg0;
    int  _arg1;
    int  _arg2;

    if ((argc < 4) || (argc > 4)) {
        Tcl_SetResult(interp, "Wrong # args. meshReset this img_width img_height ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of meshReset. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = (int ) atol(argv[2]);
    _arg2 = (int ) atol(argv[3]);
    meshReset(_arg0,_arg1,_arg2);
    return TCL_OK;
}
static int _wrap_meshScale(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    MeshT * _arg0;
    int  _arg1;
    int  _arg2;

    if ((argc < 4) || (argc > 4)) {
        Tcl_SetResult(interp, "Wrong # args. meshScale this img_width img_height ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of meshScale. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = (int ) atol(argv[2]);
    _arg2 = (int ) atol(argv[3]);
    meshScale(_arg0,_arg1,_arg2);
    return TCL_OK;
}
static int _wrap_meshFunctionalize(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    int  _result;
    MeshT * _arg0;
    int  _arg1;
    int  _arg2;

    if ((argc < 4) || (argc > 4)) {
        Tcl_SetResult(interp, "Wrong # args. meshFunctionalize this img_width img_height ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of meshFunctionalize. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = (int ) atol(argv[2]);
    _arg2 = (int ) atol(argv[3]);
    _result = (int )meshFunctionalize(_arg0,_arg1,_arg2);
    sprintf(interp->result,"%ld", (long) _result);
    return TCL_OK;
}
static int _wrap_meshPointNearest(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    long  _result;
    MeshT * _arg0;
    int  _arg1;
    int  _arg2;
    int * _arg3;
    int * _arg4;
    int * _arg5;
    int * _arg6;

    if ((argc < 8) || (argc > 8)) {
        Tcl_SetResult(interp, "Wrong # args. meshPointNearest this px py mi mj dx dy ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of meshPointNearest. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = (int ) atol(argv[2]);
    _arg2 = (int ) atol(argv[3]);
    if (SWIG_GetPtr(argv[4],(void **) &_arg3,"_int_p")) {
        Tcl_SetResult(interp, "Type error in argument 4 of meshPointNearest. Expected _int_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[4], (char *) NULL);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[5],(void **) &_arg4,"_int_p")) {
        Tcl_SetResult(interp, "Type error in argument 5 of meshPointNearest. Expected _int_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[5], (char *) NULL);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[6],(void **) &_arg5,"_int_p")) {
        Tcl_SetResult(interp, "Type error in argument 6 of meshPointNearest. Expected _int_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[6], (char *) NULL);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[7],(void **) &_arg6,"_int_p")) {
        Tcl_SetResult(interp, "Type error in argument 7 of meshPointNearest. Expected _int_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[7], (char *) NULL);
        return TCL_ERROR;
    }
    _result = (long )meshPointNearest(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5,_arg6);
    sprintf(interp->result,"%ld", (long) _result);
    return TCL_OK;
}
static int _wrap_meshPick(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    int  _result;
    MeshT * _arg0;
    int  _arg1;
    int  _arg2;
    int  _arg3;
    float  _arg4;

    if ((argc < 6) || (argc > 6)) {
        Tcl_SetResult(interp, "Wrong # args. meshPick this mouse_x mouse_y component proximity ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of meshPick. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = (int ) atol(argv[2]);
    _arg2 = (int ) atol(argv[3]);
    _arg3 = (int ) atol(argv[4]);
    _arg4 = (float ) atof(argv[5]);
    _result = (int )meshPick(_arg0,_arg1,_arg2,_arg3,_arg4);
    sprintf(interp->result,"%ld", (long) _result);
    return TCL_OK;
}
static int _wrap_meshSet(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    MeshT * _arg0;
    int  _arg1;
    int  _arg2;
    float  _arg3;
    float  _arg4;

    if ((argc < 6) || (argc > 6)) {
        Tcl_SetResult(interp, "Wrong # args. meshSet this xi yi new_x new_y ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of meshSet. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = (int ) atol(argv[2]);
    _arg2 = (int ) atol(argv[3]);
    _arg3 = (float ) atof(argv[4]);
    _arg4 = (float ) atof(argv[5]);
    meshSet(_arg0,_arg1,_arg2,_arg3,_arg4);
    return TCL_OK;
}
static int _wrap_meshCopy(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    MeshT * _arg0;
    MeshT * _arg1;

    if ((argc < 3) || (argc > 3)) {
        Tcl_SetResult(interp, "Wrong # args. meshCopy this source ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of meshCopy. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[2],(void **) &_arg1,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 2 of meshCopy. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[2], (char *) NULL);
        return TCL_ERROR;
    }
    meshCopy(_arg0,_arg1);
    return TCL_OK;
}
static int _wrap_meshBackupIndexSet(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    int  _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. meshBackupIndexSet backup_index ",TCL_STATIC);
        return TCL_ERROR;
    }
    _arg0 = (int ) atol(argv[1]);
    meshBackupIndexSet(_arg0);
    return TCL_OK;
}
static int _wrap_meshBackupFree(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {


    if ((argc < 1) || (argc > 1)) {
        Tcl_SetResult(interp, "Wrong # args. meshBackupFree ",TCL_STATIC);
        return TCL_ERROR;
    }
    meshBackupFree();
    return TCL_OK;
}
static int _wrap_meshStore(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    MeshT * _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. meshStore this ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of meshStore. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    meshStore(_arg0);
    return TCL_OK;
}
static int _wrap_meshRetrieve(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    MeshT * _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. meshRetrieve this ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of meshRetrieve. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    meshRetrieve(_arg0);
    return TCL_OK;
}
static int _wrap_meshLineAdd(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    int  _result;
    MeshT * _arg0;
    int  _arg1;
    float  _arg2;
    int  _arg3;

    if ((argc < 5) || (argc > 5)) {
        Tcl_SetResult(interp, "Wrong # args. meshLineAdd this mi mt type ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of meshLineAdd. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = (int ) atol(argv[2]);
    _arg2 = (float ) atof(argv[3]);
    _arg3 = (int ) atol(argv[4]);
    _result = (int )meshLineAdd(_arg0,_arg1,_arg2,_arg3);
    sprintf(interp->result,"%ld", (long) _result);
    return TCL_OK;
}
static int _wrap_meshLineDelete(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    int  _result;
    MeshT * _arg0;
    int  _arg1;
    int  _arg2;

    if ((argc < 4) || (argc > 4)) {
        Tcl_SetResult(interp, "Wrong # args. meshLineDelete this mi type ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of meshLineDelete. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = (int ) atol(argv[2]);
    _arg2 = (int ) atol(argv[3]);
    _result = (int )meshLineDelete(_arg0,_arg1,_arg2);
    sprintf(interp->result,"%ld", (long) _result);
    return TCL_OK;
}
static int _wrap_meshLineMouseModify(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    int  _result;
    MeshT * _arg0;
    MeshT * _arg1;
    int  _arg2;
    int  _arg3;
    char  _arg4;
    char  _arg5;

    if ((argc < 7) || (argc > 7)) {
        Tcl_SetResult(interp, "Wrong # args. meshLineMouseModify this other mouse_x mouse_y line_type action ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of meshLineMouseModify. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[2],(void **) &_arg1,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 2 of meshLineMouseModify. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[2], (char *) NULL);
        return TCL_ERROR;
    }
    _arg2 = (int ) atol(argv[3]);
    _arg3 = (int ) atol(argv[4]);
    _arg4 = *argv[5];
    _arg5 = *argv[6];
    _result = (int )meshLineMouseModify(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5);
    sprintf(interp->result,"%ld", (long) _result);
    return TCL_OK;
}
static int _wrap_meshRead(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    int  _result;
    MeshT * _arg0;
    char * _arg1;

    if ((argc < 3) || (argc > 3)) {
        Tcl_SetResult(interp, "Wrong # args. meshRead this filename ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of meshRead. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = argv[2];
    _result = (int )meshRead(_arg0,_arg1);
    sprintf(interp->result,"%ld", (long) _result);
    return TCL_OK;
}
static int _wrap_meshWrite(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    int  _result;
    MeshT * _arg0;
    char * _arg1;

    if ((argc < 3) || (argc > 3)) {
        Tcl_SetResult(interp, "Wrong # args. meshWrite this filename ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of meshWrite. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = argv[2];
    _result = (int )meshWrite(_arg0,_arg1);
    sprintf(interp->result,"%ld", (long) _result);
    return TCL_OK;
}
static int _wrap_meshMatch(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    MeshT * _arg0;
    MeshT * _arg1;

    if ((argc < 3) || (argc > 3)) {
        Tcl_SetResult(interp, "Wrong # args. meshMatch this other ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of meshMatch. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[2],(void **) &_arg1,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 2 of meshMatch. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[2], (char *) NULL);
        return TCL_ERROR;
    }
    meshMatch(_arg0,_arg1);
    return TCL_OK;
}
static int  RgbaImageT_nrows_set(RgbaImageT *obj, int  val) {
    return (obj->nrows = val);
}
static int _wrap_RgbaImageT_nrows_set(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    int  _result;
    RgbaImageT * _arg0;
    int  _arg1;

    if ((argc < 3) || (argc > 3)) {
        Tcl_SetResult(interp, "Wrong # args. RgbaImageT_nrows_set { RgbaImageT * } { int  } ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_RgbaImageT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of RgbaImageT_nrows_set. Expected _RgbaImageT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = (int ) atol(argv[2]);
    _result = (int )RgbaImageT_nrows_set(_arg0,_arg1);
    sprintf(interp->result,"%ld", (long) _result);
    return TCL_OK;
}
static int  RgbaImageT_nrows_get(RgbaImageT *obj) {
    int  result;
    result = (int ) obj->nrows;
    return result;
}
static int _wrap_RgbaImageT_nrows_get(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    int  _result;
    RgbaImageT * _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. RgbaImageT_nrows_get { RgbaImageT * } ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_RgbaImageT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of RgbaImageT_nrows_get. Expected _RgbaImageT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _result = (int )RgbaImageT_nrows_get(_arg0);
    sprintf(interp->result,"%ld", (long) _result);
    return TCL_OK;
}
static int  RgbaImageT_ncols_set(RgbaImageT *obj, int  val) {
    return (obj->ncols = val);
}
static int _wrap_RgbaImageT_ncols_set(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    int  _result;
    RgbaImageT * _arg0;
    int  _arg1;

    if ((argc < 3) || (argc > 3)) {
        Tcl_SetResult(interp, "Wrong # args. RgbaImageT_ncols_set { RgbaImageT * } { int  } ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_RgbaImageT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of RgbaImageT_ncols_set. Expected _RgbaImageT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = (int ) atol(argv[2]);
    _result = (int )RgbaImageT_ncols_set(_arg0,_arg1);
    sprintf(interp->result,"%ld", (long) _result);
    return TCL_OK;
}
static int  RgbaImageT_ncols_get(RgbaImageT *obj) {
    int  result;
    result = (int ) obj->ncols;
    return result;
}
static int _wrap_RgbaImageT_ncols_get(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    int  _result;
    RgbaImageT * _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. RgbaImageT_ncols_get { RgbaImageT * } ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_RgbaImageT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of RgbaImageT_ncols_get. Expected _RgbaImageT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _result = (int )RgbaImageT_ncols_get(_arg0);
    sprintf(interp->result,"%ld", (long) _result);
    return TCL_OK;
}
static int  RgbaImageT_compressed_set(RgbaImageT *obj, int  val) {
    return (obj->compressed = val);
}
static int _wrap_RgbaImageT_compressed_set(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    int  _result;
    RgbaImageT * _arg0;
    int  _arg1;

    if ((argc < 3) || (argc > 3)) {
        Tcl_SetResult(interp, "Wrong # args. RgbaImageT_compressed_set { RgbaImageT * } { int  } ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_RgbaImageT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of RgbaImageT_compressed_set. Expected _RgbaImageT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = (int ) atol(argv[2]);
    _result = (int )RgbaImageT_compressed_set(_arg0,_arg1);
    sprintf(interp->result,"%ld", (long) _result);
    return TCL_OK;
}
static int  RgbaImageT_compressed_get(RgbaImageT *obj) {
    int  result;
    result = (int ) obj->compressed;
    return result;
}
static int _wrap_RgbaImageT_compressed_get(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    int  _result;
    RgbaImageT * _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. RgbaImageT_compressed_get { RgbaImageT * } ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_RgbaImageT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of RgbaImageT_compressed_get. Expected _RgbaImageT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _result = (int )RgbaImageT_compressed_get(_arg0);
    sprintf(interp->result,"%ld", (long) _result);
    return TCL_OK;
}
static int  RgbaImageT_pixel_size_set(RgbaImageT *obj, int  val) {
    return (obj->pixel_size = val);
}
static int _wrap_RgbaImageT_pixel_size_set(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    int  _result;
    RgbaImageT * _arg0;
    int  _arg1;

    if ((argc < 3) || (argc > 3)) {
        Tcl_SetResult(interp, "Wrong # args. RgbaImageT_pixel_size_set { RgbaImageT * } { int  } ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_RgbaImageT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of RgbaImageT_pixel_size_set. Expected _RgbaImageT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = (int ) atol(argv[2]);
    _result = (int )RgbaImageT_pixel_size_set(_arg0,_arg1);
    sprintf(interp->result,"%ld", (long) _result);
    return TCL_OK;
}
static int  RgbaImageT_pixel_size_get(RgbaImageT *obj) {
    int  result;
    result = (int ) obj->pixel_size;
    return result;
}
static int _wrap_RgbaImageT_pixel_size_get(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    int  _result;
    RgbaImageT * _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. RgbaImageT_pixel_size_get { RgbaImageT * } ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_RgbaImageT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of RgbaImageT_pixel_size_get. Expected _RgbaImageT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _result = (int )RgbaImageT_pixel_size_get(_arg0);
    sprintf(interp->result,"%ld", (long) _result);
    return TCL_OK;
}
static int  RgbaImageT_color_mapped_set(RgbaImageT *obj, int  val) {
    return (obj->color_mapped = val);
}
static int _wrap_RgbaImageT_color_mapped_set(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    int  _result;
    RgbaImageT * _arg0;
    int  _arg1;

    if ((argc < 3) || (argc > 3)) {
        Tcl_SetResult(interp, "Wrong # args. RgbaImageT_color_mapped_set { RgbaImageT * } { int  } ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_RgbaImageT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of RgbaImageT_color_mapped_set. Expected _RgbaImageT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = (int ) atol(argv[2]);
    _result = (int )RgbaImageT_color_mapped_set(_arg0,_arg1);
    sprintf(interp->result,"%ld", (long) _result);
    return TCL_OK;
}
static int  RgbaImageT_color_mapped_get(RgbaImageT *obj) {
    int  result;
    result = (int ) obj->color_mapped;
    return result;
}
static int _wrap_RgbaImageT_color_mapped_get(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    int  _result;
    RgbaImageT * _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. RgbaImageT_color_mapped_get { RgbaImageT * } ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_RgbaImageT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of RgbaImageT_color_mapped_get. Expected _RgbaImageT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _result = (int )RgbaImageT_color_mapped_get(_arg0);
    sprintf(interp->result,"%ld", (long) _result);
    return TCL_OK;
}
static int  RgbaImageT_type_set(RgbaImageT *obj, int  val) {
    return (obj->type = val);
}
static int _wrap_RgbaImageT_type_set(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    int  _result;
    RgbaImageT * _arg0;
    int  _arg1;

    if ((argc < 3) || (argc > 3)) {
        Tcl_SetResult(interp, "Wrong # args. RgbaImageT_type_set { RgbaImageT * } { int  } ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_RgbaImageT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of RgbaImageT_type_set. Expected _RgbaImageT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = (int ) atol(argv[2]);
    _result = (int )RgbaImageT_type_set(_arg0,_arg1);
    sprintf(interp->result,"%ld", (long) _result);
    return TCL_OK;
}
static int  RgbaImageT_type_get(RgbaImageT *obj) {
    int  result;
    result = (int ) obj->type;
    return result;
}
static int _wrap_RgbaImageT_type_get(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    int  _result;
    RgbaImageT * _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. RgbaImageT_type_get { RgbaImageT * } ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_RgbaImageT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of RgbaImageT_type_get. Expected _RgbaImageT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _result = (int )RgbaImageT_type_get(_arg0);
    sprintf(interp->result,"%ld", (long) _result);
    return TCL_OK;
}
static unsigned char * RgbaImageT_ri_set(RgbaImageT *obj, unsigned char * val) {
    return (obj->ri = val);
}
static int _wrap_RgbaImageT_ri_set(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    unsigned char * _result;
    RgbaImageT * _arg0;
    unsigned char * _arg1;

    if ((argc < 3) || (argc > 3)) {
        Tcl_SetResult(interp, "Wrong # args. RgbaImageT_ri_set { RgbaImageT * } { unsigned char * } ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_RgbaImageT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of RgbaImageT_ri_set. Expected _RgbaImageT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[2],(void **) &_arg1,"_unsigned_char_p")) {
        Tcl_SetResult(interp, "Type error in argument 2 of RgbaImageT_ri_set. Expected _unsigned_char_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[2], (char *) NULL);
        return TCL_ERROR;
    }
    _result = (unsigned char *)RgbaImageT_ri_set(_arg0,_arg1);
    SWIG_MakePtr(interp->result, (void *) _result,"_unsigned_char_p");
    return TCL_OK;
}
static unsigned char * RgbaImageT_ri_get(RgbaImageT *obj) {
    unsigned char * result;
    result = (unsigned char *) obj->ri;
    return result;
}
static int _wrap_RgbaImageT_ri_get(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    unsigned char * _result;
    RgbaImageT * _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. RgbaImageT_ri_get { RgbaImageT * } ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_RgbaImageT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of RgbaImageT_ri_get. Expected _RgbaImageT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _result = (unsigned char *)RgbaImageT_ri_get(_arg0);
    SWIG_MakePtr(interp->result, (void *) _result,"_unsigned_char_p");
    return TCL_OK;
}
static unsigned char * RgbaImageT_gi_set(RgbaImageT *obj, unsigned char * val) {
    return (obj->gi = val);
}
static int _wrap_RgbaImageT_gi_set(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    unsigned char * _result;
    RgbaImageT * _arg0;
    unsigned char * _arg1;

    if ((argc < 3) || (argc > 3)) {
        Tcl_SetResult(interp, "Wrong # args. RgbaImageT_gi_set { RgbaImageT * } { unsigned char * } ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_RgbaImageT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of RgbaImageT_gi_set. Expected _RgbaImageT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[2],(void **) &_arg1,"_unsigned_char_p")) {
        Tcl_SetResult(interp, "Type error in argument 2 of RgbaImageT_gi_set. Expected _unsigned_char_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[2], (char *) NULL);
        return TCL_ERROR;
    }
    _result = (unsigned char *)RgbaImageT_gi_set(_arg0,_arg1);
    SWIG_MakePtr(interp->result, (void *) _result,"_unsigned_char_p");
    return TCL_OK;
}
static unsigned char * RgbaImageT_gi_get(RgbaImageT *obj) {
    unsigned char * result;
    result = (unsigned char *) obj->gi;
    return result;
}
static int _wrap_RgbaImageT_gi_get(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    unsigned char * _result;
    RgbaImageT * _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. RgbaImageT_gi_get { RgbaImageT * } ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_RgbaImageT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of RgbaImageT_gi_get. Expected _RgbaImageT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _result = (unsigned char *)RgbaImageT_gi_get(_arg0);
    SWIG_MakePtr(interp->result, (void *) _result,"_unsigned_char_p");
    return TCL_OK;
}
static unsigned char * RgbaImageT_bi_set(RgbaImageT *obj, unsigned char * val) {
    return (obj->bi = val);
}
static int _wrap_RgbaImageT_bi_set(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    unsigned char * _result;
    RgbaImageT * _arg0;
    unsigned char * _arg1;

    if ((argc < 3) || (argc > 3)) {
        Tcl_SetResult(interp, "Wrong # args. RgbaImageT_bi_set { RgbaImageT * } { unsigned char * } ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_RgbaImageT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of RgbaImageT_bi_set. Expected _RgbaImageT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[2],(void **) &_arg1,"_unsigned_char_p")) {
        Tcl_SetResult(interp, "Type error in argument 2 of RgbaImageT_bi_set. Expected _unsigned_char_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[2], (char *) NULL);
        return TCL_ERROR;
    }
    _result = (unsigned char *)RgbaImageT_bi_set(_arg0,_arg1);
    SWIG_MakePtr(interp->result, (void *) _result,"_unsigned_char_p");
    return TCL_OK;
}
static unsigned char * RgbaImageT_bi_get(RgbaImageT *obj) {
    unsigned char * result;
    result = (unsigned char *) obj->bi;
    return result;
}
static int _wrap_RgbaImageT_bi_get(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    unsigned char * _result;
    RgbaImageT * _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. RgbaImageT_bi_get { RgbaImageT * } ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_RgbaImageT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of RgbaImageT_bi_get. Expected _RgbaImageT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _result = (unsigned char *)RgbaImageT_bi_get(_arg0);
    SWIG_MakePtr(interp->result, (void *) _result,"_unsigned_char_p");
    return TCL_OK;
}
static unsigned char * RgbaImageT_ai_set(RgbaImageT *obj, unsigned char * val) {
    return (obj->ai = val);
}
static int _wrap_RgbaImageT_ai_set(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    unsigned char * _result;
    RgbaImageT * _arg0;
    unsigned char * _arg1;

    if ((argc < 3) || (argc > 3)) {
        Tcl_SetResult(interp, "Wrong # args. RgbaImageT_ai_set { RgbaImageT * } { unsigned char * } ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_RgbaImageT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of RgbaImageT_ai_set. Expected _RgbaImageT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[2],(void **) &_arg1,"_unsigned_char_p")) {
        Tcl_SetResult(interp, "Type error in argument 2 of RgbaImageT_ai_set. Expected _unsigned_char_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[2], (char *) NULL);
        return TCL_ERROR;
    }
    _result = (unsigned char *)RgbaImageT_ai_set(_arg0,_arg1);
    SWIG_MakePtr(interp->result, (void *) _result,"_unsigned_char_p");
    return TCL_OK;
}
static unsigned char * RgbaImageT_ai_get(RgbaImageT *obj) {
    unsigned char * result;
    result = (unsigned char *) obj->ai;
    return result;
}
static int _wrap_RgbaImageT_ai_get(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    unsigned char * _result;
    RgbaImageT * _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. RgbaImageT_ai_get { RgbaImageT * } ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_RgbaImageT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of RgbaImageT_ai_get. Expected _RgbaImageT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _result = (unsigned char *)RgbaImageT_ai_get(_arg0);
    SWIG_MakePtr(interp->result, (void *) _result,"_unsigned_char_p");
    return TCL_OK;
}
static RgbaImageT *new_RgbaImageT() { return rgbaImageNew(); }

static int _wrap_new_RgbaImageT(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    RgbaImageT * _result;

    if ((argc < 1) || (argc > 1)) {
        Tcl_SetResult(interp, "Wrong # args. new_RgbaImageT ",TCL_STATIC);
        return TCL_ERROR;
    }
    _result = (RgbaImageT *)new_RgbaImageT();
    SWIG_MakePtr(interp->result, (void *) _result,"_RgbaImageT_p");
    return TCL_OK;
}
static void delete_RgbaImageT(RgbaImageT *self) { rgbaImageDelete(self); }
static int _wrap_delete_RgbaImageT(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    RgbaImageT * _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. delete_RgbaImageT { RgbaImageT * } ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_RgbaImageT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of delete_RgbaImageT. Expected _RgbaImageT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    delete_RgbaImageT(_arg0);
    return TCL_OK;
}
static int  RgbaImageT_alloc(RgbaImageT *self,int  nx,int  ny) { return rgbaImageAlloc(self, nx, ny); }
static int _wrap_RgbaImageT_alloc(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    int  _result;
    RgbaImageT * _arg0;
    int  _arg1;
    int  _arg2;

    if ((argc < 4) || (argc > 4)) {
        Tcl_SetResult(interp, "Wrong # args. RgbaImageT_alloc { RgbaImageT * } nx ny ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_RgbaImageT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of RgbaImageT_alloc. Expected _RgbaImageT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = (int ) atol(argv[2]);
    _arg2 = (int ) atol(argv[3]);
    _result = (int )RgbaImageT_alloc(_arg0,_arg1,_arg2);
    sprintf(interp->result,"%ld", (long) _result);
    return TCL_OK;
}
static void  RgbaImageT_free(RgbaImageT *self) { rgbaImageFree(self); }
static int _wrap_RgbaImageT_free(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    RgbaImageT * _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. RgbaImageT_free { RgbaImageT * } ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_RgbaImageT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of RgbaImageT_free. Expected _RgbaImageT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    RgbaImageT_free(_arg0);
    return TCL_OK;
}
static int  RgbaImageT_dissolve(RgbaImageT *self,const RgbaImageT * siP,const RgbaImageT * diP,float  dissolve) { return rgbaImageDissolve(self, siP, diP, dissolve); }
static int _wrap_RgbaImageT_dissolve(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    int  _result;
    RgbaImageT * _arg0;
    RgbaImageT * _arg1;
    RgbaImageT * _arg2;
    float  _arg3;

    if ((argc < 5) || (argc > 5)) {
        Tcl_SetResult(interp, "Wrong # args. RgbaImageT_dissolve { RgbaImageT * } siP diP dissolve ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_RgbaImageT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of RgbaImageT_dissolve. Expected _RgbaImageT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[2],(void **) &_arg1,"_RgbaImageT_p")) {
        Tcl_SetResult(interp, "Type error in argument 2 of RgbaImageT_dissolve. Expected _RgbaImageT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[2], (char *) NULL);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[3],(void **) &_arg2,"_RgbaImageT_p")) {
        Tcl_SetResult(interp, "Type error in argument 3 of RgbaImageT_dissolve. Expected _RgbaImageT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[3], (char *) NULL);
        return TCL_ERROR;
    }
    _arg3 = (float ) atof(argv[4]);
    _result = (int )RgbaImageT_dissolve(_arg0,_arg1,_arg2,_arg3);
    sprintf(interp->result,"%ld", (long) _result);
    return TCL_OK;
}
static int  RgbaImageT_read(RgbaImageT *self,const char * filename) { return rgbaImageRead(self, filename); }
static int _wrap_RgbaImageT_read(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    int  _result;
    RgbaImageT * _arg0;
    char * _arg1;

    if ((argc < 3) || (argc > 3)) {
        Tcl_SetResult(interp, "Wrong # args. RgbaImageT_read { RgbaImageT * } filename ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_RgbaImageT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of RgbaImageT_read. Expected _RgbaImageT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = argv[2];
    _result = (int )RgbaImageT_read(_arg0,_arg1);
    sprintf(interp->result,"%ld", (long) _result);
    return TCL_OK;
}
static int  RgbaImageT_write(RgbaImageT *self,const char * filename) { return rgbaImageWrite(filename, self, NULL, 0.0); }
static int _wrap_RgbaImageT_write(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    int  _result;
    RgbaImageT * _arg0;
    char * _arg1;

    if ((argc < 3) || (argc > 3)) {
        Tcl_SetResult(interp, "Wrong # args. RgbaImageT_write { RgbaImageT * } filename ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_RgbaImageT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of RgbaImageT_write. Expected _RgbaImageT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = argv[2];
    _result = (int )RgbaImageT_write(_arg0,_arg1);
    sprintf(interp->result,"%ld", (long) _result);
    return TCL_OK;
}
static int  RgbaImageT_reset(RgbaImageT *self,int  type) { return rgbaImageTestCreate(self, type); }
static int _wrap_RgbaImageT_reset(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    int  _result;
    RgbaImageT * _arg0;
    int  _arg1;

    if ((argc < 3) || (argc > 3)) {
        Tcl_SetResult(interp, "Wrong # args. RgbaImageT_reset { RgbaImageT * } type ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_RgbaImageT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of RgbaImageT_reset. Expected _RgbaImageT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = (int ) atol(argv[2]);
    _result = (int )RgbaImageT_reset(_arg0,_arg1);
    sprintf(interp->result,"%ld", (long) _result);
    return TCL_OK;
}
static void  RgbaImageT_toPhoto(RgbaImageT *self,char * photo_tag) { /* Convert photo tag into photo handle */
                          Tk_PhotoHandle photoH = Tk_FindPhoto(photo_tag);
                          rgbaImageTkPhotoConvert(self, photoH);
                        }
static int _wrap_RgbaImageT_toPhoto(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    RgbaImageT * _arg0;
    char * _arg1;

    if ((argc < 3) || (argc > 3)) {
        Tcl_SetResult(interp, "Wrong # args. RgbaImageT_toPhoto { RgbaImageT * } photo_tag ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_RgbaImageT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of RgbaImageT_toPhoto. Expected _RgbaImageT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = argv[2];
    RgbaImageT_toPhoto(_arg0,_arg1);
    return TCL_OK;
}
static int  RgbaImageT_warp(RgbaImageT *self,const RgbaImageT * img_orig,const MeshT * mesh_src,const MeshT * mesh_dst,float  tween_param) { return rgbaImageWarp(img_orig, self, mesh_src, mesh_dst, tween_param); }
static int _wrap_RgbaImageT_warp(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    int  _result;
    RgbaImageT * _arg0;
    RgbaImageT * _arg1;
    MeshT * _arg2;
    MeshT * _arg3;
    float  _arg4;

    if ((argc < 6) || (argc > 6)) {
        Tcl_SetResult(interp, "Wrong # args. RgbaImageT_warp { RgbaImageT * } img_orig mesh_src mesh_dst tween_param ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_RgbaImageT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of RgbaImageT_warp. Expected _RgbaImageT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[2],(void **) &_arg1,"_RgbaImageT_p")) {
        Tcl_SetResult(interp, "Type error in argument 2 of RgbaImageT_warp. Expected _RgbaImageT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[2], (char *) NULL);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[3],(void **) &_arg2,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 3 of RgbaImageT_warp. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[3], (char *) NULL);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[4],(void **) &_arg3,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 4 of RgbaImageT_warp. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[4], (char *) NULL);
        return TCL_ERROR;
    }
    _arg4 = (float ) atof(argv[5]);
    _result = (int )RgbaImageT_warp(_arg0,_arg1,_arg2,_arg3,_arg4);
    sprintf(interp->result,"%ld", (long) _result);
    return TCL_OK;
}
/* delcmd.swg : Tcl object deletion method */

static void TclDeleteRgbaImageT(ClientData clientData) {
    delete_RgbaImageT((RgbaImageT *) clientData);
}

/* methodcmd.swg : Tcl method invocation */

static int TclRgbaImageTMethodCmd(ClientData clientData, Tcl_Interp *interp, int argc, char **argv) {
    int (*cmd)(ClientData, Tcl_Interp *, int, char **) = 0;
    char temp[256], *oldarg;
    int rcode;
    int length;
    char c;

    if (argc < 2) {
        Tcl_SetResult(interp,"RgbaImageT methods : { cget configure alloc free dissolve read write reset toPhoto warp  }",TCL_STATIC);
        return TCL_ERROR;
    }
    c = argv[1][0];
    length = strlen(argv[1]);
    SWIG_MakePtr(temp,(void *) clientData, "_RgbaImageT_p");
    if (0);
        if (strcmp(argv[1],"alloc") == 0) {
        cmd = _wrap_RgbaImageT_alloc;
    }    else if (strcmp(argv[1],"free") == 0) {
        cmd = _wrap_RgbaImageT_free;
    }    else if (strcmp(argv[1],"dissolve") == 0) {
        cmd = _wrap_RgbaImageT_dissolve;
    }    else if (strcmp(argv[1],"read") == 0) {
        cmd = _wrap_RgbaImageT_read;
    }    else if (strcmp(argv[1],"write") == 0) {
        cmd = _wrap_RgbaImageT_write;
    }    else if (strcmp(argv[1],"reset") == 0) {
        cmd = _wrap_RgbaImageT_reset;
    }    else if (strcmp(argv[1],"toPhoto") == 0) {
        cmd = _wrap_RgbaImageT_toPhoto;
    }    else if (strcmp(argv[1],"warp") == 0) {
        cmd = _wrap_RgbaImageT_warp;
    }
    else if ((c == 'c') && (strncmp(argv[1],"configure",length) == 0) && (length >= 2)) {
      int i = 2;
      cmd = 0;
      while (i+1 < argc) {
	                if (strcmp(argv[i],"-nrows") == 0) {
                    cmd = _wrap_RgbaImageT_nrows_set;
                }  else if (strcmp(argv[i],"-ncols") == 0) {
                    cmd = _wrap_RgbaImageT_ncols_set;
                }  else if (strcmp(argv[i],"-compressed") == 0) {
                    cmd = _wrap_RgbaImageT_compressed_set;
                }  else if (strcmp(argv[i],"-pixel_size") == 0) {
                    cmd = _wrap_RgbaImageT_pixel_size_set;
                }  else if (strcmp(argv[i],"-color_mapped") == 0) {
                    cmd = _wrap_RgbaImageT_color_mapped_set;
                }  else if (strcmp(argv[i],"-type") == 0) {
                    cmd = _wrap_RgbaImageT_type_set;
                }  else if (strcmp(argv[i],"-ri") == 0) {
                    cmd = _wrap_RgbaImageT_ri_set;
                }  else if (strcmp(argv[i],"-gi") == 0) {
                    cmd = _wrap_RgbaImageT_gi_set;
                }  else if (strcmp(argv[i],"-bi") == 0) {
                    cmd = _wrap_RgbaImageT_bi_set;
                }  else if (strcmp(argv[i],"-ai") == 0) {
                    cmd = _wrap_RgbaImageT_ai_set;
                } 
	   if (cmd) {
	     oldarg = argv[i];
	     argv[i] = &temp[0];
	     rcode = (*cmd)(clientData,interp,3,&argv[i-1]);
	     argv[i] = oldarg;
	     if (rcode == TCL_ERROR) return rcode;
	     cmd = 0;
	   } else {
	     Tcl_SetResult(interp,"Invalid configure option. Must be { -nrows -ncols -compressed -pixel_size -color_mapped -type -ri -gi -bi -ai  }",TCL_STATIC);
	     return TCL_ERROR;
	   }
	i+=2;
      }
      if ((i < argc) || (i == 2)) {
	Tcl_SetResult(interp,"{ -nrows -ncols -compressed -pixel_size -color_mapped -type -ri -gi -bi -ai  }",TCL_STATIC);
	return TCL_ERROR;
      }
      return TCL_OK;
    } else if ((c == 'c') && (strncmp(argv[1],"cget",length) == 0) && (length >= 2)) {
            if (argc == 3) {
	      if (0) {}
	                      if (strcmp(argv[2],"-nrows") == 0) {
                    cmd = _wrap_RgbaImageT_nrows_get;
                }  else if (strcmp(argv[2],"-ncols") == 0) {
                    cmd = _wrap_RgbaImageT_ncols_get;
                }  else if (strcmp(argv[2],"-compressed") == 0) {
                    cmd = _wrap_RgbaImageT_compressed_get;
                }  else if (strcmp(argv[2],"-pixel_size") == 0) {
                    cmd = _wrap_RgbaImageT_pixel_size_get;
                }  else if (strcmp(argv[2],"-color_mapped") == 0) {
                    cmd = _wrap_RgbaImageT_color_mapped_get;
                }  else if (strcmp(argv[2],"-type") == 0) {
                    cmd = _wrap_RgbaImageT_type_get;
                }  else if (strcmp(argv[2],"-ri") == 0) {
                    cmd = _wrap_RgbaImageT_ri_get;
                }  else if (strcmp(argv[2],"-gi") == 0) {
                    cmd = _wrap_RgbaImageT_gi_get;
                }  else if (strcmp(argv[2],"-bi") == 0) {
                    cmd = _wrap_RgbaImageT_bi_get;
                }  else if (strcmp(argv[2],"-ai") == 0) {
                    cmd = _wrap_RgbaImageT_ai_get;
                } 
		 else if (strcmp(argv[2],"-this") == 0) {
                   SWIG_MakePtr(interp->result,(void *) clientData, "_RgbaImageT_p");
                   return TCL_OK;
		 }
	      if (cmd) {
		oldarg = argv[2];
		argv[2] = &temp[0];
		rcode = (*cmd)(clientData,interp,argc-1,&argv[1]);
		argv[2] = oldarg;
		return rcode;
	      } else {
		Tcl_SetResult(interp,"Invalid cget option. Must be { -this -nrows -ncols -compressed -pixel_size -color_mapped -type -ri -gi -bi -ai  }",TCL_STATIC);
		return TCL_ERROR;
	      }
	    } else {
	      Tcl_SetResult(interp,"{ -this -nrows -ncols -compressed -pixel_size -color_mapped -type -ri -gi -bi -ai  }", TCL_STATIC);
	      return TCL_ERROR;
	    }
    }
    if (!cmd) {
        Tcl_SetResult(interp,"Invalid Method. Must be { cget configure alloc free dissolve read write reset toPhoto warp }",TCL_STATIC);
        return TCL_ERROR;
    }
    oldarg = argv[1];
    argv[1] = &temp[0];
    rcode = (*cmd)(clientData,interp,argc,argv);
    argv[1] = oldarg;
    return rcode;
}
/* objcmd.swg : Tcl object creation */

static int TclRgbaImageTCmd(ClientData clientData, Tcl_Interp *interp, int argc, char **argv) {
    void (*del)(ClientData) = 0;
    char *name = 0;
    int (*cmd)(ClientData, Tcl_Interp *, int, char **) = 0;
    RgbaImageT * newObj = 0;
    int firstarg = 0;
    int thisarg = 0;
    if (argc == 1) {
        cmd = _wrap_new_RgbaImageT;
    } else {
        if (strcmp(argv[1],"-this") == 0) thisarg = 2;
        else if (strcmp(argv[1],"-args") == 0) {
            firstarg = 1;
            cmd = _wrap_new_RgbaImageT;
        } else if (argc == 2) {
            firstarg = 1;
            name = argv[1];
            cmd = _wrap_new_RgbaImageT;
        } else if (argc >= 3) {
            name = argv[1];
            if (strcmp(argv[2],"-this") == 0) thisarg = 3;
            else {
                firstarg = 1;
                cmd = _wrap_new_RgbaImageT;
            }
        }
    }
    if (cmd) {
        int result;
        result = (*cmd)(clientData,interp,argc-firstarg,&argv[firstarg]);
        if (result == TCL_OK) {
            SWIG_GetPtr(interp->result,(void **) &newObj,"_RgbaImageT_p");
        } else { return result; }
        if (!name) name = interp->result;
        del = TclDeleteRgbaImageT;
    } else if (thisarg > 0) { 
        if (thisarg < argc) {
            char *r;
            r = SWIG_GetPtr(argv[thisarg],(void **) &newObj,"_RgbaImageT_p");
            if (r) {
                interp->result = "Type error. not a RgbaImageT object.";
                return TCL_ERROR;
            }
            if (!name) name = argv[thisarg];
	    /* Return value is same as pointer value */
	    Tcl_SetResult(interp,argv[thisarg],TCL_VOLATILE);
        } else {
            interp->result = "wrong # args.";
            return TCL_ERROR;
        }
    } else {
        interp->result = "No constructor available.";
        return TCL_ERROR;
    }
    {
      Tcl_CmdInfo dummy;
      if (!Tcl_GetCommandInfo(interp,name,&dummy)) {
	Tcl_CreateCommand(interp,name, TclRgbaImageTMethodCmd, (ClientData) newObj, del);
	return TCL_OK;
      } else {
	Tcl_SetResult(interp,"",TCL_VOLATILE);
	Tcl_AppendResult(interp,"Object ", name, " already exists!", (char *) NULL);
	return TCL_ERROR;
      }
    }
}


static long  MeshT_nx_set(MeshT *obj, long  val) {
    return (obj->nx = val);
}
static int _wrap_MeshT_nx_set(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    long  _result;
    MeshT * _arg0;
    long  _arg1;

    if ((argc < 3) || (argc > 3)) {
        Tcl_SetResult(interp, "Wrong # args. MeshT_nx_set { MeshT * } { long  } ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of MeshT_nx_set. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = (long ) atol(argv[2]);
    _result = (long )MeshT_nx_set(_arg0,_arg1);
    sprintf(interp->result,"%ld", (long) _result);
    return TCL_OK;
}
static long  MeshT_nx_get(MeshT *obj) {
    long  result;
    result = (long ) obj->nx;
    return result;
}
static int _wrap_MeshT_nx_get(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    long  _result;
    MeshT * _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. MeshT_nx_get { MeshT * } ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of MeshT_nx_get. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _result = (long )MeshT_nx_get(_arg0);
    sprintf(interp->result,"%ld", (long) _result);
    return TCL_OK;
}
static long  MeshT_ny_set(MeshT *obj, long  val) {
    return (obj->ny = val);
}
static int _wrap_MeshT_ny_set(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    long  _result;
    MeshT * _arg0;
    long  _arg1;

    if ((argc < 3) || (argc > 3)) {
        Tcl_SetResult(interp, "Wrong # args. MeshT_ny_set { MeshT * } { long  } ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of MeshT_ny_set. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = (long ) atol(argv[2]);
    _result = (long )MeshT_ny_set(_arg0,_arg1);
    sprintf(interp->result,"%ld", (long) _result);
    return TCL_OK;
}
static long  MeshT_ny_get(MeshT *obj) {
    long  result;
    result = (long ) obj->ny;
    return result;
}
static int _wrap_MeshT_ny_get(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    long  _result;
    MeshT * _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. MeshT_ny_get { MeshT * } ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of MeshT_ny_get. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _result = (long )MeshT_ny_get(_arg0);
    sprintf(interp->result,"%ld", (long) _result);
    return TCL_OK;
}
static double * MeshT_x_set(MeshT *obj, double * val) {
    return (obj->x = val);
}
static int _wrap_MeshT_x_set(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    double * _result;
    MeshT * _arg0;
    double * _arg1;

    if ((argc < 3) || (argc > 3)) {
        Tcl_SetResult(interp, "Wrong # args. MeshT_x_set { MeshT * } { double * } ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of MeshT_x_set. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[2],(void **) &_arg1,"_double_p")) {
        Tcl_SetResult(interp, "Type error in argument 2 of MeshT_x_set. Expected _double_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[2], (char *) NULL);
        return TCL_ERROR;
    }
    _result = (double *)MeshT_x_set(_arg0,_arg1);
    SWIG_MakePtr(interp->result, (void *) _result,"_double_p");
    return TCL_OK;
}
static double * MeshT_x_get(MeshT *obj) {
    double * result;
    result = (double *) obj->x;
    return result;
}
static int _wrap_MeshT_x_get(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    double * _result;
    MeshT * _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. MeshT_x_get { MeshT * } ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of MeshT_x_get. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _result = (double *)MeshT_x_get(_arg0);
    SWIG_MakePtr(interp->result, (void *) _result,"_double_p");
    return TCL_OK;
}
static double * MeshT_y_set(MeshT *obj, double * val) {
    return (obj->y = val);
}
static int _wrap_MeshT_y_set(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    double * _result;
    MeshT * _arg0;
    double * _arg1;

    if ((argc < 3) || (argc > 3)) {
        Tcl_SetResult(interp, "Wrong # args. MeshT_y_set { MeshT * } { double * } ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of MeshT_y_set. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[2],(void **) &_arg1,"_double_p")) {
        Tcl_SetResult(interp, "Type error in argument 2 of MeshT_y_set. Expected _double_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[2], (char *) NULL);
        return TCL_ERROR;
    }
    _result = (double *)MeshT_y_set(_arg0,_arg1);
    SWIG_MakePtr(interp->result, (void *) _result,"_double_p");
    return TCL_OK;
}
static double * MeshT_y_get(MeshT *obj) {
    double * result;
    result = (double *) obj->y;
    return result;
}
static int _wrap_MeshT_y_get(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    double * _result;
    MeshT * _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. MeshT_y_get { MeshT * } ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of MeshT_y_get. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _result = (double *)MeshT_y_get(_arg0);
    SWIG_MakePtr(interp->result, (void *) _result,"_double_p");
    return TCL_OK;
}
static MeshT *new_MeshT() { return meshNew(0, 0); }

static int _wrap_new_MeshT(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    MeshT * _result;

    if ((argc < 1) || (argc > 1)) {
        Tcl_SetResult(interp, "Wrong # args. new_MeshT ",TCL_STATIC);
        return TCL_ERROR;
    }
    _result = (MeshT *)new_MeshT();
    SWIG_MakePtr(interp->result, (void *) _result,"_MeshT_p");
    return TCL_OK;
}
static void delete_MeshT(MeshT *self) { meshDelete(self); }
static int _wrap_delete_MeshT(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    MeshT * _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. delete_MeshT { MeshT * } ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of delete_MeshT. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    delete_MeshT(_arg0);
    return TCL_OK;
}
static int  MeshT_alloc(MeshT *self,int  nx,int  ny) { return meshAlloc(self, nx, ny); }
static int _wrap_MeshT_alloc(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    int  _result;
    MeshT * _arg0;
    int  _arg1;
    int  _arg2;

    if ((argc < 4) || (argc > 4)) {
        Tcl_SetResult(interp, "Wrong # args. MeshT_alloc { MeshT * } nx ny ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of MeshT_alloc. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = (int ) atol(argv[2]);
    _arg2 = (int ) atol(argv[3]);
    _result = (int )MeshT_alloc(_arg0,_arg1,_arg2);
    sprintf(interp->result,"%ld", (long) _result);
    return TCL_OK;
}
static void  MeshT_free(MeshT *self) { meshFree(self); }
static int _wrap_MeshT_free(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    MeshT * _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. MeshT_free { MeshT * } ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of MeshT_free. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    MeshT_free(_arg0);
    return TCL_OK;
}
static void  MeshT_print(MeshT *self) { meshPrint(self); }
static int _wrap_MeshT_print(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    MeshT * _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. MeshT_print { MeshT * } ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of MeshT_print. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    MeshT_print(_arg0);
    return TCL_OK;
}
static void  MeshT_interpolate(MeshT *self,const MeshT * m1P,const MeshT * m2P,float  tween_param) {meshInterpolate(self, m1P, m2P, tween_param);}
static int _wrap_MeshT_interpolate(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    MeshT * _arg0;
    MeshT * _arg1;
    MeshT * _arg2;
    float  _arg3;

    if ((argc < 5) || (argc > 5)) {
        Tcl_SetResult(interp, "Wrong # args. MeshT_interpolate { MeshT * } m1P m2P tween_param ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of MeshT_interpolate. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[2],(void **) &_arg1,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 2 of MeshT_interpolate. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[2], (char *) NULL);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[3],(void **) &_arg2,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 3 of MeshT_interpolate. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[3], (char *) NULL);
        return TCL_ERROR;
    }
    _arg3 = (float ) atof(argv[4]);
    MeshT_interpolate(_arg0,_arg1,_arg2,_arg3);
    return TCL_OK;
}
static void  MeshT_reset(MeshT *self,int  img_width,int  img_height) { meshReset(self, img_width, img_height); }
static int _wrap_MeshT_reset(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    MeshT * _arg0;
    int  _arg1;
    int  _arg2;

    if ((argc < 4) || (argc > 4)) {
        Tcl_SetResult(interp, "Wrong # args. MeshT_reset { MeshT * } img_width img_height ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of MeshT_reset. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = (int ) atol(argv[2]);
    _arg2 = (int ) atol(argv[3]);
    MeshT_reset(_arg0,_arg1,_arg2);
    return TCL_OK;
}
static void  MeshT_scale(MeshT *self,int  img_width,int  img_height) { meshScale(self, img_width, img_height); }
static int _wrap_MeshT_scale(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    MeshT * _arg0;
    int  _arg1;
    int  _arg2;

    if ((argc < 4) || (argc > 4)) {
        Tcl_SetResult(interp, "Wrong # args. MeshT_scale { MeshT * } img_width img_height ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of MeshT_scale. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = (int ) atol(argv[2]);
    _arg2 = (int ) atol(argv[3]);
    MeshT_scale(_arg0,_arg1,_arg2);
    return TCL_OK;
}
static char * MeshT_row(MeshT *self,int  line_index) { return meshLine(self, line_index, 1); }
static int _wrap_MeshT_row(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    char * _result;
    MeshT * _arg0;
    int  _arg1;

    if ((argc < 3) || (argc > 3)) {
        Tcl_SetResult(interp, "Wrong # args. MeshT_row { MeshT * } line_index ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of MeshT_row. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = (int ) atol(argv[2]);
    _result = (char *)MeshT_row(_arg0,_arg1);
    Tcl_SetResult(interp, (char *) _result, TCL_VOLATILE);
    return TCL_OK;
}
static char * MeshT_col(MeshT *self,int  line_index) { return meshLine(self, line_index, 2); }
static int _wrap_MeshT_col(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    char * _result;
    MeshT * _arg0;
    int  _arg1;

    if ((argc < 3) || (argc > 3)) {
        Tcl_SetResult(interp, "Wrong # args. MeshT_col { MeshT * } line_index ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of MeshT_col. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = (int ) atol(argv[2]);
    _result = (char *)MeshT_col(_arg0,_arg1);
    Tcl_SetResult(interp, (char *) _result, TCL_VOLATILE);
    return TCL_OK;
}
static int  MeshT_pick(MeshT *self,int  mouse_x,int  mouse_y,int  component,float  proximity) { return meshPick(self, mouse_x, mouse_y, component, proximity); }
static int _wrap_MeshT_pick(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    int  _result;
    MeshT * _arg0;
    int  _arg1;
    int  _arg2;
    int  _arg3;
    float  _arg4;

    if ((argc < 6) || (argc > 6)) {
        Tcl_SetResult(interp, "Wrong # args. MeshT_pick { MeshT * } mouse_x mouse_y component proximity ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of MeshT_pick. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = (int ) atol(argv[2]);
    _arg2 = (int ) atol(argv[3]);
    _arg3 = (int ) atol(argv[4]);
    _arg4 = (float ) atof(argv[5]);
    _result = (int )MeshT_pick(_arg0,_arg1,_arg2,_arg3,_arg4);
    sprintf(interp->result,"%ld", (long) _result);
    return TCL_OK;
}
static void  MeshT_store(MeshT *self) { meshStore(self); }
static int _wrap_MeshT_store(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    MeshT * _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. MeshT_store { MeshT * } ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of MeshT_store. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    MeshT_store(_arg0);
    return TCL_OK;
}
static void  MeshT_recover(MeshT *self) { meshRetrieve(self); }
static int _wrap_MeshT_recover(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    MeshT * _arg0;

    if ((argc < 2) || (argc > 2)) {
        Tcl_SetResult(interp, "Wrong # args. MeshT_recover { MeshT * } ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of MeshT_recover. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    MeshT_recover(_arg0);
    return TCL_OK;
}
static int  MeshT_lineModify(MeshT *self,MeshT * other,int  mouse_x,int  mouse_y,char  line_type,char  action) { return meshLineMouseModify(self, other, mouse_x, mouse_y,
                                     line_type, action);
        }
static int _wrap_MeshT_lineModify(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    int  _result;
    MeshT * _arg0;
    MeshT * _arg1;
    int  _arg2;
    int  _arg3;
    char  _arg4;
    char  _arg5;

    if ((argc < 7) || (argc > 7)) {
        Tcl_SetResult(interp, "Wrong # args. MeshT_lineModify { MeshT * } other mouse_x mouse_y line_type action ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of MeshT_lineModify. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[2],(void **) &_arg1,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 2 of MeshT_lineModify. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[2], (char *) NULL);
        return TCL_ERROR;
    }
    _arg2 = (int ) atol(argv[3]);
    _arg3 = (int ) atol(argv[4]);
    _arg4 = *argv[5];
    _arg5 = *argv[6];
    _result = (int )MeshT_lineModify(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5);
    sprintf(interp->result,"%ld", (long) _result);
    return TCL_OK;
}
static int  MeshT_read(MeshT *self,const char * filename) { return meshRead(self, filename); }
static int _wrap_MeshT_read(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    int  _result;
    MeshT * _arg0;
    char * _arg1;

    if ((argc < 3) || (argc > 3)) {
        Tcl_SetResult(interp, "Wrong # args. MeshT_read { MeshT * } filename ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of MeshT_read. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = argv[2];
    _result = (int )MeshT_read(_arg0,_arg1);
    sprintf(interp->result,"%ld", (long) _result);
    return TCL_OK;
}
static int  MeshT_write(MeshT *self,const char * filename) { return meshWrite(self, filename); }
static int _wrap_MeshT_write(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    int  _result;
    MeshT * _arg0;
    char * _arg1;

    if ((argc < 3) || (argc > 3)) {
        Tcl_SetResult(interp, "Wrong # args. MeshT_write { MeshT * } filename ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of MeshT_write. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = argv[2];
    _result = (int )MeshT_write(_arg0,_arg1);
    sprintf(interp->result,"%ld", (long) _result);
    return TCL_OK;
}
static void  MeshT_match(MeshT *self,const MeshT * other) { meshMatch(self, other); }
static int _wrap_MeshT_match(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    MeshT * _arg0;
    MeshT * _arg1;

    if ((argc < 3) || (argc > 3)) {
        Tcl_SetResult(interp, "Wrong # args. MeshT_match { MeshT * } other ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of MeshT_match. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[2],(void **) &_arg1,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 2 of MeshT_match. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[2], (char *) NULL);
        return TCL_ERROR;
    }
    MeshT_match(_arg0,_arg1);
    return TCL_OK;
}
static float  MeshT_pointGet(MeshT *self,int  xi,int  yi,int  component) { if(0 == component) return self->x[yi * self->nx + xi];
          else if(1 == component) return self->y[yi * self->nx + xi];
          /* Invalid value for component */
          else return -1.0;
        }
static int _wrap_MeshT_pointGet(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    float  _result;
    MeshT * _arg0;
    int  _arg1;
    int  _arg2;
    int  _arg3;

    if ((argc < 5) || (argc > 5)) {
        Tcl_SetResult(interp, "Wrong # args. MeshT_pointGet { MeshT * } xi yi component ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of MeshT_pointGet. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = (int ) atol(argv[2]);
    _arg2 = (int ) atol(argv[3]);
    _arg3 = (int ) atol(argv[4]);
    _result = (float )MeshT_pointGet(_arg0,_arg1,_arg2,_arg3);
    Tcl_PrintDouble(interp,(double) _result, interp->result);
    return TCL_OK;
}
static void  MeshT_set(MeshT *self,int  xi,int  yi,float  new_x,float  new_y) {  meshSet(self, xi, yi, new_x, new_y); }
static int _wrap_MeshT_set(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]) {

    MeshT * _arg0;
    int  _arg1;
    int  _arg2;
    float  _arg3;
    float  _arg4;

    if ((argc < 6) || (argc > 6)) {
        Tcl_SetResult(interp, "Wrong # args. MeshT_set { MeshT * } xi yi new_x new_y ",TCL_STATIC);
        return TCL_ERROR;
    }
    if (SWIG_GetPtr(argv[1],(void **) &_arg0,"_MeshT_p")) {
        Tcl_SetResult(interp, "Type error in argument 1 of MeshT_set. Expected _MeshT_p, received ", TCL_STATIC);
        Tcl_AppendResult(interp, argv[1], (char *) NULL);
        return TCL_ERROR;
    }
    _arg1 = (int ) atol(argv[2]);
    _arg2 = (int ) atol(argv[3]);
    _arg3 = (float ) atof(argv[4]);
    _arg4 = (float ) atof(argv[5]);
    MeshT_set(_arg0,_arg1,_arg2,_arg3,_arg4);
    return TCL_OK;
}
/* delcmd.swg : Tcl object deletion method */

static void TclDeleteMeshT(ClientData clientData) {
    delete_MeshT((MeshT *) clientData);
}

/* methodcmd.swg : Tcl method invocation */

static int TclMeshTMethodCmd(ClientData clientData, Tcl_Interp *interp, int argc, char **argv) {
    int (*cmd)(ClientData, Tcl_Interp *, int, char **) = 0;
    char temp[256], *oldarg;
    int rcode;
    int length;
    char c;

    if (argc < 2) {
        Tcl_SetResult(interp,"MeshT methods : { cget configure alloc free print interpolate reset scale row col pick store recover lineModify read write match pointGet set  }",TCL_STATIC);
        return TCL_ERROR;
    }
    c = argv[1][0];
    length = strlen(argv[1]);
    SWIG_MakePtr(temp,(void *) clientData, "_MeshT_p");
    if (0);
        if (strcmp(argv[1],"alloc") == 0) {
        cmd = _wrap_MeshT_alloc;
    }    else if (strcmp(argv[1],"free") == 0) {
        cmd = _wrap_MeshT_free;
    }    else if (strcmp(argv[1],"print") == 0) {
        cmd = _wrap_MeshT_print;
    }    else if (strcmp(argv[1],"interpolate") == 0) {
        cmd = _wrap_MeshT_interpolate;
    }    else if (strcmp(argv[1],"reset") == 0) {
        cmd = _wrap_MeshT_reset;
    }    else if (strcmp(argv[1],"scale") == 0) {
        cmd = _wrap_MeshT_scale;
    }    else if (strcmp(argv[1],"row") == 0) {
        cmd = _wrap_MeshT_row;
    }    else if (strcmp(argv[1],"col") == 0) {
        cmd = _wrap_MeshT_col;
    }    else if (strcmp(argv[1],"pick") == 0) {
        cmd = _wrap_MeshT_pick;
    }    else if (strcmp(argv[1],"store") == 0) {
        cmd = _wrap_MeshT_store;
    }    else if (strcmp(argv[1],"recover") == 0) {
        cmd = _wrap_MeshT_recover;
    }    else if (strcmp(argv[1],"lineModify") == 0) {
        cmd = _wrap_MeshT_lineModify;
    }    else if (strcmp(argv[1],"read") == 0) {
        cmd = _wrap_MeshT_read;
    }    else if (strcmp(argv[1],"write") == 0) {
        cmd = _wrap_MeshT_write;
    }    else if (strcmp(argv[1],"match") == 0) {
        cmd = _wrap_MeshT_match;
    }    else if (strcmp(argv[1],"pointGet") == 0) {
        cmd = _wrap_MeshT_pointGet;
    }    else if (strcmp(argv[1],"set") == 0) {
        cmd = _wrap_MeshT_set;
    }
    else if ((c == 'c') && (strncmp(argv[1],"configure",length) == 0) && (length >= 2)) {
      int i = 2;
      cmd = 0;
      while (i+1 < argc) {
	                if (strcmp(argv[i],"-nx") == 0) {
                    cmd = _wrap_MeshT_nx_set;
                }  else if (strcmp(argv[i],"-ny") == 0) {
                    cmd = _wrap_MeshT_ny_set;
                }  else if (strcmp(argv[i],"-x") == 0) {
                    cmd = _wrap_MeshT_x_set;
                }  else if (strcmp(argv[i],"-y") == 0) {
                    cmd = _wrap_MeshT_y_set;
                } 
	   if (cmd) {
	     oldarg = argv[i];
	     argv[i] = &temp[0];
	     rcode = (*cmd)(clientData,interp,3,&argv[i-1]);
	     argv[i] = oldarg;
	     if (rcode == TCL_ERROR) return rcode;
	     cmd = 0;
	   } else {
	     Tcl_SetResult(interp,"Invalid configure option. Must be { -nx -ny -x -y  }",TCL_STATIC);
	     return TCL_ERROR;
	   }
	i+=2;
      }
      if ((i < argc) || (i == 2)) {
	Tcl_SetResult(interp,"{ -nx -ny -x -y  }",TCL_STATIC);
	return TCL_ERROR;
      }
      return TCL_OK;
    } else if ((c == 'c') && (strncmp(argv[1],"cget",length) == 0) && (length >= 2)) {
            if (argc == 3) {
	      if (0) {}
	                      if (strcmp(argv[2],"-nx") == 0) {
                    cmd = _wrap_MeshT_nx_get;
                }  else if (strcmp(argv[2],"-ny") == 0) {
                    cmd = _wrap_MeshT_ny_get;
                }  else if (strcmp(argv[2],"-x") == 0) {
                    cmd = _wrap_MeshT_x_get;
                }  else if (strcmp(argv[2],"-y") == 0) {
                    cmd = _wrap_MeshT_y_get;
                } 
		 else if (strcmp(argv[2],"-this") == 0) {
                   SWIG_MakePtr(interp->result,(void *) clientData, "_MeshT_p");
                   return TCL_OK;
		 }
	      if (cmd) {
		oldarg = argv[2];
		argv[2] = &temp[0];
		rcode = (*cmd)(clientData,interp,argc-1,&argv[1]);
		argv[2] = oldarg;
		return rcode;
	      } else {
		Tcl_SetResult(interp,"Invalid cget option. Must be { -this -nx -ny -x -y  }",TCL_STATIC);
		return TCL_ERROR;
	      }
	    } else {
	      Tcl_SetResult(interp,"{ -this -nx -ny -x -y  }", TCL_STATIC);
	      return TCL_ERROR;
	    }
    }
    if (!cmd) {
        Tcl_SetResult(interp,"Invalid Method. Must be { cget configure alloc free print interpolate reset scale row col pick store recover lineModify read write match pointGet set }",TCL_STATIC);
        return TCL_ERROR;
    }
    oldarg = argv[1];
    argv[1] = &temp[0];
    rcode = (*cmd)(clientData,interp,argc,argv);
    argv[1] = oldarg;
    return rcode;
}
/* objcmd.swg : Tcl object creation */

static int TclMeshTCmd(ClientData clientData, Tcl_Interp *interp, int argc, char **argv) {
    void (*del)(ClientData) = 0;
    char *name = 0;
    int (*cmd)(ClientData, Tcl_Interp *, int, char **) = 0;
    MeshT * newObj = 0;
    int firstarg = 0;
    int thisarg = 0;
    if (argc == 1) {
        cmd = _wrap_new_MeshT;
    } else {
        if (strcmp(argv[1],"-this") == 0) thisarg = 2;
        else if (strcmp(argv[1],"-args") == 0) {
            firstarg = 1;
            cmd = _wrap_new_MeshT;
        } else if (argc == 2) {
            firstarg = 1;
            name = argv[1];
            cmd = _wrap_new_MeshT;
        } else if (argc >= 3) {
            name = argv[1];
            if (strcmp(argv[2],"-this") == 0) thisarg = 3;
            else {
                firstarg = 1;
                cmd = _wrap_new_MeshT;
            }
        }
    }
    if (cmd) {
        int result;
        result = (*cmd)(clientData,interp,argc-firstarg,&argv[firstarg]);
        if (result == TCL_OK) {
            SWIG_GetPtr(interp->result,(void **) &newObj,"_MeshT_p");
        } else { return result; }
        if (!name) name = interp->result;
        del = TclDeleteMeshT;
    } else if (thisarg > 0) { 
        if (thisarg < argc) {
            char *r;
            r = SWIG_GetPtr(argv[thisarg],(void **) &newObj,"_MeshT_p");
            if (r) {
                interp->result = "Type error. not a MeshT object.";
                return TCL_ERROR;
            }
            if (!name) name = argv[thisarg];
	    /* Return value is same as pointer value */
	    Tcl_SetResult(interp,argv[thisarg],TCL_VOLATILE);
        } else {
            interp->result = "wrong # args.";
            return TCL_ERROR;
        }
    } else {
        interp->result = "No constructor available.";
        return TCL_ERROR;
    }
    {
      Tcl_CmdInfo dummy;
      if (!Tcl_GetCommandInfo(interp,name,&dummy)) {
	Tcl_CreateCommand(interp,name, TclMeshTMethodCmd, (ClientData) newObj, del);
	return TCL_OK;
      } else {
	Tcl_SetResult(interp,"",TCL_VOLATILE);
	Tcl_AppendResult(interp,"Object ", name, " already exists!", (char *) NULL);
	return TCL_ERROR;
      }
    }
}


EXPORT(int,Morph_Init)(Tcl_Interp *interp) {
	 if (interp == 0) 
		 return TCL_ERROR;
	 Tcl_CreateCommand(interp, "int_array", _wrap_int_array, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "int_destroy", _wrap_int_destroy, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "int_get", _wrap_int_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "int_set", _wrap_int_set, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "double_array", _wrap_double_array, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "double_destroy", _wrap_double_destroy, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "double_get", _wrap_double_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "double_set", _wrap_double_set, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "float_array", _wrap_float_array, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "float_destroy", _wrap_float_destroy, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "float_get", _wrap_float_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "float_set", _wrap_float_set, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "string_array", _wrap_string_array, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "string_destroy", _wrap_string_destroy, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "string_get", _wrap_string_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "string_set", _wrap_string_set, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "array_int", _wrap_array_int, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "get_int", _wrap_get_int, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "set_int", _wrap_set_int, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "array_double", _wrap_array_double, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "get_double", _wrap_get_double, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "set_double", _wrap_set_double, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "array_byte", _wrap_array_byte, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "get_byte", _wrap_get_byte, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "set_byte", _wrap_set_byte, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "array_string", _wrap_array_string, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "get_string", _wrap_get_string, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "set_string", _wrap_set_string, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "atof", _wrap_atof, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "atoi", _wrap_atoi, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "atol", _wrap_atol, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "rand", _wrap_rand, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "srand", _wrap_srand, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "calloc", _wrap_calloc, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "malloc", _wrap_malloc, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "realloc", _wrap_realloc, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "free", _wrap_free, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "abort", _wrap_abort, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "system", _wrap_system, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "getenv", _wrap_getenv, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "abs", _wrap_abs, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "labs", _wrap_labs, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "cos", _wrap_cos, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "sin", _wrap_sin, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "tan", _wrap_tan, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "acos", _wrap_acos, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "asin", _wrap_asin, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "atan", _wrap_atan, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "atan2", _wrap_atan2, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "cosh", _wrap_cosh, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "sinh", _wrap_sinh, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "tanh", _wrap_tanh, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "exp", _wrap_exp, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "log", _wrap_log, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "log10", _wrap_log10, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "pow", _wrap_pow, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "sqrt", _wrap_sqrt, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "fabs", _wrap_fabs, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "ceil", _wrap_ceil, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "floor", _wrap_floor, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "fmod", _wrap_fmod, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_LinkVar(interp, "M_E", (char *) &_wrap_const_M_E, TCL_LINK_DOUBLE | TCL_LINK_READ_ONLY);
	 Tcl_LinkVar(interp, "M_LOG2E", (char *) &_wrap_const_M_LOG2E, TCL_LINK_DOUBLE | TCL_LINK_READ_ONLY);
	 Tcl_LinkVar(interp, "M_LOG10E", (char *) &_wrap_const_M_LOG10E, TCL_LINK_DOUBLE | TCL_LINK_READ_ONLY);
	 Tcl_LinkVar(interp, "M_LN2", (char *) &_wrap_const_M_LN2, TCL_LINK_DOUBLE | TCL_LINK_READ_ONLY);
	 Tcl_LinkVar(interp, "M_LN10", (char *) &_wrap_const_M_LN10, TCL_LINK_DOUBLE | TCL_LINK_READ_ONLY);
	 Tcl_LinkVar(interp, "M_PI", (char *) &_wrap_const_M_PI, TCL_LINK_DOUBLE | TCL_LINK_READ_ONLY);
	 Tcl_LinkVar(interp, "M_PI_2", (char *) &_wrap_const_M_PI_2, TCL_LINK_DOUBLE | TCL_LINK_READ_ONLY);
	 Tcl_LinkVar(interp, "M_PI_4", (char *) &_wrap_const_M_PI_4, TCL_LINK_DOUBLE | TCL_LINK_READ_ONLY);
	 Tcl_LinkVar(interp, "M_1_PI", (char *) &_wrap_const_M_1_PI, TCL_LINK_DOUBLE | TCL_LINK_READ_ONLY);
	 Tcl_LinkVar(interp, "M_2_PI", (char *) &_wrap_const_M_2_PI, TCL_LINK_DOUBLE | TCL_LINK_READ_ONLY);
	 Tcl_LinkVar(interp, "M_2_SQRTPI", (char *) &_wrap_const_M_2_SQRTPI, TCL_LINK_DOUBLE | TCL_LINK_READ_ONLY);
	 Tcl_LinkVar(interp, "M_SQRT2", (char *) &_wrap_const_M_SQRT2, TCL_LINK_DOUBLE | TCL_LINK_READ_ONLY);
	 Tcl_LinkVar(interp, "M_SQRT1_2", (char *) &_wrap_const_M_SQRT1_2, TCL_LINK_DOUBLE | TCL_LINK_READ_ONLY);
	 Tcl_LinkVar(interp, "BITS_PER_CHANNEL", (char *) &_wrap_const_BITS_PER_CHANNEL, TCL_LINK_INT | TCL_LINK_READ_ONLY);
	 Tcl_LinkVar(interp, "RGBA_IMAGE_MAXVAL", (char *) &_wrap_const_RGBA_IMAGE_MAXVAL, TCL_LINK_INT | TCL_LINK_READ_ONLY);
	 Tcl_LinkVar(interp, "RGBA_IMAGE_OPAQUE", (char *) &_wrap_const_RGBA_IMAGE_OPAQUE, TCL_LINK_INT | TCL_LINK_READ_ONLY);
	 Tcl_CreateCommand(interp, "rgbaImageInit", _wrap_rgbaImageInit, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "rgbaImageNew", _wrap_rgbaImageNew, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "rgbaImageDelete", _wrap_rgbaImageDelete, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "rgbaImageFree", _wrap_rgbaImageFree, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "rgbaImageAlloc", _wrap_rgbaImageAlloc, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "rgbaImageDissolve", _wrap_rgbaImageDissolve, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "rgbaImageRead", _wrap_rgbaImageRead, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "rgbaImageWrite", _wrap_rgbaImageWrite, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "rgbaImageTestCreate", _wrap_rgbaImageTestCreate, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_LinkVar(interp, "MP_PICK_DIST", (char *) &_wrap_const_MP_PICK_DIST, TCL_LINK_INT | TCL_LINK_READ_ONLY);
	 Tcl_CreateCommand(interp, "meshInit", _wrap_meshInit, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "meshAlloc", _wrap_meshAlloc, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "meshNew", _wrap_meshNew, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "meshFree", _wrap_meshFree, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "meshDelete", _wrap_meshDelete, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "meshPrint", _wrap_meshPrint, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "meshCompatibilityCheck", _wrap_meshCompatibilityCheck, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "meshInterpolate", _wrap_meshInterpolate, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "meshReset", _wrap_meshReset, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "meshScale", _wrap_meshScale, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "meshFunctionalize", _wrap_meshFunctionalize, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "meshPointNearest", _wrap_meshPointNearest, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "meshPick", _wrap_meshPick, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "meshSet", _wrap_meshSet, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "meshCopy", _wrap_meshCopy, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "meshBackupIndexSet", _wrap_meshBackupIndexSet, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "meshBackupFree", _wrap_meshBackupFree, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "meshStore", _wrap_meshStore, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "meshRetrieve", _wrap_meshRetrieve, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "meshLineAdd", _wrap_meshLineAdd, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "meshLineDelete", _wrap_meshLineDelete, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "meshLineMouseModify", _wrap_meshLineMouseModify, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "meshRead", _wrap_meshRead, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "meshWrite", _wrap_meshWrite, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "meshMatch", _wrap_meshMatch, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "RgbaImageT_nrows_set", _wrap_RgbaImageT_nrows_set, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "RgbaImageT_nrows_get", _wrap_RgbaImageT_nrows_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "RgbaImageT_ncols_set", _wrap_RgbaImageT_ncols_set, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "RgbaImageT_ncols_get", _wrap_RgbaImageT_ncols_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "RgbaImageT_compressed_set", _wrap_RgbaImageT_compressed_set, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "RgbaImageT_compressed_get", _wrap_RgbaImageT_compressed_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "RgbaImageT_pixel_size_set", _wrap_RgbaImageT_pixel_size_set, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "RgbaImageT_pixel_size_get", _wrap_RgbaImageT_pixel_size_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "RgbaImageT_color_mapped_set", _wrap_RgbaImageT_color_mapped_set, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "RgbaImageT_color_mapped_get", _wrap_RgbaImageT_color_mapped_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "RgbaImageT_type_set", _wrap_RgbaImageT_type_set, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "RgbaImageT_type_get", _wrap_RgbaImageT_type_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "RgbaImageT_ri_set", _wrap_RgbaImageT_ri_set, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "RgbaImageT_ri_get", _wrap_RgbaImageT_ri_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "RgbaImageT_gi_set", _wrap_RgbaImageT_gi_set, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "RgbaImageT_gi_get", _wrap_RgbaImageT_gi_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "RgbaImageT_bi_set", _wrap_RgbaImageT_bi_set, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "RgbaImageT_bi_get", _wrap_RgbaImageT_bi_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "RgbaImageT_ai_set", _wrap_RgbaImageT_ai_set, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "RgbaImageT_ai_get", _wrap_RgbaImageT_ai_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "new_RgbaImageT", _wrap_new_RgbaImageT, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "delete_RgbaImageT", _wrap_delete_RgbaImageT, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "RgbaImageT_alloc", _wrap_RgbaImageT_alloc, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "RgbaImageT_free", _wrap_RgbaImageT_free, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "RgbaImageT_dissolve", _wrap_RgbaImageT_dissolve, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "RgbaImageT_read", _wrap_RgbaImageT_read, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "RgbaImageT_write", _wrap_RgbaImageT_write, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "RgbaImageT_reset", _wrap_RgbaImageT_reset, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "RgbaImageT_toPhoto", _wrap_RgbaImageT_toPhoto, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "RgbaImageT_warp", _wrap_RgbaImageT_warp, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp,"RgbaImageT",TclRgbaImageTCmd, (ClientData) NULL, NULL);
	 Tcl_CreateCommand(interp, "MeshT_nx_set", _wrap_MeshT_nx_set, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "MeshT_nx_get", _wrap_MeshT_nx_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "MeshT_ny_set", _wrap_MeshT_ny_set, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "MeshT_ny_get", _wrap_MeshT_ny_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "MeshT_x_set", _wrap_MeshT_x_set, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "MeshT_x_get", _wrap_MeshT_x_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "MeshT_y_set", _wrap_MeshT_y_set, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "MeshT_y_get", _wrap_MeshT_y_get, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "new_MeshT", _wrap_new_MeshT, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "delete_MeshT", _wrap_delete_MeshT, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "MeshT_alloc", _wrap_MeshT_alloc, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "MeshT_free", _wrap_MeshT_free, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "MeshT_print", _wrap_MeshT_print, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "MeshT_interpolate", _wrap_MeshT_interpolate, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "MeshT_reset", _wrap_MeshT_reset, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "MeshT_scale", _wrap_MeshT_scale, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "MeshT_row", _wrap_MeshT_row, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "MeshT_col", _wrap_MeshT_col, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "MeshT_pick", _wrap_MeshT_pick, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "MeshT_store", _wrap_MeshT_store, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "MeshT_recover", _wrap_MeshT_recover, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "MeshT_lineModify", _wrap_MeshT_lineModify, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "MeshT_read", _wrap_MeshT_read, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "MeshT_write", _wrap_MeshT_write, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "MeshT_match", _wrap_MeshT_match, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "MeshT_pointGet", _wrap_MeshT_pointGet, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp, "MeshT_set", _wrap_MeshT_set, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateCommand(interp,"MeshT",TclMeshTCmd, (ClientData) NULL, NULL);
/*
 * These are the pointer type-equivalency mappings. 
 * (Used by the SWIG pointer type-checker).
 */
	 SWIG_RegisterMapping("_signed_long","_long",0);
	 SWIG_RegisterMapping("_rgba_image_","_RgbaImageT",0);
	 SWIG_RegisterMapping("_rgba_image_","_struct_rgba_image_",0);
	 SWIG_RegisterMapping("_byte","_unsigned_char",0);
	 SWIG_RegisterMapping("_long","_unsigned_long",0);
	 SWIG_RegisterMapping("_long","_signed_long",0);
	 SWIG_RegisterMapping("_size_t","_unsigned_int",0);
	 SWIG_RegisterMapping("_size_t","_int",0);
	 SWIG_RegisterMapping("_unsigned_long","_long",0);
	 SWIG_RegisterMapping("_signed_int","_int",0);
	 SWIG_RegisterMapping("_struct_rgba_image_","_RgbaImageT",0);
	 SWIG_RegisterMapping("_struct_rgba_image_","_rgba_image_",0);
	 SWIG_RegisterMapping("_unsigned_short","_short",0);
	 SWIG_RegisterMapping("_signed_short","_short",0);
	 SWIG_RegisterMapping("_unsigned_char","_byte",0);
	 SWIG_RegisterMapping("_unsigned_int","_size_t",0);
	 SWIG_RegisterMapping("_unsigned_int","_int",0);
	 SWIG_RegisterMapping("_short","_unsigned_short",0);
	 SWIG_RegisterMapping("_short","_signed_short",0);
	 SWIG_RegisterMapping("_int","_size_t",0);
	 SWIG_RegisterMapping("_int","_unsigned_int",0);
	 SWIG_RegisterMapping("_int","_signed_int",0);
	 SWIG_RegisterMapping("_RgbaImageT","_struct_rgba_image_",0);
	 SWIG_RegisterMapping("_RgbaImageT","_rgba_image_",0);
	 return TCL_OK;
}
