/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __SINGIT_MARSHALLER_H__
#define __SINGIT_MARSHALLER_H__

#include <gtk/gtksignal.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define gtk_marshal_NONE__POINTER_STRING gtk_marshal_NONE__POINTER_POINTER

// * signal marshaller to marshal a pointer result and no arguments
#define gtk_marshal_STRING__NONE gtk_marshal_POINTER__NONE
typedef gpointer (*GtkSignal_POINTER__NONE)
		(GtkObject *object, gpointer user_data);

void gtk_marshal_POINTER__NONE(GtkObject* object,
		GtkSignalFunc func, gpointer func_data, GtkArg* args);


// * signal marshaller to marshal a int result and two pointer arguments
typedef gint (*GtkSignal_INT__POINTER_POINTER)(GtkObject *object,
		gpointer arg1, gpointer arg2, gpointer user_data);

void gtk_marshal_INT__POINTER_POINTER(GtkObject* object,
		GtkSignalFunc func, gpointer func_data, GtkArg* args);


// * signal marshaller to marshal a bool result and a pointer and two integer arguments
typedef gboolean (*GtkSignal_BOOL__POINTER_INT_INT)(GtkObject *object,
	gpointer arg1, gint arg2, gint arg3, gpointer user_data);

void gtk_marshal_BOOL__POINTER_INT_INT(GtkObject* object,
	GtkSignalFunc func, gpointer func_data, GtkArg* args);


// * signal marshaller to marshal two pointer and an integer argument
typedef void (*GtkSignal_NONE__POINTER_POINTER_INT)
	(GtkObject *object, gpointer arg1,
	gpointer arg2, gint arg3, gpointer user_data);

void gtk_marshal_NONE__POINTER_POINTER_INT(GtkObject* object,
	GtkSignalFunc func, gpointer func_data, GtkArg* args);


// * signal marshaller to marshal one pointer argument and a pointer result *
#define gtk_marshal_POINTER__STRING gtk_marshal_POINTER__POINTER
typedef gpointer (*GtkSignal_POINTER__POINTER)
	(GtkObject *object, gpointer arg1, gpointer user_data);

void gtk_marshal_POINTER__POINTER(GtkObject* object,
	GtkSignalFunc func, gpointer func_data, GtkArg* args);

// * signal marshaller to marshal two integer arguments and a pointer result *
typedef gpointer (*GtkSignal_POINTER__INT_INT)
	(GtkObject *object, gint arg1, gint arg2, gpointer user_data);

void gtk_marshal_POINTER__INT_INT(GtkObject* object,
	GtkSignalFunc func, gpointer func_data, GtkArg* args);


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif // __SINGIT_MARSHALLER_H__
