
#ifndef __PLUGINGLUE_H__
#define __PLUGINGLUE_H__

#include "Expression.h"
#include "TimeBasedScript.h"
#include "XLongList.h"
#include "XStrList.h"
#include "VideoDevice.h"
#include "PluginPrefs.h"
#include "FileSpecList.h"
#include "ArgList.h"
#include "ExpressionDict.h"
#include "CEgIOFile.h"
#include "MirroredFileSys.h"
#include "FileSysIDList.h"
#include "WindowDevice.h"
#include "ConsolePixPort.h"
#include "PixPort.h"
#include "VideoDevice.h"
#include "WindowDevice.h"
#include "PluginGlue_def.h"

enum {
	cDispTrackTitle		= 1,
	cShowHelp		= 2,
	cFrameRate		= 3,
	cReloadConfig		= 4,
	cToggleFullsceen	= 5,
	cToggleConfigName	= 6,
	cStartSlideshow		= 7,
	cStopSlideshow		= 8,
	cPrevConfig		= 9,
	cNextConfig		= 10,
	cToggleConsole		= 11,
	cDecSampScale		= 12,
	cIncSampScale		= 13,
	cDecNumFFTBins		= 14,
	cIncNumFFTBins		= 15,
	cCurrentConfigName	= 16,
	cDecFFT_BinRange	= 17,
	cIncFFT_BinRange	= 18,
	cDecFFT_Smooth		= 19,
	cIncFFT_Smooth		= 20,
	cNextFullscreenMode	= 21,
	cTakeSnapshot		= 22,
	cDecNumSampBins		= 23,
	cIncNumSampBins		= 24,
	cIncFFT_Bin_Start	= 25,
	cDecFFT_Bin_Start	= 26,
	cPluginSpecific         = 100
};

typedef struct _PluginInfo {
	long            mID;
	long		mAuthor;
	const char* 	mName;
	const char* 	mVersionStr;
	const char* 	mLongVersionStr;
	const char* 	mConfigsFolder;
	const char* 	mPrefFile;
	long            mPrefCompatVersion;
}
PluginInfo;

class PluginGlue {

public:
	PluginGlue( long inHostVers, void* inRefCon, const PluginInfo info);
	virtual	~PluginGlue();

	void			SetFullscreen( bool inFullScreen );
	inline bool		IsFullscreen()							{ return mAtFullScreen;	}

	void			PrepareToExit();

	bool			AlwaysOnTop()							{ return mAlwaysOnTop;							}
	bool			BorderlessWindow()						{ return mBorderlessWind;						}

	// Note: If inRect is nil then the entire plugin/window area is blackened on the next frame
	void			Refresh( Rect* inRect );

	bool			ExecuteKey( long inChar, bool inShiftKey, bool inCtrlKey );
	virtual bool		ExecuteCmdCode( long inCmdCode, bool inShiftKey );
	bool			ExecuteScript( CEgFileSpec& inSpec );

/*
	bool			Capturing()								{ return mCaptureFile.is_open();				}
#if STANDALONE
	bool			ExportingVideo()						{ return mVideoExporter.Exporting();			}
#endif
*/
	virtual void		CommandClick();

	void			StoreWinRect()								{ if ( ! IsFullscreen() ) mWindowOutput.GetWindowRect( mWinRectHolder ); }

	// Use this fcn to tell the visualizer if it's currently the topmost/foreground process.
	// This allows the plugin to vary what's returned in GetPriority
	void			SetForeground( bool inIsForeground )					{ mVideoOutput -> SetDesiredFPS( ( inIsForeground ) ? mForeFPS : mBackFPS ); }

	// Returns a number from 0 to 100, describing what priority level this plugin should be in the OS (0 means highest priority, 100 means lowest)
	// It's up to the caller to figure out how to make more calls to Draw()
	long			GetPriority()								{ return mVideoOutput -> GetPriority(); }

	// Orders the plugin to save a snapshot to disk (in the config folder w/ a unique name)
	void			TakeScreenshot();

	void			SetWindowOutput( PP_WindowPtr inWind, const Rect* inRect, bool inFullscreen );

	void 			SetVideoOutput( VideoDevice* inDevice, bool inFullscreen );

	void			SetOccupiedRect( bool inFullScreen );

	// Attempts to return the OS window for this plugin
	PP_WindowPtr		GetWindow()								{ return mWindowOutput.GetWindow(); }

	/* Use this call (instead of SetPort()) when the plugin
		is in control of its own window (ie, in MacAMP and Winamp)--this call will make a call to
		SetPort().  In other words, this call is like SetPort() but it also
 		correctly positions WhiteCap's window for you, changing inRect from global cords to local cords
			If inRect is invalid or NULL, the prefs are used... */
	void			SetParentWind( PP_WindowPtr inWind )					{ mParentWind = inWind; }

	// Calling this assumes that the GrafPort WhiteCap has is a window.  This call simply is a
	// MacOS/Win32 util to get a rect for the OS window size
	void			GetWinRect( Rect& outRect );

	// Looks for metastrings like #ARTIST# and replaces it with the appropriate text
	void			ReplaceTrackInfo( UtilStr& ioText );

	// Get default font info...
	const UtilStr*		GetDefaultFont()							{ return &mTextFont; }
	int			GetDefaultTextSize()							{ return mTextSize; }

	// Print something to the console
	void			Print( const char* inStr );
	void			Print( const UtilStr* inStr )						{ if ( inStr ) Print( inStr -> getCStr() ); }
	void			Print( char inChar );
	void			Println( const char* inStr );
	void			Println( const UtilStr* inStr )						{ Println( inStr ? inStr -> getCStr() : NULL ); }
	void			Println( float inNum );

	Point			GetFullscreenSize();

	long			GetFullscreenDepth()							{ return mFullscreenDepth; }

	// Pass NULL to record all zeros
	void			Draw( SPluginData* inData, long inTime_MS = -1 );

#if EG_MAC
	void			HandleEvt( WindowPtr inWin, EventRecord& evt );
#endif

	// NewTrack() updates the current track info (ie, the current track info has changed) and it triggers track title text
	void			NewTrack( char* inTitle, char* inArtist, char* inAlbum  );

	bool			IsCurrentSong( const char* inSongTitle )							{ return mSongTitle.compareTo( inSongTitle ) == 0;		}

protected:
	void			RecordSample( bool inDoFFT, bool inDoSamples );

	void			CacheFolder( const char* inFolder, FileSysIDList& outIDList, XLongList* outPlayList, long inNumLevels );

	// To ged rid of all the #defines
	typedef struct _FactoryPrefPresets {

		long		mPrefCompatVersion;

		long		mFFT_Bin_Start;
		long		mFFT_StepsPerBin;
		float		mFFT_Smooth;
		long		mFFT_NumBins;
		float		mFFT_FadeAway;
		UtilStr		mFFT_TransformStr;

		long		mFullscreenDepth;
		Point		mMaxDispSize;
		float		mSample_Smooth;
		long		mSample_NumBins;
		long		mForeFPS;
		long		mBackFPS;
	}
	FactoryPrefPresets;

	// Sets each pref...
	virtual void		SetPrefsFactory() = 0;
	void			SetPrefsFactory(FactoryPrefPresets presets);
	virtual void		LoadPrefs( Prefs& inPrefs );
	virtual void		SavePrefs( Prefs& inPrefs );

	void 			SetSample_NumBins( long inNum );
	void			SetFFT_NumBins( long inNum );

	// Script Related
	virtual bool		ExecuteCmd( UtilStr& inCmd );
	void			ExecuteCmdList( UtilStr& inCmdList );
	void			QueueCmdList( const UtilStr& inCmdList );
	void			KillRunningScripts();
	void			ManageTimeScripts();

	bool			ExecuteScriptFromKey( long inKey, bool inSuppressMsgs );
	bool			StoreStateAsScript( long inKey );
	virtual void		MakeStateCmdLine( UtilStr& outCmdList ) = 0;

	FileSysIDList		mScripts;
	FileObj			mScriptFolderID;
	nodeClass		mRunningScripts;

	// The Rect is in pane coords
	virtual void		RefreshRect( Rect* )													{ }

	virtual void		DoFrame() = 0;
	virtual void		PortResized( long inX, long inY ) = 0;

	// Capture...
	virtual PixPort*	Screenshot_PixPort() = 0;

	// Makes outSpec a unique file spec in the config folder (ex, "Screenshot 1", "Screenshot 2", etc...)
	bool			GetScreenshotSpec( CEgFileSpec& outSpec );

	// Keep the audio player informed of our current fullscreen settings
	void			AssertFullscreenSettings();

	// Various prefs...
	float			mScrnSaverDelay;		// (Pref)
	long			mBorderlessWind;		// (Pref)
	Point			mMaxDispSize;			// (Pref)
	long			mFullscreenDepth;		// (Pref)
	long			mFullscreenMode;		// (Pref)
	UtilStr			mKeyMap;			// (Pref)
	UtilStr			mTextFont;			// (Pref)
	long			mTextSize;			// (Pref)
	long			mAlwaysOnTop;			// (Pref)
	long			mForeFPS;			// (Pref)
	long			mBackFPS;			// (Pref)
	UtilStr			mStartupCmdList;		// (Pref)
	long			mCacheDepth;			// (Pref)

	// Shared expr variables
	float			mTransition_I;

	// Stores the time index
	long			mT_MS, mT_MS_Base;
	float			mT;
	void			ResetTimeIndex( long inNewTimeIndex_MS );  		// Override and add to this to handle changing the time index
	virtual void		TimeIndexHasChanged( long inOldBase_MS ) = 0;

	// Console related members
	XStrList		mConsoleLines;
	XLongList		mLineExpireTimes;
	long			mConsoleLineDur;		// (Pref)
	bool			mShowConsole;
	Rect			mConsoleDirtyRgn;
	void			DrawConsole( ConsolePixPort *inPort );
	void			RemoveExpiredConsoleLines();

	// FFT Settings
	float			mFFT_FadeAway;			// (Pref)
	long			mFFT_Bin_Start;			// (Pref)
	long			mFFT_StepsPerBin;		// (Pref)
	float			mFFT_Smooth;			// (Pref)
	long			mFFT_NumBins;			// (Pref)
	UtilStr			mFFT_TransformStr;		// (Pref)
	Expression		mFFT_TransformFcn;
	float			mFFT_X, mFFT_W;
	float			mFFT_Bass;
	ExprUserFcn*		mFFT_Fcn;

	// Sample clip settings
	float			mSample_Smooth;			// (Pref)
	long			mSample_NumBins;		// (Pref)
	float			mSample_Scale;			// (Pref)
	ExprUserFcn*		mSample_Fcn;

	// Host info
	unsigned long		mHostVersion;

	// Glue

	// Data access
	UtilStr			mTemp;
	ExpressionDict		mDict;

	// Track text related
	Expression		mTrackTextStartFcn;
	UtilStr			mTrackTextStartStr;		// (Pref)
	UtilStr			mArtist, mAlbum, mSongTitle;
	float			mLastSongStart;
	bool			mTrackTextIsReset;
	virtual void		StartTrackText() = 0;

	PluginPrefs		mPrefs;				// How we access the prefs data

	MirroredFileSys		mMainFolder;

	// Current dimensions of the occupied rect
	long			mDimX, mDimY;
	VideoDevice*		mVideoOutput;
	WindowDevice 		mWindowOutput;

	// Returns true if <inStage> was successfully initialized
	virtual void 		Initialize();

	// Init stuff
	bool			mNeedsInit;
	void			Init();

	PluginInfo              mPluginInfo;

private:
	Rect			mPaneRect;		// Local cords rect within mOSPort we're permitted to draw in (ex, the window client rect)
	Rect			mDispRect;		// Local cords rect within mOSPort we're limiting ourselves to draw in

	void*			mRefCon;		// Holds the ptr passed in the constructor
	bool			mDoingSetPortWin;	// true when a thread is currently inside SetPortWin()
	Rect			mWinRectHolder;		// Win rect holder while we're n FS mode; where's my pants?

	// Capture/export/playback members...
/*
#if STANDALONE
	VideoExporter		mVideoExporter;
	CEgIFile			mPlaybackFile;
	bool			mStartExport;
	void			VideoExport_Start( PixPort& inSample );
	void			VideoExport_End();
#endif
	CEgFileSpec		mCaptureSpec;
	CEgIOFile		mCaptureFile;
	float			mPrevCaptureT;
#define	CAPTURE_MARKER_SAMP	55
#define	CAPTURE_MARKER_FFT		66
	long			mNextT_MS;
*/
#if STANDALONE
	float*			mFFT_Copy;
	UtilStr			mFFT_CopyBuf;
	SoundInput		mSoundPort;
#endif

	// Stuff dealing with full screen & screensaver mode
	bool			mAtFullScreen;
	bool			mMouseWillAwaken;
	Point			mLastMousePt;
	float			mLastActiveTime, mLastKeyPollTime;
	unsigned long		mCurKeys[ 4 ];
	unsigned long		mPastKeys[ 4 ];
	void			IdleMonitor();

	// Data members/buffers
	UtilStr			mSamplesBuf;
	UtilStr			mFFTBuf;
	SPluginData*		mClientData;

	void			RecordFFT();
	void			RecordSample();

	// GUI related stuff
	PP_WindowPtr		mParentWind;
	long			mLastCursorUpdate;
	virtual void		ShowHelp() = 0;
	void			Show_HTML_Help();
};

#endif // __PLUGINGLUE_H__
