/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2003 Nicolas Adenis-Lamarre (aspegic500@free.fr)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include "dlg_about.h"
#include <gtk/gtk.h>
#include "singit/macros.h"
#include "displayer_xosd_status.h"

GtkWidget *dlg_about_window = NULL;

void dlg_about_close(void *data);

void dlg_about(void) {

  GtkWidget *close_button, *vbox;
  GtkWidget *label, *sep;

  if(dlg_about_window != NULL)
    return;

  label = gtk_label_new(
			g_strconcat(_("Plugin Xosd "),
				    DISPLAYER_XOSD_VERSION,
				    "\n",
				    _("developped for Singit\n"),
				    _("by Nicolas Adenis-Lamarre\n"),
				    _("(aspegic500@free.fr)\n\n"),
				    _("Special thanks to\n"),
				    _("Jan-Marek Glogowski\n"),
				    _("for his help\n\n"),
				    _("If you found a bug or have a new idea\n"),
				    _("for this plugin, please write it to me.\n"),
				    _("Please read BUGS and TODO files\n"),
				    _("in src/displayer/xosd before.\n"),
				    NULL));
  
  close_button = gtk_button_new_with_label(_("Ok"));
  gtk_signal_connect(GTK_OBJECT(close_button), "clicked", GTK_SIGNAL_FUNC(dlg_about_close), NULL);

  sep=gtk_hseparator_new();

  dlg_about_window = gtk_window_new(GTK_WINDOW_DIALOG);
  gtk_container_set_border_width(GTK_CONTAINER(dlg_about_window), 20);
  gtk_signal_connect(GTK_OBJECT(dlg_about_window), "destroy", GTK_SIGNAL_FUNC(dlg_about_close), NULL);

  vbox=gtk_vbox_new(FALSE, 0);

  gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(vbox), sep, FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(vbox), close_button, FALSE, FALSE, 0);
  gtk_container_add((GTK_CONTAINER(dlg_about_window)), vbox);
  
  gtk_widget_show_all(dlg_about_window);
}

void dlg_about_close(void *data){
  gtk_widget_destroy(dlg_about_window);
  dlg_about_window = NULL;
}
