
#include "XStrList.h"


XStrList::XStrList( XStrListOptsT inOption, DupeOptionT inDupeOption ) :
	AbstractStrList( inOption, sStrComparitor ) {

	mDupeOption = inDupeOption;
}

XStrList::~XStrList() {

	RemoveAll();
}

long XStrList::Add( const void* inData, long inLen ) {

	UtilStr* s	= new UtilStr( inData, inLen );
	bool 	doAdd;

	if ( ( mDupeOption == cNoDupes_CaseInsensitive ) ||
		( mDupeOption == cNoDupes_CaseSensitive ) )
	{
		doAdd = FindString( s ) == 0;
	}
	else
		doAdd = true;

	if ( doAdd )
		return mItems.Add( s );
	else {
		delete s;
		return 0;
	}
}

long XStrList::Add( const char* inStr ) {

	UtilStr* s	= new UtilStr( inStr );
	bool 	doAdd;

	if ( ( mDupeOption == cNoDupes_CaseInsensitive ) ||
		( mDupeOption == cNoDupes_CaseSensitive ) )
	{
		doAdd = FindString( s ) == 0;
	}
	else
		doAdd = true;

	if ( doAdd )
		return mItems.Add( s );
	else {
		delete s;
		return 0;
	}
}

long XStrList::Add( const UtilStr& inStr ) {

	bool 	doAdd;

	if ( mDupeOption == cNoDupes_CaseInsensitive || mDupeOption == cNoDupes_CaseSensitive )
		doAdd = FindString( &inStr ) == 0;
	else
		doAdd = true;

	if ( doAdd )
		return mItems.Add( new UtilStr( inStr ) );
	else
		return 0;
}

int XStrList::sStrComparitor( const void* inA, const void* inB, const void* inThis ) {

	bool isCaseSensitive =
		((XStrList*) inThis) -> mStrOrdering == ASA_Sorted_Case_Sensitive;

	return ( (UtilStr*) inA ) -> compareTo( (UtilStr*) inB, isCaseSensitive );
}
