
#include "CEgIOFile.h"

#include "Eg Common.h"

#include "CEgFileSpec.h"

long CEgIOFile::sCreatorType = MCC4_TO_INT("????");

CEgIOFile::CEgIOFile( int inDoTrunc, long inOBufSize )
	: CEgOStream(), CEgIFile(), mDoTrunc( inDoTrunc ) {

	mDoTrunc = inDoTrunc;
	mOBufSize = inOBufSize;

	if ( mOBufSize < 100 )
		mOBufSize = 100;
}

CEgIOFile::~CEgIOFile() {

	close();
}



#ifdef EG_MAC

#include <Files.h>
#include <Errors.h>
#include <Aliases.h>

#define __OSWOpen( specPtr ) \
	short int refNum;																									\
	short err = ::FSpCreate( (FSSpec*) specPtr -> OSSpec(), sCreatorType, specPtr -> GetType(), -1 );					\
	if ( err != ::noErr && err != dupFNErr ) {																			\
		throwErr( cCreateErr );																							\
		CEgOStream::mOSErr = err; \
	}																						\
	else {																												\
		Boolean isFolder, wasAliased;																					\
		FSSpec mySpec = *((FSSpec*) specPtr -> OSSpec());																\
		CEgOStream::mOSErr = ::ResolveAliasFile( &mySpec, true, &isFolder, &wasAliased );								\
		if ( CEgOStream::mOSErr == ::noErr || isFolder )																\
			CEgOStream::mOSErr = ::FSpOpenDF( (FSSpec*) specPtr -> OSSpec(), fsRdWrPerm, &refNum );						\
		if ( CEgOStream::mOSErr == ::noErr )																			\
			mFile = refNum;																								\
	}


#define __OSWrite( srcePtr, ioBytes ) \
	CEgOStream::mOSErr = ::FSWrite( mFile, &ioBytes, srcePtr );			\
	if ( CEgOStream::mOSErr != ::noErr ) 								\
		throwErr( cWriteErr );

#endif



#if (defined EG_WIN16 || defined EG_POSIX)

#ifdef EG_POSIX
#include <stdio.h>
#include <errno.h>
#define DWORD size_t
#endif

#define __OSWOpen( specPtr ) \
	mFile = (long) fopen( (char*) (specPtr -> OSSpec()), "w+b" );

#define __OSWrite( srcePtr, ioBytes ) \
	DWORD wrote = fwrite( srcePtr, 1, ioBytes, (FILE*) mFile );				\
	if ( wrote > 0 || ioBytes == 0 )										\
		ioBytes = wrote;													\
	else {																	\
		throwErr( cWriteErr );												\
	}

#endif



#ifdef EG_WIN32

#ifndef EG_ZINC
#include <time.h>		// Otherwise a weird compile err deep in windows.h occurs
#endif
#include <windows.h>

#define  __OSWOpen( specPtr ) \
	mFile = (long) ::CreateFile( (char*) (specPtr -> OSSpec()), GENERIC_READ | GENERIC_WRITE, 0, 0, OPEN_ALWAYS, 0, 0 );	\
	if ( ((void*) mFile) == INVALID_HANDLE_VALUE ) {																		\
		mFile = nil;																										\
		mOSErr = ::GetLastError();																							\
	}

#define __OSWrite( srcePtr, ioBytes ) \
	DWORD wrote; 															\
	bool ok = ::WriteFile( (void*) mFile, srcePtr, ioBytes, &wrote, 0 );	\
	if ( ! ok || ioBytes != wrote )	{										\
		throwErr( cWriteErr );												\
		mOSErr = ::GetLastError();											\
	}

#endif


void CEgIOFile::open( const CEgFileSpec* inSpecPtr ) {

	close();
	throwErr( cNoErr );

	if ( inSpecPtr ) {
		if ( mDoTrunc )
			inSpecPtr -> Delete();

		__OSWOpen( inSpecPtr )
	}

	if ( mFile == 0 ) {
#if EG_MAC
		if ( mOSErr == fnfErr )
#elif EG_WIN
		if ( mOSErr == ERROR_FILE_NOT_FOUND )
#elif EG_POSIX
		if ((errno == ENOENT) || (errno == EISDIR))
#endif
			throwErr( cFileNotFound );
		else
			throwErr( cOpenErr );
	}
}

void CEgIOFile::PutBlock( const void* inSrce, long numBytes ) {

	CEgIFile::skip( numBytes );										// Keep mPos up to date

	// If we don't want to exceed our buffer limit...
	if ( numBytes + (long) mOBuf.length() > mOBufSize ) {			// Uh oh, we actually  have to write to disk
		// Get rid of what we have waiting first
		flush();

		if ( numBytes > mOBufSize /4  && noErr() ) {
			__OSWrite( inSrce, numBytes ) }
		else
			CEgOStream::PutBlock( inSrce, numBytes ); }
	else
		CEgOStream::PutBlock( inSrce, numBytes );
}

/*
void CEgIOFile::PutBlock( const void* inSrce, long numBytes ) {

	CEgIFile::skip( numBytes );										// Keep mPos up to date
	if ( numBytes + (long) mOBuf.length() >= cMaxOBufSize )			// Uh oh, we actually  have to write to disk
		flush();													// Dump our buf to disk

	while ( numBytes > cMaxOBufSize ) {								// We do this loop crap because to avoid code duplication/maintainance and
		PutBlock( inSrce, cMaxOBufSize );							// to avoid giving OSWrite a nil srce ptr (which is perfectly valid from a skip call)
		if ( inSrce )
			inSrce = (char*) inSrce + cMaxOBufSize;
		numBytes -= cMaxOBufSize;
	}

	CEgOStream::PutBlock( inSrce, numBytes );
}
*/

void CEgIOFile::flush() {

	long ioBytes = mOBuf.length();

	if ( ! mFile )
		throwErr( cNotOpen );
	else if ( ioBytes > 0 && noErr() ) {
		__OSWrite( mOBuf.getCStr(), ioBytes )
		if ( noErr() ) {
			invalidateBuf();							// Invalidate read buffer
			mOBuf.Wipe();								// We're done with the out buffer
		}
	}
}

long CEgIOFile::size() {

	flush();

	return CEgIFile::size();
}

void CEgIOFile::seek( long inPos ) {

	if ( noErr() ) {
		flush();										// Write any pending data

		if ( noErr() ) {
			CEgIFile::seek( inPos );
			diskSeek( inPos );
		}
	}
}

void CEgIOFile::close() {

	if ( is_open() ) {
		flush();

		CEgIFile::close();
	}
}
