/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#include <X11/Xlib.h>
#include <gtk/gtk.h>

#include <xmms/plugin.h>
#include <xmms/xmmsctrl.h>

#include <stdlib.h>
#include <gdk/gdkkeysyms.h>
#include <stdio.h>

#include "singit_macros.h"
#include "singit_macros_private.h"

#include "singit_dialogs.h"
#include "singit_main.h"
#include "singit_plugin_scanner.h"
#include "singit_dialogs.h"

static void main_init(void);
static void main_cleanup(void);
static void main_about(void);
static void main_config(void);
static void main_playback_start(void);
static void main_playback_stop(void);
static void main_render_freq(gint16 freq_data[2][256]);
static void main_render_pcm(gint16 pcm_data[2][512]);

VisPlugin singit_vp =
{
	NULL,
	NULL,
	0,
	SINGIT_VERSION_STRING,
	2,
	2,
	main_init, /* init */
	main_cleanup, /* cleanup */
	main_about, /* about */
	main_config, /* configure */
	NULL, /* disable_plugin */
	main_playback_start, /* playback_start */
	main_playback_stop, /* playback_stop */
	main_render_pcm, /* render_pcm */
	main_render_freq  /* render_freq */
};

VisPlugin *get_vplugin_info(void)
{
	singit_vp.description = g_strdup(SINGIT_VERSION_STRING);
	return &singit_vp;
}

static void main_init(void)
{
#	ifdef CODEDEBUG
	DEBUG(("main.c [main_init]\n"), 9);
#	endif

	singit_main_init(TRUE);
}

static void main_cleanup(void)
{
	#ifdef CODEDEBUG
	DEBUG(("main.c [main_cleanup]\n"), 9);
	#endif

	singit_main_finish(TRUE);
}

static void main_about(void)
{
	#ifdef CODEDEBUG
	DEBUG(("main.c [main_about]\n"), 9);
	#endif

	singit_about_show();
}

void main_config(void)
{
	#ifdef CODEDEBUG
	DEBUG(("main.c [main_config]\n"), 9);
	#endif

	singit_config_show();
}

static void main_playback_start(void)
{
	#ifdef CODEDEBUG
	DEBUG(("main.c [main_playback_start]\n"), 9);
	#endif
}

static void main_playback_stop(void)
{
	#ifdef CODEDEBUG
	DEBUG(("main.c [main_playback_stop]\n"), 9);
	#endif
}

static void main_render_freq(gint16 freq_data[2][256])
{
	dis_plugin_render_freq(freq_data);
}

static void main_render_pcm(gint16 pcm_data[2][512])
{
	dis_plugin_render_pcm(pcm_data);
}
