/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <gtk/gtk.h>

#include "singit_macros.h"
#include "singit_macros_private.h"

#include "dlg_singit_about.h"

static GtkWidget *singit_about_win = NULL;

static 	GtkWidget *about_vbox,
		*about_notebook,
			*info_about_frame, *info_about_table, *info_about_label, *info_about_text_label,
			*info_key_1_vbox,
				*info_creator_frame, *info_creator_table, *info_creator_label, *info_creator_text_label,
				*info_1_displayer_frame, *info_1_displayer_table, *info_1_displayer_text_label,
			*info_2_displayer_frame, *info_2_displayer_table, *info_2_displayer_label, *info_2_displayer_text_label,
		*button_hbox, *ok_button;

void singit_about_hide(void)
{
	#ifdef CODEDEBUG
	DEBUG(("dlg_singit_about.c [singit_about_hide]\n"), 9);
	#endif

	if (singit_about_win) {
		gtk_widget_destroy(singit_about_win);
	}
}

/*
	SingIt main about  page
*/
void singit_about_create_about_page(GtkNotebook *notebook)
{
	gchar *transStr = '\0', *formatStr[3];

	info_about_frame = gtk_frame_new(NULL);
	gtk_widget_show(info_about_frame);
	info_about_label = gtk_label_new(_("About"));
	gtk_widget_show(info_about_label);
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), info_about_frame, info_about_label);

	info_about_table = gtk_table_new(1, 1, FALSE);
	gtk_container_add(GTK_CONTAINER(info_about_frame), info_about_table);
	gtk_container_border_width(GTK_CONTAINER(info_about_table), 5);
	gtk_widget_show(info_about_table);

	formatStr[0] = g_strdup_printf(_("Developed by %s"), "Jan-Marek Glogowski");
	formatStr[1] = g_strdup_printf(_("Email: %s"), JMG_EMAIL);
	formatStr[2] = NULL;
	transStr = g_strconcat(SINGIT_VERSION_STRING, "\n\n\n", formatStr[0], "\n", formatStr[1], "\n\n",
	  _("Current Translation: Jan-Marek Glogowski"), "\n",
	  _("Email: glogow@stud.fbi.fh-darmstadt.de"), "\n\n",
	  _("For further autors see AUTHORS"),
	  "\n\nCopyright (C) 2000 - 2002 Jan-Marek Glogowski", transStr);
	info_about_text_label = gtk_label_new( transStr );
	gtk_table_attach_defaults(GTK_TABLE(info_about_table), info_about_text_label, 0, 1, 0, 1);
	gtk_widget_show(info_about_text_label);
	g_free(transStr);
	g_free(formatStr[1]);
	g_free(formatStr[0]);
}

/*
	SingIt key 1  about  page
*/
void singit_about_create_keybindings_one_page(GtkNotebook *notebook)
{
	gchar *transStr = '\0';

	info_key_1_vbox = gtk_vbox_new(FALSE, 2);
	gtk_widget_show(info_key_1_vbox);
	info_creator_label = gtk_label_new(_("Keys 1"));
	gtk_widget_show(info_creator_label);
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), info_key_1_vbox, info_creator_label);

	info_creator_frame = gtk_frame_new(_("Editor key bindings"));
	gtk_box_pack_start(GTK_BOX(info_key_1_vbox), info_creator_frame, FALSE, FALSE, 0);
	gtk_widget_show(info_creator_frame);

	info_creator_table = gtk_table_new(1, 2, FALSE);
	gtk_container_add(GTK_CONTAINER(info_creator_frame), info_creator_table);
	gtk_container_border_width(GTK_CONTAINER(info_creator_table), 5);
	gtk_table_set_col_spacing(GTK_TABLE(info_creator_table), 0, 5);
	gtk_widget_show(info_creator_table);

	transStr = g_strconcat("   ", _("CTRL"), " + l", "\n   ", _("CTRL"), " + n", "\n   ",
		_("CTRL"), " + o", "\n   ", _("CTRL"), " + s", "\n   ",
		_("CTRL"), " + t", "\n\n", _("Timestamp mode"), "\n\n   ",
		_("Left mouse"), "\n   ", _("CTRL"), " + ", _("Left mouse"), "\n   ",
		_("SHIFT"), " + ", _("Left mouse"), "\n", NULL);
	info_creator_text_label = gtk_label_new( transStr );
	gtk_label_set_justify(GTK_LABEL(info_creator_text_label), GTK_JUSTIFY_LEFT);
	gtk_table_attach_defaults(GTK_TABLE(info_creator_table), info_creator_text_label, 0, 1, 0, 1);
	gtk_widget_show(info_creator_text_label);
	g_free(transStr);

	transStr = g_strconcat( _("Load current song lyrics"), "\n", _("Start new lyrics"), "\n",
		_("Open lyric file"), "\n", _("Save lyrics"), "\n",
		_("Toggle editor mode"), "\n\n\n\n", _("Insert timestamp"), "\n",
		_("Remove timestamp"), "\n", _("Insert timestamp"), "\n", _("and keep line"), NULL);
	info_creator_text_label = gtk_label_new( transStr );
	gtk_label_set_justify(GTK_LABEL(info_creator_text_label), GTK_JUSTIFY_LEFT);
	gtk_table_attach_defaults(GTK_TABLE(info_creator_table), info_creator_text_label, 1, 2, 0, 1);
	gtk_widget_show(info_creator_text_label);
	g_free(transStr);

	info_1_displayer_frame = gtk_frame_new(_("Displayer quick song key bindings"));
	gtk_box_pack_start(GTK_BOX(info_key_1_vbox), info_1_displayer_frame, FALSE, FALSE, 0);
	gtk_widget_show(info_1_displayer_frame);

	info_1_displayer_table = gtk_table_new(1, 2, FALSE);
	gtk_container_add(GTK_CONTAINER(info_1_displayer_frame), info_1_displayer_table);
	gtk_container_border_width(GTK_CONTAINER(info_1_displayer_table), 5);
	gtk_table_set_col_spacing(GTK_TABLE(info_1_displayer_table), 0, 5);
	gtk_widget_show(info_1_displayer_table);

	transStr = g_strconcat( _("NUM + [0..9]"), "\n", _("NUM + [.,]"), "\n", _("NUM + ENTER"), NULL);
	info_1_displayer_text_label = gtk_label_new( transStr );
	gtk_label_set_justify(GTK_LABEL(info_1_displayer_text_label), GTK_JUSTIFY_LEFT);
	gtk_table_attach_defaults(GTK_TABLE(info_1_displayer_table), info_1_displayer_text_label, 0, 1, 0, 1);
	gtk_widget_show(info_1_displayer_text_label);
	g_free(transStr);

	transStr = g_strconcat( _("Number of song"), "\n", _("Clear song number buffer"), "\n", _("Jump to song"), NULL);
	info_1_displayer_text_label = gtk_label_new( transStr );
	gtk_label_set_justify(GTK_LABEL(info_1_displayer_text_label), GTK_JUSTIFY_LEFT);
	gtk_table_attach_defaults(GTK_TABLE(info_1_displayer_table), info_1_displayer_text_label, 1, 2, 0, 1);
	gtk_widget_show(info_1_displayer_text_label);
	g_free(transStr);
}

/*
	SingIt key 2 about  page
*/
void singit_about_create_keybindings_two_page(GtkNotebook *notebook)
{
	gchar *transStr = '\0';

	info_2_displayer_frame = gtk_frame_new(_("Displayer key bindings"));
	gtk_widget_show(info_2_displayer_frame);
	info_2_displayer_label = gtk_label_new(_("Keys 2"));
	gtk_widget_show(info_2_displayer_label);
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), info_2_displayer_frame, info_2_displayer_label);

	info_2_displayer_table = gtk_table_new(1, 2, FALSE);
	gtk_container_add(GTK_CONTAINER(info_2_displayer_frame), info_2_displayer_table);
	gtk_container_border_width(GTK_CONTAINER(info_2_displayer_table), 5);
	gtk_table_set_col_spacing(GTK_TABLE(info_2_displayer_table), 0, 5);
	gtk_widget_show(info_2_displayer_table);

	transStr = g_strconcat( "[zy]\nx\nc\nv\nb\n\n", _("CTRL"), " + p\n", _("CTRL"), " + e\n",
		_("CTRL"), " + a\n", _("CTRL"), " + i\n", _("CTRL"), " + [0-9]\nESC\n",
		_("CTRL"), " + c\n\n", _("NUM + '+'"), "\n", _("NUM + '-'"), NULL);
	info_2_displayer_text_label = gtk_label_new( transStr );
	gtk_label_set_justify(GTK_LABEL(info_2_displayer_text_label), GTK_JUSTIFY_LEFT);
	gtk_table_attach_defaults(GTK_TABLE(info_2_displayer_table), info_2_displayer_text_label, 0, 1, 0, 1);
	gtk_widget_show(info_2_displayer_text_label);
	g_free(transStr);

	transStr = g_strconcat( _("Previous song"), "\n", _("Play"), "\n", _("Pause"), "\n", _("Stop"),
		"\n", _("Next song"), "\n\n", _("Show preferences window"),
		"\n", _("Show the lyrics editor"),
		"\n", _("Show the about window"),
		"\n", _("Show the id3 tag window"),
		"\n", _("Start displayer plugin"),
		"\n", _("Stop displayer plugin"),
		"\n", _("Show displayer config"),
		"\n",
		"\n", _("Volume up"),
		"\n", _("Volume down"), NULL);
	info_2_displayer_text_label = gtk_label_new( transStr );
	gtk_label_set_justify(GTK_LABEL(info_2_displayer_text_label), GTK_JUSTIFY_LEFT);
	gtk_table_attach_defaults(GTK_TABLE(info_2_displayer_table), info_2_displayer_text_label, 1, 2, 0, 1);
	gtk_widget_show(info_2_displayer_text_label);
	g_free(transStr);
}

void singit_about_show_page(guint page)
{
	#ifdef CODEDEBUG
	DEBUG(("dlg_singit_about.c [singit_about_show_page] : %i\n", page), 9);
	#endif

	if (singit_about_win) {
		if (gtk_notebook_current_page(GTK_NOTEBOOK(about_notebook)) != page)
			gtk_notebook_set_page(GTK_NOTEBOOK(about_notebook), page);
		gdk_window_raise(singit_about_win->window);
		return;
	}

#ifdef ENABLE_NLS
	setlocale (LC_ALL, "");
	bindtextdomain (PACKAGE, SINGIT_LOCALE_DIR);
#endif

	singit_about_win = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_signal_connect(GTK_OBJECT(singit_about_win), "destroy",
		GTK_SIGNAL_FUNC(gtk_widget_destroyed), &singit_about_win);
	gtk_window_set_title(GTK_WINDOW(singit_about_win), "XMMS SingIt About");
	gtk_window_set_policy(GTK_WINDOW(singit_about_win), FALSE, FALSE, FALSE);
	gtk_window_set_position(GTK_WINDOW(singit_about_win), GTK_WIN_POS_MOUSE);
	gtk_container_border_width(GTK_CONTAINER(singit_about_win), 3);
	gtk_window_set_position(GTK_WINDOW(singit_about_win), GTK_WIN_POS_MOUSE);

	about_vbox = gtk_vbox_new(FALSE, 2);
	gtk_container_add(GTK_CONTAINER(singit_about_win), about_vbox);
	gtk_widget_show (about_vbox);

	about_notebook = gtk_notebook_new();
	gtk_notebook_set_tab_pos(GTK_NOTEBOOK(about_notebook), GTK_POS_TOP);
	gtk_box_pack_start(GTK_BOX(about_vbox), about_notebook, FALSE, FALSE, 0);
	gtk_widget_show(about_notebook);

	singit_about_create_about_page(GTK_NOTEBOOK(about_notebook));
	singit_about_create_keybindings_one_page(GTK_NOTEBOOK(about_notebook));
	singit_about_create_keybindings_two_page(GTK_NOTEBOOK(about_notebook));

	/* Centered cancel button */
	button_hbox = gtk_hbutton_box_new();
	gtk_button_box_set_spacing(GTK_BUTTON_BOX(button_hbox), 5);
	gtk_box_pack_start(GTK_BOX(about_vbox), button_hbox, FALSE, FALSE, 2);

	ok_button = gtk_button_new_with_label( _("Ok") );
	gtk_signal_connect_object(GTK_OBJECT(ok_button), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(singit_about_win));
	GTK_WIDGET_SET_FLAGS(ok_button, GTK_CAN_DEFAULT);
	gtk_box_pack_start(GTK_BOX(button_hbox), ok_button, TRUE, TRUE, 0);
	gtk_widget_grab_default(ok_button);

	gtk_widget_show(ok_button);
	gtk_widget_show(button_hbox);
	gtk_widget_show(singit_about_win);

	if (gtk_notebook_current_page(GTK_NOTEBOOK(about_notebook)) != page)
		gtk_notebook_set_page(GTK_NOTEBOOK(about_notebook), page);
}

void singit_about_show(void)
{
	#ifdef CODEDEBUG
	DEBUG(("dlg_singit_about.c [singit_about_show]\n"), 9);
	#endif

	singit_about_show_page(0);
}