/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <gtk/gtk.h>

#include "singit_macros.h"
#include "singit_macros_private.h"

#include "dlg_messagebox.h"

enum {
	BUTTON_PRESSED,
	LAST_SIGNAL
};

static guint message_box_dialog_signals[LAST_SIGNAL] = { 0 };
static GtkWidgetClass *parent_class = NULL;

static void message_box_dialog_destroy (GtkObject *object);
static void any_button_clicked (GtkButton *button, gpointer data);

static void message_box_dialog_class_init (MessageBoxDialogClass *class)
{
	GtkObjectClass *object_class;

	object_class = (GtkObjectClass*) class;

	parent_class = gtk_type_class (gtk_widget_get_type ());

	message_box_dialog_signals[BUTTON_PRESSED] =
		gtk_signal_new ("button_pressed",
		GTK_RUN_FIRST,
		object_class->type,
		GTK_SIGNAL_OFFSET (MessageBoxDialogClass, button_pressed),
		gtk_marshal_NONE__INT,
		GTK_TYPE_NONE,
		1,
		GTK_TYPE_INT);

	gtk_object_class_add_signals (object_class, message_box_dialog_signals, LAST_SIGNAL);
  	class->button_pressed = NULL;

	object_class->destroy = message_box_dialog_destroy;
}

gint message_box_delete_event(GtkWidget *widget, GdkEvent *event, gpointer data)
{
	#ifdef CODEDEBUG
	DEBUG(("dlg_messagebox.c [message_box_delete_event]\n"), 9);
	#endif

	any_button_clicked(GTK_BUTTON(MESSAGE_BOX_DIALOG(data)->std_button), data);
	return (TRUE);
}

static void message_box_dialog_init (MessageBoxDialog *dialog)
{
	GtkWidget *separator;

	dialog->button_counter = 2;
	dialog->isVisible = FALSE;

	gtk_window_set_policy(GTK_WINDOW(dialog), FALSE, FALSE, FALSE);
	gtk_window_set_position(GTK_WINDOW(dialog), GTK_WIN_POS_MOUSE);

	dialog->vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (dialog), dialog->vbox);
	gtk_widget_show (dialog->vbox);

	dialog->action_area = gtk_hbox_new (FALSE, 5);
	gtk_container_set_border_width (GTK_CONTAINER (dialog->action_area), 10);
	gtk_box_pack_start (GTK_BOX (dialog->vbox), dialog->action_area, TRUE, TRUE, 0);
	gtk_widget_show (dialog->action_area);

	separator = gtk_hseparator_new ();
	gtk_box_pack_start (GTK_BOX (dialog->vbox), separator, FALSE, TRUE, 0);
	gtk_widget_show (separator);

	dialog->button_hbox = gtk_hbox_new (TRUE, 5);
	gtk_container_set_border_width (GTK_CONTAINER (dialog->button_hbox), 3);
	gtk_box_pack_start (GTK_BOX (dialog->vbox), dialog->button_hbox, FALSE, FALSE, 0);
	gtk_widget_show (dialog->button_hbox);

	gtk_signal_connect(GTK_OBJECT(dialog), "delete_event",
		GTK_SIGNAL_FUNC(message_box_delete_event), dialog);
}

GtkType message_box_dialog_get_type (void)
{
	static GtkType dialog_type = 0;

	if (!dialog_type) {

		static const GtkTypeInfo dialog_info =
		{
			"MessageBoxDialog",
			sizeof (MessageBoxDialog),
			sizeof (MessageBoxDialogClass),
			(GtkClassInitFunc) message_box_dialog_class_init,
			(GtkObjectInitFunc) message_box_dialog_init,
			NULL,
			NULL,
			(GtkClassInitFunc) NULL,
		};

		dialog_type = gtk_type_unique (GTK_TYPE_WINDOW, &dialog_info);
	}

	return dialog_type;
}

static inline guint message_box_dialog_add_button (MessageBoxDialog *dialog, gchar *title,
	GtkSignalFunc func, gboolean append)
{
	GtkWidget *button = gtk_button_new_with_label(title);
	gtk_object_set_user_data(GTK_OBJECT(button), ((gpointer) dialog->button_counter));
	gtk_signal_connect(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(any_button_clicked), (gpointer) dialog);
	if (func) {
		gtk_signal_connect(GTK_OBJECT(button), "clicked", func, (gpointer) dialog);
	}
	if (append) { gtk_box_pack_end (GTK_BOX(dialog->button_hbox), button, TRUE, FALSE, 0); }
	else { gtk_box_pack_start (GTK_BOX(dialog->button_hbox), button, TRUE, FALSE, 0); }
	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
	gtk_widget_show(button);
	dialog->button_counter++;
	return (dialog->button_counter-1);
}

guint message_box_dialog_append_button (MessageBoxDialog *dialog, gchar *title, GtkSignalFunc func)
{
	return message_box_dialog_add_button(dialog, title, func, TRUE);
}

guint message_box_dialog_prepend_button (MessageBoxDialog *dialog, gchar *title, GtkSignalFunc func)
{
	return message_box_dialog_add_button(dialog, title, func, FALSE);
}

GtkWidget *message_box_dialog_new  (gchar  *title,
				    gchar  *text,
				    gchar  *buttonText,
				    gint    width,
				    gint    height)
{
	GtkWidget *dialog;
	MessageBoxDialog *mbd;

	#ifdef CODEDEBUG
	DEBUG(("dlg_messagebox.c [message_box_dialog_new]\n"), 9);
	#endif

	mbd = gtk_type_new(TYPE_MESSAGE_BOX_DIALOG);
	dialog = GTK_WIDGET(mbd);

	if (buttonText) {
		mbd->std_button = gtk_button_new_with_label(buttonText);
		gtk_object_set_user_data(GTK_OBJECT(mbd->std_button), (gpointer) 1);
		gtk_signal_connect(GTK_OBJECT(mbd->std_button), "clicked",
			GTK_SIGNAL_FUNC(any_button_clicked), (gpointer) dialog);
		gtk_box_pack_end (GTK_BOX(MESSAGE_BOX_DIALOG(dialog)->button_hbox), mbd->std_button,
			TRUE, FALSE, 0);
		GTK_WIDGET_SET_FLAGS(mbd->std_button, GTK_CAN_DEFAULT);
		gtk_widget_grab_default(mbd->std_button);
		gtk_widget_show(mbd->std_button);
	}
	if (title) {
		gtk_window_set_title(GTK_WINDOW(dialog), title);
	}
	if (text) {
		mbd->label = gtk_label_new (text);
		gtk_box_pack_start (GTK_BOX(MESSAGE_BOX_DIALOG(dialog)->action_area), mbd->label,
			FALSE, TRUE, 0);
		gtk_widget_show(mbd->label);
	}

	return dialog;
}

static void message_box_dialog_destroy (GtkObject *object)
{
	#ifdef CODEDEBUG
	DEBUG(("dlg_messagebox.c [message_box_dialog_destroy]\n"), 9);
	#endif

	if (GTK_OBJECT_CLASS(parent_class)->destroy)
		(* GTK_OBJECT_CLASS (parent_class)->destroy) (object);
}

static void any_button_clicked (GtkButton *button, gpointer data)
{
	MessageBoxDialog *mbd;

	#ifdef CODEDEBUG
	DEBUG(("dlg_messagebox.c [any_button_clicked]\n"), 9);
	#endif

	g_return_if_fail (IS_MESSAGE_BOX_DIALOG((GtkWidget *) data));
	mbd = MESSAGE_BOX_DIALOG(data);

	gtk_signal_emit (GTK_OBJECT(mbd), message_box_dialog_signals[BUTTON_PRESSED],
		(gint) gtk_object_get_user_data(GTK_OBJECT(button)));
}

void message_box_dialog_show (MessageBoxDialog *dialog, GtkWindow *parent)
{
	#ifdef CODEDEBUG
	DEBUG(("dlg_messagebox.c [message_box_dialog_show]\n"), 9);
	#endif

	if (dialog->isVisible == TRUE) { return; }
	gtk_window_set_transient_for (GTK_WINDOW(dialog), GTK_WINDOW(parent));
	if (dialog->std_button) { gtk_widget_grab_default(dialog->std_button); }
	dialog->isVisible = TRUE;
	gtk_widget_show (GTK_WIDGET(dialog));

//	while (dialog->isVisible) { gtk_main_iteration(); }
}

void message_box_dialog_hide (MessageBoxDialog *dialog)
{
	#ifdef CODEDEBUG
	DEBUG(("dlg_messagebox.c [message_box_dialog_hide]\n"), 9);
	#endif

	if (dialog->isVisible == FALSE) { return; }
	dialog->isVisible = FALSE;
	gtk_widget_hide (GTK_WIDGET(dialog));
}

void message_box_dialog_set_text (MessageBoxDialog *dialog, gchar *text)
{
	#ifdef CODEDEBUG
	DEBUG(("dlg_messagebox.c [message_box_dialog_set_text]\n"), 9);
	#endif

	gtk_label_set_text(GTK_LABEL(dialog->label), text);
}