#!/usr/bin/perl
# Inserts XMMS InfoPipe information to the web page...
# Intended to be used with SSI or something. Will return a HTML fragment.
# By Weyfour WWWWolf, 2000-12-10
# $Id: xmms-info.pl,v 1.1 2002/02/07 21:13:01 wwwwolf Exp $

use strict;
use warnings;

use CGI qw(:standard);

use vars qw($tune $time);

#######################################################################

sub htmlescape {
  my $string = shift;

  $string =~ s/&/&amp;/gi;
  $string =~ s/</&lt;/gi;
  $string =~ s/>/&gt;/gi;

  return $string;
}


#######################################################################

# Read the information. If file cannot be read, we just silently quit...
open(INFO,"/tmp/xmms-info") or do {
  print header();
  exit(0);
};

while(<INFO>) {
  chomp;
  if(/^Title: (.*)$/) {
    $tune = htmlescape($1);
  }
  if(/^Position: (.*)$/) {
    $time = htmlescape($1);
  }
}


close INFO;

print header(),
  "<p>Currently XMMS is playing song: <strong>$tune</strong>,\n",
  "at position <strong>$time</strong>.</p>\n";
