/* Xmmsfind - small plugin for the X Multimedia System 
 *  Copyright (C) 2001-2002 Isak Savo <iso01001@student.mdh.se>
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef XMMSFIND_H
#define XMMSFIND_H

#define SEARCHSTR_MAX 50
#define NAME_LEN _POSIX_PATH_MAX

#define OPT_MATCH_TITLE 1
#define OPT_MATCH_FILENAME 2

/* Playlist struct from xmms */
typedef struct
{
    gchar *filename;
    gchar *title;
    gint length;
    gboolean selected;
} PlaylistEntry;

void xmmsfind_do_read_config_file (void);
gint xmmsfind_do_hide_main_window ();

/* xmmsfind callback functions */
void main_window_focus_in_event (GtkWidget *widget, GdkEvent *event);
void mwin_clist_key_pressed (GtkWidget *widget, GdkEventKey *event, gpointer data);
void mwin_clist_row_selected (GtkWidget *widget, gint row, gint column, GdkEventButton *event, gpointer data);
void mwin_btn_clicked (GtkWidget *btn, GtkCList *clist);
void mwin_txt_search_key_pressed (GtkWidget *widget, GdkEventKey *event, gpointer data);
void mwin_chk_clicked (GtkWidget *chk, gpointer data);
void xmmsfind_config (void);
void xmmsfind_do_search (void);
void xmmsfind_do_refresh_clist (GtkWidget *btn, gpointer data);
/* Some misc functions */
void xmmsfind_do_free_playlist (void);
void xmmsfind_do_fill_clist (gboolean force);
void xmmsfind_do_change_song (void);
void xmmsfind_do_enqueue_song (void);
void xmmsfind_do_enqueue_list (void);
void xmmsfind_clist_move_to_current_song (gint current_row);
void cfg_write_changes (_cfg_struct cfg);
_pl_struct *get_playlist_from_xmms ();
gchar **str2arr (gchar *srcstr, gint *elements);
int count_words (gchar *s);

/* Functions called from within xmms */
extern void playlist_ins (gchar *filename, glong pos);
extern void playlist_delete_index (glong index);
extern char * playlist_get_filename(int pos);
extern char * playlist_get_songtitle(int pos);
extern void playlist_delete_filenames(GList *filenames);
extern void playlist_queue_position (gint pos);
#endif



