#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <gtk/gtk.h>
#include <dirent.h>
#include <id3.h>
#include "globals.h"
#include "cd-discid.h"
#include "graphics.h"
#include "interface-xmms.h"

gchar *strip_spaces(gchar *string);
void netsearch(struct fileinfo *info,gchar *arts, gchar *tits);

gchar *utf8_decode(gchar *str)
	{ gchar *temp,*in,*out; unsigned int c, d;
	if (str)
	{
		temp=(gchar *) malloc(strlen(str)*2+1);
		out=temp; in=str;
		while ((c=*in++)!=0)
			{
			if (c<0x80)
				*out++=c;
			else
				{
				d=*in++;
				/* hack for displaying ' */ 
				if ((d & 0xFF)==0x92 && (c & 0xFF)==0xc2)
					*out++=0x27;
				else
					*out++=( (d & 0x3F) | ((c & 0x03) << 6) );
				}
			}
		*out=0;
		out=(gchar *) strdup(temp);
		g_free(temp); g_free(str);
		return out;
	}
	else
		return NULL;
	}

gchar *net_purge(gchar *str)
	{gchar *temp;
	if (str)
		{
		temp=strdup(str);
		free(str);
		temp=replace(temp, "#", " ");
		temp=replace(temp, "*", " ");
		temp=replace(temp, "?", " ");
		temp=replace(temp, "(", " ");
		temp=replace(temp, ")", "");
		temp=replace(temp, "\'", "\\ZOGZOG");
		temp=replace(temp, "`", "\\ZOGZOG");
		temp=replace(temp, "ZOGZOG", "\'");
		temp=replace(temp, "\"", "");
		temp=replace(temp, ":", " ");
		temp=replace(temp, "&", " ");
		temp=replace(temp, "/", " ");
		temp=replace(temp, "  ", " ");
		return temp;
		}
	else return NULL;
	}

gchar *gentitle(fileinfo *info)
	{ gchar *title;
	title=strdup(title_format);
	if (info)
		{
		if (info->title)
			title=replace(title,"%t",info->title);
		if (info->artist)
			title=replace(title,"%s",info->artist);
		if (info->album)
			title=replace(title,"%a",info->album);
		if (info->track)
			title=replace(title,"%n",info->track);
		}
	if (strstr(title,"%a") || strstr(title,"%t") || strstr(title,"%s") || strstr(title,"%n"))
		return NULL;
	else
		return title;
	}

void readfile(char *buffer, unsigned int n, FILE *file)
	{unsigned int cnt;
	for (cnt=0;cnt<n;cnt++)
		{
		buffer[cnt]=fgetc(file);
		}
	}

void showfileinfo(fileinfo *info)
	{
	if (info)
		{
		if (info->filename) {printf("-> File : %s\n",info->filename);}
		if (info->title) {printf("-> Title : %s\n",info->title);}
		if (info->artist) {printf("-> Artist : %s\n",info->artist);}
		if (info->album) {printf("-> Album : %s\n",info->album);}
		if (info->track) {printf("-> Track : %s\n",info->track);}
		if (info->year) {printf("-> Year : %s\n",info->year);}
		}
	else
		printf("No info for this file...\n");
	printf("\n");
	}

void freefileinfo(fileinfo *info)
	{
	if (info)
		{
		if (info->filename!=NULL) {free(info->filename);}
		if (info->title) {free(info->title);}
		if (info->album) {free(info->album);}
		if (info->artist) {free(info->artist);}
		if (info->track) {free(info->track);}
		if (info->year) {free(info->year);}
		free(info);
		}
	}

struct fileinfo *dupfileinfo(struct fileinfo *old)
{	struct fileinfo *info;

	info=malloc (sizeof(fileinfo));
	info->title=info->artist=info->album=info->track=info->year=info->filename=NULL;
	if (old->filename) info->filename=strdup(old->filename);
	if (old->title) info->title=strdup(old->title);
	if (old->album) info->album=strdup(old->album);
	if (old->artist) info->artist=strdup(old->artist);
	if (old->track) info->track=strdup(old->track);
	if (old->year) info->year=strdup(old->year);
		
	return info;
}
	
struct fileinfo *fromfile(gchar *filename)
{	gchar *temp,*str,*pos,*field[10];
	int nb_field=0;
	struct fileinfo *info;

	info=malloc (sizeof(fileinfo));
	info->title=info->artist=info->album=info->track=info->year=info->filename=NULL;
	info->filename=strdup(filename);
	
	str=strdup(filename);
	// First get rid of the extension
	pos=strrchr(str,'.');
	pos[0]=0;
	
	// Getting fields...
	temp=strrchr(str,'/')+1;
	while (temp)
	{
		pos=strchr(temp,'-');
		if (pos)
			pos[0]=0;
		field[nb_field++]=strdup(temp);
		if (pos)
			temp=pos+1;
		else
			temp=0;
	}
	if (nb_field==2)
	{
		field[0]=replace(field[0],"_"," ");
		field[0]=replace(field[0],"%20"," ");
		info->artist=strip_spaces(field[0]);
		field[1]=replace(field[1],"_"," ");
		field[1]=replace(field[1],"%20"," ");
		info->title=strip_spaces(field[1]);
	}
	if (nb_field==3)
	{
		field[0]=replace(field[0],"_"," ");
		field[0]=replace(field[0],"%20"," ");
		info->artist=strip_spaces(field[0]);
		field[2]=replace(field[2],"_"," ");
		field[2]=replace(field[2],"%20"," ");
		info->title=strip_spaces(field[2]);
		field[1]=replace(field[1],"_"," ");
		field[1]=replace(field[1],"%20"," ");
		info->album=strip_spaces(field[1]);
	}
	free(str);
#ifdef __HEAVYDEBUG__
	printf("--------------\n");
	printf("Info from file\n");
	showfileinfo(info);
#endif
	return info;
}
	
struct fileinfo *oggfile(gchar *filename)
	{ unsigned int i,l,l2,empty;
	char *buffer,*cmp;
	FILE *f;
	struct fileinfo *info;

	info=malloc (sizeof(fileinfo));
	info->title=info->artist=info->album=info->track=info->year=info->filename=NULL;
	f=fopen(filename,"r");
	
	empty=1;
	if (f)
		{
		buffer=malloc(1000);
		fseek(f,0,0);
		i=0;
		while ((buffer[0]!=3) || (strcmp(&buffer[1],"vorbis")!=0))
			{
			i++;
			readfile(buffer,1,f);
			if (buffer[0]==3)
				{
				readfile(&buffer[1],6,f);
				buffer[7]=0;
				if (strcmp(&buffer[1],"vorbis")!=0)
					{
					fseek(f,i,0);
					buffer[1]=0;
					}
				else
					{
					break;
					}
				}
			if (i==1000) { free(info); free(buffer); fclose(f); return NULL;}
			}
		// Vendor Chain size
		readfile(buffer,4,f);
		l= (buffer[0] & 0xff)+
				256*((buffer[1] & 0xff)+
				256*((buffer[2] & 0xff)+
				256*((buffer[3] & 0xff))));
		// Vendor
		if (l>1000)
			{free(buffer); buffer=malloc(l);}
		readfile(buffer,l,f);
		
		readfile(buffer,4,f);
		l= (buffer[0] & 0xff)+
				256*((buffer[1] & 0xff)+
				256*((buffer[2] & 0xff)+
				256*((buffer[3] & 0xff))));
		
		for (i=0;i<l;i++)
			{
			readfile(buffer,4,f);
			l2= (buffer[0] & 0xff)+
				256*((buffer[1] & 0xff)+
				256*((buffer[2] & 0xff)+
				256*((buffer[3] & 0xff))));
			if (l2>1000)
				{free(buffer); buffer=malloc(l2);}
			readfile(buffer,l2,f);
			buffer[l2]=0;
			cmp=up(buffer);
			if (strstr(cmp,"TITLE=") !=NULL)
       				{
				info->title=strdup(buffer+6);
				info->title=utf8_decode(info->title);
				empty=0;
       				}
       			if (strstr(cmp,"ARTIST=") !=NULL)
       				{
				info->artist=strdup(buffer+7);
				info->artist=utf8_decode(info->artist);
				empty=0;
       				}
       			if (strstr(cmp,"ALBUM=") !=NULL)
       				{
				info->album=strdup(buffer+6);
				info->album=utf8_decode(info->album);
				empty=0;
       				}
       			if (strstr(cmp,"TRACKNUMBER=")!=NULL)
       				{
				info->track=strdup(buffer+12);
				empty=0;
       				}
       			if (strstr(cmp,"DATE=") !=NULL)
       				{
				info->year=strdup(buffer+5);
				empty=0;
				}
			free(cmp);
			}
		free(buffer);
		fclose(f);
		}
	if (empty)
		{
		freefileinfo(info);
		info=fromfile(filename);
		return info;
		}
		else
		{ 
		info->filename=strdup(filename);
#ifdef __HEAVYDEBUG__
	printf("--------------\n");
		printf("Info from ogg\n");
		showfileinfo(info);
#endif
		return info;
		}
	}

gchar *strip_spaces(gchar *string)
	{ gchar *tmp,*pos,*pos2;
	if (!string)
		return NULL;
	tmp=(gchar *) strdup(string);
	pos=tmp+strlen(string)-1;
	/*end_spaces*/
	while(pos>=tmp && (pos[0]==32 || pos[0]==13 || pos[0]==10))
		{
		pos[0]=0;
		pos--;
		}
	/*start_spaces*/
	pos2=tmp;
	while(pos2[0]==32)
		pos2++;
	pos2=(gchar *) strdup(pos2);
	if (pos!=tmp-1)
		{free(tmp);
		return pos2;}
	free(tmp);
	return NULL;
	}
		
gchar *get_field(ID3Tag *tag, ID3_FieldID FIELD_ID)
{
	ID3Frame *frame;
	ID3Field *field;
	gchar *string,*result;
		
	string=malloc(4097);		
	if ( (frame=ID3Tag_FindFrameWithID(tag, FIELD_ID)) )
	{
		if ( (field = ID3Frame_GetField(frame,ID3FN_TEXT)) )
		{
			ID3Field_GetASCII(field, string ,4096);
			result=strdup(string);
			free(string);
			return result;
		}
	}
	return NULL;
}	

void *save_image(ID3Tag *tag, gchar *filename)
{
	ID3Frame *frame;
	ID3Field *field;
	if ( (frame=ID3Tag_FindFrameWithID(tag,  ID3FID_PICTURE)) )
		if ( (field = ID3Frame_GetField(frame,ID3FN_DATA)) )
			ID3Field_ToFile(field,filename);
	return NULL;
}
	
struct fileinfo *mp3file(gchar *filename)
	{
	struct fileinfo *info;
	int empty,nb_image;
	gchar *image_file_name;
	ID3Tag *tag;

	info=malloc (sizeof(fileinfo));
	info->title=info->artist=info->album=info->track=info->year=info->filename=NULL;
	empty=1;
	nb_image=0;
	
	tag=ID3Tag_New();
	ID3Tag_Link(tag,filename);

	if ( (info->title=get_field(tag, ID3FID_TITLE)) )		// Title
		empty=0;
	if ( (info->artist=get_field(tag, ID3FID_LEADARTIST)) )		// Artist
		empty=0;
	if ( (info->album=get_field(tag, ID3FID_ALBUM)) )		// Album
		empty=0;
	if ( (info->track=get_field(tag, ID3FID_TRACKNUM)) )		// Track
		empty=0;
	if ( (info->year=get_field(tag, ID3FID_YEAR)) )			// Year
		empty=0;
	
	// Look for a picture inside the tags
	image_file_name=malloc(strlen(tempdir)+9);
	sprintf(image_file_name,"%s/cover%03u.img",tempdir,nb_image++);
	save_image(tag,image_file_name);
	free(image_file_name);
	
	if (!(info->artist && info->title)) empty=1;
	if (empty)
		{
		freefileinfo(info);
		info=fromfile(filename);
		return info;
		}
		else
		{
		info->filename=strdup(filename);
#ifdef __HEAVYDEBUG__
	printf("-------------\n");
	printf("Info from MP3\n");
	showfileinfo(info);
#endif
		return info;
		}
	}

struct fileinfo *cdinfo(gchar *filename)
	{ char *cdid,*buffer;
	FILE *f;
	struct fileinfo *info;
	char *cddbfile;
	gchar *track,*pos;	
	
	cddbfile=malloc(1000);
	buffer=malloc(1000);
	info=malloc (sizeof(fileinfo));
	info->title=info->artist=info->album=info->track=info->year=info->filename=NULL;
	info->filename=strdup(filename);
	cdid=get_cdid(cdaudio_player);

	sprintf(cddbfile,"%s/.xmms/cdinfo",g_get_home_dir());
	f=fopen(cddbfile,"r");
	if (f)
	{
	while (feof(f)==0)
		{
 		fgets(buffer,1000,f);
		if (strstr(buffer,cdid)!=NULL)
			break;
		}
	if (!feof(f))
		{
 		fgets(buffer,1000,f);
		info->album=strip_spaces(buffer+10);
 		fgets(buffer,1000,f);
		info->artist=strip_spaces(buffer+11);
		
		pos=strrchr(filename,'/')+1;
		track=strdup(pos);
		track=replace(track,"Track ","track_title");
		track=replace(track,".cda","=");
		track=replace(track,".CDA","=");
		track=replace(track,"e01=","e1=");
		track=replace(track,"e02=","e2=");
		track=replace(track,"e03=","e3=");
		track=replace(track,"e04=","e4=");
		track=replace(track,"e05=","e5=");
		track=replace(track,"e06=","e6=");
		track=replace(track,"e07=","e7=");
		track=replace(track,"e08=","e8=");
		track=replace(track,"e09=","e9=");
		
		while (!feof(f))
			{
	 		fgets(buffer,1000,f);
			if (strstr(buffer,track))
				{
				pos=strdup(buffer);
				info->title=strip_spaces(replace(pos,track," "));
				free(track);
				pos=strrchr(filename,'/')+1;
				track=strdup(pos);
				track=replace(track,"Track "," ");
				track=replace(track,".cda"," ");
				track=replace(track,".CDA"," ");
				info->track=strip_spaces(track);
				break;
				}
			}
		free(track);
		}
	fclose(f); 
	}
	free(cddbfile);
	free(buffer);
	free(cdid);
#ifdef __HEAVYDEBUG__
	printf("---------------------\n");
	printf("Info from cd-database\n");
	showfileinfo(info);
#endif
	return info;
	}
	
gchar *cur_stream=NULL;

struct fileinfo *streaminfo(gchar *filename)
	{struct fileinfo *info;
	gchar *streamtitle,*pos;
	
	if (!(cur_stream)) cur_stream=strdup("START");
	info=malloc(sizeof(fileinfo));
	info->title=info->artist=info->album=info->track=info->year=info->filename=NULL;
	info->filename=strdup(filename);

	streamtitle=coview_title(coview_playlist_pos());
	if (strcmp(streamtitle,cur_stream)!=0)
		{
		freefileinfo(curfile);
		free(cur_stream);
		cur_stream=strdup(streamtitle);
		// Purge the radio name ()
		pos=strrchr(streamtitle,'(');
		if (pos>streamtitle+1)
			{
			pos[0]=0;
			streamtitle=strip_spaces(streamtitle);
			pos=strrchr(streamtitle,'-');
			if (pos)
				{
				pos[-1]=0;
				info->artist=strdup(streamtitle);
				info->artist=strip_spaces(info->artist);
				info->title=strdup(pos+1);
				info->title=strip_spaces(info->title);
				info->track=strdup("is streamed");
				}
			}
#ifdef __HEAVYDEBUG__
	printf("----------------\n");
	printf("Info from stream\n");
	showfileinfo(info);
#endif
		return info;
		}
	else
		{
		free(streamtitle);
		freefileinfo(info);
		return curfile;
		}
	}

gboolean search_album=FALSE;
	
gint find_cover(gchar *filedir, struct fileinfo *info, struct image_name_buffer **first_image)
	{  struct image_name_buffer *imbuff,*imbuff2;
	int found=0;
	gchar *text,*strtemp,*title,*artist,*temp1,*temp2,*result_lock;
	DIR *dir;
	FILE *f;
	struct dirent *files;

	// Smart search... Let's guess album name...
	if (!(info->album) && info->title && info->artist && smart_search)
	{
		title=strdup(info->title);
		title=net_purge(title);
		artist=strdup(info->artist);
		artist=net_purge(artist);
		strtemp=strdup(title);
		strtemp=replace(strtemp,"\\\'","\'");
		temp1= g_strdup_printf("%s/.albums/%s - %s.alb", image_dir,artist,title);
		temp1=replace(temp1,"\\\'","\'");
		f=fopen(temp1,"r");
		free(temp1);
		if (f)
		{
			album_search=FALSE;
			title=replace(title,"\\\'","\'");
			artist=replace(artist,"\\\'","\'");
			strtemp = g_strdup_printf("rm \"%s/.albums/%s - %s.lock\" 2>/dev/null", image_dir,artist,title);
			system(strtemp);
			free(strtemp);
			strtemp=malloc(1000);
			fgets(strtemp,1000,f);
			info->album=utf8_decode(strdup(strtemp));
#ifdef __DEBUG__
				printf("Album name found : %s\n",strtemp);
#endif
			free(strtemp);
			fclose(f);
		}
		else
		{
			temp1=g_strdup_printf("%s/.albums", image_dir);
			if (!(exists_file(temp1,up(strtemp),".LOCK")))
			{	// Search album name (smartsearch)
			album_search=TRUE;
			free(strtemp);
			strtemp = g_strdup_printf("%s %s.albums/ %s __00__ %s&", script_album, image_dir, artist,title);
			system(strtemp);
			g_free(strtemp);
			title=replace(title,"\\\'","\'");
			artist=replace(artist,"\\\'","\'");
			strtemp = g_strdup_printf("touch \"%s/.albums/%s - %s.lock\"", image_dir,artist,title);
			system(strtemp);
			free(strtemp);
			}
			free(title); free(artist);
			free(temp1);
			return 0;
		}
		free(title); free(artist);
	}

	//text=strdup(info->filename);
	imbuff=*first_image;
	imbuff2=*first_image;
	while(imbuff)
		{
		imbuff2=imbuff->next;
		free(imbuff->imagename);
		free(imbuff);
		imbuff=imbuff2;
		}
	(*first_image)=malloc(sizeof(image_name_buffer));
	(*first_image)->imagename=NULL;
	(*first_image)->next=NULL;
	imbuff=(*first_image);

	if (!net_search && !album_search )
	{
	// Looking for any (tag)image in temporary directory
	dir = opendir (tempdir);
	if (dir != NULL)
		{
            while ((files=readdir(dir))!=NULL)
			{
			strtemp=up(files->d_name);
			if (strstr(strtemp,".IMG") !=NULL )
				{
				text=(char *) malloc (strlen(tempdir)+strlen(files->d_name)+2);
				strcpy(text,tempdir);
				strcat(text,"/");
				strcat(text,files->d_name);
				imbuff->next=malloc(sizeof(image_name_buffer));
				imbuff=imbuff->next;
				imbuff->imagename=text;
				imbuff->next=NULL;
				found++;
				}
			free(strtemp);
			}
                closedir(dir);
		}
	//if (found) { return found; }

	// Looking for any image in file directory
	dir = opendir (filedir);
	if (dir != NULL)
		{
            while ((files=readdir(dir))!=NULL)
			{
			strtemp=up(files->d_name);
			if (strstr(strtemp,".JPG") !=NULL || strstr(strtemp,".GIF") !=NULL || strstr(strtemp,".PNG") !=NULL)
				{
				text=(char *) malloc (strlen(filedir)+strlen(files->d_name)+1);
				strcpy(text,filedir);
				strcat(text,files->d_name);
				imbuff->next=malloc(sizeof(image_name_buffer));
				imbuff=imbuff->next;
				imbuff->imagename=text;
				imbuff->next=NULL;
				found++;
				from_dir=0;	
				}
			free(strtemp);
			}
            closedir(dir);
		}
	}
	//if (found) { from_dir=0; return found; }
	
	// Looking for images in image directory
	if (strcmp(image_dir,"")==0) return found;
	if (info->album && strstr(info->album,"(null)")==NULL)
		{
		album_search=FALSE;
		title=up(info->album);
		title=net_purge(title);
		title=replace(title,"\\\'","\'");
		artist=up(info->artist);
		artist=net_purge(artist);
		artist=replace(artist,"\\\'","\'");
			temp1=malloc(strlen(title)+strlen(artist)+4);
			strcpy(temp1,artist);
			temp2=malloc(strlen(title)+strlen(artist)+2);
			strcpy(temp2,artist);
			strcat(temp1," - ");
			strcat(temp1,title);
			strcat(temp2," ");
			strcat(temp2,title);
			dir = opendir (image_dir);
			if (dir != NULL)
			{	
				if (exists_file(image_dir,temp1,".LOCK"))
					net_search=TRUE;
				if (!lock_file)
				{
					result_lock=exists_file(image_dir,temp2,".RESULT");
					if (!result_lock)
						result_lock=exists_file(image_dir,temp1,".RESULT");
					if (result_lock)
					{
						free(title); free(artist);
						title=strdup(info->album);
						title=net_purge(title);
						title=replace(title,"\\\'","\'");
						artist=strdup(info->artist);
						artist=net_purge(artist);
						artist=replace(artist,"\\\'","\'");
						lock_file=TRUE;
						strtemp = g_strdup_printf("rm \"%s%s - %s.lock\" 2>/dev/null", image_dir,artist,title);
						system(strtemp);
						free(strtemp);
					}
				}
				if (!net_search || lock_file)
				{
	               	while ((files=readdir(dir))!=NULL)
					{
					strtemp=up(files->d_name);
					if (strstr(strtemp,".JPG") !=NULL || strstr(strtemp,".JPEG") !=NULL || strstr(strtemp,".GIF") !=NULL || strstr(strtemp,".PNG") !=NULL)
					{
						if (strstr(strtemp,temp1)!=NULL || strstr(strtemp,temp2)!=NULL)
						{
						text=(char *) malloc (strlen(image_dir)+strlen(files->d_name)+1);
						strcpy(text,image_dir);
						strcat(text,files->d_name);
						imbuff->next=malloc(sizeof(image_name_buffer));
						imbuff=imbuff->next;
						imbuff->imagename=text;
						imbuff->next=NULL;
						found++;
						}
					}
					free(strtemp);
					}
				// Keep lock file if no result found...
				if (found && lock_file)
				{
					strtemp=exists_file(image_dir,temp1,".RESULT");
					if (!strtemp)
						strtemp=exists_file(image_dir,temp2,".RESULT");
					strtemp = g_strdup_printf("rm \"%s\"", strtemp);
					system(strtemp);	
					free(strtemp);
				}	
				}
            closedir(dir);
			}
			free(temp1); free(temp2);
			free(title); free(artist);
		}
		if (found) return found;
			
		// Internet cover search
		if (info->album && info->artist)
		{
			if (internet_search && !net_search && !lock_file)
				netsearch(info,NULL,NULL);
		}

	return 0;
	}

void netsearch(struct fileinfo *info,gchar *arts, gchar *tits)
	{gchar *title,*artist,*strtemp;

	title=strdup(info->album);
	title=net_purge(title);
	artist=strdup(info->artist);
	artist=net_purge(artist);
	net_search=TRUE;
	lock_file=FALSE;
#ifdef __DEBUG__
	printf("Launching cover search...\n");
#endif
	if ((arts==NULL) | (tits==NULL)) 
		strtemp = g_strdup_printf("%s %s %s %s %s __00__ %s&", script_net, get_all, search_order, image_dir, artist,title);
	else
		strtemp = g_strdup_printf("%s %s %s %s %s __00__ %s  __00__ %s - %s&", script_net, get_all, search_order, image_dir,arts,tits, artist,title);
	system(strtemp);
	free(strtemp);	
	title=replace(title,"\\\'","\'");
	artist=replace(artist,"\\\'","\'");
	strtemp = g_strdup_printf("rm \"%s%s - %s.result\" 2>/dev/null", image_dir,artist,title);
	system(strtemp);
	free(strtemp);

	strtemp = g_strdup_printf("touch \"%s%s - %s.lock\"", image_dir,artist,title);
	system(strtemp);
	free(strtemp);

	free(title); free(artist);
	}
	
GtkWidget *artist_entry, *album_entry;
struct fileinfo *tempinfo;
	
void launch_ns(GtkWidget *widget)
	{gchar *album,*artist;

	artist=gtk_entry_get_text((GtkEntry *)artist_entry);
	album=gtk_entry_get_text((GtkEntry *)album_entry);
	artist=net_purge(artist);
	album=net_purge(album);

	netsearch(tempinfo,artist,album);
	gtk_widget_hide(widget);
	free(album);free(artist);
	}
	
void cancel_ns(GtkWidget *widget)
	{
	gtk_widget_destroy(widget);
	}
	
void advnetsearch(struct fileinfo *info)
	{gchar *album,*artist;
	GtkWidget *dialog, *label,*button;
  	
	//if (!net_search)
	{
	if (info)
		{
		if (info->album && info->artist)
		{
		tempinfo=info;
		album=strdup(info->album);
		artist=strdup(info->artist);

		dialog = gtk_dialog_new();

		label=gtk_label_new((gchar*)"Artist : ");
		artist_entry=gtk_entry_new();
		gtk_entry_set_text((GtkEntry *)artist_entry,(gchar *) artist);
		gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dialog)->vbox),label);
		gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dialog)->vbox),artist_entry);

		label=gtk_label_new((gchar*)"Album : ");
		album_entry=gtk_entry_new();
		gtk_entry_set_text((GtkEntry *)album_entry,(gchar *) album);
		gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dialog)->vbox),label);
		gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dialog)->vbox),album_entry);
		
		button = gtk_button_new_with_label("Search");
		gtk_signal_connect_object (GTK_OBJECT (button), "clicked",	GTK_SIGNAL_FUNC (launch_ns), (GtkObject *) dialog);
		gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dialog)->action_area),button);
		button = gtk_button_new_with_label("Cancel");
		gtk_signal_connect_object (GTK_OBJECT (button),"clicked",GTK_SIGNAL_FUNC (cancel_ns),(GtkObject *)dialog);	
		gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dialog)->action_area),button);

		gtk_widget_show_all (dialog);
		gtk_window_set_title((GtkWindow *) dialog,(gchar *)"Advanced Internet Search");
		//gtk_window_set_policy(GTK_WINDOW(dialog), FALSE, FALSE, FALSE);
		free(album);
		free(artist);
		}
		}
	}
	}
	
void get_file_info(char *filename)
	{char *strtemp;
	
	strtemp=up(filename);
		
	if (strstr(strtemp,"HTTP://") !=NULL) // Shoutcast stream
		{
		stream_play=TRUE;
		curfile=streaminfo(filename);
		free(strtemp);
		return;}
		
	stream_play=FALSE;
	freefileinfo(curfile);
		
	if (strstr(strtemp,".OGG") !=NULL)	// OGG Files
		{curfile=oggfile(filename);
		stream_play=FALSE;
		free(strtemp);
		return;}
		
	if ((strstr(strtemp,".MP3") !=NULL)
			 || (strstr(strtemp,".FLAC") !=NULL)
	    	 || (strstr(strtemp,".FLC") !=NULL)
	     	 || (strstr(strtemp,".MPC") !=NULL))	// ID3 Tags (MP3/FLAC)
		{curfile=mp3file(filename);
		stream_play=FALSE;
		free(strtemp);
		return;}

	if (strstr(strtemp,".CDA") !=NULL || strstr(strtemp,"/DEV/")!=NULL)	// Audio cds
		{
		stream_play=FALSE;
		curfile=cdinfo(filename);
		free(strtemp);
		return;}

	// unknown...
	curfile=malloc(sizeof(fileinfo));
	curfile->filename=strdup(filename);
	curfile->title=curfile->artist=curfile->album=curfile->track=curfile->year=NULL;
	return;
	}
