#ifndef BUMP_SCOPE_H
#define BUMP_SCOPE_H

#include <config.h>

/*#define DBRK() { fprintf(stderr, __FILE__": DBRK() at %d\n", __LINE__); }*/
#define DBRK()

#define MAX_WIDTH 640
#define MAX_HEIGHT 480
#define MAX_PHONGRES 1024 /* Be careful with this, square to get bytes consumed. */

#define WIDTH (bumpscope_cfg.width)
#define HEIGHT (bumpscope_cfg.height)
#define PHONGRAD (bumpscope_cfg.phongrad)
#define PHONGRES (bumpscope_cfg.phongrad*2)

extern void bumpscope_configure(void);
extern void bumpscope_read_config(void);
extern void bumpscope_write_cfg(void);

typedef struct {
        guint color;
	guint x, y, width, height;
	guint phongrad;
	gboolean color_cycle;
	gboolean moving_light;
	gboolean diamond;
	gboolean auto_fullscreen;
} BumpScopeConfig;

extern BumpScopeConfig bumpscope_cfg;
extern GtkWidget *bumpscope_window;
extern gint bumpscope_win_w, bumpscope_win_h;

extern void bumpscope_generate_cmap(guint32 color);
void bumpscope_generate_phongdat();
extern void bumpscope_draw_xmms_logo();

#include <pthread.h>

extern pthread_mutex_t bumpscope_res_lock;
extern gboolean bumpscope_have_mutex;

#define BUMP_LOCK() \
	{ if (bumpscope_have_mutex) pthread_mutex_lock(&bumpscope_res_lock); }
#define BUMP_UNLOCK() \
	{ if (bumpscope_have_mutex) pthread_mutex_unlock(&bumpscope_res_lock); }

#endif
