#! /usr/bin/env ruby

#
# Testcase for Parser
# 
# Copyright (C) 2001 by Michael Neumann (neumann@s-direktnet.de)
#
# $Id: test_parser.rb,v 1.8 2001/11/02 11:03:16 michael Exp $
#

require "runit/testcase"
require "xmlrpc/parser"

class Test_Parser < RUNIT::TestCase

  def setup
    @xml1 = File.readlines("files/xml1.xml").to_s
    @expected1 = File.readlines("files/xml1.expected").to_s.chomp

    @xml2 = File.readlines("files/value.xml").to_s
    @expected2 = File.readlines("files/value.expected").to_s.chomp

    @xml3 = File.readlines("files/bug_covert.xml").to_s
    @expected3 = File.readlines("files/bug_covert.expected").to_s.chomp

    @xml4 = File.readlines("files/bug_bool.xml").to_s
    @expected4 = File.readlines("files/bug_bool.expected").to_s.chomp
  end

  def test1_XMLTreeParser
    p = XMLRPC::XMLParser::XMLTreeParser.new
    assert_equal(@expected1, p.parseMethodResponse(@xml1).inspect)
  end

  def test1_XMLStreamParser
    p = XMLRPC::XMLParser::XMLStreamParser.new
    assert_equal(@expected1, p.parseMethodResponse(@xml1).inspect)
  end

  def test1_NQXMLTreeParser
    p = XMLRPC::XMLParser::NQXMLTreeParser.new
    assert_equal(@expected1, p.parseMethodResponse(@xml1).inspect)
  end

  def test1_NQXMLStreamParser
    p = XMLRPC::XMLParser::NQXMLStreamParser.new
    assert_equal(@expected1, p.parseMethodResponse(@xml1).inspect)
  end


  # ----------------------------------------------------------

  def test2_XMLTreeParser
    p = XMLRPC::XMLParser::XMLTreeParser.new
    assert_equal(@expected2, p.parseMethodCall(@xml2).inspect)
  end

  def test2_XMLStreamParser
    p = XMLRPC::XMLParser::XMLStreamParser.new
    assert_equal(@expected2, p.parseMethodCall(@xml2).inspect)
  end

  def test2_NQXMLTreeParser
    p = XMLRPC::XMLParser::NQXMLTreeParser.new
    assert_equal(@expected2, p.parseMethodCall(@xml2).inspect)
  end

  def test2_NQXMLStreamParser
    p = XMLRPC::XMLParser::NQXMLStreamParser.new
    assert_equal(@expected2, p.parseMethodCall(@xml2).inspect)
  end

  # ----------------------------------------------------------
  # bug (in XMLStreamParser) found by covert, thaddeus on 31.10.2001

  def test3_XMLTreeParser
    p = XMLRPC::XMLParser::XMLTreeParser.new
    assert_equal(@expected3, p.parseMethodResponse(@xml3).inspect)
  end

  def test3_XMLStreamParser
    p = XMLRPC::XMLParser::XMLStreamParser.new
    assert_equal(@expected3, p.parseMethodResponse(@xml3).inspect)
  end

  def test3_NQXMLTreeParser
    p = XMLRPC::XMLParser::NQXMLTreeParser.new
    assert_equal(@expected3, p.parseMethodResponse(@xml3).inspect)
  end

  def test3_NQXMLStreamParser
    p = XMLRPC::XMLParser::NQXMLStreamParser.new
    assert_equal(@expected3, p.parseMethodResponse(@xml3).inspect)
  end
  
  # ----------------------------------------------------------
  # bug (in StreamParserMixin) found by covert, thaddeus on 02.11.2001

  def test4_XMLTreeParser
    p = XMLRPC::XMLParser::XMLTreeParser.new
    assert_equal(@expected4, p.parseMethodResponse(@xml4).inspect)
  end

  def test4_XMLStreamParser
    p = XMLRPC::XMLParser::XMLStreamParser.new
    assert_equal(@expected4, p.parseMethodResponse(@xml4).inspect)
  end

  def test4_NQXMLTreeParser
    p = XMLRPC::XMLParser::NQXMLTreeParser.new
    assert_equal(@expected4, p.parseMethodResponse(@xml4).inspect)
  end

  def test4_NQXMLStreamParser
    p = XMLRPC::XMLParser::NQXMLStreamParser.new
    assert_equal(@expected4, p.parseMethodResponse(@xml4).inspect)
  end

  # ----------------------------------------------------------


   def test_fault
     doc = File.readlines("files/fault.xml").to_s

     for parser in %w(XMLTreeParser XMLStreamParser NQXMLTreeParser NQXMLStreamParser)
       flag, fault = eval("XMLRPC::XMLParser::#{parser}.new").parseMethodResponse(doc)

       assert_equal(flag, false)
       unless fault.is_a? XMLRPC::FaultException
         assert(false, "must be an instance of class XMLRPC::FaultException")
       end
       assert_equal(fault.faultCode, 4)
       assert_equal(fault.faultString, "an error message")
    end
  end
 
end

