/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * filename: xmnuftry.c                                                    *
 *                                                                         *
 * UTIL C-source: Medical Image Conversion Utility                         *
 *                                                                         *
 * purpose      : menu creation factory                                    *
 *                                                                         *
 * project      : (X)MedCon by Erik Nolf                                   *
 *                                                                         *
 * Note         : basic code extracted from Gtk+ tutorial                  *
 *                                                                         *
 * Functions    : XMdcMenusGetMain()      - Get main menu                  *
 *                                                                         *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* $Id: xmnuftry.c,v 1.30 2006/03/01 23:21:59 enlf Exp $
 */

/*
   Copyright (C) 1997-2006 by Erik Nolf

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any later
   version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
   Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   59 Place - Suite 330, Boston, MA 02111-1307, USA.  */

/****************************************************************************
                              H E A D E R S
****************************************************************************/

#include <stdio.h>

#include "xmedcon.h"

/****************************************************************************
                              D E F I N E S 
****************************************************************************/

static GtkItemFactoryEntry menu_items[] = {
  {(char *)"/_File", NULL, (void(*)())NULL, 0, (char *)"<Branch>"},
  {(char *)"/File/Open", (char *)"<control>O", XMdcFileSelOpen, 0, NULL},
  {(char *)"/File/Open Raw", NULL, (void(*)())NULL, 0, (char *)"<Branch>" },
  {(char *)"/File/Open Raw/Interactive", NULL, XMdcFileSelOpen, XMDC_RAW, NULL},
  {(char *)"/File/Open Raw/Predefined", NULL, XMdcFileSelOpen,XMDC_PREDEF,NULL},
  {(char *)"/File/SepA", NULL, (void(*)())NULL, 0, (char *)"<Separator>" },
  {(char *)"/File/Raw Predef Load", NULL, XMdcRawPredefSelOpen, 0, NULL },
  {(char *)"/File/Raw Predef Save", (char *)"<control>I"
                                       , XMdcRawPredefSelSave, 0, NULL },
  {(char *)"/File/SepB", NULL, (void(*)())NULL, 0, (char *)"<Separator>" },
  {(char *)"/File/Info Show", (char *)"<control>I", XMdcShowFileInfo, 0, NULL},
  {(char *)"/File/Info Edit", (char *)"<control>F", XMdcEditFileInfo, 0, NULL},
  {(char *)"/File/SepC", NULL, (void(*)())NULL, 0, (char *)"<Separator>" },
  {(char *)"/File/Save", (char *)"<control>S", XMdcFileSelSave
                                                          ,MDC_MAX_FRMTS,NULL},
  {(char *)"/File/Save _As", NULL, (void(*)())NULL, 0, (char *)"<Branch>" },
  {(char *)"/File/Save As/Raw Binary", NULL,XMdcFileSelSave,MDC_FRMT_RAW,NULL},
  {(char *)"/File/Save As/Raw Ascii", NULL,XMdcFileSelSave,MDC_FRMT_ASCII,NULL},
#if MDC_INCLUDE_ACR
  {(char *)"/File/Save As/AcrNema",   NULL,XMdcFileSelSave,MDC_FRMT_ACR,NULL},
#endif
#if MDC_INCLUDE_ANLZ
  {(char *)"/File/Save As/Analyze",   NULL,XMdcFileSelSave,MDC_FRMT_ANLZ,NULL},
#endif
#if MDC_INCLUDE_CONC
  {(char *)"/File/Save As/Concorde",  NULL,XMdcFileSelSave,MDC_FRMT_CONC,NULL},
#endif
#if MDC_INCLUDE_DICM
  {(char *)"/File/Save As/DICOM",     NULL,XMdcFileSelSave,MDC_FRMT_DICM,NULL},
#endif
#if MDC_INCLUDE_ECAT
  {(char *)"/File/Save As/Ecat6",     NULL,XMdcFileSelSave,MDC_FRMT_ECAT6,NULL},
#endif
#if MDC_INCLUDE_GIF
  {(char *)"/File/Save As/Gif89a",    NULL,XMdcFileSelSave,MDC_FRMT_GIF,NULL},
#endif
#if MDC_INCLUDE_INTF
  {(char *)"/File/Save As/InterFile", NULL,XMdcFileSelSave,MDC_FRMT_INTF,NULL},
#endif
#if MDC_INCLUDE_INW
  {(char *)"/File/Save As/INW (RUG)", NULL,XMdcFileSelSave,MDC_FRMT_INW,NULL},
#endif
#if MDC_INCLUDE_NIFTI
  {(char *)"/File/Save As/NIFTI",     NULL,XMdcFileSelSave,MDC_FRMT_NIFTI,NULL},
#endif
#if MDC_INCLUDE_PNG
  {(char *)"/File/Save As/PNG",       NULL,XMdcFileSelSave,MDC_FRMT_PNG,NULL},
#endif
  {(char *)"/File/SepD", NULL, (void(*)())NULL, 0, (char *)"<Separator>" },
  {(char *)"/File/Close", NULL, XMdcCloseFile, 0, NULL},
  {(char *)"/File/Quit", (char *)"<control>Q", XMdcMedconQuit, 0, NULL},
  {(char *)"/_Images", NULL, (void(*)())NULL, 0, (char *)"<Branch>" },
  {(char *)"/Images/View", (char *)"<control>V", XMdcImagesView, 0, NULL},
  {(char *)"/Images/Extract", (char *)"<control>E",XMdcExtractStyleSel, 0,NULL},
  {(char *)"/Images/Reslice", NULL, (void(*)())NULL, 0, (char *)"<Branch>" },
  {(char *)"/Images/Reslice/XY-Transaxial",NULL,XMdcResliceImages
                                              ,MDC_TRANSAXIAL,NULL},
  {(char *)"/Images/Reslice/XZ-Coronal",   NULL,XMdcResliceImages
                                              ,MDC_CORONAL, NULL},
  {(char *)"/Images/Reslice/YZ-Sagittal",  NULL,XMdcResliceImages
                                              ,MDC_SAGITTAL, NULL},
  {(char *)"/Images/Flip", NULL, (void(*)())NULL, 0, (char *)"<Branch>" },
  {(char *)"/Images/Flip/Horizontal",NULL,XMdcTransformImages
                                        ,MDC_TRANSF_HORIZONTAL,NULL},
  {(char *)"/Images/Flip/Vertical ",NULL ,XMdcTransformImages
                                        ,MDC_TRANSF_VERTICAL,NULL},
  {(char *)"/Images/Sort", NULL, (void(*)())NULL, 0, (char *)"<Branch>" },
  {(char *)"/Images/Sort/Reverse",NULL,XMdcTransformImages
                                     ,MDC_TRANSF_REVERSE,NULL},
  {(char *)"/Images/Sort/Cine", NULL, (void(*)())NULL, 0, (char *)"<Branch>" },
  {(char *)"/Images/Sort/Cine/Apply",NULL,XMdcTransformImages
                                        ,MDC_TRANSF_CINE_APPLY,NULL},
  {(char *)"/Images/Sort/Cine/Undo",NULL ,XMdcTransformImages
                                        ,MDC_TRANSF_CINE_UNDO,NULL},
  {(char *)"/Images/Matrix",NULL, (void(*)())NULL, 0, (char *)"<Branch>" },
  {(char *)"/Images/Matrix/Square",NULL,XMdcTransformImages
                                      ,MDC_TRANSF_SQR1,NULL},
  {(char *)"/Images/Matrix/Square Pwr2",NULL,XMdcTransformImages
                                           ,MDC_TRANSF_SQR2,NULL},
  {(char *)"/_Options", NULL,  (void(*)())NULL, 0, (char *)"<Branch>"},
  {(char *)"/Options/MedCon", "<control>M", XMdcOptionsMedconSel, 0, NULL},
  {(char *)"/Options/SepE", NULL, (void(*)())NULL, 0, (char *)"<Separator>" },
  {(char *)"/Options/Render", (char *)"<control>R",XMdcOptionsRenderSel,0,NULL},
  {(char *)"/Options/Labels", (char *)"<control>L", XMdcOptionsLabelSel,0,NULL},
  {(char *)"/Options/Pages", (char *)"<control>P", XMdcOptionsPagesSel,0,NULL},
  {(char *)"/Options/Resize", (char *)"<control>Z",XMdcOptionsResizeSel,0,NULL},
  {(char *)"/Options/Colormap", NULL, (void(*)())NULL, 0, (char *)"<Branch>"},
  {(char *)"/Options/Colormap/Colors", (char *)"<control>C"
                                    , XMdcOptionsColorMapSel, 0, NULL},
  {(char *)"/Options/Colormap/Place", NULL, XMdcOptionsMapPlaceSel, 0, NULL},
  {(char *)"/_Help", NULL, (void(*)())NULL, 0, (char *)"<Branch>"},
  {(char *)"/Help/Online Info", NULL, XMdcHelp, 0, NULL},
  {(char *)"/Help/Console Logs", NULL, XMdcShowLogConsole, 0, NULL},
  {(char *)"/Help/About", NULL, XMdcAbout, 0, NULL}
};

/****************************************************************************
                            F U N C T I O N S
****************************************************************************/

void XMdcMenusGetMain(GtkWidget *window, GtkWidget **menubar)
{
    guint nmenu_items = sizeof(menu_items) / sizeof(menu_items[0]);
    GtkItemFactory *factory;
    GtkAccelGroup *accel_group;

    accel_group = gtk_accel_group_new();

    factory = gtk_item_factory_new(GTK_TYPE_MENU_BAR, "<main>", accel_group);

    gtk_item_factory_create_items(factory, nmenu_items, menu_items, NULL);

    gtk_accel_group_attach(accel_group, GTK_OBJECT(window));

    if (menubar)
      *menubar = gtk_item_factory_get_widget(factory, "<main>");

}

