package xm::pfe::cutfcodedocs;
use strict;
use xm::o;

sub DESC
{"
  will look for a FCODE docs and cut them out for printing.
"}

sub ARGS { return xm::o::args_stdin(@_,DESC); }


sub format 
{
    my $in = shift;
    my $out;

    split /^/, $in;

    my $state = 0;

    for (@_)
    {
	if (/^((?:<[^<>]*>)*)\/\*(.*)\*\//) {
	    $out .= $1."<FORTHHEADER>".$2."</FORTHHEADER>"
		."<FORTHFOOTER></FORTHFOOTER>\n";
	} elsif (/^((?:<[^<>]*>)*)\/\*(.*)/) {
	    $out .= $1."<FORTHHEADER>".$2."</FORTHHEADER>\n";
	} elsif (/^\s*\*\/(.*)/) {
	    $out .= "<FORTHFOOTER></FORTHFOOTER>\n"; # temporary... TOBEDONE
	} elsif (/^\s\*\s(.*)/) {
	    if ($state) { $out .= "</FORTHCODE>"; $state = 0; }
	    else { $out .= "<br>"; }
	    $out .= $1."\n";
	}else{
	    if (not $state) { $out .= "<FORTHCODE>"; $state = 1; }
	    $out .= $_;
	}
    }

    if ($state) { $out .= "</FORTHCODE>"; $state = 0; }

    return $out;
}	
	

sub DO
{
    my $in = shift;
    my $out = "";

    $in =~ s{ (<CDOCFCODE\b[^<>]*>) 
		  ((?:.(?!</?CDOCFCODE\b))*.) (</CDOCFCODE\b[^<>]*>)
		  }
    { $out .= "<ITEMFCODE>".$1.&format($2).$3."</ITEMFCODE>"."\n"; "" }gsex;

    $in =~ s{ (<CDOC\b[^<>]*><XDEFDOC>) 
		  ((?:.(?!</?CDOC\b))*.) (</CDOC\b[^<>]*>)
		  }
    { $out .= "<ITEMFCODE>".$1.&format($2).$3."</ITEMFCODE>"."\n"; "" }gsex;

    return $out;
}

1;

