package xm::grabitemxtra;
use strict;
use xm::o;

sub DESC
{"
  try to look for text outside a (global) ITEM[A-Z]* section
  and then mark these text areas as ITEMXTRA.
"}

sub ARGS { return xm::o::args_stdin(@_, DESC); }

sub DO
{
    my $in = shift;

    # demark all inner ITEMs ... just prepend "___"
    while ($in =~ 
	   s{<(ITEM\w*\b[^<>]*(?=>))
		 ((?:.(?!</?ITEM))*.)
		     <(ITEM\w*\b[^<>]*(?=>))
			 ((?:.(?!</?ITEM))*.)
			     </(ITEM\w*\b[^<>]*(?=>))
			     }
	   { "<".$1.$2."<___".$3.$4."</___".$5 }gsex
    ) {};

    my $fu = sub { 
	my $x = $_[0];
	return "<ITEMXTRA>".$x."</ITEMXTRA>" if $x !~ /^\s*$/s;
	return $x;
    };

    # do it
    $in =~ s{(^|</ITEM\w*\b[^<>]*>) 
		 ((?:.(?!</?ITEM))*.)
		     (<ITEM\w*\b[^<>]*(?=>))
		     } 
         { 
	     $1.&$fu($2).$3
	 }gsex;

    # remark the ___ITEMs
    $in =~ s{(</?)___ITEM} {$1."ITEM"}gsex;
	
    return $in;
} 

1;



