/*
 * xlog - GTK+ logging program for amateur radio operators
 * Copyright (C) 2001-2006 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * dxcc.h
 */

enum
{
	BAND_2200,  /* 0.135 - 0.137 MHz experimental */
	BAND_160,
	BAND_80,
	BAND_60,    /* 5.3 MHz, some countries */
	BAND_40,
	BAND_30,
	BAND_20,
	BAND_17,
	BAND_15,
	BAND_12,
	BAND_10,
	BAND_6,
	BAND_4,
	BAND_2,
	BAND_125CM, /* 220 - 225 MHz, region 2 */
	BAND_70CM,
	BAND_33CM,  /* 902 - 920 MHz, region 2 */
	BAND_23CM,
	BAND_ALL,
	MAX_BANDS   /* number of bands in the enumeration */
};

/* struct for dxcc information from cty.dat */
typedef struct
{
	gchar *countryname;
	guchar cq;              /* guchar max=255 */
	guchar itu;
	gchar *continent;
	gint latitude;
	gint longitude;
	gshort timezone;
	gchar *px;
	gchar *exceptions;
	guint worked;
	guint confirmed;
}
dxcc_data;

struct info
{
	gint country;
	gint cq;
	gint itu;
};

void cleanup_dxcc (void);
gint readctydata (void);
void updatedxccframe (gchar * item, gboolean byprefix);
void update_dxccscoring (void);
void fill_worked_array (void);
struct info lookupcountry_by_callsign (gchar * callsign);
struct info lookupcountry_by_prefix (gchar * px);
