/*-
 * Copyright (c) 1994 by David Bagley.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * This file is provided AS IS with no warranties of any kind.  The author
 * shall have no liability with respect to the infringement of copyrights,
 * trade secrets or any patents by this file or any part thereof.  In no
 * event will the author be liable for any lost revenue or profits or
 * other special, indirect and consequential damages.
 *
 * Revision History:
 * 28-Jun-2004: LIFE_NAMES compile-time option.
 * 02-Jun-2004: Lots more lifeforms.
 * 16-Apr-2004: S45B5 shower, blob with stabilizers, big pinwheel,
 *              pulsar 10, pulsar 20
 * 15-Apr-2004: S45B5 linked glider, 123243, dancing beacon, Lq 
 *              S567B6 sparky, fountain, cruncher, big star, mouth
 *              S56B5 double switch
 *              S678B5 waving tail, deformed runner
 *              S6767 pump
 *              Found with life4d searcher by Lee Earl Meeker.
 * 13-Mar-2004: Updated with minimum points from:
 *              Lee Earl Meeker's "Four Dimensional Cellular Automata and
 *              the Game of Life" 1998
 *              http://home.sc.rr.com/lmeeker/Lee/Home.html
 * 25-Jan-2003: File spawned from life3d.c, life forms from Carter Bays.
 *
 */

#define MAXNEIGHBORS 27
#define NUMPTS 42

typedef struct {
	int         survival, birth;
} paramstruct;

/*-
 * S45/B5 life is probably the best
 * S567/B6 life has gliders like Conway's 2d S23/B3 life
 * There are no known gliders for S67/B67,
 * so the others may be better
 */

static char patterns_S45B5[][3 * NUMPTS + 1] =
{
#if 0
/* still life */
#ifdef LIFE_NAMES
	{"V (s)"},
#endif
	{
		-1, -1, -1, 0, -1, -1,
		-1, 0, -1, 0, 0, -1,

		-1, -1, 0, 0, -1, 0,
		127
	},
#ifdef LIFE_NAMES
	{"cross (s)"},
#endif
	{
		0, 0, -1,

		0, -1, 0,
		-1, 0, 0, 1, 0, 0,
		0, 1, 0,

		0, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"pillar (s)"},
#endif
	{
		0, -1, -1,
		-1, 0, -1, 1, 0, -1,
		0, 1, -1,

		0, -1, 0,
		-1, 0, 0, 1, 0, 0,
		0, 1, 0,
		127
	},
#endif
#ifdef LIFE_NAMES
	{"blinker (p2)"},
#endif
	{
		0, 0, -1,

		0, -1, 0,
		-1, 0, 0, 1, 0, 0,
		0, 1, 0,

		-1, 0, 1, 1, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"double blinker (p2)"},
#endif
	{
		0, -1, -1,
		0, 1, -1,

		0, -1, 0,
		-1, 0, 0, 1, 0, 0,
		0, 1, 0,

		-1, 0, 1, 1, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"deformed double blinker (p2)"},
#endif
	{
		0, 0, -1,
		0, 1, -1,

		0, -1, 0, 1, -1, 0,
		-1, 0, 0,
		1, 1, 0,

		0, 0, 1,
		0, 1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"rotor (p2)"},
#endif
	{
		0, -1, -1,
		0, 0, -1,

		0, -2, 0,
		-1, -1, 0, 1, -1, 0,
		-1, 0, 0, 1, 0, 0,
		0, 1, 0,

		0, -1, 1,
		0, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"gate (p2)"},
#endif
	{
		-2, -1, -1, -1, -1, -1, 0, -1, -1,
		-2, 0, -1, -1, 0, -1,

		1, 0, 1, 2, 0, 1,
		0, 1, 1, 1, 1, 1, 2, 1, 1,

		127
	},
#ifdef LIFE_NAMES
	{"triple blinker 1 (p2)"},
#endif
	{
		-1, -1, -2,
		-1, 0, -2,

		-2, -1, -1,
		1, 0, -1,
		-1, 1, -1, 0, 1, -1,

		-1, -2, 0, 0, -2, 0,
		-2, -1, 0, 1, 0, 0,

		0, -1, 1,
		0, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"triple blinker 2 (p2)"},
#endif
	{
		-1, -1, -2, 0, -1, -2,

		0, -2, -1,
		1, -1, -1,
		1, 0, -1,
		-1, 1, -1,

		0, -2, 0,
		-2, -1, 0,
		-2, 0, 0,
		-1, 1, 0,

		-1, 0, 1, 0, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"three halves blinker (p2)"},
#endif
	{
		0, -1, -1,
		-1, 0, -1, 1, 0, -1,

		-1, -1, 0,
		1, 0, 0,
		-1, 1, 0, 0, 1, 0,

		0, -1, 1,
		0, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"seesaw (p2)"},
#endif
	{
		0, 0, -2,

		-2, -1, -1, -1, -1, -1,
		-2, 0, -1,
		0, 1, -1,

		-1, -1, 0,
		1, 0, 0,
		0, 1, 0, 1, 1, 0,

		-1, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"tripump (p2)"},
#endif
	{
		0, -2, -2,
		-2, -1, -2, -1, -1, -2, 0, -1, -2,

		0, -2, -1,
		-2, 0, -1,
		-2, 1, -1, -1, 1, -1,

		1, -2, 0,
		1, -1, 0,
		1, 0, 0,
		-1, 1, 0,

		0, 0, 1, 1, 0, 1,
		-1, 1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"windshieldwiper (helicopter) (p2)"},
#endif
	{
		-2, -1, -2, -1, -1, -2,
		0, 0, -2,

		-1, -2, -1,
		-2, -1, -1,
		1, 0, -1,
		-1, 1, -1, 0, 1, -1, 1, 1, -1,

		0, -2, 0,
		-2, -1, 0, 1, -1, 0,

		0, -2, 1,
		0, -1, 1,
		0, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"blink junk (p2)"},
#endif
	{
		0, -1, -1,
		-2, 0, -1, -1, 0, -1,

		0, -2, 0,
		1, -1, 0,
		-2, 0, 0,
		-1, 1, 0,

		0, -2, 1,
		1, -1, 1,
		-1, 0, 1, 0, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"beacon (p2)"},
#endif
	{
		-1, -2, -1, 0, -2, -1,
		-1, -1, -1,
		0, 0, -1,

		-1, -2, 0, 0, -2, 0,
		0, 1, 0, 1, 1, 0,

		0, -1, 1,
		1, 0, 1,
		0, 1, 1, 1, 1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"opening box (p2)"},
#endif
	{
		0, -1, -2,
		-1, 0, -2,

		-1, -2, -1, 0, -2, -1,
		-2, -1, -1, 1, -1, -1,
		1, 0, -1,
		-1, 1, -1, 0, 1, -1,

		-1, -2, 0, 0, -2, 0,
		-2, -1, 0, 1, -1, 0,
		-2, 0, 0,
		-1, 1, 0, 0, 1, 0,

		-1, -1, 1,
		0, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"ball (p2)"},
#endif
	{
		-1, -1, -2, 0, -1, -2,
		-1, 0, -2, 0, 0, -2,

		-1, -2, -1, 0, -2, -1,
		-2, -1, -1, 1, -1, -1,
		-2, 0, -1, 1, 0, -1,
		-1, 1, -1, 0, 1, -1,

		-1, -2, 0, 0, -2, 0,
		-2, -1, 0, 1, -1, 0,
		-2, 0, 0, 1, 0, 0,
		-1, 1, 0, 0, 1, 0,

		-1, -1, 1, 0, -1, 1,
		-1, 0, 1, 0, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"shower (p3)"},
#endif
	{
		-1, -2, -3,
		-2, -1, -3, 0, -1, -3,
		-1, 0, -3,

		-1, -2, -2,
		-2, -1, -2,
		1, 0, -2,
		0, 1, -2,

		1, 0, -1,
		0, 1, -1,

		1, -1, 0,
		-1, 1, 0,

		0, -1, 1,
		-1, 0, 1, 1, 0, 1,
		0, 1, 1,

		1, 0, 2,
		0, 1, 2,
		127
	},
#ifdef LIFE_NAMES
	{"blob with stabilizers (p3)"},
#endif
	{
		-1, -1, -3, 3, -1, -3,
		2, 0, -3, 3, 0, -3,

		0, -1, -2, 1, -1, -2, 3, -1, -2,
		-1, 0, -2, 3, 0, -2,

		-1, -3, -1,
		0, -2, -1,
		-3, -1, -1, 1, -1, -1,
		-2, 0, -1,
		-2, 1, -1, -1, 1, -1,
		-3, 3, -1, -2, 3, -1,

		-1, -2, 0,
		-2, -1, 0,
		-3, 2, 0,
		-3, 3, 0, -2, 3, 0,

		-1, -2, 1,
		-1, -1, 1,

		0, -3, 2,

		-1, -3, 3, 0, -3, 3,
		-1, -2, 3, 0, -2, 3,
		127
	},
#ifdef LIFE_NAMES
	{"blob with stabilizers (variant) (p3)"},
#endif
	{
		-1, 2, -3,
		-1, 3, -3, 0, 3, -3,

		0, 0, -2,
		0, 1, -2,
		-1, 3, -2, 0, 3, -2,

		2, -3, -1, 3, -3, -1,
		3, -2, -1,
		1, 0, -1,
		0, 1, -1,

		3, -3, 0,
		0, -2, 0, 1, -2, 0, 3, -2, 0,
		1, -1, 0,
		-2, 0, 0, 2, 0, 0,
		-1, 1, 0,
		0, 2, 0,

		0, -1, 1,
		-2, 0, 1, -1, 0, 1,

		-3, -1, 2,
		0, 0, 2,

		-3, -1, 3, -2, -1, 3,
		-3, 0, 3, -2, 0, 3,
		127
	},
#ifdef LIFE_NAMES
	{"cheshire (p3)"},
#endif
	{
		-1, -1, -1, 0, -1, -1,
		-2, 0, -1, 1, 0, -1,
		-1, 2, -1, 0, 2, -1,

		-1, -2, 0,
		-2, -1, 0, 1, -1, 0,
		-2, 1, 0, 1, 1, 0,

		-1, -1, 1, 0, -1, 1,
		-1, 0, 1, 0, 0, 1,
		-1, 2, 1, 0, 2, 1,

		127
	},
#ifdef LIFE_NAMES
	{"puffer (p4)"},
#endif
	{
		0, -1, -1,
		0, 0, -1,

		0, -2, 0,
		-1, -1, 0, 1, -1, 0,
		-1, 0, 0, 1, 0, 0,
		0, 1, 0,
		127
	},
#ifdef LIFE_NAMES
	{"arrow (p4)"},
#endif
	{
		0, -1, -1,
		0, 0, -1,

		0, -2, 0,
		1, -1, 0,
		1, 0, 0,
		0, 1, 0,

		-1, -1, 1,
		-1, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"heart (p4)"},
#endif
	{
		-1, -1, -1,
		-1, 0, -1, 0, 0, -1,

		0, -1, 0,
		-2, 0, 0, 1, 0, 0,

		-1, -1, 1,
		-1, 1, 1, 0, 1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"pinwheel (p4)"},
#endif
	{
		-1, 1, -1, 0, 1, -1,

		-1, -1, 0, 0, -1, 0,
		-2, 0, 0, 1, 0, 0,

		-1, 0, 1, 0, 0, 1,
		-1, 1, 1, 0, 1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"bronco (p4)"},
#endif
	{
		0, -1, -1,
		0, 0, -1,

		0, -2, 0,
		-1, -1, 0, 1, -1, 0,
		-1, 0, 0, 1, 0, 0,
		0, 1, 0,

		-1, -1, 1,
		-1, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"dancing beacon2 (p4)"},
#endif
	{
		0, -2, -2, 1, -2, -2,
		0, -1, -2, 1, -1, -2,

		1, -2, -1,

		0, -1, 0,
		-2, 0, 0, 0, 0, 0,
		-2, 1, 0,

		-2, 0, 1,
		-2, 1, 1, -1, 1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"shift rotate (p4)"},
#endif
	{
		-1, -1, -2, 0, -1, -2,
		-1, 0, -2, 0, 0, -2,

		-1, -2, -1,
		1, -1, -1,
		-2, 0, -1, 1, 0, -1,
		-1, 1, -1,

		-1, -2, 0,
		-2, -1, 0,
		0, 0, 0,

		-1, -1, 1, 0, -1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"waltzer (p6)"},
#endif
	{
		-1, -1, -1,
		-2, 0, -1,

		-1, -1, 0, 0, -1, 0,
		-2, 0, 0,
		1, 1, 0,

		-1, 0, 1, 1, 0, 1,
		0, 1, 1, 1, 1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"big waltzer (p6)"},
#endif
	{
		0, -1, -1, 1, -1, -1,
		-1, 0, -1, 0, 0, -1,
		-1, 1, -1,

		0, -2, 0, 1, -2, 0,
		-2, 0, 0,
		-2, 1, 0,

		0, -1, 1, 1, -1, 1,
		-1, 0, 1, 0, 0, 1,
		-1, 1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"123243 (p6)"},
#endif
	{
		-1, -1, -1, -1, -1, 0,
		-1, 1, -1, -1, 1, 0,

		0, -2, -1, 0, -2, 0,
		0, -1, -2, 0, -1, 1,
		0, 1, -2, 0, 1, 1,
		0, 2, -1, 0, 2, 0,

		1, 0, -1, 1, 0, 0,
		127
	},
#ifdef LIFE_NAMES
	{"dancing beacon (p6)"},
#endif
	{
		-2, -2, -2, -1, -2, -2,
		-2, -1, -2, -1, -1, -2,

		-2, -2, -1, 0, -1, -1,

		1, 0, 0,
		0, 1, 0, 1, 1, 0,

		1, 0, 1,
		0, 1, 1, 1, 1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"big pinwheel (p6)"},
#endif
	{
		-1, -1, -2, 0, -1, -2,
		0, 1, -2, 1, 1, -2,

		1, -1, -1,
		-1, 0, -1, 1, 0, -1,
		-1, 1, -1,

		1, -1, 0,
		-1, 0, 0, 1, 0, 0,
		-1, 1, 0,

		-1, -1, 1, 0, -1, 1,
		0, 1, 1, 1, 1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"diablo (p6)"},
#endif
	{
		0, -2, -3,
		-2, 0, -3,

		0, -3, -2,
		0, -1, -2,
		-3, 0, -2, -1, 0, -2,

		0, -2, -1,
		0, -1, -1,
		-2, 0, -1, -1, 0, -1,

		-2, -3, 0,
		-3, -2, 0, -1, -2, 0,
		-2, -1, 0, -1, -1, 0,
		1, 1, 0, 2, 1, 0,
		1, 2, 0, 3, 2, 0,
		2, 3, 0,

		1, 0, 1, 2, 0, 1,
		0, 1, 1,
		0, 2, 1,

		1, 0, 2, 3, 0, 2,
		0, 1, 2,
		0, 3, 2,

		2, 0, 3,
		0, 2, 3,
		127
	},
#ifdef LIFE_NAMES
	{"pulsar 10 (p10)"},
#endif
	{
		1, -1, -2,
		-1, 0, -2, 1, 0, -2,
		-1, 1, -2,
		0, 1, -2,

		0, -2, -1, 1, -2, -1,
		-2, 1, -1, 0, 1, -1,

		1, -2, 0,
		-2, -1, 0, 1, -1, 0,
		-2, 1, 0,

		-1, -2, 1, 0, -2, 1,
		-2, -1, 1,
		-2, 0, 1, -1, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"Lq (p16)"},
#endif
	{
		-1, 1, -1, 0, 1, -1,
		-1, 2, -1,

		0, -2, 0,
		-1, -1, 0, 1, -1, 0,
		-2, 1, 0, 0, 1, 0,
		-1, 2, 0,

		0, -2, 1,
		-1, -1, 1, 0, -1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"4 cups (p16)"},
#endif
	{
		-1, -2, -4, 0, -2, -4,
		-1, 1, -4, 0, 1, -4,

		-2, -2, -3, 1, -2, -3,
		-3, -1, -3, -2, -1, -3, -1, -1, -3,
		0, -1, -3, 1, -1, -3, 2, -1, -3,
		-3, 0, -3, -2, 0, -3, -1, 0, -3,
		0, 0, -3, 1, 0, -3, 2, 0, -3,
		-2, 1, -3, 1, 1, -3,

		-2, -2, 2, 1, -2, 2,
		-3, -1, 2, -2, -1, 2, -1, -1, 2,
		0, -1, 2, 1, -1, 2, 2, -1, 2,
		-3, 0, 2, -2, 0, 2, -1, 0, 2,
		0, 0, 2, 1, 0, 2, 2, 0, 2,
		-2, 1, 2, 1, 1, 2,

		-1, -2, 3, 0, -2, 3,
		-1, 1, 3, 0, 1, 3,
		127
	},
#ifdef LIFE_NAMES
	{"pulsar 20 (p20)"},
#endif
	{
		1, 0, -2,

		0, -1, -1, 1, -1, -1,
		0, 0, -1, 2, 0, -1,
		1, 1, -1,

		0, -2, 0,
		-1, -1, 0, 1, -1, 0,
		-1, 0, 0, 1, 0, 0,
		0, 1, 0,

		-1, -2, 1,
		-2, -1, 1, 0, -1, 1,
		-1, 0, 1, 0, 0, 1,

		-1, -1, 2,
		127
	},
#if 0
#ifdef LIFE_NAMES
	{"glider 1 (also as glider 2) diag p4"},
#endif
	{
		0, 0, 0, 0, 0, 1,
		0, 1, 2,
		0, 2, 2,
		0, 3, 0, 0, 3, 1,

		1, 1, 0, 1, 1, 1,
		1, 2, 0, 1, 2, 1,
		127
	},
#endif
#ifdef LIFE_NAMES
	{"linked glider (diag p4)"},
#endif
	{
		-1, 0, -3, -1, 0, -2, -1, 0, 1, -1, 0, 2,

		0, -1, -3, 0, -1, -2, 0, -1, 1, 0, -1, 2,
		0, 0, -4, 0, 0, -1, 0, 0, 0, 0, 0, 3,
		

		1, -1, -3, 1, -1, -2, 1, -1, 1, 1, -1, 2,
		1, 0, -4, 1, 0, 3,
		1, 1, -1, 1, 1, 0,
		127
	},
#ifdef LIFE_NAMES
	{"crab glider (diag p7)"},
#endif
	{
		0, 0, -2, 1, 0, -2,
		0, 1, -2,

		1, -2, -1,
		2, -1, -1,
		2, 0, -1,
		-2, 1, -1,
		-1, 2, -1, 0, 2, -1,

		0, -1, 0, 2, -1, 0,
		-1, 0, 0, 0, 0, 0, 2, 0, 0,
		-1, 2, 0, 0, 2, 0,

		1, -1, 1,
		1, 0, 1,
		-1, 1, 1, 0, 1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"glider 3 (24 cell, c/2, p4)"},
#endif
	{
		0, -1, -2,
		-2, 0, -2,
		0, 1, -2,

		0, -2, -1,
		-2, -1, -1, 1, -1, -1,
		-2, 0, -1, 1, 0, -1,
		-2, 1, -1, 1, 1, -1,
		0, 2, -1,

		1, -1, 0,
		1, 1, 0,

		0, -2, 1,
		-2, -1, 1, 1, -1, 1,
		-2, 0, 1, 1, 0, 1,
		-2, 1, 1, 1, 1, 1,
		0, 2, 1,

		0, -1, 2,
		-2, 0, 2,
		0, 1, 2,
		127
	},
#ifdef LIFE_NAMES
	{"glider 4 (28 cell, c/2, p2)"},
#endif
	{
		-2, -2, -2,
		-2, -1, -2, 0, -1, -2,
		-2, 1, -2, 0, 1, -2,
		-2, 2, -2,

		-2, -2, -1, 0, -2, -1,
		1, -1, -1,
		1, 0, -1,
		1, 1, -1,
		-2, 2, -1, 0, 2, -1,

		1, -1, 0,
		1, 1, 0,

		-2, -2, 1, 0, -2, 1,
		1, -1, 1,
		1, 0, 1,
		1, 1, 1,
		-2, 2, 1, 0, 2, 1,

		-2, -2, 2,
		-2, -1, 2, 0, -1, 2,
		-2, 1, 2, 0, 1, 2,
		-2, 2, 2,
		127
	},
#ifdef LIFE_NAMES
	{"collision -> redirection"},
#endif
	{
		-2, 3, -7, -1, 3, -7,
		-3, 4, -7, 0, 4, -7,
		-3, 5, -7, 0, 5, -7,

		-2, 4, -6, -1, 4, -6,
		-2, 5, -6, -1, 5, -6,

		1, -2, 1,

		1, -3, 2,
		0, -2, 2, 2, -2, 2,
		1, -1, 2,

		0, -2, 3, 2, -2, 3,
		127
	},
#ifdef LIFE_NAMES
	{"collision -> seesaw (p2)"},
#endif
	{
		-4, -6, -7, -1, -6, -7,
		-4, -5, -7, -1, -5, -7,
		-3, -4, -7, -2, -4, -7,

		-3, -6, -6, -2, -6, -6,
		-3, -5, -6, -2, -5, -6,

		1, 4, 6, 2, 4, 6,
		0, 5, 6, 3, 5, 6,
		0, 6, 6, 3, 6, 6,

		1, 5, 5, 2, 5, 5,
		1, 6, 5, 2, 6, 5,
		127
	}
};

static char patterns_S567B6[][3 * NUMPTS + 1] =
{
#if 0
#ifdef LIFE_NAMES
	{"blinker (p2)"},
#endif
	{
		-1, -1, 0, 0, -1, 0, 1, -1, 0,
		-1, 0, 0, 0, 0, 0, 1, 0, 0,
		127
	},
#endif
#ifdef LIFE_NAMES
	{"knife-switch blinker"},
#endif
	{
		-1, -1, -1, 0, -1, -1,
		-1, 0, -1, 1, 0, -1,
		-1, 1, -1, 0, 1, -1,

		-1, 0, 0, 0, 0, 0,
		127,
	},
#ifdef LIFE_NAMES
	{"switch"},
#endif
	{
		-1, 0, -1, 1, 0, -1,

		0, -1, 0,
		-1, 0, 0, 0, 0, 0, 1, 0, 0,
		0, 1, 0,

		0, 0, 1,
		127,
	},
#ifdef LIFE_NAMES
	{"triknot"},
#endif
	{
		0, 0, -1, 1, 0, -1,

		-1, -1, 0, 0, -1, 0,
		-1, 0, 0, 1, 0, 0,
		0, 1, 0,

		0, 0, 1,
		0, 1, 1,
		127,
	},
#ifdef LIFE_NAMES
	{"double blinker"},
#endif
	{
		0, 0, -1,
		0, 1, -1,

		-1, -1, 0, 0, -1, 0,
		-1, 0, 0, 1, 0, 0,
		0, 1, 0,

		0, -1, 1,
		1, 0, 1,
		0, 1, 1,
		127,
	},
#ifdef LIFE_NAMES
	{"pile driver"},
#endif
	{
		-1, 0, -1, 0, 0, -1,
		-1, 1, -1,

		-1, -1, 0, 0, -1, 0,
		1, 0, 0,
		-1, 1, 0, 0, 1, 0,

		-1, -1, 1,
		-1, 0, 1, 0, 0, 1,
		127,
	},
#ifdef LIFE_NAMES
	{"run around"},
#endif
	{
		0, -1, -1,
		-1, 0, -1, 1, 0, -1,

		0, -1, 0,
		-1, 0, 0, 1, 0, 0,
		0, 1, 0, 1, 1, 0,

		0, -1, 1,
		-1, 0, 1,
		0, 1, 1,
		127,
	},
#ifdef LIFE_NAMES
	{"single blinker"},
#endif
	{
		0, -1, -1,
		1, 0, -1,
		0, 1, -1,

		-1, -1, 0, 0, -1, 0,
		-1, 0, 0, 1, 0, 0,
		-1, 1, 0, 1, 1, 0,

		0, 0, 1,
		0, 1, 1,
		127,
	},
#ifdef LIFE_NAMES
	{"beacon"},
#endif
	{
		-2, -1, -2, -1, -1, -2,
		-2, 0, -2, -1, 0, -2,

		-2, -1, -1,
		-2, 0, -1,

		1, -1, 0,
		1, 0, 0,

		0, -1, 1, 1, -1, 1,
		0, 0, 1, 1, 0, 1,
		127,
	},
#ifdef LIFE_NAMES
	{"clock"},
#endif
	{
		-1, -2, -1,
		-1, -1, -1, 1, -1, -1,
		-2, 0, -1, 0, 0, -1,
		0, 1, -1,

		-1, -2, 0,
		-1, -1, 0, 1, -1, 0,
		-2, 0, 0, 0, 0, 0,
		0, 1, 0,
		127,
	},
#ifdef LIFE_NAMES
	{"gear"},
#endif
	{
		0, 0, -2,

		0, -2, -1,
		-1, -1, -1, 1, -1, -1,
		-1, 0, -1, 1, 0, -1,

		-1, -1, 0, 1, -1, 0,
		-1, 0, 0, 1, 0, 0,
		0, 1, 0,

		0, -1, 1,
		127,
	},
#ifdef LIFE_NAMES
	{"s"},
#endif
	{
		-1, -1, -2, 0, -1, -2,

		-1, -1, -1, 0, -1, -1,
		-1, 0, -1, 0, 0, -1,

		-1, -1, 0, 0, -1, 0,
		-1, 0, 0, 0, 0, 0,

		-1, 0, 1, 0, 0, 1,
		127,
	},
#ifdef LIFE_NAMES
	{"3 halves blinker"},
#endif
	{
		-1, -1, -1,
		-1, 0, -1,

		0, -2, 0,
		-2, -1, 0, 1, -1, 0,
		-2, 0, 0, 1, 0, 0,
		-1, 1, 0, 0, 1, 0,

		0, -2, 1,
		-1, -1, 1, 0, -1, 1,
		-1, 0, 1, 0, 0, 1,
		127,
	},
#ifdef LIFE_NAMES
	{"digger"},
#endif
	{
		0, -1, -2,
		-1, 0, -2, 0, 0, -2,

		-1, -2, -1, 0, -2, -1,
		-2, -1, -1,
		1, 0, -1,
		-1, 1, -1, 0, 1, -1,

		-1, -1, 0, 0, -1, 0,
		-1, 1, 0, 0, 1, 0,

		-1, -1, 1,
		-1, 0, 1,
		127,
	},
#ifdef LIFE_NAMES
	{"deformed digger"},
#endif
	{
		0, -1, -2,

		-1, -2, -1, 0, -2, -1,
		-2, -1, -1, 1, -1, -1,
		-1, 0, -1, 1, 0, -1,
		0, 1, -1,

		-1, -2, 0, 0, -2, 0,
		-2, -1, 0,
		-2, 0, 0, -1, 0, 0, 1, 0, 0,
		0, 1, 0,

		0, 0, 1,
		127,
	},
#ifdef LIFE_NAMES
	{"help"},
#endif
	{
		-1, 0, -2, 0, 0, -2,

		-1, -1, -1, 0, -1, -1,
		-1, 1, -1, 0, 1, -1,

		-1, -2, 0, 0, -2, 0,
		-2, -1, 0, 1, -1, 0,
		-2, 0, 0, 1, 0, 0,
		-1, 1, 0, 0, 1, 0,

		-1, -1, 1, 0, -1, 1,
		127,
	},
#ifdef LIFE_NAMES
	{"half blinkers"},
#endif
	{
		0, -1, -2,
		0, 0, -2,

		-1, -1, -1, 1, -1, -1,
		-1, 0, -1, 1, 0, -1,
		0, 1, -1,

		-1, -2, 0, 0, -2, 0, 1, -2, 0,
		-2, -1, 0, 2, -1, 0,
		-2, 0, 0, 2, 0, 0,
		0, 1, 0,

		-1, -1, 1, 1, -1, 1,
		-1, 0, 1, 1, 0, 1,
		0, 1, 1,

		0, -1, 2,
		0, 0, 2,
		127,
	},
#ifdef LIFE_NAMES
	{"mutant half blinkers"},
#endif
	{
		0, -1, -2,
		0, 0, -2,

		0, -2, -1,
		-1, -1, -1, 1, -1, -1,
		-1, 0, -1, 1, 0, -1,
		0, 1, -1,

		-1, -2, 0, 1, -2, 0,
		-2, -1, 0, 2, -1, 0,
		-2, 0, 0, 2, 0, 0,
		0, 1, 0,

		0, -2, 1, 1, -2, 1,
		-1, -1, 1, 2, -1, 1,
		-1, 0, 1, 2, 0, 1,
		0, 1, 1,

		0, -1, 2, 1, -1, 2,
		0, 0, 2,
		127,
	},
#ifdef LIFE_NAMES
	{"2 pts of star of David"},
#endif
	{
		-2, -1, -3,
		-3, 0, -3, -1, 0, -3,
		-2, 1, -3,

		-2, -1, -2,
		-3, 0, -2, -1, 0, -2,
		-2, 1, -2,

		-2, 0, -1, 0, 0, -1,

		1, 0, 0, 2, 0, 0,

		1, -1, 1, 2, -1, 1,
		0, 0, 1,
		1, 1, 1, 2, 1, 1,

		1, 0, 2, 2, 0, 2,
		127,
	},
#ifdef LIFE_NAMES
	{"triple blinker 1"},
#endif
	{
		0, -1, -2,
		0, 0, -2,

		-1, -1, -1, 1, -1, -1,
		-2, 0, -1,
		-1, 1, -1, 0, 1, -1,

		-1, -2, 0, 0, -2, 0,
		1, -1, 0,
		-2, 0, 0, 0, 0, 0,

		-1, -1, 1,
		-1, 0, 1,
		127,
	},
#ifdef LIFE_NAMES
	{"triple blinker 2"},
#endif
	{
		-1, -1, -2, 0, -1, -2,

		-1, -2, -1,
		-2, -1, -1, -1, -1, -1,
		-2, 0, -1,
		0, 1, -1,

		-1, -2, 0,
		1, -1, 0,
		0, 0, 0, 1, 0, 0,
		0, 1, 0,

		-1, 0, 1, 0, 0, 1,
		127,
	},
#ifdef LIFE_NAMES
	{"searchlight"},
#endif
	{
		-1, -1, -2, 0, -1, -2,
		-1, 0, -2, 0, 0, -2,

		-1, -2, -1, 0, -2, -1,
		-2, -1, -1, 1, -1, -1,
		-2, 0, -1, 1, 0, -1,
		0, 1, -1,

		-1, -2, 0, 0, -2, 0,
		1, -1, 0,
		-1, 0, 0, 1, 0, 0,
		0, 1, 0,

		-1, -1, 1, 0, -1, 1,
		127,
	},
#ifdef LIFE_NAMES
	{"little star"},
#endif
	{
		0, -1, -1,
		-1, 0, -1, 1, 0, -1,
		-1, 1, -1, 0, 1, -1, 1, 1, -1,

		-1, -1, 0, 1, -1, 0,
		-1, 1, 0, 1, 1, 0,

		-1, -1, 1, 0, -1, 1, 1, -1, 1,
		-1, 0, 1, 1, 0, 1,
		0, 1, 1,
		127,
	},
#ifdef LIFE_NAMES
	{"cruncher"},
#endif
	{
		0, -2, -2,
		0, -1, -2,

		0, -2, -1, 1, -2, -1,
		1, -1, -1,
		-1, 0, -1, 1, 0, -1,

		-1, -1, 0, 1, -1, 0,
		-1, 0, 0,
		-1, 1, 0, 0, 1, 0,

		0, 0, 1,
		0, 1, 1,
		127,
	},
#ifdef LIFE_NAMES
	{"fountain (p3)"},
#endif
	{
		1, -2, -3, 2, -2, -3,
		1, 1, -3, 2, 1, -3,

		1, -3, -2, 2, -3, -2,
		0, 0, -2, 3, 0, -2,
		0, 1, -2, 3, 1, -2,
		1, 2, -2, 2, 2, -2,

		1, -2, -1, 2, -2, -1,
		0, 0, -1, 3, 0, -1,
		0, 1, -1, 3, 1, -1,
		1, 2, -1, 2, 2, -1,

		1, 1, 0, 2, 1, 0,
		127
	},
#ifdef LIFE_NAMES
	{"star maker (p3)"},
#endif
	{
		1, -2, -1, 2, -2, -1,
		1, -1, -1, 2, -1, -1,
		-2, 1, -1, -1, 1, -1,
		-2, 2, -1, -1, 2, -1,

		1, -3, 0, 2, -3, 0,
		3, -2, 0, 0, -1, 0,
		3, -1, 0, -1, 0, 0,
		1, 0, 0,
		-3, 1, 0, 0, 1, 0,
		-3, 2, 0,
		-2, 3, 0, -1, 3, 0,

		1, -2, 1, 2, -2, 1,
		1, -1, 1, 2, -1, 1,
		-2, 1, 1, -1, 1, 1,
		-2, 2, 1, -1, 2, 1,
		127
	},
#ifdef LIFE_NAMES
	{"v (p3)"},
#endif
	{
		1, 0, -3,
		0, 1, -3, 1, 1, -3,

		-1, -1, -2, 0, -1, -2, 1, -1, -2,
		-1, 0, -2, 2, 0, -2,
		-1, 1, -2, 2, 1, -2,
		0, 2, -2, 1, 2, -2,

		-1, -2, -1, 0, -2, -1,
		-2, -1, -1,
		-2, 0, -1, 2, 0, -1,
		2, 1, -1,
		0, 2, -1, 1, 2, -1,

		-1, -2, 0, 0, -2, 0,
		-2, -1, 0, 1, -1, 0,
		-2, 0, 0,
		-1, 1, 0,

		0, -1, 1, 1, -1, 1,
		-1, 0, 1,
		-1, 1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"peak-a-boo (p3)"},
#endif
	{
		-1, -2, -3, 0, -2, -3,
		-2, -1, -3, 1, -1, -3,
		-2, 0, -3, 1, 0, -3,

		-1, -3, -2, 0, -3, -2,
		-2, -2, -2, 1, -2, -2,
		-3, -1, -2, 2, -1, -2,
		-3, 0, -2, -1, 0, -2, 0, 0, -2, 2, 0, -2,
		-2, 1, -2, 1, 1, -2,

		-1, -3, -1, 0, -3, -1,
		-2, -2, -1, 1, -2, -1,
		-3, 0, -1, 2, 0, -1,
		-2, 1, -1, 1, 1, -1,

		-2, -2, 0, 1, -2, 0,
		-2, -1, 0, 1, -1, 0,
		-2, 0, 0, 1, 0, 0,
		-1, 1, 0, 0, 1, 0,

		-1, -1, 1, 0, -1, 1,
		-1, 0, 1, 0, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"jaws (p3)"},
#endif
	{
		0, -1, -2,
		-1, 0, -2, 1, 0, -2,
		0, 1, -2,

		0, -2, -1,
		-1, -1, -1, 1, -1, -1,
		-1, 0, -1, 2, 0, -1,
		0, 1, -1, 1, 1, -1,

		-1, -2, 0, 1, -2, 0,
		-1, -1, 0, 2, -1, 0,
		1, 1, 0, 2, 1, 0,

		0, -2, 1,
		0, -1, 1, 1, -1, 1,
		1, 0, 1, 2, 0, 1,

		-2, 1, 1,
		-2, 2, 1, -1, 2, 1,

		-2, 1, 2, -1, 1, 2,
		-2, 2, 2, -1, 2, 2,
		127,
	},
#ifdef LIFE_NAMES
	{"sparky (p4)"},
#endif
	{
		0, -1, -2,
		0, 0, -2,

		0, -2, -1,
		-1, -1, -1, 1, -1, -1,
		-1, 0, -1, 1, 0, -1,

		0, -2, 0,
		-1, -1, 0, 1, -1, 0,
		1, 0, 0,
		-1, 1, 0, 0, 1, 0,

		-1, 0, 1, 0, 0, 1,
		-1, 1, 1,
		127,
	},
#ifdef LIFE_NAMES
	{"star (p4)"},
#endif
	{
		0, 0, -2,

		0, -1, -1, 1, -1, -1,
		-1, 0, -1, 1, 0, -1,
		0, 1, -1, 1, 1, -1,

		-1, -1, 0, 1, -1, 0,
		-1, 1, 0, 1, 1, 0,

		-1, -1, 1, 0, -1, 1,
		-1, 0, 1, 1, 0, 1,
		-1, 1, 1, 0, 1, 1,

		0, 0, 2,
		127,
	},
#ifdef LIFE_NAMES
	{"big star (p4)"},
#endif
	{
		-1, -1, -1, 0, -1, -1,
		-1, 0, -1, 1, 0, -1,
		-1, 1, -1, 0, 1, -1,

		-1, -1, 0, 1, -1, 0,
		-2, 0, 0, 2, 0, 0,
		-1, 1, 0, 1, 1, 0,

		0, -1, 1, 1, -1, 1,
		-1, 0, 1, 1, 0, 1,
		0, 1, 1, 1, 1, 1,
		127,
	},
#ifdef LIFE_NAMES
	{"mouth (p4)"},
#endif
	{
		-1, 1, -2,

		0, -2, -1, 1, -2, -1,
		-1, -1, -1, 2, -1, -1,
		-2, 0, -1, 2, 0, -1,
		-2, 1, -1, 1, 1, -1,
		-1, 2, -1, 0, 2, -1,

		0, -2, 0, 1, -2, 0,
		-1, -1, 0, 2, -1, 0,
		-2, 0, 0, 2, 0, 0,
		-2, 1, 0, 1, 1, 0,
		-1, 2, 0, 0, 2, 0,

		1, -1, 1,
		127,
	},
#ifdef LIFE_NAMES
	{"v2 (p5)"},
#endif
	{
		-1, -1, -2, 0, -1, -2,
		-1, 0, -2,

		0, -2, -1, 1, -2, -1,
		-2, 0, -1, 0, 0, -1,
		-2, 1, -1,

		0, -2, 0, 1, -2, 0,
		-1, -1, 0, 2, -1, 0,
		-2, 0, 0, 1, 0, 0,
		-2, 1, 0, 0, 1, 0,
		-1, 2, 0,

		1, -1, 1,
		1, 0, 1,
		-1, 1, 1, 0, 1, 1,
		127,
	},
#ifdef LIFE_NAMES
	{"m (p5)"},
#endif
	{
		1, -1, -3,
		1, 0, -3,
		-1, 1, -3, 0, 1, -3,

		1, -2, -2,
		0, -1, -2, 2, -1, -2,
		-1, 0, -2, 2, 0, -2,
		-2, 1, -2, 1, 1, -2,
		-1, 2, -2, 0, 2, -2,

		1, -2, -1,
		2, -1, -1,
		2, 0, -1,
		-2, 1, -1,
		-1, 2, -1, 0, 2, -1,

		0, -1, 0, 1, -1, 0,
		-1, 0, 0, 0, 0, 0,
		-1, 1, 0,

		0, 0, 1,
		127,
	},
#ifdef LIFE_NAMES
	{"birthday cake (p5)"},
#endif
	{
		-1, 0, -2, 0, 0, -2,
		-1, 1, -2, 0, 1, -2,

		-1, -1, -1,
		-2, 0, -1,
		-2, 1, -1, 1, 1, -1,
		-1, 2, -1, 0, 2, -1,

		0, -2, 0,
		-1, -1, 0, 0, -1, 0,
		2, 0, 0,
		-1, 1, 0, 2, 1, 0,
		-1, 2, 0,

		0, -1, 1, 1, -1, 1,
		2, 0, 1,
		0, 1, 1, 2, 1, 1,
		0, 2, 1, 1, 2, 1,

		1, 0, 2,
		1, 1, 2,
		127,
	},
#ifdef LIFE_NAMES
	{"sparky2 (p5)"},
#endif
	{
		0, -1, -2, 1, -1, -2,
		0, 0, -2, 1, 0, -2,

		0, -2, -1,
		-1, -1, -1,
		2, 0, -1,
		1, 1, -1,

		-1, -2, 0, 0, -2, 0,
		0, 0, 0, 2, 0, 0,
		2, 1, 0,

		-1, -2, 1, 0, -2, 1,
		-2, -1, 1, 1, -1, 1,
		-1, 0, 1, 2, 0, 1,
		0, 1, 1, 2, 1, 1,
		1, 2, 1,

		-1, -1, 2,
		-1, 0, 2,
		0, 1, 2, 1, 1, 2,
		127,
	},
#ifdef LIFE_NAMES
	{"fuse"},
#endif
	{
		0, 0, 4,

		0, 0, 3,

		0, -2, 2,
		-1, -1, 2, 1, -1, 2,
		-2, 0, 2, 2, 0, 2,
		-1, 1, 2, 1, 1, 2,
		0, 2, 2,

		0, -2, 1,
		-1, -1, 1, 1, -1, 1,
		-2, 0, 1, 2, 0, 1,
		-1, 1, 1, 1, 1, 1,
		0, 2, 1,

		0, 0, 0,

		0, 0, -1,

		0, -2, -2,
		-1, -1, -2, 1, -1, -2,
		-2, 0, -2, 2, 0, -2,
		-1, 1, -2, 1, 1, -2,
		0, 2, -2,

		0, -2, -3,
		-1, -1, -3, 1, -1, -3,
		-2, 0, -3, 2, 0, -3,
		-1, 1, -3, 1, 1, -3,
		0, 2, -3,

		-1, 0, -4, 0, 0, -4, 1, 0, -4,
		127,
	},
#ifdef LIFE_NAMES
	{"glider 2 (16 cell, c/4, p8)"},
#endif
	{
		-1, -2, -1, -1, -2, 0,
		-1, -1, -1, -1, -1, 0,
		-1, 1, -1, -1, 1, 0,

		0, -1, -1, 0, -1, 0,
		0, 1, -1, 0, 1, 0,
		0, 2, -1, 0, 2, 0,

		1, 0, -1, 1, 0, 0,
		1, 1, -1, 1, 1, 0,
		127
	},
#ifdef LIFE_NAMES
	{"near ship"},
#endif
	{
		-2, -1, -2, -1, -1, -2,
		-2, 0, -2, -1, 0, -2,

		-2, -1, -1, -1, -1, -1,
		-2, 0, -1, -1, 0, -1,

		0, -1, 0,
		0, 0, 0,

		-2, -1, 1, -1, -1, 1,
		-2, 0, 1, -1, 0, 1,

		-2, -1, 2, -1, -1, 2,
		-2, 0, 2, -1, 0, 2,
		127
	}
};

/*-
 * Many names of S56/B5 & S67/B67 are made up by David Bagley.
 * They are listed in * order given by Carter Bays all p2 except "H"
 */
static char patterns_S56B5[][3 * NUMPTS + 1] =
{
#if 0
#ifdef LIFE_NAMES
	{"C"},
#endif
	{
		-1, 0, -1, 1, 0, -1,

		-1, 0, 0, 0, 0, 0, 1, 0, 0,
		127
	},
#endif
#ifdef LIFE_NAMES
	{"mosquito"},
#endif
	{
		0, 0, -1,
		-1, -1, 0,
		-1, 0, 0, 0, 0, 0,
		-1, 1, 0,
		-1, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"prop"},
#endif
	{
		-1, 0, -1, 0, 0, -1, 1, 0, -1,

		0, -1, 0,
		0, 0, 0,
		0, 1, 0,
		127
	},
#ifdef LIFE_NAMES
	{"seesaw"},
#endif
	{
		0, -1, -1,
		-1, 0, -1, 0, 0, -1,

		0, 0, 0, 1, 0, 0,
		0, 1, 0,
		127
	},
#ifdef LIFE_NAMES
	{"arrow"},
#endif
	{
		-1, -1, -1,
		-1, 0, -1,

		1, -1, 0,
		0, 0, 0, 1, 0, 0,

		0, -1, 1,
		0, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"broken seesaw"},
#endif
	{
		0, -1, -1,
		-1, 0, -1, 0, 0, -1,

		1, -1, 0,
		0, 0, 0, 1, 0, 0,
		0, 1, 0,
		127
	},
#ifdef LIFE_NAMES
	{"column"},
#endif
	{
		0, -1, -1,
		-1, 0, -1, 0, 0, -1, 1, 0, -1,
		0, 1, -1,

		0, 0, 0,

		0, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"small rower"},
#endif
	{
		-1, 0, -1, 0, 0, -1, 1, 0, -1,

		-1, -1, 0, 0, -1, 0, 1, -1, 0,
		0, 0, 0,
		127
	},
#ifdef LIFE_NAMES
	{"runner"},
#endif
	{
		0, -1, -1,
		-1, 0, -1,

		-1, -1, 0, 0, -1, 0,
		-1, 0, 0,

		-1, -1, 1,
		0, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"sliding blocks "},
#endif
	{
		0, -1, -1,
		0, 0, -1,

		0, -1, 0,
		-1, 0, 0, 0, 0, 0,

		-1, -1, 1,
		-1, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"stinging mosquito"},
#endif
	{
		0, 0, -1,
		0, 1, -1, 1, 1, -1,

		0, -1, 0,
		-1, 0, 0, 0, 0, 0, 1, 0, 0,
		127
	},
#ifdef LIFE_NAMES
	{"double blinker"},
#endif
	{
		0, 0, -1,
		0, 1, -1,

		-1, -1, 0, 1, -1, 0,
		-1, 0, 0, 1, 0, 0,

		0, 0, 1,
		0, 1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"2C"},
#endif
	{
		-1, -1, -1, 1, -1, -1,
		-1, 0, -1, 1, 0, -1,
		1, 1, -1,

		-1, -1, 0, 1, -1, 0,
		1, 1, 0,

		-1, -1, 1,
		-1, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"2C2"},
#endif
	{
		-2, -1, -1, 0, -1, -1,
		-1, 1, -1, 0, 1, -1, 1, 1, -1,

		-2, -1, 0, -1, -1, 0, 0, -1, 0,
		-1, 1, 0, 1, 1, 0,
		127
	},
#ifdef LIFE_NAMES
	{"2S"},
#endif
	{
		0, 0, -2,
		0, 1, -2,

		-2, 0, -1, -1, 0, -1,
		0, 1, -1,

		-1, 0, 0,
		0, 1, 0,
		0, 2, 0,
		-1, 0, 1, 0, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"clock"},
#endif
	{
		-1, -2, -1,
		-1, -1, -1, 1, -1, -1,
		-2, 0, -1, 0, 0, -1,
		0, 1, -1,

		-1, -2, 0,
		1, -1, 0,
		-2, 0, 0,
		0, 1, 0,
		127
	},
#ifdef LIFE_NAMES
	{"clock2"},
#endif
	{
		-1, 0, -2, 0, 0, -2,

		-1, -2, -1, 0, -2, -1,
		0, -1, -1,

		-1, 0, 0,
		-1, 1, 0, 0, 1, 0,

		-1, -1, 1, 0, -1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"bat"},
#endif
	{
		0, -1, -1, 1, -1, -1,
		-1, 0, -1,
		-1, 1, -1,

		0, -2, 0, 1, -2, 0,
		0, -1, 0,
		-2, 0, 0, -1, 0, 0,
		-2, 1, 0,
		127
	},
#ifdef LIFE_NAMES
	{"deformed stairs"},
#endif
	{
		1, -1, -2,
		1, 0, -2,

		0, -1, -1,
		0, 0, -1, 1, 0, -1,

		-2, -1, 0, -1, -1, 0,
		-2, 0, 0, -1, 0, 0,

		-1, -1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"deformed stairs2"},
#endif
	{
		0, -1, -2, 1, -1, -2,
		0, 0, -2,

		0, -1, -1,
		0, 0, -1,

		-1, -1, 0,
		-1, 0, 0,

		-1, -1, 1,
		-2, 0, 1, -1, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"folding stairs"},
#endif
	{
		-1, -2, -2, 0, -2, -2,

		-1, -2, -1,
		-1, -1, -1,
		0, -1, -1,

		-1, 0, 0, 0, 0, 0,
		0, 0, 1,
		-1, 1, 1, 0, 1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"folding stairs2"},
#endif
	{
		-1, -2, -2, 0, -2, -2,

		-1, -2, -1,
		-1, -1, -1, 0, -1, -1,

		-1, 0, 0, 0, 0, 0,
		-1, 0, 1,
		-1, 1, 1, 0, 1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"folding stairs3"},
#endif
	{
		1, 0, -2,

		0, -1, -1, 1, -1, -1,
		0, 0, -1, 1, 0, -1,
		-1, -1, 0,
		-1, 0, 0,

		-2, -1, 1,
		-1, -1, 1,
		-1, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"folding stairs 4"},
#endif
	{
		1, -2, -1,
		0, -1, -1,
		-1, 0, -1,
		-2, 1, -1, -1, 1, -1,

		0, -2, 0,
		0, -1, 0, 1, -1, 0,
		-2, 0, 0, -1, 0, 0,
		127
	},
#ifdef LIFE_NAMES
	{"folding stairs5"},
#endif
	{
		-1, -2, -2,

		-1, -2, -1, 0, -2, -1,
		-1, -1, -1, 0, -1, -1,

		-1, 0, 0, 0, 0, 0,

		-1, 0, 1, 0, 0, 1,
		-1, 1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"folding stairs6"},
#endif
	{
		-2, -1, -2,
		-1, 0, -2,

		-1, -1, -1,
		-2, 0, -1, -1, 0, -1,

		0, -1, 0,
		0, 0, 0,
		1, 0, 0,

		1, -1, 1,
		0, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"folding stairs7"},
#endif
	{
		0, 0, -2,

		0, -1, -1, 1, -1, -1,
		0, 0, -1, 1, 0, -1,

		-1, -1, 0,
		-2, 0, 0, -1, 0, 0,

		-2, -1, 1,
		-2, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"pinwheel"},
#endif
	{
		-1, -1, -2,
		-1, -1, -1,
		0, -1, -1,
		-1, 1, -1,
		0, 1, -1,
		-1, -1, 0,
		0, -1, 0,
		-1, 1, 0,
		0, 1, 0,
		0, 1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"pinwheel2"},
#endif
	{
		0, -1, -2,
		0, -1, -1,
		1, -1, -1,
		-2, 0, -1,
		-1, 0, -1,
		0, -1, 0,
		1, -1, 0,
		-2, 0, 0,
		-1, 0, 0,
		-1, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"pump"},
#endif
	{
		0, -1, -1, 1, -1, -1,
		0, 0, -1,

		-1, -1, 0, 1, -1, 0,
		-1, 0, 0, 1, 0, 0,

		-1, -1, 1, 0, -1, 1,
		0, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"rubberband"},
#endif
	{
		0, -1, -1,
		1, -1, -1,
		-1, 0, -1,
		0, 0, -1,
		1, -1, 0,
		-1, 0, 0,
		0, -1, 1,
		1, -1, 1,
		-1, 0, 1,
		0, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"switch"},
#endif
	{
		2, -1, -2,
		1, 0, -2, 2, 0, -2,

		1, -1, -1, 2, -1, -1,
		1, 0, -1,

		1, 0, 0,

		-1, -1, 1,
		-2, 0, 1, -1, 0, 1, 0, 0, 1,

		-2, -1, 2, -1, -1, 2,
		-2, 0, 2,
		127
	},
#ifdef LIFE_NAMES
	{"capacitor"},
#endif
	{
		0, -1, -2,
		-1, 0, -2, 0, 0, -2,

		0, 0, -1, 1, 0, -1,
		0, 1, -1, 1, 1, -1,

		0, 0, 1, 1, 0, 1,
		0, 1, 1, 1, 1, 1,

		0, -1, 2,
		-1, 0, 2, 0, 0, 2,
		127
	},
#ifdef LIFE_NAMES
	{"backwards runner"},
#endif
	{
		-1, -2, -1, 0, -2, -1,
		0, -1, -1,

		-1, -1, 0, 0, -1, 0,

		-1, 0, 1, 0, 0, 1,
		-1, 1, 1,

		-1, 0, 2, 0, 0, 2,
		127
	},
#ifdef LIFE_NAMES
	{"eagle"},
#endif
	{
		0, -2, -1, 1, -2, -1,
		0, -1, -1, 1, -1, -1,
		0, 1, -1, 1, 1, -1,
		0, 2, -1, 1, 2, -1,

		0, -1, 0,
		-1, 0, 0,
		0, 1, 0,
		127
	},
#ifdef LIFE_NAMES
	{"variant 1"},
#endif
	{
		1, -1, -2,
		0, 0, -2,

		0, -1, -1,
		0, 0, -1, 1, 0, -1,

		-1, -1, 0,

		0, -1, 1,
		0, 0, 1, 1, 0, 1,

		1, -1, 2,
		0, 0, 2,
		127
	},
#ifdef LIFE_NAMES
	{"variant 2"},
#endif
	{
		0, -1, -2,
		1, 0, -2,

		0, -1, -1, 1, -1, -1,
		0, 0, -1,

		-1, 0, 0,

		0, -1, 1,
		0, 0, 1, 1, 0, 1,

		1, -1, 2,
		0, 0, 2,
		127
	},
#ifdef LIFE_NAMES
	{"variant 3"},
#endif
	{
		1, -1, -2,
		0, 0, -2,

		0, -1, -1, 1, -1, -1,
		0, 0, -1,

		-1, -1, 0,

		0, -1, 1,
		0, 0, 1, 1, 0, 1,

		1, -1, 2,
		0, 0, 2,
		127
	},
#ifdef LIFE_NAMES
	{"variant 4"},
#endif
	{
		1, -1, -2,
		0, 0, -2,

		0, -1, -1, 1, -1, -1,
		0, 0, -1,

		-1, 0, 0,

		0, -1, 1,
		0, 0, 1, 1, 0, 1,

		1, -1, 2,
		0, 0, 2,
		127
	},
#ifdef LIFE_NAMES
	{"squid"},
#endif
	{
		-2, -1, -2, -1, -1, -2,
		1, 1, -2,
		1, 2, -2,

		-2, -1, -1, -1, -1, -1, 0, -1, -1,
		1, 0, -1,
		1, 1, -1,
		1, 2, -1,

		-1, -1, 0,
		1, 1, 0,

		-1, 0, 1,
		-2, 1, 1, -1, 1, 1, 0, 1, 1,
		-2, 2, 1, -1, 2, 1,
		127
	},
#ifdef LIFE_NAMES
	{"rower"},
#endif
	{
		0, 1, -2,

		-1, -1, -1, 1, -1, -1,
		-2, 0, -1, -1, 0, -1, 1, 0, -1, 2, 0, -1,

		-1, 0, 0, 1, 0, 0,
		-1, 1, 0, 1, 1, 0,

		0, -1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"flip"},
#endif
	{
		-1, -2, -2,
		0, -1, -2,
		0, 0, -2,

		-1, -2, -1,
		-2, -1, -1, 1, -1, -1,
		1, 0, -1,
		1, 1, -1,

		-1, -2, 0,
		-2, -1, 0,
		-1, 1, 0, 0, 1, 0,

		-2, 0, 1, -1, 0, 1, 0, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"corner 1"},
#endif
	{
		-1, -3, -3,
		-1, -2, -3, 0, -2, -3,
		1, -1, -3,
		1, 0, -3, 2, 0, -3,

		-1, -3, -2,
		0, -2, -2,
		1, -1, -2,
		2, 0, -2,

		-3, -3, -1, -2, -3, -1,
		-3, -2, -1,
		2, 1, -1,
		1, 2, -1, 2, 2, -1,

		-3, -2, 0, -2, -2, 0,
		1, 1, 0,
		1, 2, 0,

		-3, -1, 1, -2, -1, 1,
		-3, 0, 1,
		0, 1, 1,
		-1, 2, 1, 0, 2, 1,

		-3, 0, 2, -2, 0, 2,
		-1, 1, 2,
		-1, 2, 2,
		127
	},
#ifdef LIFE_NAMES
	{"corner 2"},
#endif
	{
		-2, -2, -3, -1, -2, -3,
		-2, -1, -3,
		2, 1, -3,
		1, 2, -3, 2, 2, -3,

		-3, -2, -2, -1, -2, -2,
		-3, -1, -2, 0, -1, -2,
		1, 0, -2,
		2, 1, -2,
		1, 3, -2, 2, 3, -2,

		-3, -2, -1, -2, -2, -1,
		0, -1, -1,
		1, 0, -1,
		2, 2, -1,
		2, 3, -1,

		-2, -1, 0, -1, -1, 0,
		1, 1, 0,
		1, 2, 0,

		-2, 0, 1, -1, 0, 1,
		0, 1, 1,
		-3, 2, 1, 0, 2, 1,
		-2, 3, 1,

		-3, 1, 2, -2, 1, 2,
		-3, 2, 2, -1, 2, 2,
		-2, 3, 2, -1, 3, 2,
		127
	},
#ifdef LIFE_NAMES
	{"runner"},
#endif
	{
		-1, -2, -1, 0, -2, -1,
		0, -1, -1,

		-1, -1, 0, 0, -1, 0,

		-1, 0, 1, 0, 0, 1,
		0, 1, 1,

		-1, 1, 2, 0, 1, 2,
		127
	},
#ifdef LIFE_NAMES
	{"3 columns"},
#endif
	{
		0, 0, -6,

		0, 0, -5,

		0, -1, -4,
		-1, 0, -4, 0, 0, -4, 1, 0, -4,
		0, 1, -4,

		0, -1, -1,
		-1, 0, -1, 0, 0, -1, 1, 0, -1,
		0, 1, -1,

		0, 0, 0,

		0, 0, 1,

		0, 0, 2,

		0, 0, 3,

		0, -1, 4,
		-1, 0, 4, 0, 0, 4, 1, 0, 4,
		0, 1, 4,
		127
	},
#ifdef LIFE_NAMES
	{"H (p3)"},
#endif
	{
		-1, -2, 0, 0, -2, 0, 1, -2, 0,
		0, -1, 0,
		-1, 0, 0, 0, 0, 0, 1, 0, 0,
		127
	},
#ifdef LIFE_NAMES
	{"1 leg walker (p4)"},
#endif
	{
		0, 1, -2,
		-1, 2, -2, 0, 2, -2,

		-1, 1, -1, 0, 1, -1,
		-1, 2, -1,

		0, -2, 0,
		0, -1, 0, 1, -1, 0,
		1, 0, 0,

		1, -2, 1,
		1, -1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"2 enemies (p4)"},
#endif
	{
		-1, -2, -1, 0, -2, -1,
		0, 2, -1, 1, 2, -1,

		0, -2, 0,
		-1, -1, 0, 0, -1, 0,
		0, 1, 0, 1, 1, 0,
		1, 2, 0,

		-1, 0, 1, 1, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"W (p4)"},
#endif
	{
		-1, -2, -1,
		1, -1, -1,
		-2, 0, -1, 1, 0, -1,
		0, 1, -1, 2, 1, -1,

		-1, -2, 0,
		-1, -1, 0, 1, -1, 0,
		-2, 0, 0,
		0, 1, 0, 2, 1, 0,
		127
	},
#ifdef LIFE_NAMES
	{"W2 (p4)"},
#endif
	{
		0, -1, -2,
		0, 0, -2,

		1, -1, -1,
		0, 0, -1, 1, 0, -1,

		-2, -1, 0,
		-2, 0, 0,

		-1, -1, 1, 0, -1, 1,
		0, 0, 1,

		-1, -1, 2,
		-1, 0, 2,
		127
	},
#ifdef LIFE_NAMES
	{"beacon (p4)"},
#endif
	{
		1, -2, -1, 2, -2, -1,
		1, -1, -1, 2, -1, -1,
		2, -2, 0,
		0, -1, 0, 2, -1, 0,
		-1, 0, 0,
		-2, 1, 0, -1, 1, 0,
		-2, 0, 1, -1, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"beacon2 (p4)"},
#endif
	{
		2, -2, -1,
		1, -1, -1, 2, -1, -1,
		1, -2, 0, 2, -2, 0,
		0, -1, 0, 2, -1, 0,
		-1, 0, 0,
		-2, 1, 0, -1, 1, 0,
		-2, 0, 1, -1, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"friend with stabilizer (p4)"},
#endif
	{
		-2, 0, -2, -1, 0, -2,

		-2, 0, -1, -1, 0, -1,
		-1, 1, -1,

		1, -1, 0,
		1, 0, 0,
		-1, 1, 0,

		0, -1, 1, 1, -1, 1,
		0, 0, 1, 1, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"double switch (p4)"},
#endif
	{
		-2, -3, -1,
		-1, -2, -1,
		-2, -1, -1, -1, -1, -1,

		-1, -3, 0,
		-2, -2, 0, -1, -2, 0,
		-1, 0, 0,

		0, 1, 0, 1, 1, 0,
		0, 2, 0,

		0, 1, 1,
		1, 2, 1,
		127
	},
#ifdef LIFE_NAMES
	{"double switch2 (p4)"},
#endif
	{
		-1, 0, -3,
		0, 1, -3,

		-1, 0, -2, 0, 0, -2,
		0, 1, -2,

		-1, 0, -1,
		0, 1, -1,

		0, -1, 0,

		0, -2, 1,
		0, -1, 1, 1, -1, 1,
		1, -2, 2,

		0, -1, 2,
		127
	},
#ifdef LIFE_NAMES
	{"3 friends (p4)"},
#endif
	{
		2, -1, -3,
		1, 0, -3,

		1, -1, -2,
		0, 0, -2, 1, 0, -2, 2, 0, -2,

		-2, 1, -1,
		-3, 2, -1,

		0, -2, 0,
		-2, 0, 0,
		-3, 1, 0, -2, 1, 0,
		-2, 2, 0,

		0, -3, 1,
		-1, -2, 1, 0, -2, 1,

		-1, -3, 2,
		0, -2, 2,
		127
	},
#ifdef LIFE_NAMES
	{"stuff with 3 stabilizers (p4)"},
#endif
	{
		-2, 2, -3, -1, 2, -3,
		-2, 3, -3, -1, 3, -3,

		2, -3, -2, 3, -3, -2,
		2, -2, -2, 3, -2, -2,
		-2, 2, -2,
		-2, 3, -2,

		2, -3, -1, 3, -3, -1,
		2, -1, -1,
		0, 0, -1,
		0, 1, -1,
		-1, 2, -1,

		0, -1, 0, 1, -1, 0,
		-1, 0, 0,

		-1, 0, 1,

		-3, -2, 2, -2, -2, 2,
		-3, -1, 2, -1, -1, 2,

		-3, -2, 3, -2, -2, 3,
		-3, -1, 3,
		127
	},
#ifdef LIFE_NAMES
	{"corner (p6)"},
#endif
	{
		1, 1, -3,
		2, 2, -3,

		2, 1, -2,
		1, 2, -2, 2, 2, -2,

		1, 1, -1,
		2, 2, -1,

		2, 1, 0,

		1, -3, 1,
		2, -2, 1,
		1, -1, 1,
		-3, 1, 1, -1, 1, 1,
		-2, 2, 1, 0, 2, 1, 2, 2, 1,

		2, -3, 2,
		1, -2, 2, 2, -2, 2,
		2, -1, 2,
		1, 0, 2,
		-2, 1, 2, 2, 1, 2,
		-3, 2, 2, -2, 2, 2, -1, 2, 2, 1, 2, 2,
		127
	},
#ifdef LIFE_NAMES
	{"glider 1 (18 cell, c/2, p2)"},
#endif
	{
		-1, -2, -1, 0, -2, -1,
		-2, -1, -1, 1, -1, -1,
		-2, 1, -1, 1, 1, -1,
		-1, 2, -1, 0, 2, -1,

		-1, -2, 0, 0, -2, 0,
		-1, -1, 0, 0, -1, 0,
		-2, 0, 0, 1, 0, 0,
		-1, 1, 0, 0, 1, 0,
		-1, 2, 0, 0, 2, 0,
		127
	},
#ifdef LIFE_NAMES
	{"glider 2 (32 cell, 3c/4, p4)"},
#endif
	{
		-1, -2, -3,
		1, -1, -3,
		1, 0, -3,
		-1, 1, -3,

		-1, -3, -2,
		-2, -1, -2,
		-2, 0, -2,
		-1, 2, -2,

		1, -3, -1,
		-2, -2, -1,
		-2, -1, -1, 1, -1, -1,
		-2, 0, -1, 1, 0, -1,
		-2, 1, -1,
		1, 2, -1,

		1, -3, 0,
		-2, -2, 0,
		-2, -1, 0, 1, -1, 0,
		-2, 0, 0, 1, 0, 0,
		-2, 1, 0,
		1, 2, 0,

		-1, -3, 1,
		-2, -1, 1,
		-2, 0, 1,
		-1, 2, 1,

		-1, -2, 2,
		1, -1, 2,
		1, 0, 2,
		-1, 1, 2,
		127
	}
#if 0
#ifdef LIFE_NAMES
	,{"glider 3 (14 cell diag, p7)"},
#endif
	{
		1, -2, -1,
		-2, 1, -1,

		0, -2, 0, 2, -2, 0,
		1, -1, 0, 2, -1, 0,
		-2, 0, 0,
		-1, 1, 0,
		-2, 2, 0, -1, 2, 0,

		1, -2, 1, 2, -2, 1,
		-2, 1, 1,
		-2, 2, 1,
		127
	}
#endif
};

static char patterns_S678B5[][3 * NUMPTS + 1] =
{
#if 0
#ifdef LIFE_NAMES
	{"C"},
#endif
	{
		0, -1, -1, 0, -1, 0,
		0, 0, -1,
		0, 1, -1, 0, 1, 0,
		127
	},
#endif 
#ifdef LIFE_NAMES
	{"arrow"},
#endif
	{
		-1, -1, -1,
		0, 0, -1, 1, 0, -1,
		0, 1, -1,

		-1, -1, 0,
		1, 0, 0,
		0, 1, 0,
		127
	},
#ifdef LIFE_NAMES
	{"little runner"},
#endif
	{
		0, -1, -1,
	       	0, 0, -1,
		-1, 1, -1,

		-1, -1, 0,
		-1, 0, 0, 0, 0, 0,
		0, 1, 0,
		127
	},
#ifdef LIFE_NAMES
	{"s"},
#endif
	{
		-1, -1, -1, 0, -1, -1,
		0, 0, -1, 1, 0, -1,

		-1, -1, 0,
		0, 0, 0, 1, 0, 0,
		127
	},
#ifdef LIFE_NAMES
	{"rower"},
#endif
	{
		-1, -1, -1,
		-1, 0, -1, 0, 0, -1,
		-1, 1, -1,

		0, -1, 0,
		-1, 0, 0,
		0, 1, 0,
		127
	},
#ifdef LIFE_NAMES
	{"corner"},
#endif
	{
		1, -1, -1,
		0, 0, -1, 1, 0, -1,
		-1, 1, -1, 0, 1, -1,

		1, 0, 0,
		0, 1, 0, 1, 1, 0,
		1, 1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"2C"},
#endif
	{
		1, -2, -1,
		-1, -1, -1,
		-1, 0, -1, 1, 0, -1,
		-1, 1, -1,

		1, -2, 0,
		-1, -1, 0, 1, -1, 0,
		1, 0, 0,
		-1, 1, 0,
		127
	},
#ifdef LIFE_NAMES
	{"deformed runner"},
#endif
	{
		0, -1, -2, 1, -1, -2,

		0, -1, -1,
		0, 0, -1,
		-1, 1, -1,

		0, -2, 0,
		-1, -1, 0,
		-1, 0, 0,

		-2, 0, 1, -1, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"2 friends"},
#endif
	{
		0, -2, -2,
		-1, -1, -2,
		0, -1, -2,
		-1, -1, -1, 0, -1, -1,
		-1, 0, 0, 0, 0, 0,
		-1, 1, 0, 0, 1, 0,
		0, 1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"2 friends2"},
#endif
	{
		-1, -1, -2,

		-2, -1, -1, -1, -1, -1,
		-2, 0, -1, -1, 0, -1,

		0, -1, 0,
		0, 0, 0, 1, 0, 0,

		0, -1, 1,
		0, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"bird"},
#endif
	{
		-1, -1, -1, 0, -1, -1,
		-2, 0, -1, 0, 0, -1, 1, 0, -1,

		-1, -1, 0, 0, -1, 0,
		-2, 0, 0, -1, 0, 0, 1, 0, 0,
		127
	},
#ifdef LIFE_NAMES
	{"bug jumping jack"},
#endif
	{
		0, -1, -2, 1, -1, -2,
		0, -1, -1,
		0, 0, -1,
		-1, 1, -1,
		0, -2, 0,
		-1, -1, 0,
		-1, 0, 0,
		-2, 0, 1, -1, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"dali clock"},
#endif
	{
		0, 0, -2,

		0, -2, -1,
		-2, -1, -1, 0, -1, -1,
		0, 0, -1,

		-1, -1, 0,
		-1, 0, 0, 1, 0, 0,
		-1, 1, 0,

		-1, -1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"deformed walker"},
#endif
	{
		-1, -2, -1,
		-2, -1, -1, -1, -1, -1,
		0, 0, -1, 1, 0, -1,

		-2, -2, 0,
		-1, -1, 0,
		0, 0, 0,
		0, 1, 0, 1, 1, 0,
		127
	},
#ifdef LIFE_NAMES
	{"flattened snake"},
#endif
	{
		-2, 0, -1, -1, 0, -1, 0, 0, -1,
		-1, 1, -1, 0, 1, -1,

		-1, -2, 0, 0, -2, 0,
		-1, -1, 0, 0, -1, 0, 1, -1, 0,
		127
	},
#ifdef LIFE_NAMES
	{"open_wide"},
#endif
	{
		-1, -1, -2,

		-1, -1, -1, 0, -1, -1,
		-1, 1, -1, 0, 1, -1,

		-1, -1, 0, 0, -1, 0,
		-1, 1, 0, 0, 1, 0,

		0, 1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"peek-a-boo"},
#endif
	{
		0, 0, -2,

		-1, 0, -1, 0, 0, -1,
		-1, 1, -1, 0, 1, -1,

		0, -2, 0,
		-1, -1, 0, 0, -1, 0,

		-1, -1, 1, 0, -1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"roll over"},
#endif
	{
		-1, -2, -1,
		-2, -1, -1, 0, -1, -1,
		-1, 0, -1, 1, 0, -1,
		0, 1, -1,

		-1, -1, 0, 0, -1, 0,
		-1, 0, 0, 0, 0, 0,
		127
	},
#ifdef LIFE_NAMES
	{"switch"},
#endif
	{
		0, -1, -1,
		0, 0, -1,

		0, -2, 0,
		0, -1, 0,
		-1, 0, 0,
		0, 1, 0,

		-1, -1, 1, 0, -1, 1,
		-1, 0, 1, 0, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"tiny star"},
#endif
	{
		-1, 0, -1, 0, 0, -1,
		0, 1, -1,

		1, -1, 0,
		-1, 0, 0, 1, 0, 0,
		-1, 1, 0,

		0, -1, 1,
		0, 0, 1, 1, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"confused pile driver"},
#endif
	{
		0, -1, -1, 1, -1, -1,
		-1, 0, -1, 1, 0, -1,
		-1, 1, -1, 0, 1, -1,

		-1, -1, 0, 0, -1, 0,
		-1, 0, 0, 1, 0, 0,
		0, 1, 0, 1, 1, 0,
		127
	},
#ifdef LIFE_NAMES
	{"spinning table"},
#endif
	{
		-1, -1, -2,
		-1, 0, -2,
		0, -2, -1,
		-1, -1, -1,
		-1, 0, -1,
		0, 1, -1,
		0, -2, 0,
		-1, -1, 0,
		-1, 0, 0,
		0, 1, 0,
		-1, -1, 1,
		-1, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"H (p3)"},
#endif
	{
		-1, 0, -1, 1, 0, -1,

		-1, 0, 0, 0, 0, 0, 1, 0, 0,

		-1, 0, 1, 1, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"waving tail (p3)"},
#endif
	{
		-1, -1, -1, 0, -1, -1, 1, -1, -1,

		-1, 0, -1, 0, 0, -1, 1, 0, -1,

		0, -1, 0,
		0, 0, 0, 1, 0, 0,
		127
	},
#ifdef LIFE_NAMES
	{"door swing (p4)"},
#endif
	{
		0, -1, -1,
		0, 0, -1,

		0, -2, 0,
		-1, -1, 0, 0, -1, 0,
		0, 0, 0,
		0, 1, 0,

		-1, -1, 1,
		-1, 0, 1, 0, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"legs (p4)"},
#endif
	{
		-1, -1, -2,
		-1, 0, -2,

		-1, -2, -1,
		-1, -1, -1,
		0, 0, -1,

		0, -1, 0,
		-1, 0, 0,
		-1, 1, 0,

		-1, -1, 1,
		-1, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"monroe (p4)"},
#endif
	{
		0, -1, -2,

		0, -2, -1,
		-1, -1, -1,
		0, 0, -1,
		0, 1, -1,

		0, -2, 0,
		0, -1, 0,
		-1, 0, 0,
		0, 1, 0,

		0, 0, 1,
		127
	},
#if 0
#ifdef LIFE_NAMES
	{"glider 1 (14 cell diag, p2)"},
#endif
	{
		-1, -1, -1, -1, -1, 0,
		-1, 0, -2, -1, 0, -1, -1, 0, 0, -1, 0, 1,

		0, -1, -1, 0, -1, 0,
		0, 0, -1, 0, 0, 0,

		1, 0, -1, 1, 0, 0,
		127
	},
#endif
#ifdef LIFE_NAMES
	{"glider 2 (16 cell, c/3, p3)"},
#endif
	{
		-1, -1, -1, -1, -1, 1,
		-1, 1, -1, -1, 1, 1,

		0, -2, -1, 0, -2, 1,
		0, -1, -2, 0, -1, 0, 0, -1, 2,
		0, 0, -1, 0, 0, 1,
		0, 1, -2, 0, 1, 0, 0, 1, 2,
		0, 2, -1, 0, 2, 1,
		127
	},
#ifdef LIFE_NAMES
	{"glider 3 (24 cell diag, p2)"},
#endif
	{
		-2, 0, -1, -2, 0, 0,
		-2, 1, -2, -2, 1, -1, -2, 1, 0, -2, 1, 1,

		-1, 0, -1, -1, 0, 0,
		-1, 1, -1, -1, 1, 0,

		0, -2, -1, 0, -2, 0,
		0, -1, -1, 0, -1, 0,
		0, 2, -2, 0, 2, 1,

		1, -2, -2, 1, -2, -1, 1, -2, 0, 1, -2, 1,
		1, -1, -1, 1, -1, 0,

		2, 0, -2, 2, 0, 1,
		127
	}
};

static char patterns_S67B67[][3 * NUMPTS + 1] =
{
#ifdef LIFE_NAMES
	{"S"},
#endif
	{
		0, -1, -1, 1, -1, -1,
		-1, 0, -1, 0, 0, -1,

		0, -1, 0, 1, -1, 0,
		-1, 0, 0, 0, 0, 0,
		127
	},
#ifdef LIFE_NAMES
	{"S1"},
#endif
	{
		0, -1, -1, 1, -1, -1,
		0, 0, -1,

		-1, -1, 0, 0, -1, 0, 1, -1, 0,
		-1, 0, 0, 0, 0, 0,
		127
	},
#ifdef LIFE_NAMES
	{"S2"},
#endif
	{
		0, -1, -1, 1, -1, -1,
		-1, 0, -1, 0, 0, -1,

		-1, -1, 0, 0, -1, 0, 1, -1, 0,
		0, 0, 0,
		127
	},
#ifdef LIFE_NAMES
	{"T"},
#endif
	{
		1, 0, -1,

		1, -1, 0,
		-1, 0, 0, 0, 0, 0, 1, 0, 0,
		1, 1, 0,

		1, 0, 1,
		1, 1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"arrow"},
#endif
	{
		0, -1, -1,
		-1, 0, -1, 0, 0, -1,
		1, 1, -1,

		0, -1, 0,
		-1, 0, 0, 0, 0, 0,
		1, 1, 0,
		127
	},
#ifdef LIFE_NAMES
	{"runner"},
#endif
	{
		-1, -1, -1, 0, -1, -1,
		-2, 0, -1, -1, 0, -1,

		-2, -1, 0, -1, -1, 0,
		-1, 0, 0, 0, 0, 0,
		127
	},
#ifdef LIFE_NAMES
	{"walker"},
#endif
	{
		0, -1, -1,
		-1, 0, -1, 0, 0, -1, 1, 0, -1,

		-1, -1, 0, 0, -1, 0, 1, -1, 0,
		0, 0, 0,
		127
	},
#ifdef LIFE_NAMES
	{"triknot"},
#endif
	{
		0, -1, -1,
		0, 0, -1,

		0, -1, 0,
		-1, 0, 0, 1, 0, 0,
		0, 1, 0, 1, 1, 0,

		-1, 0, 1, 0, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"pile driver"},
#endif
	{
		0, 0, -1, 1, 0, -1,
		1, 1, -1,

		0, -1, 0, 1, -1, 0,
		-1, 0, 0,
		0, 1, 0, 1, 1, 0,

		1, -1, 1,
		0, 0, 1, 1, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"clock"},
#endif
	{
		-1, -1, -2,
		-1, 0, -2,

		-1, -1, -1, 1, -1, -1,
		-1, 0, -1, 1, 0, -1,

		-2, -1, 0, 0, -1, 0,
		-2, 0, 0, 0, 0, 0,

		0, -1, 1,
		0, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"worm sandwich"},
#endif
	{
		-1, 0, -2, 0, 0, -2,

		-1, -1, -1, 0, -1, -1,
		-2, 0, -1,
		-2, 1, -1, -1, 1, -1, 0, 1, -1,

		-1, -1, 0, 0, -1, 0, 1, -1, 0,
		1, 0, 0,
		-1, 1, 0, 0, 1, 0,

		-1, 0, 1, 0, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"worm sandwich2"},
#endif
	{
		-1, -1, -2,

		-1, -2, -1, 0, -2, -1,
		-2, -1, -1, 1, -1, -1,
		-1, 0, -1, 0, 0, -1, 1, 0, -1,

		-2, -2, 0, -1, -2, 0, 0, -2, 0,
		-2, -1, 0, 1, -1, 0,
		-1, 0, 0, 0, 0, 0,

		0, -1, 1,
		127
	},
#ifdef LIFE_NAMES
	{"triple switch"},
#endif
	{
		-1, 0, -2,

		0, -2, -1,
		-1, -1, -1, 0, -1, -1,
		-1, 0, -1, 1, 0, -1,

		-2, -1, 0, -1, -1, 0,
		-1, 1, 0, 1, 1, 0,
		1, 2, 0,

		0, -1, 1,
		1, 0, 1, 2, 0, 1,
		0, 1, 1, 1, 1, 1,

		0, 1, 2,
		127
	},
#ifdef LIFE_NAMES
	{"3 switch"},
#endif
	{
		-1, 0, -2, 0, 0, -2,

		0, -2, -1,
		-1, -1, -1, 1, -1, -1,
		1, 0, -1,
		-1, 1, -1, 0, 1, -1,

		0, -2, 0,
		-2, -1, 0, 1, -1, 0,
		-2, 0, 0, 1, 0, 0,
		-1, 1, 0, 0, 1, 0,

		-1, -1, 1, 0, -1, 1,
		-1, 0, 1, 0, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"knot switch"},
#endif
	{
		-1, 0, -2,

		0, -2, -1, -1, -1, -1, 0, -1, -1,
		-1, 0, -1, 1, 0, -1,
		-2, -1, 0, -1, -1, 0,
		-1, 1, 0, 1, 1, 0,
		1, 2, 0,

		0, -1, 1,
		1, 0, 1, 2, 0, 1,
		0, 1, 1, 2, 1, 1,
		1, 2, 1,

		0, 1, 2, 1, 1, 2,
		127
	},
#ifdef LIFE_NAMES
	{"2 arrows"},
#endif
	{
		-2, -1, -1, 1, -1, -1,
		-4, 0, -1, -3, 0, -1, -1, 0, -1, 0, 0, -1, 2, 0, -1, 3, 0, -1,
		-3, 1, -1, 2, 1, -1,

		-2, -1, 0, 1, -1, 0,
		-4, 0, 0, -3, 0, 0, -1, 0, 0, 0, 0, 0, 2, 0, 0, 3, 0, 0,
		-3, 1, 0, 2, 1, 0,
		127
	},
#ifdef LIFE_NAMES
	{"fat walker"},
#endif
	{
		-1, -1, -2, 0, -1, -2,
		-1, 0, -2, 0, 0, -2,

		-1, -2, -1,
		-2, -1, -1, 1, -1, -1,
		-2, 0, -1, 1, 0, -1,
		-1, 1, -1,

		0, -2, 0,
		-2, -1, 0, 1, -1, 0,
		-2, 0, 0, 1, 0, 0,
		0, 1, 0,

		-1, -1, 1, 0, -1, 1,
		-1, 0, 1, 0, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"walking box"},
#endif
	{
		-1, -1, -2,
		0, 0, -2,

		-1, -2, -1, 0, -2, -1,
		-2, -1, -1, 1, -1, -1,
		-2, 0, -1, 1, 0, -1,
		-1, 1, -1, 0, 1, -1,

		-1, -2, 0, 0, -2, 0,
		-2, -1, 0, 1, -1, 0,
		-2, 0, 0, 1, 0, 0,
		-1, 1, 0, 0, 1, 0,

		-1, -1, 1,
		0, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"spinning box"},
#endif
	{
		-1, -1, -2, 0, -1, -2,
		-1, 0, -2, 0, 0, -2,

		0, -2, -1,
		-2, -1, -1, 1, -1, -1,
		-2, 0, -1,
		-1, 1, -1, 0, 1, -1,

		-1, -2, 0, 0, -2, 0,
		-2, -1, 0, 1, -1, 0,
		-2, 0, 0, 1, 0, 0,
		-1, 1, 0, 0, 1, 0,

		-1, -1, 1, 0, -1, 1,
		0, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"double knot"},
#endif
	{
		-1, -1, -2, 0, -1, -2,

		-1, -2, -1,
		-2, -1, -1, 0, -1, -1,
		-2, 0, -1, -1, 0, -1,
		0, 1, -1,

		-1, -2, 0,
		-1, -1, 0, 1, -1, 0,
		1, 1, 0, 2, 1, 0,

		-1, 0, 1, 1, 0, 1,
		0, 1, 1, 2, 1, 1,
		0, 2, 1, 1, 2, 1,

		1, 0, 2,
		1, 1, 2,
		127
	},
#ifdef LIFE_NAMES
	{"planetary war"},
#endif
	{
		-1, -1, -2, 0, -1, -2,
		-1, 0, -2,

		-1, -2, -1, 0, -2, -1,
		-2, -1, -1, 1, -1, -1,
		-2, 0, -1, 1, 0, -1,
		-1, 1, -1, 0, 1, -1,

		-1, -2, 0,
		-2, -1, 0, 1, -1, 0,
		1, 0, 0,
		-1, 1, 0, 0, 1, 0,

		-1, -1, 1, 0, -1, 1,
		-1, 0, 1, 0, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"fat walker2"},
#endif
	{
		-1, -1, -2, 0, -1, -2,
		-1, 0, -2, 0, 0, -2,

		-1, -2, -1, 0, -2, -1,
		-2, -1, -1, 1, -1, -1,
		-2, 0, -1, 1, 0, -1,
		0, 1, -1,

		-1, -2, 0, 0, -2, 0,
		-2, -1, 0, 1, -1, 0,
		-2, 0, 0, 1, 0, 0,
		-1, 1, 0,

		-1, -1, 1, 0, -1, 1,
		-1, 0, 1, 0, 0, 1,
		127
	},
#ifdef LIFE_NAMES
	{"pop change"},
#endif
	{
		0, 0, -2,

		0, -1, -1,
		-1, 0, -1, 2, 0, -1,
		0, 1, -1, 1, 1, -1,

		0, -2, 0,
		-1, -1, 0, 1, -1, 0,
		-2, 0, 0, 2, 0, 0,
		-1, 2, 0, 0, 2, 0, 1, 2, 0,

		1, -1, 1,
		-1, 0, 1, 2, 0, 1,
		-1, 1, 1, 1, 1, 1,

		0, -1, 2,
		0, 0, 2,
		0, 1, 2,
		127
	},
#ifdef LIFE_NAMES
	{"large pile driver"},
#endif
	{
		-1, -2, -1, 0, -2, -1, 1, -2, -1,
		-2, -1, -1, -1, -1, -1, 1, -1, -1, 2, -1, -1,
		-2, 0, -1, 2, 0, -1,
		-2, 1, -1, -1, 1, -1, 1, 1, -1, 2, 1, -1,
		-1, 2, -1, 0, 2, -1, 1, 2, -1,

		0, -2, 0,
		-1, -1, 0, 1, -1, 0,
		-2, 0, 0, 2, 0, 0,
		-1, 1, 0, 1, 1, 0,
		0, 2, 0,
		127
	},
#ifdef LIFE_NAMES
	{"F"},
#endif
	{
		1, 0, -2, 2, 0, -2,
		-1, 1, -2,
		-1, 2, -2, 1, 2, -2,

		1, -2, -1, 2, -2, -1,
		2, -1, -1,
		2, 0, -1,
		1, 1, -1,
		-1, 2, -1, 1, 2, -1,

		-2, 1, 0,
		-2, 2, 0, -1, 2, 0,

		0, -2, 1, 2, -2, 1,
		-2, -1, 1, 1, -1, 1, 2, -1, 1,
		-1, 1, 1,

		0, -2, 2,
		-2, -1, 2, -1, -1, 2, 0, -1, 2,
		-2, 1, 2, -1, 1, 2,
		127
	},
#ifdef LIFE_NAMES
	{"4Y"},
#endif
	{
		0, -2, -1,
		-2, 0, -1, 2, 0, -1,
		0, 2, -1,

		-1, -2, 0, 0, -2, 0, 1, -2, 0,
		-2, -1, 0, 2, -1, 0,
		-2, 0, 0, 2, 0, 0,
		-2, 1, 0, 2, 1, 0,
		-1, 2, 0, 0, 2, 0, 1, 2, 0,

		-1, -2, 1, 1, -2, 1,
		-2, -1, 1, 0, -1, 1, 2, -1, 1,
		-1, 0, 1, 1, 0, 1,
		-2, 1, 1, 0, 1, 1, 2, 1, 1,
		-1, 2, 1, 1, 2, 1,
		127
	},
#ifdef LIFE_NAMES
	{"blob2"},
#endif
	{
		0, 0, -2, 1, 0, -2, 2, 0, -2,
		0, 1, -2, 1, 1, -2,
		1, 2, -2,

		1, -1, -1,
		2, 0, -1,
		-1, 1, -1,
		1, 2, -1,

		0, -2, 0, 1, -2, 0,
		-2, 0, 0,
		-2, 1, 0, 1, 1, 0,
		-2, 2, 0, -1, 2, 0,

		0, -2, 1, 1, -2, 1, 2, -2, 1,
		-1, -1, 1, 2, -1, 1,
		-2, 0, 1, 1, 0, 1,
		-2, 1, 1, 0, 1, 1,

		0, -2, 2,
		0, -1, 2,
		-2, 1, 2, -1, 1, 2,
		127
	},
#ifdef LIFE_NAMES
	{"stuff"},
#endif
	{
		1, 0, -2, 2, 0, -2,
		0, 1, -2, 1, 1, -2,
		1, 2, -2,

		1, -1, -1, 2, -1, -1,
		2, 0, -1,
		-1, 1, -1,
		-1, 2, -1, 0, 2, -1, 1, 2, -1,

		1, -2, 0,
		2, -1, 0,
		-2, 1, 0,
		-2, 2, 0, -1, 2, 0,

		0, -2, 1, 1, -2, 1, 2, -2, 1,
		-1, -1, 1, 2, -1, 1,
		-2, 0, 1,
		-2, 1, 1,

		0, -2, 2,
		-1, -1, 2, 0, -1, 2,
		-1, 0, 2,
		-2, 1, 2, -1, 1, 2,
		127
	},
#ifdef LIFE_NAMES
	{"3 fins"},
#endif
	{
		0, -2, -2, 1, -2, -2, 2, -2, -2,
		0, -1, -2, 1, -1, -2, 2, -1, -2,
		-2, 0, -2,
		-2, 1, -2,
		-2, 2, -2,
		1, -1, -1,
		-2, 0, -1,
		-2, 1, -1, -1, 1, -1, 0, 1, -1,
		-2, 2, -1,
		-2, -2, 0, -1, -2, 0,
		1, -1, 0,
		1, 0, 0,
		0, 1, 0, 1, 1, 0,
		-2, -2, 1, -1, -2, 1,
		-1, -1, 1,
		-1, 0, 1, 0, 0, 1, 1, 0, 1,
		0, 1, 1, 1, 1, 1,
		-2, -2, 2, -1, -2, 2,
		127
	},
#ifdef LIFE_NAMES
	{"solitare"},
#endif
	{
		-1, -3, -1, 0, -3, -1, 1, -3, -1,
		-3, -1, -1, -1, -1, -1, 1, -1, -1, 3, -1, -1,
		-3, 0, -1, 3, 0, -1,
		-3, 1, -1, -1, 1, -1,
		1, 1, -1, 3, 1, -1,
		-1, 3, -1, 0, 3, -1, 1, 3, -1,

		-1, -3, 0, 0, -3, 0, 1, -3, 0,
		-3, -1, 0, -1, -1, 0, 1, -1, 0, 3, -1, 0,
		-3, 0, 0, 3, 0, 0,
		-3, 1, 0, -1, 1, 0,
		1, 1, 0, 3, 1, 0,
		-1, 3, 0, 0, 3, 0, 1, 3, 0,
		127
	},
#ifdef LIFE_NAMES
	{"tic tac toe"},
#endif
	{
		-3, -3, -1, -2, -3, -1, 1, -3, -1, 2, -3, -1,
		-3, -2, -1, 2, -2, -1,
		-3, 1, -1, 2, 1, -1,
		-3, 2, -1, -2, 2, -1, 1, 2, -1, 2, 2, -1,

		-2, -3, 0, 1, -3, 0,
		-3, -2, 0, -2, -2, 0, -1, -2, 0, 0, -2, 0, 1, -2, 0, 2, -2, 0,
		-2, -1, 0, 1, -1, 0,
		-2, 0, 0, 1, 0, 0,
		-3, 1, 0, -2, 1, 0, -1, 1, 0, 0, 1, 0, 1, 1, 0, 2, 1, 0,
		-2, 2, 0, 1, 2, 0,
		127
	},
#ifdef LIFE_NAMES
	{"square peg"},
#endif
	{
		-1, -4, -1, 0, -4, -1,
		-1, -3, -1, 0, -3, -1,
		-2, -2, -1, 1, -2, -1,
		-4, -1, -1, -3, -1, -1, -1, -1, -1,
	       	  0, -1, -1, 2, -1, -1, 3, -1, -1,
		-4, 0, -1, -3, 0, -1, -1, 0, -1, 0, 0, -1, 2, 0, -1, 3, 0, -1,
		-2, 1, -1, 1, 1, -1,
		-1, 2, -1, 0, 2, -1,
		-1, 3, -1, 0, 3, -1,

		-1, -3, 0, 0, -3, 0,
		-2, -2, 0, 1, -2, 0,
		-3, -1, 0, 2, -1, 0,
		-3, 0, 0, 2, 0, 0,
		-2, 1, 0, 1, 1, 0,
		-1, 2, 0, 0, 2, 0,
		127
	},
#ifdef LIFE_NAMES
	{"large solitare"},
#endif
	{
		-1, -5, -1, 0, -5, -1,
		-3, -3, -1, -2, -3, -1, 1, -3, -1, 2, -3, -1,
		-3, -2, -1, 2, -2, -1,
		-5, -1, -1, 4, -1, -1,
		-5, 0, -1, 4, 0, -1,
		-3, 1, -1, 2, 1, -1,
		-3, 2, -1, -2, 2, -1, 1, 2, -1, 2, 2, -1,
		-1, 4, -1, 0, 4, -1,

		-1, -5, 0, 0, -5, 0,
		-3, -3, 0, -2, -3, 0, 1, -3, 0, 2, -3, 0,
		-3, -2, 0, 2, -2, 0,
		-5, -1, 0, 4, -1, 0,
		-5, 0, 0, 4, 0, 0,
		-3, 1, 0, 2, 1, 0,
		-3, 2, 0, -2, 2, 0, 1, 2, 0, 2, 2, 0,
		-1, 4, 0,
		0, 4, 0,
		127
	},
#ifdef LIFE_NAMES
	{"panckake"},
#endif
	{
		-2, -3, -1, 0, -3, -1, 2, -3, -1,
		-3, -2, -1, 3, -2, -1,
		-3, 0, -1, 3, 0, -1,
		-3, 2, -1, 3, 2, -1,
		-2, 3, -1, 0, 3, -1, 2, 3, -1,

		-2, -3, 0, 0, -3, 0, 2, -3, 0,
		-3, -2, 0, -2, -2, 0, 2, -2, 0, 3, -2, 0,
		-3, 0, 0, 3, 0, 0,
		-3, 2, 0, -2, 2, 0, 2, 2, 0, 3, 2, 0,
		-2, 3, 0, 0, 3, 0, 2, 3, 0,

		-2, -3, 1, 0, -3, 1, 2, -3, 1,
		-3, -2, 1, 3, -2, 1,
		-3, 0, 1, 3, 0, 1,
		-3, 2, 1, 3, 2, 1,
		-2, 3, 1, 0, 3, 1, 2, 3, 1,
		127
	},
#ifdef LIFE_NAMES
	{"arrow beacon (p4)"},
#endif
	{
		1, -2, -2,
		1, -1, -2, 2, -1, -2,
		0, 0, -2,

		1, -2, -1,
		1, -1, -1, 2, -1, -1,
		0, 0, -1,

		-2, 1, 0,
		-2, 2, 0, -1, 2, 0,

		-2, 1, 1, -1, 1, 1,
		-2, 2, 1, -1, 2, 1,
		127
	},
#ifdef LIFE_NAMES
	{"sticks (p4)"},
#endif
	{
		0, 0, -2, 2, 0, -2,
		0, 1, -2,
		0, 2, -2,

		1, -1, -1,
		2, 0, -1,
		-1, 1, -1, 1, 1, -1,

		0, -2, 0, 1, -2, 0, 2, -2, 0,
		-2, 0, 0, 2, 0, 0,
		-2, 2, 0, -1, 2, 0, 0, 2, 0,

		-1, -1, 1, 1, -1, 1,
		-2, 0, 1,
		-1, 1, 1,

		0, -2, 2,
		0, -1, 2,
		-2, 0, 2, 0, 0, 2,
		127
	},
#ifdef LIFE_NAMES
	{"blob (p4)"},
#endif
	{
		-1, -1, -2, 1, -1, -2,
		-1, 0, -2, 1, 0, -2,
		-1, 1, -2,

		-1, -2, -1, 0, -2, -1, 1, -2, -1,
		-2, -1, -1,
		2, 0, -1,
		-2, 1, -1, 1, 1, -1,
		0, 2, -1,

		-2, -1, 0, 2, -1, 0,
		2, 0, 0,
		-2, 1, 0,
		-1, 2, 0, 0, 2, 0,

		-1, -2, 1, 0, -2, 1,
		-2, -1, 1, 1, -1, 1,
		-1, 1, 1, 1, 1, 1,

		0, -1, 2,
		-1, 0, 2, 0, 0, 2,
		127
	},
#ifdef LIFE_NAMES
	{"pump (p4)"},
#endif
	{
		-1, -1, -2, 1, -1, -2,
		-1, 1, -2, 1, 1, -2,

		0, -1, -1,
		-1, 0, -1, 1, 0, -1,
		0, 1, -1,

		-1, -2, 0, 0, -2, 0, 1, -2, 0,
		-2, -1, 0, 2, -1, 0,
		-2, 0, 0, 2, 0, 0,
		-2, 1, 0, 2, 1, 0,
		-1, 2, 0, 0, 2, 0, 1, 2, 0,

		-1, -1, 1, 0, -1, 1, 1, -1, 1,
		-1, 0, 1, 1, 0, 1,
		-1, 1, 1, 0, 1, 1, 1, 1, 1,

		0, -1, 2,
		-1, 0, 2, 1, 0, 2,
		0, 1, 2,
		127
	},
#ifdef LIFE_NAMES
	{"corner (p4)"},
#endif
	{
		1, 1, -3,
		1, 2, -3,

		1, 1, -2, 2, 1, -2,
		1, 2, -2, 2, 2, -2,

		1, 1, -1,
		2, 2, -1,

		1, 2, 0, 2, 2, 0,

		1, -3, 1, 2, -3, 1,
		1, -2, 1, 2, -2, 1,
		1, -1, 1,
		2, 0, 1,
		-3, 1, 1, -2, 1, 1, -1, 1, 1, 3, 1, 1,
		-2, 2, 1,
		1, 3, 1, 2, 3, 1,

		1, -2, 2, 2, -2, 2,
		2, -1, 2,
		2, 0, 2,
		-3, 1, 2, -2, 1, 2, 0, 1, 2, 3, 1, 2,
		-2, 2, 2, -1, 2, 2, 0, 2, 2, 2, 2, 2,

		1, 1, 3,
		1, 2, 3,
		127
	},
#ifdef LIFE_NAMES
	{"corner2 (p4)"},
#endif
	{
		-2, -1, -3, -1, -1, -3,

		-1, -3, -2,
		-2, -2, -2, 0, -2, -2, 2, -2, -2, 3, -2, -2,
		1, -1, -2, 2, -1, -2,
		-2, 0, -2, -1, 0, -2,
		-1, 1, -2,
		-2, 2, -2, -1, 2, -2,
		-2, 3, -2, -1, 3, -2,

		-1, -3, -1,
		-3, -2, -1, 0, -2, -1, 1, -2, -1, 2, -2, -1, 3, -2, -1,
		-3, -1, -1, 2, -1, -1,
		-2, 1, -1,
		-2, 2, -1, -1, 2, -1,

		-2, -2, 0,
		-2, -1, 0,

		-1, -2, 1,
		-2, -1, 1,

		-2, -2, 2, -1, -2, 2,
		-2, -1, 2, -1, -1, 2,

		-2, -2, 3,
		-2, -1, 3,
		127
	},
#ifdef LIFE_NAMES
	{"shuttlecock (p8)"},
#endif
	{
		-1, -2, -3,
		-2, -1, -3, 0, -1, -3,

		-1, -3, -2,
		-2, -2, -2, 0, -2, -2,
		-3, -1, -2, 1, -1, -2,
		-2, 0, -2,
		-1, 1, -2, 0, 1, -2,
		1, 1, -2,

		-2, -3, -1,
		-3, -2, -1, 1, -2, -1,
		1, -1, -1,
		-3, 0, -1, 1, 0, -1,
		-2, 1, -1, -1, 1, -1,
		0, 2, -1,

		-1, -3, 0,
		-2, -2, 0, 1, -2, 0,
		2, -1, 0,
		-1, 1, 0, 1, 1, 0,

		-1, -2, 1, 1, -2, 1,
		-2, -1, 1, -1, -1, 1,
		0, -1, 1,
		-2, 0, 1, 1, 0, 1,
		-2, 1, 1, 0, 1, 1,

		-1, 0, 2,
		127
	}
};

#ifdef LIFE_NAMES
#define DIV 2
#else
#define DIV 1
#endif

static int  patterns_rules[] =
{
	(sizeof patterns_S45B5 / sizeof patterns_S45B5[0]) / DIV,
	(sizeof patterns_S567B6 / sizeof patterns_S567B6[0]) / DIV,
	(sizeof patterns_S56B5 / sizeof patterns_S56B5[0]) / DIV,
	(sizeof patterns_S678B5 / sizeof patterns_S678B5[0]) / DIV,
	(sizeof patterns_S67B67 / sizeof patterns_S67B67[0]) / DIV
};

static paramstruct param_rules[] =
{
	{0x30, 0x20},
	{0xE0, 0x40},
	{0x60, 0x20},
	{0x1C0, 0x20},
	{0xC0, 0xC0}
};

#define LIFE_S45B5 0
#define LIFE_S567B6 1
#define LIFE_S56B5 2
#define LIFE_S678B5 3
#define LIFE_GLIDERS 4	/* GLIDER rules are first in param_rules */
#define LIFE_S67B67 4
#define LIFE_RULES (sizeof patterns_rules / sizeof patterns_rules[0])
