/* $Id: cfgfile.h,v 1.19 2004/01/02 03:54:01 fesnel Exp $ */
/*******************************************************************************
 *   This program is part of a library used by the Archimedes email client     * 
 *                                                                             *
 *   Copyright : (C) 1995-1998 Gennady B. Sorokopud (gena@NetVision.net.il)    *
 *               (C) 1995 Ugen. J. S. Antsilevich (ugen@latte.worldbank.org)   *
 *               (C) 1998-2004 by the Archimedes Project                       *
 *                   http://sourceforge.net/projects/archimedes                *
 *                                                                             *
 *             --------------------------------------------                    *
 *                                                                             *
 *   This program is free software; you can redistribute it and/or modify      *
 *   it under the terms of the GNU Library General Public License as published *
 *   by the Free Software Foundation; either version 2 of the License, or      *
 *   (at your option) any later version.                                       *
 *                                                                             *
 *   This program is distributed in the hope that it will be useful,           *
 *   but WITHOUT ANY WARRANTY, without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 *   GNU Library General Public License for more details.                      *
 *                                                                             *
 *   You should have received a copy of the GNU Library General Public License *
 *   along with this program; if not, write to the Free Software               *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston MA 02111-1307, USA.  *
 *                                                                             *
 ******************************************************************************/

#ifndef _CFGFILE_H_
#define _CFGFILE_H_

using namespace std;

#include <string>

#include <cassert>

#include <config.h>
#include <umail.h>

#define SECFILEMODE 00600	 /* secure mode on file */

#ifdef ARCHIMEDES
    #define GLOBAL_MAILRC 	"/etc/archimedes.mailrc" /* global configuration file */
    #define GLOBAL_DEFAULTS	"/etc/archimedes.defaults"   /* global defaults file */
#endif

#ifdef XFMAIL
    #define GLOBAL_MAILRC 	"/etc/xfmail.mailrc" /* global configuration file */
    #define GLOBAL_DEFAULTS	"/etc/xfmail.defaults"   /* global defaults file */
#endif

typedef map<string, string> mapType;

class cfgfile {

public:

	cfgfile();
	cfgfile(cfgfile const &config);

	~cfgfile();

	cfgfile const &operator= (cfgfile const &rhs);

	int save(int ask);
	int save_file(char * file, int ask);
	int size();
	int sizeSaved();
	int load(char * fn);
	int check_version();
	void setFlags(char * ln,int flags);
	int getInt(string ln,int def);
	int getIntDefault(string ln, int def, int return_default);
	bool exist(string ln);
	void read_xfdefaults();
	bool set(string key, string val);
	bool set(string key, int val);
	bool remove(string key);
	string get(string key, string def);
    string get(string ln, string def, int return_default);
	string getString(string ln,string def);
	string getStringDefault(string ln, string def, int return_default);

	void print();

    cfgfile & Singleton();

private:

	unsigned int hash(char * cfgstr);
	bool add(string, string);
	string find(string);
	void addLine(char *);
	void clear();
	void destroy();
	int lock(char * file, const char * mode);
	int unlock(char * file);

	FILE *cfile;
	char fname[MAXPATHLEN];
	int changedKeys;
	int changedFlags;

	int saved;

	mapType Map;

};

#endif
