#include "help.h"

// Help text
const char helptext[]=

"\n"
"\n"
"                                          XFE, X File Explorer File Manager\n"
"\n"
"                                       Copyright (C) 2002-2006 Roland Baudin\n"
"\n"
"                                            <http://roland65.free.fr/xfe>\n"
"                                        <http://sourceforge.net/projects/xfe>\n"
"\n"
"\n"
"\n"
"\n"

"This program is free software; you can redistribute it and/or modify "
"it under the terms of the GNU General Public License as published by "
"the Free Software Foundation; either version 2, or (at your option) "
"any later version.\n"
"\n"
"\n"


"This program is distributed in the hope that it will be useful, "
"but WITHOUT ANY WARRANTY; without even the implied warranty of "
"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the " 
"GNU General Public License for more details.\n"
"\n"
"\n"
  
"  Description\n"
"  =-=-=-=-=-=\n"
"\n"
"X File Explorer (xfe) is a lightweight file manager for X11, written using the FOX toolkit.\n"
"It is desktop independent and can easily be customized.\n"
"It has Windows Commander or MS-Explorer style and it is very fast and small.\n"
"Xfe is based on the popular, but discontinued X Win Commander, written by Maxim Baranov.\n"
"\n"
"\n"

"  Features\n"
"  =-=-=-=-=\n"
"\n"
"  - Very fast graphic user interface\n"
"  - Commander/Explorer interface with four file manager modes : one panel, a directory tree \n"
"    and one panel, two panels or a directory tree and two panels\n"
"  - Integrated text viewer (X File View, xfv)\n"
"  - Integrated image viewer (X File Image, xfi)\n"
"  - Integrated RPM viewer / installer / uninstaller (X File Query, xfq)\n"
"  - Status line\n"
"  - File associations\n"
"  - Optional trash can for file delete operations (trash can directory is ~/.xfetrash,\n"
"    deleted file names have the form 'filename__YYYY-MM-DD-HH:MM:SS-s')\n"
"  - Auto save registry\n"
"  - Right mouse click pop-up menu in tree list and file list\n"
"  - Change file(s) attributes\n"
"  - Mount/Unmount devices (for Linux only)\n"
"  - Toolbar\n"
"  - Bookmarks\n"
"  - Color schemes (GNOME, KDE, Windows...)\n"
"  - Drag and Drop in Xfe and from and to your favorite desktop\n"
"  - Create / Extract archives (tar, zip, gzip, bzip2, compress formats are supported)\n"
"  - Tool tips for long file names\n"
"  - Progress bars or dialogs for lengthy file operations\n"
"  - Thumbnails image previews\n"
"\n"
"\n"

"  Key bindings:\n"
"  =-=-=-=-=-=\n"
"\n"
"    o Help                         - F1\n"
"    o New file                     - F2\n"
"    o New window                   - F3\n"
"    o View                         - return\n"
"    o Edit                         - F4\n"
"    o Copy                         - F5, Ctrl-c\n"
"    o Cut                          - Ctrl-x\n"
"    o Paste                        - Ctrl-v\n"
"    o Move                         - F6, Ctrl-d\n"
"    o Symlink                      - Ctrl-s\n"
"    o Rename                       - Ctrl-n\n"
"    o New folder                   - F7\n"
"    o Open                         - Ctrl-o\n"
"    o Delete                       - F8, del\n"
"    o Go up                        - backspace\n"
"    o Properties                   - F9\n"
"    o One panel                    - Ctrl-F1\n"
"    o Tree and one panel           - Ctrl-F2\n"
"    o Two panels                   - Ctrl-F3\n"
"    o Tree and two panels          - Ctrl-F4\n"
"    o Large icons                  - F10\n"
"    o Small icons                  - F11\n"
"    o Detailed view                - F12\n"
"    o Hidden folders               - Ctrl-F5\n"
"    o Hidden files                 - Ctrl-F6\n"
"    o Thumbnails preview           - Ctrl-F7\n"
"    o Execute                      - Ctrl-e\n"
"    o Go home                      - Ctrl-h\n"
"    o Terminal                     - Ctrl-t\n"
"    o Refresh                      - Ctrl-r\n"
"    o Select all                   - Ctrl-a\n"
"    o Deselect all                 - Ctrl-z\n"
"    o Invert selection             - Ctrl-i\n"
"    o Add bookmark                 - Ctrl-b\n"
"    o Mount (Linux only)           - Ctrl-m\n"
"    o Unmount (Linux only)         - Ctrl-u\n"
"    o Open file panel context menu - Shift-F10\n"
"    o Empty trash can              - Ctrl-del\n"
"    o Quit                         - Ctrl-q, Ctrl-w\n"

"\n"
"\n"
"  Drag and Drop operations :\n"
"  =-=-=-=-=-=-=-=-=-=-=-=-=-=\n"
"\n"
"    o Drag copy   - Ctrl + mouse left button\n"
"    o Drag move   - Shift + mouse left button, or simply mouse left button\n"
"    o Drag link   - Ctrl + Shift + mouse left button\n"

"\n"
"\n"

"  Configuration\n"
"  =-=-=-=-=-=-=\n"
"\n"
"You can perform any Xfe customization (layout, file associations, ...) without editing "
"any file by hand. However, you may want to know how the FOX registry works, "
"because some customizations can easily be done by editing the configurations files. "
"Be careful to quit Xfe before hand editing any registry file, otherwise changes could not be "
"taken into account.\n"
"\n"
"The system-wide configuration file Desktop (which is a registry file) is located in /etc/foxrc, "
"or /usr/lib/foxrc, or /usr/local/lib/foxrc, in the given order of precedence.\n"
"\n"
"Since version 0.82, local registry files for Xfe, Xfv, Xfi, Xfq are located in "
"the ~/.foxrc/XFileExplorer directory.\n"
 "\n" 
"Every FOX application reads the file Desktop, but Xfe is specific to the X File Explorer.\n"
"\n"
"Since version 0.88, the system-wide configuration file Desktop is at first run copied "
"into the local registry file ~/.foxrc/XFileExplorer/Xfe\n"
"It is thus easier to customize Xfe (this is particularly true for the file associations) "
"by hand editing because all the local options are located in the same registry file.\n"
"\n"
"PNG Icons are in /usr/local/lib/foxicons. You can change the path in Options->Change icon path. " 
"(You may want to change it, if Xfe is not installed in /usr/local.)\n"
"\n"
"\n"

"  Tips\n"
"  =-=-=\n"
"\n"
"File list\n"
"   - Select files and right click to open a context menu on the selected files\n"
"   - Press Ctrl + right click to open a context menu on the file panel\n"
"   - When dragging a file/folder to a folder, hold on the mouse \n"
"     on the folder to open it\n"
"\n"
"Tree list\n"
"   - Select a folder and right click to open a context menu on the selected folder\n"
"   - When dragging a file/folder to a folder, hold on the mouse on the folder \n"
"     to expand it\n"
"\n"
"\n"

"  Bugs\n"
"  =-=-=\n"
"\n"
"Please report bugs to me (roland65@free.fr).\n"
"\n"
"\n"

"  Translations\n"
"  =-=-=-=-=-=-=\n"
"\n"
"To translate Xfe to your language, open the xfe.pot file in the po directory \n"
"of the source tree and fill it with your translated strings, and then send \n"
"it back to me.\n"
"\n"
"\n"

"  Patches\n"
"  =-=-=-=\n"
"\n"
"If you've done some interesting patch, please send it to me, "
" I will try to include it in the next release...\n"
"\n"

"[Many thanks to Maxim Baranov for his excellent X Win Commander "
"and to all people that have provided useful patches and advices.]\n"
"\n"
;
