/*
 *	xeno_theme_main.h
 */

#ifndef XENO_THEME_MAIN_H
#define XENO_THEME_MAIN_H

/*
 *	Glib and GTK stuff
 */
#define	G_LOG_DOMAIN	"Xenophilia-Theme"

#ifndef G_DISABLE_CHECKS
#if 0
#define G_DISABLE_CHECKS
#endif
#endif

#include <math.h>
#include <gtk/gtk.h>

#if GTK_CHECK_VERSION(1, 3, 2)
#define XENO_GTK2		1
#else
#define XENO_GTK2		0
#endif

#if defined(__GNUC__) && !defined(__STRICT_ANSI__)
#define XENO_GNUC		1
#else
#define	XENO_GNUC		0
#endif

#if XENO_GNUC || defined(__cplusplus)
#define	XENO_INLINE		inline
#else
#define	XENO_INLINE		/* empty */
#endif

/*
 *	Useful macros
 */
#ifndef M_PI
#define M_PI    3.1415926535897932384626433
#endif
#ifndef M_PI_4
#define M_PI_4  0.78539816339744830962
#endif
#define XENO_EPSILON 1.0e-5

#ifdef LERP
#undef LERP
#endif
#define LERP(a, b, f)		((a) + (f) * ((b) - (a)))

/*
 *	Exported from xeno_theme_main.c
 */
extern		gboolean		xeno_pseudocolor;
extern		GdkVisual		*xeno_visual;
extern		GdkColormap		*xeno_colormap;

#endif /* XENO_THEME_MAIN_H */

