/*
 *	xeno_theme_color.h
 */

#ifndef XENO_THEME_COLOR_H
#define XENO_THEME_COLOR_H

#include "xeno_theme_main.h"
#include "xeno_theme_enums.h"

/*
 *	XenoColor
 */

typedef struct {
	gfloat	red, green, blue;
} XenoColor;

#define xeno_color_from_gdk(color, src) \
	{ \
		const gfloat f = 1.0/65535.0; \
		(color)->red   = f * (src)->red; \
		(color)->green = f * (src)->green; \
		(color)->blue  = f * (src)->blue; \
	}

#define xeno_color_to_gdk(src, dst) \
	{ \
		gint32 red, green, blue; \
		red   = (src)->red   * 65535.0; \
		green = (src)->green * 65535.0; \
		blue  = (src)->blue  * 65535.0; \
		(dst)->red   = CLAMP(red,   0, 0x0ffff); \
		(dst)->green = CLAMP(green, 0, 0x0ffff); \
		(dst)->blue  = CLAMP(blue,  0, 0x0ffff); \
	}

#define xeno_color_init(color, _red, _green, _blue) \
	(color)->red   = (_red); \
	(color)->green = (_green); \
	(color)->blue  = (_blue);

#define xeno_color_blend(a, b, k, dst) \
	(dst)->red   = LERP((a)->red,	(b)->red,   (k));\
	(dst)->green = LERP((a)->green, (b)->green, (k));\
	(dst)->blue  = LERP((a)->blue,	(b)->blue,  (k));

#define xeno_color_flip(a, b, c, d) \
	(d)->red   = (a)->red   - ((b)->red   - (c)->red); \
	(d)->green = (a)->green - ((b)->green - (c)->green); \
	(d)->blue  = (a)->blue  - ((b)->blue  - (c)->blue);

void	xeno_color_shade	(const XenoColor *src, gfloat k, XenoColor *dst);
void	xeno_color_dither	(const XenoColor *src, const GdkVisual *visual, gint x, gint y, GdkColor *dst);

extern const guchar xeno_dither_table[16][16];

#define xeno_dither(x, y)	(xeno_dither_table[x & 0x0f][y & 0x0f] * (1.0/255.0))


/*
 *	Pixmap remapping
 */

/*
	FIXME:	Shouldn't this be in xeno_theme_style, with the actual pixmap remapping
			functions exported?
*/

/*
GdkPixmap *	xeno_image_get		(GtkStyle		*style,
								 GdkWindow		*window,
								 XenoImageType	image_type,
								 const GtkStyle *parent_style,
								 GdkBitmap		**mask_p);
*/

GdkBitmap *	xeno_image_mask		(XenoImageType	i);
void		xeno_image_ref		(XenoImageType	image_type);
void		xeno_image_unref	(XenoImageType	image_type);

GdkPixmap * xeno_pixmap_get (GdkWindow *window, GtkStyle *style,
							 const GtkStyle *style2, XenoImageType image_type);

XenoColor *	xeno_pixmap_get_average_color (GdkPixmap *pixmap, GdkVisual *visual, XenoColor *color);


#endif /* XENO_THEME_COLOR_H */

