/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterConstants;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.ReturnControl;
import bsh.SimpleNode;

public class ASTForStatement
extends SimpleNode
implements InterpreterConstants {
    public boolean hasForInit;
    public boolean hasExpression;
    public boolean hasForUpdate;
    private SimpleNode forInit;
    private SimpleNode expression;
    private SimpleNode forUpdate;
    private SimpleNode statement;
    private boolean parsed;

    ASTForStatement(int n) {
        super(n);
    }

    public Object eval(NameSpace nameSpace, Interpreter interpreter) throws EvalError {
        int n = 0;
        if (this.hasForInit) {
            this.forInit = (SimpleNode)this.jjtGetChild(n++);
        }
        if (this.hasExpression) {
            this.expression = (SimpleNode)this.jjtGetChild(n++);
        }
        if (this.hasForUpdate) {
            this.forUpdate = (SimpleNode)this.jjtGetChild(n++);
        }
        if (n < this.jjtGetNumChildren()) {
            this.statement = (SimpleNode)this.jjtGetChild(n);
        }
        if (this.hasForInit) {
            this.forInit.eval(nameSpace, interpreter);
        }
        while (!this.hasExpression || this.evaluateCondition(this.expression, nameSpace, interpreter)) {
            Object object;
            boolean bl = false;
            if (this.statement != null && (object = this.statement.eval(nameSpace, interpreter)) instanceof ReturnControl) {
                switch (((ReturnControl)object).kind) {
                    case 40: {
                        return object;
                    }
                    case 11: {
                        bl = true;
                        break;
                    }
                }
            }
            if (bl) break;
            if (!this.hasForUpdate) continue;
            this.forUpdate.eval(nameSpace, interpreter);
        }
        return Primitive.VOID;
    }

    private boolean evaluateCondition(SimpleNode simpleNode, NameSpace nameSpace, Interpreter interpreter) throws EvalError {
        Object object = simpleNode.eval(nameSpace, interpreter);
        if (object instanceof Primitive) {
            object = ((Primitive)object).getValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        throw new EvalError("Condition must evaluate to a Boolean or boolean.", this);
    }
}

