#include <qwidget.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qdialog.h>
#include <qcolor.h>
#include <qfont.h>
#include <qnamespace.h>

#include "render2d.h"
#include "graphdialog.h"
#include "graphdata.h"

GraphDialog::GraphDialog(QWidget *parent, QString name) : 
	QDialog(parent, name, TRUE)
{
  setBackgroundColor(lightGray);
  setCaption(name);
  g = new GraphWidget(this, "NMR goes here");
  g->setBackgroundColor(QColor(255,255,255));
  g->setGeometry(0,0,600,500);
  //QPushButton *showhide = new QPushButton("Show/hide molecule", this);
  //showhide->setGeometry(20,320,150,40);
  //showhide->setPalette(QPalette(lightGray));
  QPushButton *qprint = new QPushButton( tr("Print"), this);
  qprint->setGeometry(20,520,150,40);
  qprint->setPalette(QPalette(lightGray));
  connect(qprint, SIGNAL(clicked()), g, SLOT(Print()) );
  QPushButton *qclose = new QPushButton( tr("Close"), this);
  qclose->setGeometry(360,520,150,40);
  qclose->setPalette(QPalette(lightGray));
  connect(qclose, SIGNAL(clicked()), SLOT(accept()));
    QPushButton *qexport = new QPushButton( tr("Export Peak List"), this);
  qexport->setGeometry(190,520,150,40);
  qexport->setPalette(QPalette(lightGray));
  connect(qexport, SIGNAL(clicked()), g, SLOT(Export()) );

  if (name.contains("13C-NMR") > 0) g->setDataType(1);
  if (name.contains("IR") > 0) g->setDataType(2);
}

void GraphDialog::AddPeak(double v1, QString l1, QString t1) {
  if (v1 < 0) return;  // negative indicates invalid peak.
  g->AddPeak(v1, l1, t1);
}

void GraphDialog::AddPixmap(QPixmap p1) {
  g->AddPixmap(p1);
}
