#ifndef _XDOTOOL_H_
#define _XDOTOOL_H_

/* TODO(sissel): use proper printf format depending on the storage
 * size of Window (could be 4 or 8 bytes depending on platform */
#define window_print(window) (printf("%ld\n", window))
#define window_each(context, window_arg, block) \
{ \
  Window *windows; \
  int nwindows; \
  window_list(context, window_arg, &windows, &nwindows, False); \
  int w_index;\
  for (w_index = 0; w_index < nwindows; w_index++) { \
    Window window = windows[w_index]; \
    {  \
      block \
    } \
  } \
} /* end define window_each */

  

typedef struct context {
  xdo_t *xdo;
  int argc;
  char **argv;
  Window *windows;
  int nwindows;
  Window window_placeholder[1];
} context_t;

int cmd_click(context_t *context);
int cmd_getwindowfocus(context_t *context);
int cmd_getwindowpid(context_t *context);
int cmd_getactivewindow(context_t *context);
int cmd_help(context_t *context);
int cmd_key(context_t *context);
int cmd_mousedown(context_t *context);
int cmd_mousemove(context_t *context);
int cmd_mousemove_relative(context_t *context);
int cmd_mouseup(context_t *context);
int cmd_getmouselocation(context_t *context);
int cmd_search(context_t *context);
int cmd_type(context_t *context);
int cmd_windowactivate(context_t *context);
int cmd_windowfocus(context_t *context);
int cmd_windowmap(context_t *context);
int cmd_windowmove(context_t *context);
int cmd_windowraise(context_t *context);
int cmd_windowsize(context_t *context);
int cmd_windowunmap(context_t *context);
int cmd_set_window(context_t *context);
int cmd_version(context_t *context);
  
/* pager-like commands */
int cmd_set_num_desktops(context_t *context);
int cmd_get_num_desktops(context_t *context);
int cmd_set_desktop(context_t *context);
int cmd_get_desktop(context_t *context);
int cmd_set_desktop_for_window(context_t *context);
int cmd_get_desktop_for_window(context_t *context);

#endif /* _XDOTOOL_H_ */
