#include "request.h"

Request::Request() {
  in = NULL;
  out = NULL;
  state = UNUSED;

  bodyFromServer = new char[MAX_FILE_SIZE];
  bodyFromServerAllocatedLength = MAX_FILE_SIZE;
  bodyFromServerStart = bodyFromServer;
  bodyFromServerLength = 0;

  bodyToClient = new char[MAX_FILE_SIZE];
  bodyToClientAllocatedLength = MAX_FILE_SIZE;
  bodyToClientStart = bodyToClient;
  bodyToClientLength = 0;

  tempBuffer[0] = '\0';
  tempBufferStart = tempBuffer;
  tempBufferLength = 0;

  bzero(localMD5, 17);
  haveLocalMD5 = false;

  processClientRequestTimer = GTIMER_NEW();
  processClientRequestTime = 0;
  processServerResponseTimer = GTIMER_NEW();
  processServerResponseTime = 0;
  parseResponseHeaderTimer = GTIMER_NEW();
  parseResponseHeaderTime = 0;

  originalSize = 0;
  currentSize = 0;
}

Request::~Request() {
  delete [] bodyFromServer;
  delete [] bodyToClient;
  GTIMER_DESTROY(processClientRequestTimer);
  GTIMER_DESTROY(processServerResponseTimer);
  GTIMER_DESTROY(parseResponseHeaderTimer);
}

void Request::reset() {
  state = UNUSED;

  requestFromClient.reset();
  responseFromServer.reset();

  // Size down the buffer for data from server.
  if (bodyFromServerAllocatedLength > MAX_FILE_SIZE) {
    delete [] bodyFromServer;
    bodyFromServer = new char[MAX_FILE_SIZE];
    bodyFromServerAllocatedLength = MAX_FILE_SIZE;
  }
  bzero(bodyFromServer, MAX_FILE_SIZE); // might want to take this out later after system debugged ???
  bodyFromServerStart = bodyFromServer;
  bodyFromServerLength = 0;

  // Size down the buffer for data to client.
  if (bodyToClientAllocatedLength > MAX_FILE_SIZE) {
    delete [] bodyToClient;
    bodyToClient = new char[MAX_FILE_SIZE];
    bodyToClientAllocatedLength = MAX_FILE_SIZE;
  }
  bzero(bodyToClient, MAX_FILE_SIZE); // might want to take this out later after system debugged ???
  bodyToClientStart = bodyToClient;
  bodyToClientLength = 0;

  tempBuffer[0] = '\0';
  tempBufferStart = tempBuffer;
  tempBufferLength = 0;

  bzero(localMD5, 17);
  haveLocalMD5 = false;
  //ino.minor.ino_type = FT_NotFound;

  processClientRequestTime = 0;
  processServerResponseTime = 0;
  parseResponseHeaderTime = 0;

  originalSize = 0;
  currentSize = 0;
}

HTTPState::HTTPState() {
  method[0] = '\0';
  url[0] = '\0';
  HTTP11 = false;
  HTTPCode = -1;
  server[0] = '\0';
  port = 80;
  resource[0] = '\0';
  reasonPhrase[0] = '\0';
  date = -1;
  expires = -1;
  ifModifiedSince = -1;
  originalIfModifiedSince = -1;
  lastModified = -1;
  contentLength = -1;
  bzero(contentMD5, 17);
  haveContentMD5 = false;
  bzero(deltaBase, 17);
  haveDeltaBase = false;
  strcpy(contentType, "text/html");
  IMXDelta = false;
  aIMXDelta = false;
  connectionClose = false;
  transferEncodingChunked = false;
  contentEncodingGZIP = false;
  acceptEncodingGZIP = false;
  eTag[0] = '\0';
  originalETag[0] = '\0';
  hasCookie = false;
  maxAge = -1;
  additionalHeaders[0] = '\0';
  doneReadingChunks = false;
}

HTTPState::~HTTPState() {
}

void HTTPState::reset() {
  method[0] = '\0';
  url[0] = '\0';
  HTTP11 = false;
  HTTPCode = -1;
  server[0] = '\0';
  port = 80;
  resource[0] = '\0';
  reasonPhrase[0] = '\0';
  date = -1;
  expires = -1;
  ifModifiedSince = -1;
  originalIfModifiedSince = -1;
  lastModified = -1;
  contentLength = -1;
  bzero(contentMD5, 17);
  haveContentMD5 = false;
  bzero(deltaBase, 17);
  haveDeltaBase = false;
  strcpy(contentType, "text/html");
  IMXDelta = false;
  aIMXDelta = false;
  connectionClose = false;
  transferEncodingChunked = false;
  contentEncodingGZIP = false;
  acceptEncodingGZIP = false;
  eTag[0] = '\0';
  originalETag[0] = '\0';
  hasCookie = false;
  maxAge = -1;
  additionalHeaders[0] = '\0';
  doneReadingChunks = false;
}
