#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
/*
#include <sys/times.h>
#include <limits.h>
*/
#include <sys/resource.h>
#include <xdfs_cpp.h>
#include <xdfs_comp.h>
#include <xdelta.h>
#include <edsiostdio.h>

#include <zlib.h>

#define max(a,b) ((a) > (b) ? (a) : (b))
#define min(a,b) ((a) < (b) ? (a) : (b))

#define MAX_FILE_SIZE 200000
#define MAX_LINE 256
#define MAX_NUM_SITES 1000
#define MAX_FILENAME_SIZE 32
#define MAX_INT 1000000

#define GTIMER_NEW() g_timer_new()
#define GTIMER_START(timer) g_timer_reset(timer); g_timer_start(timer)
#define GTIMER_STOP(timer) g_timer_stop(timer)
#define GTIMER_ELAPSED(timer) g_timer_elapsed(timer, NULL)
#define GTIMER_DESTROY(timer) g_timer_destroy(timer)

/*
#define GTIMER_START(timer) START_TIME=gethrvtime()
#define GTIMER_STOP(timer) FINISH_TIME=gethrvtime()
#define GTIMER_ELAPSED(timer) (FINISH_TIME - START_TIME)/1000000000.0
*/

/*
#define GTIMER_START(timer) getrusage(RUSAGE_SELF, &START_TIME)
#define GTIMER_STOP(timer) getrusage(RUSAGE_SELF, &FINISH_TIME)
#define GTIMER_ELAPSED(timer) ((FINISH_TIME.ru_utime.tv_sec - START_TIME.ru_utime.tv_sec)*1000000.0 + (FINISH_TIME.ru_utime.tv_usec - START_TIME.ru_utime.tv_usec) + (FINISH_TIME.ru_stime.tv_sec - START_TIME.ru_stime.tv_sec)*1000000.0 + (FINISH_TIME.ru_stime.tv_usec - START_TIME.ru_stime.tv_usec))/1000000.0
*/

struct statStruct {
  float min;
  float max;
  double sum;
  int counter;
};

struct statStruct2 {
  int min;
  int max;
  long sum;
  int counter;
};

// IMS + compressed1 + delta = IMS + compressed2 + deltaCompressed

struct requestStruct {
  int IMS;
  int compressed1;
  int delta;
  int compressed2;
  int compressedDelta;
};

struct costStruct {
  struct statStruct compress;
  struct statStruct computeDelta;
  struct statStruct computeCompressedDelta;
  struct statStruct applyDelta;
};

struct resultStruct {
  struct statStruct compressed;
  struct statStruct delta;
  struct statStruct compressedDelta;
  struct requestStruct request;
  struct costStruct cost;
  struct statStruct compressedTime;
  struct statStruct deltaTime;
  struct statStruct compressedDeltaTime;
  struct statStruct uncompressedTime;
  struct statStruct appliedDeltaTime;
  struct statStruct uncompressedAppliedDeltaTime;
};

void initializeStatStruct(struct statStruct *stat) {
  stat->min = MAX_INT;
  stat->max = 0;
  stat->sum = 0;
  stat->counter = 0;
}

void initializeStatStruct2(struct statStruct2 *stat) {
  stat->min = MAX_INT;
  stat->max = 0;
  stat->sum = 0;
  stat->counter = 0;
}

void initializeRequestStruct(struct requestStruct *request) {
  request->IMS = 0;
  request->compressed1 = 0;
  request->delta = 0;
  request->compressed2 = 0;
  request->compressedDelta = 0;
}

void initializeCostStruct(struct costStruct *cost) {
  initializeStatStruct(&(cost->compress));
  initializeStatStruct(&(cost->computeDelta));
  initializeStatStruct(&(cost->computeCompressedDelta));
  initializeStatStruct(&(cost->applyDelta));
}

void initializeResultStruct(struct resultStruct *result) {
  initializeStatStruct(&(result->compressed));
  initializeStatStruct(&(result->delta));
  initializeStatStruct(&(result->compressedDelta));
  initializeRequestStruct(&(result->request));
  initializeCostStruct(&(result->cost));
  initializeStatStruct(&(result->compressedTime));
  initializeStatStruct(&(result->deltaTime));
  initializeStatStruct(&(result->compressedDeltaTime));
  initializeStatStruct(&(result->uncompressedTime));
  initializeStatStruct(&(result->appliedDeltaTime));
  initializeStatStruct(&(result->uncompressedAppliedDeltaTime));
}

int generate_delta(char *source, int sourceSize, char *destination, int destinationSize, char *delta, int *deltaSize) {
  FileHandle *sourceHandle, *destinationHandle, *dataHandle, *controlHandle;
  int dataSize, controlSize;
  XdeltaGenerator *gen;
  char *data, *control;
  XdeltaControl *ctrl;
  XdeltaSource *deltaSource;

  // Get file handles.
  if (!(sourceHandle = handle_read_mem((guint8*) source, (guint) sourceSize))) {
    return 0;
  }
  if (!(deltaSource = xdp_source_new(sourceHandle, XS_Primary, NULL))) {
    handle_free(sourceHandle);
    return 0;
  }
  if (!(destinationHandle = handle_read_mem((guint8*) destination, (guint) destinationSize))) {
    handle_free(sourceHandle);
    return 0;
  }
  if (!(dataHandle = handle_write_mem())) {
    handle_free(sourceHandle);
    handle_free(destinationHandle);
    return 0;
  }
  if (!(controlHandle = handle_write_mem())) {
    handle_free(sourceHandle);
    handle_free(destinationHandle);
    handle_free(dataHandle);
    return 0;
  }

  gen = xdp_generator_new();
  xdp_source_add(gen, deltaSource);

  if (!(ctrl = xdp_generate_delta(gen, destinationHandle, controlHandle, dataHandle))) {
    handle_free(sourceHandle);
    handle_free(destinationHandle);
    handle_free(dataHandle);
    handle_free(controlHandle);
    xdp_generator_free(gen);
    return 0;
  }

  handle_close(controlHandle);
  handle_write_mem_result(controlHandle, (const guint8**) &control, (guint*) &controlSize);

  // handle_close(dataHandle);
  handle_write_mem_result(dataHandle, (const guint8**) &data, (guint*) &dataSize);

  *deltaSize = controlSize + dataSize;
  if (delta != NULL) {
    memcpy(delta, control, controlSize);
    memcpy(&(delta[controlSize]), data, dataSize);
  }

  handle_free(controlHandle);
  handle_free(dataHandle);
  //handle_close(sourceHandle);
  //handle_free(sourceHandle); // used to be commented
  handle_close(destinationHandle);
  handle_free(destinationHandle);

  xdp_control_free(ctrl);
  xdp_generator_free(gen);

  return 1;
}

// Returns 1 if successful; otherwise, 0.  Applies delta to the target file and saves result in out if NOT NULL; size of result is returned in outSize.

int apply_delta(char *in, int inSize, char *delta, int deltaSize, char *out, int *outSize) {

  FileHandle *inHandle, *deltaHandle, *outHandle;
  char *result;

  // Get file handles.
  if (!(inHandle = handle_read_mem((guint8*) in, (guint) inSize))) {
    return 0;
  }
  if (!(deltaHandle = handle_read_mem((guint8*) delta, (guint) deltaSize))) {
    handle_free(inHandle);
    return 0;
  }
  if (!(outHandle = handle_write_mem())) {
    handle_free(inHandle);
    handle_free(deltaHandle);
    return 0;
  }

  if (!xdfs_apply_delta(inHandle, deltaHandle, outHandle)) {
    handle_free(inHandle);
    handle_free(deltaHandle);
    handle_free(outHandle);
    return 0;
  }

  handle_close(outHandle);
  handle_write_mem_result(outHandle, (const guint8**) &result, (guint*) outSize);
  if (out != NULL) {
    memcpy(out, result, *outSize);
  }

  handle_free(outHandle);
  handle_close(inHandle);
  handle_close(deltaHandle);
  handle_free(inHandle); // used to be commented
  handle_free(deltaHandle); // used to be commented

  return 1;
}

int main(int argc, char **argv) {

  FILE *inputFile, *outputFile1, *outputFile2, *outputFile3, *outputFile4, *outputFile5, *log, *originalFile1, *originalFile2;
  char **files;
  struct resultStruct *results;
  int days, interval, totalTimeMinutes, numFiles, numSites, i, j, k, t, matchedItems, compressedFlag, compressedDeltaFlag, numVersions, destLen1, sourceLen1, destLen2, sourceLen2, destLen3, deltaLen, compressedDeltaLen;
  char sites[MAX_NUM_SITES][MAX_LINE];
  char line[MAX_LINE], dest1[MAX_FILE_SIZE], source1[MAX_FILE_SIZE*2], dest2[MAX_FILE_SIZE], source2[MAX_FILE_SIZE*2], dest3[MAX_FILE_SIZE], delta[MAX_FILE_SIZE], compressedDelta[MAX_FILE_SIZE];
  float fraction;
  struct stat fileStat, compressedStat, deltaStat, compressedDeltaStat, tempStat;
  float compressedPercentage, deltaPercentage, compressedDeltaPercentage;
  struct statStruct2 original, deltaVersions, compressedDeltaVersions;
  struct statStruct compressed, originalCompressedTime, originalUncompressedTime;

  GTimer *timer;
  double time, compressedTime, deltaTime, compressedDeltaTime, uncompressedTime, appliedDeltaTime, uncompressedAppliedDeltaTime;
  //hrtime_t START_TIME, FINISH_TIME;
  //long START_TIME, FINISH_TIME;
  //struct rusage START_TIME, FINISH_TIME;

  timer = GTIMER_NEW();
  //timer = NULL;

  // Check number of arguments.
  if (argc != 6) {
    printf("Usage: analyze4 input_file days interval log output_file\n");
    return 1;
  }
  days = atoi(argv[2]);
  interval = atoi(argv[3]);
  fraction = interval / 60.00;

  if (!edsio_library_init()) {
    printf("ERROR: failed on edsio_library_init()\n");
    return 1;
  }
  if (!xd_edsio_init()) {
    printf("ERROR: failed on xd_edsio_init()\n");
    return 1;
  }

  // Open log for writing.
  log = fopen(argv[4], "w");
  if (log == NULL) {
    printf("ERROR: could not open log for writing\n");
    return 1;
  }

  if ((i = fork())) {
    fprintf(log, "PID: %d\n", i);
    fclose(log);
    return 0;
  }

  // Open output file for writing.
  outputFile2 = fopen(argv[5], "w");
  if (outputFile2 == NULL) {
    fprintf(log, "ERROR: could not open output file all.txt for writing\n");
    return 1;
  }

  fprintf(outputFile2, "#site original(MIN) original(MAX) original(AVG) total_bytes compression(MIN) compression(MAX) compression(AVG) delta(MIN) delta(MAX) delta(AVG) compressed_delta(MIN) compressed_delta(MAX) compressed_delta(AVG) total_responses num_IMS percentage_IMS num_compression1 percentage_compression1 num_delta percentage_delta num_compression2 percentage_compression2 num_compressed_delta percentage_compressed_delta num_delta(MIN) num_delta(MAX) num_delta(AVG) num_compressed_delta(MIN) num_compressed_delta(MAX) num_compressed_delta(AVG) compressed_time(MIN) compressed_time(MAX) compressed_time(AVG) delta_time(MIN) delta_time(MAX) delta_time(AVG) compressed_delta_time(MIN) compressed_delta_time(MAX) compressed_delta_time(AVG) uncompressed_time(MIN) uncompressed_time(MAX) uncompressed_time(AVG) applied_delta_time(MIN) applied_delta_time(MAX) applied_delta_time(AVG) uncompressed_applied_delta_time(MIN) uncompressed_applied_delta_time(MAX) uncompressed_applied_delta_time(AVG)\n\n");

  // Open input file for reading.
  inputFile = fopen(argv[1], "r");
  if (inputFile == NULL) {
    fprintf(log, "ERROR: could not open input file for reading\n");
    return 1;
  }

  // Read input file and store necessary information.
  numSites = 0;
  while (fgets(line, MAX_LINE-1, inputFile) != NULL) {
    matchedItems = sscanf(line, "%s", sites[numSites]);
    if (matchedItems == 1 && line[0] != '#') {
      numSites++;
    }
  }
  fclose(inputFile);

  // Allocate array of files and fill in the array with the appropriate file names.
  // Assume data files are in the format: day_hour_minutes.html.
  numFiles = (60 / interval) * 24 * days + 1;
  files = (char **) malloc(numFiles * sizeof(char *));
  for (i = 0; i < numFiles; i++) {
    files[i] = (char *) malloc(MAX_FILENAME_SIZE * sizeof(char));
  }

  // Allocate array of results.
  results = (struct resultStruct *) malloc((numFiles-1)*sizeof(struct resultStruct));

  // Analyze data for all sites.
  for (i = 0; i < numSites; i++) {
    // Open output file for writing.
    strcpy(line, sites[i]);
    strcat(line, "/table_percentage.txt");
    outputFile1 = fopen(line, "w");
    if (outputFile1 == NULL) {
      fprintf(log, "ERROR: could not open output file %s for writing\n", line);
      continue;
    }
    fprintf(outputFile1, "#%s\n#interval filesize compressed_size compressed_percentage delta_size delta_percentage compressed_delta_size compressed_delta_percentage\n\n", sites[i]);

    // Open output file for writing times.
    strcpy(line, sites[i]);
    strcat(line, "/table_time.txt");
    outputFile4 = fopen(line, "w");
    if (outputFile4 == NULL) {
      fprintf(log, "ERROR: could not open output file %s for writing\n", line);
      continue;
    }
    fprintf(outputFile4, "#%s\n#interval compressed_time delta_time compressed_delta_time uncompressed_time applied_delta_time uncompressed_applied_delta_time\n\n", sites[i]);

    // Open output file for writing averages for the above percentages.
    strcpy(line, sites[i]);
    strcat(line, "/table_percentage_avg.txt");
    outputFile3 = fopen(line, "w");
    if (outputFile3 == NULL) {
      fprintf(log, "ERROR: could not open output file %s for writing\n", line);
      continue;
    }
    fprintf(outputFile3, "#%s\n#interval compressed_percentage(AVG) delta_percentage(AVG) compressed_delta_percentage(AVG)\n\n", sites[i]);

    // Open output file for writing average times.
    strcpy(line, sites[i]);
    strcat(line, "/table_time_avg.txt");
    outputFile5 = fopen(line, "w");
    if (outputFile5 == NULL) {
      fprintf(log, "ERROR: could not open output file %s for writing\n", line);
      continue;
    }
    fprintf(outputFile5, "#%s\n#interval compressed_time(AVG) delta_time(AVG) compressed_delta_time(AVG) uncompressed_time(AVG) applied_delta_time(AVG) uncompressed_applied_delta_time(AVG)\n\n", sites[i]);

    // Initialize array of files.
    totalTimeMinutes = 0;
    for (j = 0; j < numFiles; j++) {
      sprintf(files[j], "%s/%d_%d_%d.html", sites[i], ((totalTimeMinutes/60)/24)+1, (totalTimeMinutes/60)%24, (totalTimeMinutes%60));
      totalTimeMinutes = totalTimeMinutes + interval;
    }

    // Initialize array of results.
    for (j = 0; j < (numFiles-1); j++) {
      initializeResultStruct(&(results[j]));
    }

    // Initialize other structures.
    initializeStatStruct2(&original);
    initializeStatStruct2(&deltaVersions);
    initializeStatStruct2(&compressedDeltaVersions);
    initializeStatStruct(&compressed);
    initializeStatStruct(&originalCompressedTime);
    initializeStatStruct(&originalUncompressedTime);

    for (j = 0; j < numFiles; j++) {
      compressedFlag = 1;
      compressedDeltaFlag = 1;

      if (stat(files[j], &fileStat) != 0) {
	fprintf(log, "ERROR: could not get size of %s\n", files[j]);
	continue;
      }
      if (((int) fileStat.st_size) == 0) {
	continue;
      }

      // Store stats for original file.
      original.min = min(original.min, (int) fileStat.st_size);
      original.max = max(original.max, (int) fileStat.st_size);
      original.sum += (long) fileStat.st_size;
      original.counter++;

      // Compress original file.
      // Open file.
      originalFile1 = fopen(files[j], "r");
      if (originalFile1 == NULL) {
	fprintf(log, "ERROR: could not open file %s\n", files[j]);
	continue;
      }
      sourceLen1 = fread(source1, sizeof(char), MAX_FILE_SIZE*2, originalFile1);

      // Compress file.
      destLen1 = MAX_FILE_SIZE;
      GTIMER_START(timer);
      if (compress(dest1, (uLongf*) &destLen1, source1, sourceLen1) != Z_OK) {
	fprintf(log, "ERROR: could not compress file %s\n", files[j]);
	fclose(originalFile1);
	continue;
      }
      GTIMER_STOP(timer);
      time = GTIMER_ELAPSED(timer);
      //printf("OriginalCompressTime: %f\n", time);
      compressedStat.st_size = destLen1;

      // Update compress time for original file.
      originalCompressedTime.min = min((int) (originalCompressedTime.min * 1000000), (int) (time * 1000000)) / 1000000.000000;
      originalCompressedTime.max = max((int) (originalCompressedTime.max * 1000000), (int) (time * 1000000)) / 1000000.000000;
      originalCompressedTime.sum += time;
      originalCompressedTime.counter++;

      // Uncompress file.
      destLen3 = MAX_FILE_SIZE;
      GTIMER_START(timer);
      if (uncompress(dest3, (uLongf*) &destLen3, dest1, destLen1) != Z_OK) {
	fprintf(log, "ERROR: could not uncompress file %s\n", files[j]);
	fclose(originalFile1);
	continue;
      }
      GTIMER_STOP(timer);
      time = GTIMER_ELAPSED(timer);

      // Update uncompress time for original file.
      originalUncompressedTime.min = min((int) (originalUncompressedTime.min * 1000000), (int) (time * 1000000)) / 1000000.000000;
      originalUncompressedTime.max = max((int) (originalUncompressedTime.max * 1000000), (int) (time * 1000000)) / 1000000.000000;
      originalUncompressedTime.sum += time;
      originalUncompressedTime.counter++;

      /*
	sprintf(line, "gzip --stdout %s > compressed", files[j]);
	system(line);
	if (stat("compressed", &compressedStat) != 0) {
	fprintf(log, "ERROR: could not get size of original compressed file %s\n", files[j]);
	unlink("compressed");
	continue;
	}
      */

      compressedPercentage = (((float) compressedStat.st_size) / fileStat.st_size) * 100;

      // Store stats for original compressed file.
      compressed.min = min((int) (compressed.min * 100), (int) (compressedPercentage * 100)) / 100.00;
      compressed.max = max((int) (compressed.max * 100), (int) (compressedPercentage * 100)) / 100.00;
      compressed.sum += compressedPercentage;
      compressed.counter++;

      //unlink("compressed");

      for (k = j+1; k < numFiles; k++) {
	/*
	if (!(strcmp(files[j], "scratch/4_13_0.html") == 0 && strcmp(files[k], "scratch/6_6_0.html") == 0)) {
	  continue;
	}
	*/

	if (stat(files[k], &fileStat) != 0) {
	  fprintf(log, "ERROR: could not get size of %s\n", files[k]);
	  continue;
	}
	if (((int) fileStat.st_size) == 0) {
	  // Check to see if all responses between j+1 and k-1 were 304 responses; only then, we can declare current response as 304.
	  for (t = j+1; t < k; t++) {
	    if (stat(files[t], &fileStat) != 0) {
	      fprintf(log, "ERROR: could not get size of %s\n", files[t]);
	      continue;
	    }
	    if (((int) fileStat.st_size) != 0) {
	      break;
	    }
	  }
	  if (t == k) {
	    // 304 response.
	    results[k-j-1].request.IMS++;
	  }
	  continue;
	}

	// Compress file.
	// Open file.
	originalFile2 = fopen(files[k], "r");
	if (originalFile2 == NULL) {
	  fprintf(log, "ERROR: could not open file %s\n", files[k]);
	  continue;
	}
	sourceLen2 = fread(source2, sizeof(char), MAX_FILE_SIZE*2, originalFile2);

	// Compress file.
	destLen2 = MAX_FILE_SIZE;
	GTIMER_START(timer);
	if (compress(dest2, (uLongf*) &destLen2, source2, sourceLen2) != Z_OK) {
	  fprintf(log, "ERROR: could not compress file %s\n", files[k]);
	  fclose(originalFile2);
	  continue;
	}
	GTIMER_STOP(timer);
	compressedTime = GTIMER_ELAPSED(timer);
	//printf("CurrentCompressTime: %f\n", compressedTime);
	compressedStat.st_size = destLen2;

	// Uncompress file.
	destLen3 = MAX_FILE_SIZE;
	GTIMER_START(timer);
	if (uncompress(dest3, (uLongf*) &destLen3, dest2, destLen2) != Z_OK) {
	  fprintf(log, "ERROR: could not uncompress file %s\n", files[k]);
	  fclose(originalFile2);
	  continue;
	}
	GTIMER_STOP(timer);
	uncompressedTime = GTIMER_ELAPSED(timer);

	/*
	  sprintf(line, "gzip --stdout %s > compressed", files[k]);
	  system(line);
	  if (stat("compressed", &compressedStat) != 0) {
	  fprintf(log, "ERROR: could not get size of compressed %s\n", files[k]);
	  continue;
	  }
	*/

	// Generate delta.
	/*
	if (!generate_delta(files[j], files[k], "delta")) {
	  fprintf(log, "ERROR: could not generate delta from %s to %s\n", files[j], files[k]);
	  unlink("delta");
	  unlink("compressed");
	  continue;
	}
	if (stat("delta", &deltaStat) != 0) {
	  fprintf(log, "ERROR: could not get size of delta from %s to %s\n", files[j], files[k]);
	  unlink("delta");
	  unlink("compressed");
	  continue;
	}
	*/

	GTIMER_START(timer);
	if (!generate_delta(source1, sourceLen1, source2, sourceLen2, delta, &deltaLen)) {
	  fprintf(log, "ERROR: could not generate delta from %s to %s\n", files[j], files[k]);
	  fclose(originalFile2);
	  continue;
	}
	GTIMER_STOP(timer);
	deltaTime = GTIMER_ELAPSED(timer);
	//printf("CurrentDeltaTime: %f\n", deltaTime);
	deltaStat.st_size = deltaLen;

	// Apply delta.
	destLen3 = MAX_FILE_SIZE;
	GTIMER_START(timer);
	if (!apply_delta(source1, sourceLen1, delta, deltaLen, dest3, &destLen3)) {
	  fprintf(log, "ERROR: could not apply delta from %s to %s\n", files[j], files[k]);
	  fclose(originalFile2);
	  continue;
	}
	GTIMER_STOP(timer);
	appliedDeltaTime = GTIMER_ELAPSED(timer);

	// Compress delta.
	compressedDeltaLen = MAX_FILE_SIZE;
	GTIMER_START(timer);
	if (compress(compressedDelta, (uLongf*) &compressedDeltaLen, delta, deltaLen) != Z_OK) {
	  fprintf(log, "ERROR: could not compress delta from %s to %s\n", files[j], files[k]);
	  fclose(originalFile2);
	  continue;
	}
	GTIMER_STOP(timer);
	compressedDeltaTime = GTIMER_ELAPSED(timer) + deltaTime;
	//printf("CurrentCompressDeltaTime: %f\n", compressedDeltaTime);
	compressedDeltaStat.st_size = compressedDeltaLen;

	// Uncompress delta.
	destLen3 = MAX_FILE_SIZE;
	GTIMER_START(timer);
	if (uncompress(dest3, (uLongf*) &destLen3, compressedDelta, compressedDeltaLen) != Z_OK) {
	  fprintf(log, "ERROR: could not uncompress delta from %s to %s\n", files[j], files[k]);
	  fclose(originalFile2);
	  continue;
	}
	GTIMER_STOP(timer);
	uncompressedAppliedDeltaTime = GTIMER_ELAPSED(timer) + appliedDeltaTime;

	/*
	system("gzip --force delta");
	if (stat("delta.gz", &compressedDeltaStat) != 0) {
	  fprintf(log, "ERROR: could not get size of compressed delta from %s to %s\n", files[j], files[k]);
	  unlink("delta");
	  unlink("compressed");
	  unlink("delta.gz");
	  continue;
	}
	*/

	fclose(originalFile2);

	// Determine if compression, delta or compressed delta is better.
	if (compressedStat.st_size < deltaStat.st_size) {
	  results[k-j-1].request.compressed1++;
	  if (compressedFlag) {
	    compressedFlag = 0; // not useful to keep this version because we can just send compressed file
	    numVersions = 0;
	    // Look for all non-zero responses all the way back to the base version.
	    for (t = k-1; t >= j; t--) {
	      if (stat(files[t], &tempStat) != 0) {
		fprintf(log, "ERROR: could not get size of %s\n", files[t]);
		continue;
	      }
	      if ((int) tempStat.st_size != 0) {
		numVersions++;
	      }
	    }
	    deltaVersions.min = min(deltaVersions.min, numVersions);
	    deltaVersions.max = max(deltaVersions.max, numVersions);
	    deltaVersions.sum += numVersions;
	    deltaVersions.counter++;
	  }
	}
	else {
	  results[k-j-1].request.delta++;
	}
	if (compressedStat.st_size < compressedDeltaStat.st_size) {
	  results[k-j-1].request.compressed2++;
	  if (compressedDeltaFlag) {
	    compressedDeltaFlag = 0; // not useful to keep this version because we can just send compressed file
	    numVersions = 0;
	    // Look for all non-zero responses all the way back to the base version.
	    for (t = k-1; t >= j; t--) {
	      if (stat(files[t], &tempStat) != 0) {
		fprintf(log, "ERROR: could not get size of %s\n", files[t]);
		continue;
	      }
	      if ((int) tempStat.st_size != 0) {
		numVersions++;
	      }
	    }
	    compressedDeltaVersions.min = min(compressedDeltaVersions.min, numVersions);
	    compressedDeltaVersions.max = max(compressedDeltaVersions.max, numVersions);
	    compressedDeltaVersions.sum += numVersions;
	    compressedDeltaVersions.counter++;
	  }
	}
	else {
	  results[k-j-1].request.compressedDelta++;
	}

	// Determine various minimums and maximums; keep two precision digits after the point.
	//compressedPercentage = (((float) compressedStat.st_size) / fileStat.st_size) * 100;
	deltaPercentage = (((float) deltaStat.st_size) / fileStat.st_size) * 100;
	compressedDeltaPercentage = (((float) compressedDeltaStat.st_size) / fileStat.st_size) * 100;

	// Compressed.
	results[k-j-1].compressed.min = min((int) (results[k-j-1].compressed.min * 100), (int) (compressedPercentage * 100)) / 100.00;
	results[k-j-1].compressed.max = max((int) (results[k-j-1].compressed.max * 100), (int) (compressedPercentage * 100)) / 100.00;
	results[k-j-1].compressed.counter++;
	results[k-j-1].compressed.sum += compressedPercentage;

	// Delta.
	results[k-j-1].delta.min = min((int) (results[k-j-1].delta.min * 100), (int) (deltaPercentage * 100)) / 100.00;
	results[k-j-1].delta.max = max((int) (results[k-j-1].delta.max * 100), (int) (deltaPercentage * 100)) / 100.00;
	results[k-j-1].delta.counter++;
	results[k-j-1].delta.sum += deltaPercentage;

	// Compressed delta.
	results[k-j-1].compressedDelta.min = min((int) (results[k-j-1].compressedDelta.min * 100), (int) (compressedDeltaPercentage * 100)) / 100.00;
	results[k-j-1].compressedDelta.max = max((int) (results[k-j-1].compressedDelta.max * 100), (int) (compressedDeltaPercentage * 100)) / 100.00;
	results[k-j-1].compressedDelta.counter++;
	results[k-j-1].compressedDelta.sum += compressedDeltaPercentage;

	// Update compress time for current file.
	results[k-j-1].compressedTime.min = min((int) (results[k-j-1].compressedTime.min * 1000000), (int) (compressedTime * 1000000)) / 1000000.000000;
	results[k-j-1].compressedTime.max = max((int) (results[k-j-1].compressedTime.max * 1000000), (int) (compressedTime * 1000000)) / 1000000.000000;
	results[k-j-1].compressedTime.sum += compressedTime;
	results[k-j-1].compressedTime.counter++;

	// Update delta time for current file.
	results[k-j-1].deltaTime.min = min((int) (results[k-j-1].deltaTime.min * 1000000), (int) (deltaTime * 1000000)) / 1000000.000000;
	results[k-j-1].deltaTime.max = max((int) (results[k-j-1].deltaTime.max * 1000000), (int) (deltaTime * 1000000)) / 1000000.000000;
	results[k-j-1].deltaTime.sum += deltaTime;
	results[k-j-1].deltaTime.counter++;

	// Update compress delta time for current file.
	results[k-j-1].compressedDeltaTime.min = min((int) (results[k-j-1].compressedDeltaTime.min * 1000000), (int) (compressedDeltaTime * 1000000)) / 1000000.000000;
	results[k-j-1].compressedDeltaTime.max = max((int) (results[k-j-1].compressedDeltaTime.max * 1000000), (int) (compressedDeltaTime * 1000000)) / 1000000.000000;
	results[k-j-1].compressedDeltaTime.sum += compressedDeltaTime;
	results[k-j-1].compressedDeltaTime.counter++;

	// Update uncompress time for current file.
	results[k-j-1].uncompressedTime.min = min((int) (results[k-j-1].uncompressedTime.min * 1000000), (int) (uncompressedTime * 1000000)) / 1000000.000000;
	results[k-j-1].uncompressedTime.max = max((int) (results[k-j-1].uncompressedTime.max * 1000000), (int) (uncompressedTime * 1000000)) / 1000000.000000;
	results[k-j-1].uncompressedTime.sum += uncompressedTime;
	results[k-j-1].uncompressedTime.counter++;

	// Update apply delta time for current file.
	results[k-j-1].appliedDeltaTime.min = min((int) (results[k-j-1].appliedDeltaTime.min * 1000000), (int) (appliedDeltaTime * 1000000)) / 1000000.000000;
	results[k-j-1].appliedDeltaTime.max = max((int) (results[k-j-1].appliedDeltaTime.max * 1000000), (int) (appliedDeltaTime * 1000000)) / 1000000.000000;
	results[k-j-1].appliedDeltaTime.sum += appliedDeltaTime;
	results[k-j-1].appliedDeltaTime.counter++;

	// Update uncompress apply delta time for current file.
	results[k-j-1].uncompressedAppliedDeltaTime.min = min((int) (results[k-j-1].uncompressedAppliedDeltaTime.min * 1000000), (int) (uncompressedAppliedDeltaTime * 1000000)) / 1000000.000000;
	results[k-j-1].uncompressedAppliedDeltaTime.max = max((int) (results[k-j-1].uncompressedAppliedDeltaTime.max * 1000000), (int) (uncompressedAppliedDeltaTime * 1000000)) / 1000000.000000;
	results[k-j-1].uncompressedAppliedDeltaTime.sum += uncompressedAppliedDeltaTime;
	results[k-j-1].uncompressedAppliedDeltaTime.counter++;

	fprintf(outputFile1, "%.2f %d %d %.2f %d %.2f %d %.2f\n", (k-j)*fraction, (int) fileStat.st_size, (int) compressedStat.st_size, compressedPercentage, (int) deltaStat.st_size, deltaPercentage, (int) compressedDeltaStat.st_size, compressedDeltaPercentage);

	fprintf(outputFile4, "%.2f %.3f %.3f %.3f %.3f %.3f %.3f\n", (k-j)*fraction, compressedTime*1000, deltaTime*1000, compressedDeltaTime*1000, uncompressedTime*1000, appliedDeltaTime*1000, uncompressedAppliedDeltaTime*1000);

	//unlink("delta.gz");
	//unlink("compressed");

      }

      fclose(originalFile1);

    }
    for (j = 0; j < (numFiles-1); j++) {
      if (results[j].compressed.counter != 0 && results[j].delta.counter != 0 && results[j].compressedDelta.counter != 0) {
	fprintf(outputFile3, "%.2f %.2f %.2f %.2f\n", (j+1)*fraction, results[j].compressed.sum/results[j].compressed.counter, results[j].delta.sum/results[j].delta.counter, results[j].compressedDelta.sum/results[j].compressedDelta.counter);
      }
      if (results[j].compressedTime.counter != 0 && results[j].deltaTime.counter != 0 && results[j].compressedDeltaTime.counter != 0 &&
	  results[j].uncompressedTime.counter != 0 && results[j].appliedDeltaTime.counter != 0 && results[j].uncompressedAppliedDeltaTime.counter != 0) {
	fprintf(outputFile5, "%.2f %.3f %.3f %.3f %.3f %.3f %.3f\n", (j+1)*fraction,
		(results[j].compressedTime.sum/results[j].compressedTime.counter)*1000, (results[j].deltaTime.sum/results[j].deltaTime.counter)*1000, (results[j].compressedDeltaTime.sum/results[j].compressedDeltaTime.counter)*1000,
		(results[j].uncompressedTime.sum/results[j].uncompressedTime.counter)*1000, (results[j].appliedDeltaTime.sum/results[j].appliedDeltaTime.counter)*1000, (results[j].uncompressedAppliedDeltaTime.sum/results[j].uncompressedAppliedDeltaTime.counter)*1000);
      }
    }
    fclose(outputFile3);
    fclose(outputFile5);

    fclose(outputFile1);
    fclose(outputFile4);

    // Average out various metrics.
    for (j = 1; j < (numFiles-1); j++) {
      // Compression.
      /*
      results[0].compressed.min = min((int) (results[0].compressed.min * 100), (int) (results[j].compressed.min * 100)) / 100.00;
      results[0].compressed.max = max((int) (results[0].compressed.max * 100), (int) (results[j].compressed.max * 100)) / 100.00;
      results[0].compressed.sum += results[j].compressed.sum;
      results[0].compressed.counter += results[j].compressed.counter;
      */

      // Delta.
      results[0].delta.min = min((int) (results[0].delta.min * 100), (int) (results[j].delta.min * 100)) / 100.00;
      results[0].delta.max = max((int) (results[0].delta.max * 100), (int) (results[j].delta.max * 100)) / 100.00;
      results[0].delta.sum += results[j].delta.sum;
      results[0].delta.counter += results[j].delta.counter;

      // Compressed delta.
      results[0].compressedDelta.min = min((int) (results[0].compressedDelta.min * 100), (int) (results[j].compressedDelta.min * 100)) / 100.00;
      results[0].compressedDelta.max = max((int) (results[0].compressedDelta.max * 100), (int) (results[j].compressedDelta.max * 100)) / 100.00;
      results[0].compressedDelta.sum += results[j].compressedDelta.sum;
      results[0].compressedDelta.counter += results[j].compressedDelta.counter;

      // Requests.
      results[0].request.IMS += results[j].request.IMS;
      results[0].request.compressed1 += results[j].request.compressed1;
      results[0].request.delta += results[j].request.delta;
      results[0].request.compressed2 += results[j].request.compressed2;
      results[0].request.compressedDelta += results[j].request.compressedDelta;

      // Compress time for current file.
      /*
      results[0].compressedTime.min = min((int) (results[0].compressedTime.min * 1000000), (int) (results[j].compressedTime.min * 1000000)) / 1000000.000000;
      results[0].compressedTime.max = max((int) (results[0].compressedTime.max * 1000000), (int) (results[j].compressedTime.max * 1000000)) / 1000000.000000;
      results[0].compressedTime.sum += results[j].compressedTime.sum;
      results[0].compressedTime.counter += results[j].compressedTime.counter;
      */

      // Delta time for current file.
      results[0].deltaTime.min = min((int) (results[0].deltaTime.min * 1000000), (int) (results[j].deltaTime.min * 1000000)) / 1000000.000000;
      results[0].deltaTime.max = max((int) (results[0].deltaTime.max * 1000000), (int) (results[j].deltaTime.max * 1000000)) / 1000000.000000;
      results[0].deltaTime.sum += results[j].deltaTime.sum;
      results[0].deltaTime.counter += results[j].deltaTime.counter;

      // Compress delta time for current file.
      results[0].compressedDeltaTime.min = min((int) (results[0].compressedDeltaTime.min * 1000000), (int) (results[j].compressedDeltaTime.min * 1000000)) / 1000000.000000;
      results[0].compressedDeltaTime.max = max((int) (results[0].compressedDeltaTime.max * 1000000), (int) (results[j].compressedDeltaTime.max * 1000000)) / 1000000.000000;
      results[0].compressedDeltaTime.sum += results[j].compressedDeltaTime.sum;
      results[0].compressedDeltaTime.counter += results[j].compressedDeltaTime.counter;

      // Apply delta time for current file.
      results[0].appliedDeltaTime.min = min((int) (results[0].appliedDeltaTime.min * 1000000), (int) (results[j].appliedDeltaTime.min * 1000000)) / 1000000.000000;
      results[0].appliedDeltaTime.max = max((int) (results[0].appliedDeltaTime.max * 1000000), (int) (results[j].appliedDeltaTime.max * 1000000)) / 1000000.000000;
      results[0].appliedDeltaTime.sum += results[j].appliedDeltaTime.sum;
      results[0].appliedDeltaTime.counter += results[j].appliedDeltaTime.counter;

      // Uncompress apply delta time for current file.
      results[0].uncompressedAppliedDeltaTime.min = min((int) (results[0].uncompressedAppliedDeltaTime.min * 1000000), (int) (results[j].uncompressedAppliedDeltaTime.min * 1000000)) / 1000000.000000;
      results[0].uncompressedAppliedDeltaTime.max = max((int) (results[0].uncompressedAppliedDeltaTime.max * 1000000), (int) (results[j].uncompressedAppliedDeltaTime.max * 1000000)) / 1000000.000000;
      results[0].uncompressedAppliedDeltaTime.sum += results[j].uncompressedAppliedDeltaTime.sum;
      results[0].uncompressedAppliedDeltaTime.counter += results[j].uncompressedAppliedDeltaTime.counter;

    }

    j = results[0].request.IMS + results[0].request.compressed1 + results[0].request.delta;

    if ((results[0].request.compressed1 + results[0].request.delta) != (results[0].request.compressed2 + results[0].request.compressedDelta)) {
      fprintf(outputFile2, "Invariant does not hold!\n");
    }

    // fprintf(outputFile2, "Total requests: %d,  IMS: %d\n", j, results[0].request.IMS);

    fprintf(outputFile2, "%s %d %d %d %d %0.2f %.2f %.2f %.2f %.2f %.2f %.2f %.2f %.2f %d %d %.2f %d %.2f %d %.2f %d %.2f %d %.2f ",
	    sites[i],
	    original.min, original.max, (int) (original.sum/original.counter),
	    (int) original.sum,
	    compressed.min, compressed.max, compressed.sum/compressed.counter,
	    results[0].delta.min, results[0].delta.max, results[0].delta.sum/results[0].delta.counter,
	    results[0].compressedDelta.min, results[0].compressedDelta.max, results[0].compressedDelta.sum/results[0].compressedDelta.counter,
	    j, results[0].request.IMS, (((float) results[0].request.IMS)/j)*100, results[0].request.compressed1, (((float) results[0].request.compressed1)/j)*100, results[0].request.delta, (((float) results[0].request.delta)/j)*100, results[0].request.compressed2, (((float) results[0].request.compressed2)/j)*100, results[0].request.compressedDelta, (((float) results[0].request.compressedDelta)/j)*100);

    fprintf(outputFile2, "%d %d %d %d %d %d ",
	    deltaVersions.min, deltaVersions.max, (deltaVersions.counter == 0 ? MAX_INT : (int) (deltaVersions.sum/deltaVersions.counter)),
	    compressedDeltaVersions.min, compressedDeltaVersions.max, (compressedDeltaVersions.counter == 0 ? MAX_INT : (int) (compressedDeltaVersions.sum/compressedDeltaVersions.counter)));

    fprintf(outputFile2, "%.3f %.3f %.3f %.3f %.3f %.3f %.3f %.3f %.3f ",
	    originalCompressedTime.min*1000, originalCompressedTime.max*1000, (originalCompressedTime.sum/originalCompressedTime.counter)*1000,
	    results[0].deltaTime.min*1000, results[0].deltaTime.max*1000, (results[0].deltaTime.sum/results[0].deltaTime.counter)*1000,
	    results[0].compressedDeltaTime.min*1000, results[0].compressedDeltaTime.max*1000, (results[0].compressedDeltaTime.sum/results[0].compressedDeltaTime.counter)*1000);

    fprintf(outputFile2, "%.3f %.3f %.3f %.3f %.3f %.3f %.3f %.3f %.3f\n",
	    originalUncompressedTime.min*1000, originalUncompressedTime.max*1000, (originalUncompressedTime.sum/originalUncompressedTime.counter)*1000,
	    results[0].appliedDeltaTime.min*1000, results[0].appliedDeltaTime.max*1000, (results[0].appliedDeltaTime.sum/results[0].appliedDeltaTime.counter)*1000,
	    results[0].uncompressedAppliedDeltaTime.min*1000, results[0].uncompressedAppliedDeltaTime.max*1000, (results[0].uncompressedAppliedDeltaTime.sum/results[0].uncompressedAppliedDeltaTime.counter)*1000);

    fflush(outputFile2);

  }

  fclose(outputFile2);

  return 0;

}
