/* -*-Mode: C;-*-
 * $Id: library.c,v 1.9 2001/05/15 23:34:05 jmacd Exp $
 *
 * Copyright (C) 1998, 1999, 2000, Joshua P. MacDonald <jmacd@CS.Berkeley.EDU>
 * and The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 *    Neither name of The University of California nor the names of
 *    its contributors may be used to endorse or promote products
 *    derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "edsio.h"
#include "edsiopriv.h"
#include <gmodule.h>

typedef struct _Library Library;

struct _Library {
  const char* name;
  const char* libname;
  gint        index;
  gboolean    loaded;
};

static Library known_libraries[] = {
  { "edsio",   "edsio",   6 },
  { "xd",      "xdelta",  3 },
  { "xdfs",    "xdfs",    7 },
};

static GHashTable* loaded_libraries;

gboolean
edsio_library_init (void)
{
  gint i;
  gint n = ARRAY_SIZE (known_libraries);

  loaded_libraries = g_hash_table_new (g_int_hash, g_int_equal);

  if (! edsio_edsio_init ())
    return FALSE;

  if (! edsio_stdio_init ())
    return FALSE;

  for (i = 0; i < n; i += 1)
    {
      Library* lib = known_libraries + i;

      g_hash_table_insert (loaded_libraries, & lib->index, lib);
    }

  return TRUE;
}

void
edsio_library_register (guint32 number, const char* name)
{
  Library* lib;

  g_assert (loaded_libraries);

  lib = g_hash_table_lookup (loaded_libraries, & number);

  if (lib)
    {
      lib->loaded = TRUE;
      return;
    }

  lib = g_new0 (Library, 1);

  lib->index = number;
  lib->name = name;
  lib->loaded = TRUE;

  g_hash_table_insert (loaded_libraries, & lib->index, lib);
}

gboolean
edsio_library_check (guint32 number, gboolean err)
{
  Library* lib;

  g_assert (loaded_libraries);

  lib = g_hash_table_lookup (loaded_libraries, & number);

  if (lib)
    {
      lib->loaded = TRUE;
      return TRUE;
    }

#if 0
  if (lib->libname && g_module_supported ())
    {
      GModule *module;
      GString *module_name = g_string_new (NULL);
      GString *symbol_name = g_string_new (NULL);
      gboolean (* init) (void);

      if (! (module = g_module_open (module_name->str, 0)))
	{
	  edsio_generate_stringstring_event (EC_EdsioGModuleError, module_name->str, g_module_error ());
	  return FALSE;
	}

      if (! g_module_symbol (module,
			     symbol_name->str,
			     (void**) & init))
	{
	  edsio_generate_stringstring_event (EC_EdsioGModuleError, g_module_name (module), g_module_error ());
	  return FALSE;
	}

      g_module_make_resident (module);

      g_module_close (module);

      lib->loaded = TRUE;

      return (* init) ();
    }
#endif

  if (err)
    edsio_generate_int_event (EC_EdsioUnregisteredLibrary, number);
  return FALSE;
}
