#! /usr/bin/perl
# This short script creates fixed look-up tables for xcftools
# Copyright (C) 2006  Henning Makholm
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of version 2 of the GNU General Public License as
# published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

use strict ; use warnings ;

sub shipsubarray (@) {
    while( @_ > 1 && $_[$#_] == 0 ) {
        pop @_ ;
    }
    my $last = pop @_ ;
    print "  {" ;
    my $left = 75 ;
    for my $d ( (map{ $_ . "," } @_), "$last}," ) {
        if( length($d) > $left ) {
            print "\n   " ;
            $left = 75 ;
        }
        print $d ;
        $left -= length($d) ;
    }
    print "\n" ;
}

my $precompute_it = 1 ;
if( open CONFIGH, "<", "config.h" ) {
    $precompute_it = 0 ;
    while( <CONFIGH> ) {
        if( /\#\s*define\s+PRECOMPUTED_SCALETABLE/ ) {
            $precompute_it = 1 ;
            last ;
        }
    }
    close CONFIGH ;
}

print "/* Autogenerated by $0 */\n" ;
print "#include \"pixels.h\"\n" ;
print "#ifdef PRECOMPUTED_SCALETABLE\n" ;
if( $precompute_it ) {
    print "const uint8_t scaletable[256][256] = {\n" ;
    for my $p ( 0..255 ) {
        shipsubarray( map { int(($p*$_+127)/255) } ( 0 .. 255 ) );
        # This formula has the property that
        # scaletable[p][q] + scaletable[255-p][q] == q
        # for all uint8_t values of p and q.
        # This is important in order that a partially transparent
        # pixel does not change the color of the underlying pixel
        # unless the two pixels have different colors.
    }
    print "};\n" ;
} else {
    print "#error PRECOMPUTED_SCALETABLE was not defined at generation time\n";
}
print "#endif\n" ;

if(0) {

print "const uint8_t divtable[256][256] = {\n" ;
for my $p ( 0..255 ) {
    shipsubarray( map { $_ >= $p ? 255 : int(0.5 + 255*$_/$p) }
                  ( 0 .. 255 ) );
}
print "};\n" ;

}

print "const rgba graytable[256] = {\n" ;
for my $p ( 0..255 ) {
    print "   (rgba)$p << RED_SHIFT | (rgba)$p << GREEN_SHIFT | (rgba)$p << BLUE_SHIFT,\n" ;
}
print "};\n" ;
