/******************************************************************
 
        MUSCLE SmartCard Development ( http://www.musclecard.com )
            Title  : xcardPINV.h
            Author : David Corcoran
            Date   : 10/05/01
	    License: Copyright (C) 2001 David Corcoran
	             <corcoran@linuxnet.com>
            Purpose: This provides functionality for the xcard
	             personalization tool for the musclecard.
 
********************************************************************/ 

#ifndef xcardPINV_included
#define xcardPINV_included

#include "xcardPINVData.h"

#ifdef MSC_TARGET_OSX
#include <PCSC/musclecard.h>
#else
#include <musclecard.h>
#endif

#include <qlistview.h>

class xcardPINV : public xcardPINVData
{
    Q_OBJECT
      
      public:

    bool isUnBlock;

    xcardPINV(
	      MSCLPTokenConnection pConn,
	      QListViewItem *pinSelected,
	      int pinNum,
	      bool unblockPIN,
	      QWidget *parent = NULL,
	      const char *name = NULL 
	      );

    virtual ~xcardPINV();    

    MSCLPTokenConnection pConnect;
    int pinNumber;
    QListViewItem *currentPINSelected;

public slots:

    virtual void XCVerifyPINCancelled();
    virtual void XCVerifyPINClicked();


};
#endif // xcardPINV_included
