#ifndef lint
static char *sccsid = "@(#)xcal_cal.c	1.1+ (Hillside Systems) 7/14/90";
#endif  /* lint */
/***

* program name:
	xcal_cal.c
* function:
	read files generated by xcal and produce a file compatible
	with the standard "calendar" utility
* switches:
	-d dir	use "dir" instead of "Calendar"
	-f file use "file" instead of .xcal
	-m	copy all of multi-line entries
* history:
	Written July, 1990
	Ed Gould
	mt Xinu, Inc.
* (C) Copyright: 1990 mt Xinu, Inc.
	
	Permission to use, copy, modify, and distribute this software
	and its documentation for any purpose is hereby granted to
	anyone, provided that the above copyright notice appear in
	all copies and that both that copyright notice and this
	permission notice appear in supporting documentation, and
	that the names of Ed Gould and mt Xinu, Inc. not be used
	in advertising or publicity pertaining to distribution of
	the software without specific, written prior permission.
	mt Xinu, Inc. makes no representations about the suitability
	of this software for any purpose.  It is provided "as is"
	without express or implied warranty.

	Ed Gould and mt Xinu, Inc. DISCLAIM ALL WARRANTIES WITH
	REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES
	OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL Ed Gould
	or mt Xinu, Inc. BE LIABLE FOR ANY SPECIAL, INDIRECT OR
	CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
	FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
	CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT
	OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
	SOFTWARE.

***/
#include <stdio.h>
#include <ctype.h>
#include <sys/param.h>
#include <unistd.h>
#if defined(NeXT)
# include <sys/fcntl.h>
# include <sys/dir.h>
# include <sys/dirent.h>
#else
# include <dirent.h>
#endif
#include <string.h>
#include <time.h>


char	*directory	= "Calendar";
char	*file		= ".xcal";
char	*home;

#ifndef MAXPATHLEN
#  define MAXPATHLEN 256
#endif

char	usedir[MAXPATHLEN];
char	usefile[MAXPATHLEN];
char	line[BUFSIZ];

char	*months[]	= {"jan", "feb", "mar", "apr", "may", "jun",
			   "jul", "aug", "sep", "oct", "nov", "dec"};

int	debug;
int	mflag;

FILE	*out;

void
main(argc, argv)
	char **argv;
{
	register int c;
	time_t now;
	register struct tm *lt;
	char *getenv();

	while((c = getopt(argc, argv, "d:f:m#")) != EOF) {
		extern char *optarg;

		switch (c) {

		case 'd':
			directory = optarg;
			break;

		case 'f':
			file = optarg;
			break;

		case 'm':
			mflag++;
			break;

		case '#':
			debug++;
			break;

		case '?':
		default:
			fprintf(stderr, "usage: %s [-d dir] [-f file]\n",
								argv[0]);
			exit(1);
		}
	}
	home = getenv("HOME");
	/*
	 * For both directory and output file, 
	 *
	 *   /...	is absolute path
	 *   ./...	is relative to current directory
	 *
	 * otherwise, relative to $HOME, if available
	 */
	if(file[0] == '/' || (file[0] == '.' && file[1] == '/') ||
	   home == NULL)
		strcpy(usefile, file);
	else
		sprintf(usefile, "%s/%s", home, file);
	if(debug)
		fprintf(stderr, "output to %s\n", usefile);
	if((out = fopen(usefile, "w")) == NULL) {
		perror(usefile);
		exit(1);
	}
	now = time((time_t *)NULL);
	lt = localtime(&now);
	calfiles(directory, lt->tm_year + 1900, lt->tm_mon, lt->tm_mday);
	if(lt->tm_mday >= 25 ) {
		/*
		 * close to end of month: include next month, too
		 */
		if(lt->tm_mon == 11)
			calfiles(directory, lt->tm_year + 1900 + 1, 0, 1);
		else
			calfiles(directory, lt->tm_year + 1900,
							lt->tm_mon + 1, 1);
	}
}

calfiles(dir, year, thismonth, today)
	register char *dir;
{
	register DIR *dp;
	register char *to;
	register char *from;
	register struct dirent *d;
	char day[3];
	char month[4];

	if(dir[0] == '/' || (dir[0] == '.' && dir[1] == '/') ||
	   home == NULL)
		sprintf(usedir, "%s/xy%4d", dir, year);
	else
		sprintf(usedir, "%s/%s/xy%4d", home, dir, year);
	if(debug)
		fprintf(stderr, "looking in directory %s\n", usedir);
	if((dp = opendir(usedir)) == NULL) {
		perror(usedir);
		exit(1);
	}
	while((d = readdir(dp)) != NULL) {
		register FILE *in;

		if(d->d_name[0] != 'x' || d->d_name[1] != 'c' ||
		   !isascii(d->d_name[2]) || !isdigit(d->d_name[2]))
			continue;
		sprintf(usefile, "%s/%s", usedir, d->d_name);
		if(debug)
			fprintf(stderr, "looking in file %s\n", usefile);
		if((in = fopen(usefile, "r")) == NULL) {
			if(debug)
				perror(usefile);
			continue;
		}
		from = &d->d_name[2];
		to = day;
		while(isascii(*from) && isdigit(*from))
			*to++ = *from++;
		*to = '\0';
		to = month;
		while(isascii(*from) && !isdigit(*from)) {
			if(isupper(*from))
				*from = tolower(*from);
			*to++ = *from++;
		}
		*to = '\0';
		if(strcmp(month, months[thismonth]) != 0 ||
		   atoi(day) < today) {
			if(debug)
				fprintf(stderr, "\tskipped - date\n");
			fclose(in);
			continue;
		}
		while(fgets(line, sizeof(line), in) != NULL) {
			char *cp;

			if((to = strchr(line, '\n')) != NULL)
				*to = '\0';
			cp = line;
			while(isspace(*cp))
				cp++;
			if(*cp == '\0') {
				if(debug)
					fprintf(stderr, "\tskipped - empty\n");
				continue;
			}
			if(debug)
				fprintf(stderr, "==>\t%s %s\t%s\n", month,
								day, cp);
			fprintf(out, "%s %s\t%s\n", month, day, cp);
			if(mflag == 0)
				break;
		}
		fclose(in);
	}
}
