#ifndef _GAME_H
#define _GAME_H

#include "board.h"
#include "opponent.h"

enum GameMode { SINGLE_PLAYER, TWO_PLAYERS, PLAYER_VS_COMPUTER, DEMO };
enum GameResult { DRAW, PLAYER1_WON, PLAYER1_LOST, ABORTED };
typedef struct _Game * Game;

#define board_spacing(S)   (S)
#define game_win_width(S)  ((int)(2*board_win_width(S) + 3*board_spacing(S)))
#define game_win_height(S) ((int)( board_win_height(S) + 3*board_spacing(S)))

Game new_game( enum GameMode mode, int *handicap, int preload, int *colors,
	       int round, int *score, enum Level level );
void delete_game( Game game, int no_clean );
enum GameResult play_game( Game game );

#endif /* _GAME_H */



