/*
 * Program XBLAST V2.5.10 or higher
 * (C) by Oliver Vogel (e-mail: vogel@ikp.uni-koeln.de)
 * October 4th 1997
 * started August 1993
 *
 * File: intro.c
 * intros etc for xblast
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as by published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will be entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: intro.c,v 1.2 1999/03/21 18:35:05 xblast Exp $
 * $Log: intro.c,v $
 * Revision 1.2  1999/03/21 18:35:05  xblast
 * Bugfix: In double mode only player per team was shown
 *
 * Revision 1.1  1998/01/03 14:10:43  xblast
 * Initial revision
 *
 */

#define _INTRO_C

#include <stdio.h>
#include <stdlib.h>


#include "const.h"
#include "include.h"
#include "mytypes.h"
#include "patchlev.h"
#include "graphics.h"
#include "data.h"
#include "info.h"
#include "maze.h"
#include "map.h"
#include "sprite.h"
#include "main.h"
#include "event.h"
#include "status.h"
#include "intro.h"
#include "introdat.h"
#include "util.h"

#if defined(XBLAST_SOUND)
#include "sound.h"
#endif

#define SCORE_TIME 16

#define PARTNER(p) ( ((p)/2)*2 + 1 - ((p)%2) )

/*
 * local function draw_intro_player
 */
#ifdef __STDC__
static void
draw_intro_player (BMPlayer *ps, 
		   char *name,
		   XBConfig *config)
#else
static void
draw_intro_player (ps, name, config)
     BMPlayer *ps;
     char *name;
     XBConfig *config;
#endif
{
  static char disp_name[]="X\0";

  disp_name[0]='1'+config->pl_at_disp[ps->id];

  /* Player Sprite */
  move_sprite (ps->sprite, intro_player_pos[ps->id].x, intro_player_pos[ps->id].y);
  set_sprite_mode (ps->sprite, SPM_MAPPED);
  set_sprite_anime (ps->sprite, SpriteStopDown);
  /* Partner in double mode */
  if (TM_Double == config->team_mode) {
    BMPlayer *other = ps + config->num_player/2;
    move_sprite (other->sprite, intro_player_pos_2[ps->id].x, intro_player_pos_2[ps->id].y);
    set_sprite_mode (other->sprite, SPM_MAPPED);
    set_sprite_anime (other->sprite, SpriteStopDown);
  }

  /* Floor */
  draw_block(control_pos[ps->id][0].x, control_pos[ps->id][0].y, 0);
  draw_block(control_pos[ps->id][0].x, control_pos[ps->id][0].y-1, 0);
  draw_textbox(name, FF_White|FF_Boxed|FF_Large, intro_player_box+ps->id);
  if (config->team_mode != TM_Double) {
    /* alpha control */
    if (ps->id == config->disp_player.p2) {
      draw_block_at(control_pos[ps->id][2].x,control_pos[ps->id][2].y, 2);
    }
    /* num control */
    if (ps->id == config->disp_player.p1) {
      draw_block_at(control_pos[ps->id][3].x,control_pos[ps->id][3].y, 1);
    }
  } else {
    /* both controls for double mode */
    if (ps->id == config->disp_player.p1) {
      draw_block_at(control_pos[ps->id][2].x,control_pos[ps->id][2].y, 2);
      draw_block_at(control_pos[ps->id][3].x,control_pos[ps->id][3].y, 1);
    }
  }
  /* Display */
  draw_block_at(control_pos[ps->id][1].x, control_pos[ps->id][1].y, 3);
  draw_textbox(disp_name, FF_Large | FF_Black, disp_box+ps->id);
}

		   

/*
 * public function: do_intro 
 *   intro screen of xblast
 */
#ifdef __STDC__
void 
do_intro (BMPlayer *ps,
	  PlayerStrings *p_string, 
	  XBConfig *config)
#else
void 
do_intro (ps, p_string, config)
     BMPlayer *ps;
     PlayerStrings *p_string;
     XBConfig *config;
#endif
{
  int count;
  int player;
  int i, flags;
  double pfactor;

  static BMBlockTile intro_tile[4] = {
    { "iron_floor",    "Black", "Gray75", "MidnightBlue" },
    { "control_num",   "Black", "White", NULL },
    { "control_alpha", "Black", "White", NULL },
    { "display",       "Black", "White", NULL },
  };
#if defined (XBLAST_SOUND)
  load_sound(SND_WHIRL);
#endif

  for (i=0; i<4; i++) {
    init_block (i, intro_tile+i);
  }

  clear_pixmap();
  
  flags = FF_Large | FF_Black | FF_Outlined;
  
  draw_textbox("On a Workstation", flags, intro_box+0);
  draw_textbox("not far away", flags, intro_box+1);
  draw_textbox("Press SPACE to begin", FF_Large | FF_White | FF_Boxed, 
	       intro_box+2);
  
#if defined(XBLAST_SOUND)
  play_sound(SND_WHIRL, SOUND_MIDDLE_POSITION);
#endif

  set_fade_max(PIXH+SCOREH);
  fade_in();
  
  flush_pixmap(FALSE);

  /* wait for space bar */
  init_timer();
  clear_keys(config->num_player);
  do {
    other_event();
  } while(!wait_eval_keys(config->num_player));


  clear_pixmap();

#if defined (XBLAST_SOUND)
  stop_sound(STOP_ALL_SOUNDS);
  unload_sound(SND_WHIRL);
  load_sound(SND_INTRO);
  load_sound(SND_EXPL);
#endif

  /* update status bar */
  init_status_bar(config, ps, "Press Space", FALSE);

  fade_in();

  flush_pixmap(FALSE);

  /* main intro screen */
  init_timer();

  for (count = 0; count < INTRO_LENGTH; count ++) {
#if defined(XBLAST_SOUND)
    if (! (count % CHAR_ANIME) ) {
      play_sound(SND_EXPL, (count/CHAR_ANIME)*3+1);
    }
#endif
    if (count < CHAR_ANIME) {
      copy_expl_block( 0, 8, Block_B[count]);
    } else if (count < (CHAR_ANIME*2)) {
      copy_expl_block( 3, 8, Block_L[count-CHAR_ANIME]);
    } else if (count < (CHAR_ANIME*3)) {
      copy_expl_block( 6, 8, Block_A[count-CHAR_ANIME*2]);
    } else if (count < (CHAR_ANIME*4)) {
      copy_expl_block( 9, 8, Block_S[count-CHAR_ANIME*3]);
    } else {
      copy_expl_block(12, 8, Block_T[count-CHAR_ANIME*4]);
    }

    /* draw growing poly */
    pfactor = (double)(count+1)/INTRO_LENGTH;
    draw_polygon((int)(0.5+(7.5-2.5*pfactor)*BLOCK_WIDTH), 
		 (int)(0.5+(10.0-9.0*pfactor)*BLOCK_HEIGHT), 
		 (int)(0.5+pfactor*5.0*BLOCK_WIDTH), 
		 (int)(0.5+pfactor*6.0*BLOCK_HEIGHT), 
		 pointx, SIZE_OF_X, TRUE);
    mark_maze(5,1,9,10);


    if (count==(INTRO_LENGTH-1)) {
      for (i=0; i<NUM_XC; i++) {
	draw_textbox(xc_string[i], xc_flags[i], &(xc_box[i]) );
      }
      mark_maze(4, 9, 10, 11 ); 
      mark_maze(0,0,14,12);
      /* draw players */
      if (config->team_mode != TM_Double) {
	for (player = 0; player < config->num_player; player ++) {
	  draw_intro_player(ps + player, p_string[player].tag, config);
	}
      } else {
	for (player = 0; player < config->num_player/2; player ++) {
	  draw_intro_player(ps + player, p_string[player].tag, config);
	}
      }
      /* draw team tags if needed */
      if (config->team_mode == TM_Team) {
	for (i = 0; i < (config->num_player / 2); i ++) {
	  draw_textbox(NULL, FF_Medium|FF_White|FF_Boxed, team_box2+i );
	  draw_textbox(team_string[i], FF_Medium|FF_Black|FF_Boxed, team_box+i);
	}
      }
    }
    intro_event();
  }

    /* nachher hier die fanfare */
#if defined(XBLAST_SOUND)
  play_sound(SND_INTRO, SOUND_MIDDLE_POSITION);
#endif

  init_timer();
  clear_keys(config->num_player);
  do {
    other_event();
  } while(!wait_eval_keys(config->num_player));

  fade_out();
  set_fade_max(PIXH+1);
  
  free_block(BTFree);
#if defined(XBLAST_SOUND)
  stop_sound(STOP_ALL_SOUNDS);
  unload_sound(SND_INTRO);
  unload_sound(SND_EXPL);
#endif
}


/* 
 * public function level_start  
 */
#ifdef __STDC__
void 
level_start (void)
#else
void 
level_start()
#endif
{
  flush_score_board();
  fade_out();
}



/*
 * public function level_intro
 * Level Introduction (Garth Denley)
 * modified by Oliver Vogel
 */
#ifdef __STDC__
void 
level_intro (int lvl, 
	     BMPlayer *player_stat,
	     XBConfig *config)
#else
void 
level_intro (lvl, player_stat, config)
     int lvl;
     BMPlayer *player_stat;
     XBConfig *config;
#endif
{
  int player;
  int i, count;
  BMPlayer *ps;

  char **extra_info;
  char **level_info;
  char **player_info;

  reset_status_bar(player_stat, "Press Space", FALSE);
  /* draw player positions */
  for (player=0, ps=player_stat; player < config->num_player; player++, ps++) {
    move_sprite (ps->sprite, ps->x, ps->y);
    set_sprite_mode (ps->sprite, SPM_MAPPED);
    set_sprite_anime (ps->sprite, SpriteStopDown);
  }

  draw_maze();

  draw_all_sprites();

  /* Display level info */
  get_info(&extra_info, &level_info, &player_info);

    /* draw level title */
  draw_textbox(NULL, FF_White | FF_Boxed , title_box+0);
  draw_textbox(get_level_name(lvl), FF_White |FF_Large, title_box+1);
  draw_textbox(get_level_author(lvl), FF_White |FF_Small, title_box+2);
  
  /* draw player info */
  draw_textbox(NULL, FF_White | FF_Boxed | FF_Transparent,
	       &player_info_frame);
  draw_textbox("Player Info", FF_Black | FF_Boxed | FF_Medium,
	       player_info_box+0);
  for (i=0; (i<MAX_INFO) && (player_info[i][0] != '\0'); i++) {
    draw_textbox(player_info[i], FF_White | FF_Boxed | FF_Small, 
		 player_info_box+i+1);
  }
  
  /* draw level info */
  draw_textbox(NULL, FF_White | FF_Boxed | FF_Transparent,
	       &level_info_frame);
  draw_textbox("Level Info", FF_Black | FF_Boxed | FF_Medium,
	       level_info_box+0);
  for (i=0; (i<MAX_INFO) && (level_info[i][0] != '\0'); i++) {
    draw_textbox(level_info[i], FF_White | FF_Boxed | FF_Small, 
		 level_info_box+i+1);
  }
  
  /* draw extra info */
  draw_textbox(NULL, FF_White | FF_Boxed | FF_Transparent,
	       &extra_info_frame);
  draw_textbox("Extra Info", FF_Black | FF_Boxed | FF_Medium,
	       extra_info_box+0);
  for (i=0; (i<MAX_INFO) && (extra_info[i][0] != '\0'); i++) {
    draw_textbox(extra_info[i], FF_White | FF_Boxed | FF_Small, 
		 extra_info_box+i+1);
  }

  /* draw general tip */
  draw_textbox(get_level_tip(lvl), FF_White | FF_Boxed | FF_Large,
	       &level_tip_box);

  level_start ();

  flush_pixmap(FALSE);

  init_timer();
  clear_keys(config->num_player);
  for (count = 0; count < SCORE_TIME ; count ++) {
    other_event();
  }
  do {
    other_event();
  } while(!wait_eval_keys(config->num_player));

  fade_out();
}


/* 
 * public function welcome
 */
#ifdef __STDC__
void 
welcome (int num_player, PlayerStrings *st)
#else
void 
welcome (num_player, st)
     int num_player;
     PlayerStrings *st;
#endif
{
  char *tmpl;
  int j;
  int p1,p2;
  char *welcomes[2*MAX_PLAYER];

  for(p1=0; p1<num_player; p1++) {
    welcomes[p1] = st[p1].welcome;
  }
  for(j=0; j<3; j++) {
    for(p1=0; p1<num_player; p1++) {
      p2 = random_number(num_player);
      tmpl = welcomes[p1];
      welcomes[p1] = welcomes[p2];
      welcomes[p2] = tmpl;
    }
  }
  for(p1=0; p1<num_player; p1++) {
    set_message(welcomes[p1], FALSE);
  }
}



static int n_audience;
struct Audience {
  Sprite *sprite;
  BMSpriteAnimation *data;
  int nvalues;
  int phase;
};

static struct Audience audience[3*MAZE_W+3];

/*
 * local function: draw_audience
 */
#ifdef __STDC__
static void
draw_audience (BMPlayer *ps, 
	       int num_player, 
	       int last_team,
	       int nrows, 
	       int laola)
#else
static void
draw_audience (ps, num_player, last_team, nrows, laola)
  BMPlayer *ps;
  int num_player, last_team;
  int nrows;
  int laola;
#endif
{
  struct Audience *ptr;
  int row,xpos,ypos,xoff,yoff;
  int player;
  
  n_audience = 0;
  ptr = audience;
  for (row=0; row<nrows; row++) {
    ypos = -4*BLOCK_HEIGHT/3 + row*BLOCK_HEIGHT;
    for (xpos = (row % 2) ? (-BLOCK_WIDTH/2) : 0; xpos <PIXW; 
	 xpos += BLOCK_WIDTH) {
      player = random_number(MAX_PLAYER);
      if (player >= num_player) {
	player = random_number(MAX_PLAYER);
      }
      xoff = random_number(BASE_X) - BASE_X/2;
      yoff = random_number(BASE_Y) - BASE_Y/2;
      ptr->sprite = create_player_sprite (player, xpos+xoff, ypos+yoff, 
					  SpriteStopDown, SPM_MAPPED);
      if (laola) {
	ptr->data = laola_animation;
	ptr->nvalues = NUM_LAOLA_ANIME;
	ptr->phase = (2*NUM_LAOLA_ANIME - 2*xpos/BLOCK_WIDTH + random_number(3)) 
	  % NUM_LAOLA_ANIME;
      } else {
	if (player < num_player) {
	  if (ps[player].team == last_team) {
	    ptr->data = winner_animation;
	    ptr->nvalues = NUM_WINNER_ANIME;
	  } else {
	    ptr->data = looser_animation;
	    ptr->nvalues = NUM_LOOSER_ANIME;
	  }	  
	} else {
	  if (last_team != 2*MAX_PLAYER) {
	    ptr->data = other_animation;
	    ptr->nvalues = NUM_OTHER_ANIME;
	  } else {
	    ptr->data = draw_animation;
	    ptr->nvalues = NUM_DRAW_ANIME;
	  }
	}
	ptr->phase = random_number(ptr->nvalues);
      }
      set_sprite_anime(ptr->sprite, ptr->data[ptr->phase]);

      n_audience++;
      ptr++;
    }
  }  
}

/*
 * local function: animate_audience
 */
#ifdef __STDC__
static void
animate_audience (void)
#else
static void
animate_audience ()
#endif
{
  int i;
  struct Audience *ptr;

  for (i=0, ptr=audience; i<n_audience; i++, ptr++) {
    if (ptr->nvalues != 0) {
      ptr->phase++;
      if (ptr->phase >= ptr->nvalues) {
	ptr->phase = 0;
      }
      set_sprite_anime (ptr->sprite, ptr->data[ptr->phase]);
    }
  }
}

/*
 * local function: delete audience
 */
#ifdef __STDC__
static void
delete_audience (void)
#else
static void
delete_audience ()
#endif
{
  while (n_audience) {
    delete_sprite(audience[--n_audience].sprite);
  }
}


/* 
 * public function status_board 
 */
#ifdef __STDC__
void 
status_board (int last_team,
	      int num_victories,
	      int max_victories,
	      BMPlayer *player_stat,
	      PlayerStrings *p_string,
	      XBConfig *config)
#else
void 
status_board (last_team, num_victories, max_victories, player_stat, p_string, 
	      config)
     int last_team;
     int num_victories, max_victories;
     BMPlayer *player_stat;
     PlayerStrings *p_string;
     XBConfig *config;
#endif
{
  BMPlayer *ps;
  int player, i;
  int count;
  int box_set = 0;
  int flag = 0;
  Sprite *trophy[MAX_PLAYER*MAX_VICTORIES];
  int n_trophies = 0;

  /* load score board maze */
  load_maze(scoreBoard);

  /* draw maze in pixmap */
  reset_status_bar(player_stat, get_level_name(scoreBoard), FALSE);
  draw_maze();

  /* draw player positions */
  switch (config->team_mode) {
  case TM_Single:
    box_set = config->num_player-2;
    flag = FF_Medium |FF_Boxed |FF_White;
    break;

  case TM_Team:
    box_set = (config->num_player-4)/2+5;
    flag = FF_Small |FF_Boxed |FF_White;
    break;

  case TM_Double:
    box_set = (config->num_player/2)-2;
    flag = FF_Medium |FF_Boxed |FF_White;
    break;
  }

  for (player=0, ps=player_stat; player < config->num_player; player ++, ps++) {
    /* draw player names */
    if ( (config->team_mode != TM_Double) || (player < config->num_player/2) ) {
      draw_textbox(p_string[player].name,flag, score_player_box[box_set]+player);
    }
    /* set player animes */
    if (ps->team == last_team) {
      set_sprite_anime(ps->sprite, SpriteStopDown);
    } else if (ps->victories == num_victories) {
      set_sprite_anime(ps->sprite, SpriteStopDown);
    } else {
      set_sprite_anime(ps->sprite, SpriteLooser);
    }
    move_sprite (ps->sprite, ps->x, ps->y);
    set_sprite_mode (ps->sprite, SPM_MAPPED);
    /* draw "score" bombs */
    for (i = 0; i < player_stat[player].victories; i ++) {
      trophy[n_trophies ++] = create_bomb_sprite 
	(BB_NORMAL, (6+i)*BLOCK_WIDTH, ps->y + BLOCK_HEIGHT, 0, SPM_MAPPED);
    }
  }

  /* draw audience */
  if ( (config->num_player != 6) || (config->team_mode != TM_Single) ) {
    draw_audience (player_stat, config->num_player, last_team, 3, FALSE);
  } else {
    draw_audience (player_stat, config->num_player, last_team, 1, FALSE);
  }

  draw_all_sprites();

  level_start();

  flush_pixmap(FALSE);

  init_timer();
  clear_keys(config->num_player);
  count = 0;
  do {
    other_event();
    /* set winner animes */
    if (count < NUM_WINGAME_ANIME) {
      for (player=0,ps=player_stat; player < config->num_player; player++,ps++) {
	if (ps->team == last_team) {
	  set_sprite_anime(ps->sprite, wingame_animation[count]);
	} 
      }
    }
    /* animate audience */
    animate_audience();
    count ++;
  } while( (count <= NUM_WINGAME_ANIME) || !wait_eval_keys(config->num_player));

  if (num_victories == max_victories) {
    white_out();
  } else {
    fade_out();
  }

  /* delete audience sprites */
  delete_audience();
  
  /* delete all trophy sprites */
  while (n_trophies) {
    delete_sprite(trophy[--n_trophies]);
  }
}




/* local function winning the game */
#ifdef __STDC__
void 
winning_the_game (int last_team,
		  BMPlayer *player_stat,
		  PlayerStrings *p_string,
		  XBSettings *setup,
		  XBConfig *config)
#else
void 
winning_the_game (last_team, player_stat, p_string, setup, config)
     int last_team;
     BMPlayer *player_stat;
     PlayerStrings *p_string;
     XBSettings *setup;
     XBConfig *config;
#endif

{
  int player,pos,xpos;
  int i, count;
  BMPlayer *ps, *last_ps;

  last_ps = player_stat + last_team;

  /* load score board maze */
  load_maze(winningTheGame);

  /* draw maze in pixmap */
  game_time = 0;
  reset_status_bar(player_stat, get_level_name(winningTheGame), FALSE);
  draw_maze();

  /* draw audience */
  draw_audience (player_stat, config->num_player, last_team, 3, TRUE);

  /* draw player positions */
  pos = 0;
  for (player = 0; player < config->num_player; player ++) {
    if ( (config->team_mode == TM_Double) && (player == config->num_player/2) ) {
      pos ++;
    }
    if (player_stat[player].victories != last_ps->victories) {
      move_sprite (player_stat[player].sprite, player_stat[pos].x, 
		   player_stat[pos].y);
      set_sprite_mode (player_stat[player].sprite, SPM_MAPPED);
      if (0 != player_stat[player].victories) {
	set_sprite_anime (player_stat[player].sprite, SpriteLooser);
      } else {
	set_sprite_anime (player_stat[player].sprite, SpriteDamagedDown);
      }
      pos ++;
    } 
  }
  
  switch (config->team_mode) {
  case TM_Single:
    set_sprite_anime (last_ps->sprite, SpriteBigWinner);
    move_sprite (last_ps->sprite, (PIXW-BLOCK_WIDTH)/2, (PIXH-3*BLOCK_HEIGHT)/2);
    draw_textbox(p_string[last_team].name, FF_White|FF_Medium|FF_Boxed, 
		 &winner_box);
    break;
    
  case TM_Team:
  case TM_Double:
    xpos = (PIXW-4*BLOCK_WIDTH)/2;
    for (i=0, ps = player_stat; i<config->num_player; i++, ps++) {
      if (ps->team == last_team) {
	set_sprite_anime (ps->sprite, SpriteBigWinner);
	move_sprite (ps->sprite, xpos, (PIXH-3*BLOCK_HEIGHT)/2);
	xpos += 5*BLOCK_WIDTH/2;
      }
    }
    draw_textbox(p_string[last_team].name, FF_White|FF_Medium|FF_Boxed, 
		 &two_winner_box);
    break;
  }
  
  draw_all_sprites();

  if (setup->print_stat) {
    printf("GameStat {%s} {",p_string[last_team].name);
    for (player =0; player < config->num_player; player ++) {
      printf(" {%s} ",p_string[player].name);
    }
    printf("}\n");
  }

  init_timer();
  
  fade_in();

  flush_pixmap(FALSE);
  
  count = 0;
  do {
    if (0 == (count % 16)) {
      if (0 == (count % 32)) {
	if (count >= NUM_LAOLA_ANIME) {
	  set_message ("Press Space", TRUE);
	}
      } else {
	set_message (p_string[last_team].wingame, TRUE);
      }
    }
    other_event();
    animate_audience();
    count ++;
  } while ((count < NUM_LAOLA_ANIME) || 
	   (! wait_eval_keys(config->num_player) ) );

  fade_out();
}



/*
 * end of file intro.c
 */
