/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.style.SAXONFunction;
import com.icl.saxon.style.SAXONGroup;
import com.icl.saxon.style.XSLFallback;
import com.icl.saxon.style.XSLForEach;
import com.icl.saxon.style.XSLGeneralVariable;
import org.xml.sax.SAXException;

public class SAXONReturn
extends XSLGeneralVariable {
    public boolean isInstruction() {
        return true;
    }

    public void prepareAttributes() throws SAXException {
        String[] stringArray = new String[]{"select"};
        this.allowAttributes(stringArray);
        this.variableName = "#return-value#";
        String string = this.getAttributeValue("select");
        if (string != null) {
            this.select = Expression.make(string, this);
        }
    }

    public void validate() throws SAXException {
        NodeInfo nodeInfo = (NodeInfo)this.getParentNode();
        while (nodeInfo != null) {
            if (nodeInfo instanceof SAXONFunction) break;
            if (nodeInfo instanceof XSLForEach) {
                throw this.styleError("saxon:return may not be used within xsl:for-each");
            }
            if (nodeInfo instanceof SAXONGroup) {
                throw this.styleError("saxon:return may not be used within saxon:group");
            }
            nodeInfo = (NodeInfo)nodeInfo.getParentNode();
        }
        if (nodeInfo == null) {
            throw this.styleError("saxon:return must only be used within saxon:function");
        }
        NodeInfo nodeInfo2 = (NodeInfo)this.getNextSibling();
        if (nodeInfo2 != null && !(nodeInfo2 instanceof XSLFallback)) {
            throw this.styleError("saxon:return must be the last instruction in its template body");
        }
        if (this.select == null && this.getNumberOfChildren() == 0) {
            this.select = new StringValue("");
        }
    }

    public void process(Context context) throws SAXException {
        Value value = this.getSelectValue(context);
        context.setReturnValue(value);
    }
}

