/*
 *   Copyright (C) 2002-2004 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef	SunMoonPanel_H
#define	SunMoonPanel_H

#include "Sun.h"
#include "Moon.h"

#include <wx/wx.h>
#include <wx/datetime.h>

#ifdef __WINDOWS__
const int FONT1_SIZE = 35;
const int FONT2_SIZE = 16;
const int FONT3_SIZE = 10;
#else
const int FONT1_SIZE = 50;
const int FONT2_SIZE = 20;
const int FONT3_SIZE = 14;
#endif

enum textPos {
	Text_Left,
	Text_Right,
	Text_Centred
};

class CSunMoonPanel : public wxPanel, public wxTimer {

    public:
	CSunMoonPanel(wxWindow* parent, int id = -1, const wxPoint& pos = wxDefaultPosition, const wxSize& size = wxDefaultSize);
	virtual ~CSunMoonPanel();

	virtual bool setLocator(const wxString& locator);
	virtual void setFrequency(double frequency);

	virtual void onPaint(const wxPaintEvent& event);

	virtual void Notify();

    private:
	CSun      m_sun;
	CMoon     m_moon;
	wxBitmap* m_bitmap;
	int       m_width;
	int       m_height;

	void writeText(wxDC& dc, const wxString& text, int x, int y, enum textPos pos) const;

	DECLARE_EVENT_TABLE()
};

#endif
