/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.office;

import java.io.IOException;
import java.util.HashSet;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import sun.misc.BASE64Decoder;
import writer2latex.api.GraphicConverter;
import writer2latex.office.MIMETypes;
import writer2latex.office.SVMReader;
import writer2latex.util.Misc;
import writer2latex.xmerge.BinaryGraphicsDocument;
import writer2latex.xmerge.EmbeddedBinaryObject;
import writer2latex.xmerge.EmbeddedObject;
import writer2latex.xmerge.OfficeDocument;

public final class ImageLoader {
    private OfficeDocument oooDoc;
    private String sOutFileName;
    private int nImageCount = 0;
    private boolean bExtractEPS;
    private GraphicConverter gcv = null;
    private boolean bAcceptOtherFormats = true;
    private String sDefaultFormat = null;
    private HashSet acceptedFormats = new HashSet();

    public ImageLoader(OfficeDocument oooDoc, String sOutFileName, boolean bExtractEPS) {
        this.oooDoc = oooDoc;
        this.sOutFileName = sOutFileName;
        this.bExtractEPS = bExtractEPS;
    }

    public void setOutFileName(String sOutFileName) {
        this.sOutFileName = sOutFileName;
    }

    public void setAcceptOtherFormats(boolean b) {
        this.bAcceptOtherFormats = b;
    }

    public void setDefaultFormat(String sMime) {
        this.addAcceptedFormat(sMime);
        this.sDefaultFormat = sMime;
    }

    public void addAcceptedFormat(String sMime) {
        this.acceptedFormats.add(sMime);
    }

    private boolean isAcceptedFormat(String sMime) {
        return this.acceptedFormats.contains(sMime);
    }

    public void setGraphicConverter(GraphicConverter gcv) {
        this.gcv = gcv;
    }

    public BinaryGraphicsDocument getImage(Node node) {
        int[] offlen;
        String sMIME = null;
        String sExt = null;
        byte[] blob = null;
        String sHref = Misc.getAttribute(node, "xlink:href");
        if (sHref == null || sHref.length() == 0) {
            Element obd = Misc.getChildByTagName(node, "office:binary-data");
            if (obd != null) {
                StringBuffer buf = new StringBuffer();
                NodeList nl = obd.getChildNodes();
                int nLen = nl.getLength();
                int i = 0;
                while (i < nLen) {
                    if (nl.item(i).getNodeType() == 3) {
                        buf.append(nl.item(i).getNodeValue());
                    }
                    ++i;
                }
                try {
                    blob = new BASE64Decoder().decodeBuffer(buf.toString());
                }
                catch (IOException e) {
                    System.err.println("Oops - error converting base64");
                }
                sMIME = MIMETypes.getMagicMIMEType(blob);
                sExt = MIMETypes.getFileExtension(sMIME);
            }
        } else {
            EmbeddedObject obj;
            if (sHref.startsWith("#")) {
                sHref = sHref.substring(1);
            }
            if (sHref.startsWith("./")) {
                sHref = sHref.substring(2);
            }
            if ((obj = this.oooDoc.getEmbeddedObject(sHref)) != null && obj instanceof EmbeddedBinaryObject) {
                EmbeddedBinaryObject object = (EmbeddedBinaryObject)obj;
                blob = object.getBinaryData();
                sMIME = object.getType();
                sExt = MIMETypes.getFileExtension(sMIME);
            }
        }
        if (blob == null) {
            return null;
        }
        String sName = this.sOutFileName + "-img" + ++this.nImageCount;
        BinaryGraphicsDocument bgd = null;
        if (this.bExtractEPS && "image/x-svm".equals(MIMETypes.getMagicMIMEType(blob)) && SVMReader.readSVM(blob, offlen = new int[2])) {
            bgd = new BinaryGraphicsDocument(sName, ".eps", "image/x-eps");
            bgd.read(blob, offlen[0], offlen[1]);
        }
        if (bgd == null) {
            byte[] newBlob;
            if (this.gcv != null && this.sDefaultFormat != null && !this.isAcceptedFormat(sMIME) && this.gcv.supportsFormat(this.sDefaultFormat) && this.gcv.supportsFormat(sMIME) && (newBlob = this.gcv.convert(blob, sMIME, this.sDefaultFormat)) != null) {
                blob = newBlob;
                sMIME = this.sDefaultFormat;
                sExt = MIMETypes.getFileExtension(sMIME);
            }
            if (this.isAcceptedFormat(sMIME) || this.bAcceptOtherFormats) {
                bgd = new BinaryGraphicsDocument(sName, sExt, sMIME);
                bgd.read(blob);
            }
        }
        return bgd;
    }
}

