/* listviewdnd.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: listviewdnd.cc,v 1.10 2002/01/11 01:05:23 ralf Exp $ */

#include "listviewdnd.h"
#include "awindow.h"
#include "guielement.h"
#include "dndtext.h"

const char *ListViewDND::type="ListViewDND";

ListViewDND::~ListViewDND()
{
  removealldndtexts();
  delete dndtexts;
}

ListViewDND::ListViewDND(AGUIX *taguix):ListView(taguix)
{
  dndtexts=new List();
}

ListViewDND::ListViewDND(AGUIX *taguix,int tx,int ty,int width,int height,int tdata):ListView(taguix,tx,ty,width,height,tdata)
{
  dndtexts=new List();
}

void ListViewDND::handleSelect(Message *msg)
{
  if(msg->button==Button2) return;
  int j=-1;
  int dely;
  int elements=getElements();
  bool ende;
  int i;

  for(i=0;i<maxdisplayv;i++) {
    if(msg->window==subwins[i]) j=i;
  }
  if(j==-1) return;
  if((j+yoffset)>elements) return;

  if(quickAdd==true) return;

  int ch;
  if(font==NULL) ch=aguix->getCharHeight();
  else ch=font->getCharHeight();
  ListViewContent *tlvc,*firstselect;
  tlvc=vislvcs[j];
  bool state=tlvc->getSelect();
  state=(state==false)?true:false;
  tlvc->setSelect(state);
  tlvc->setActive(true);
  runSelectHandler(tlvc,j+yoffset);
  aguix->Flush();

  dely=j*ch;
  Message *tmsg;
  int newelement,element=j,my,elementh=ch;
  int dest,source;
  int selected=1;
  bool ignore4end = false;

  firstselect=tlvc;
  newelement=element;
  Time lasttime=0;
  for(ende=false;ende==false;) {
    tmsg=aguix->wait4messReact(MES_GET,false);
    if(tmsg!=NULL) {
      if(tmsg->type==ButtonRelease) {
        ende=true;
	lasttime=tmsg->time;

	my = tmsg->mousey;
	my += dely;
	newelement = my / elementh;
	if ( my < 0 ) newelement--;
	ignore4end = false;  // to allow apply new elementselection
      } else if((tmsg->type==MotionNotify)||(tmsg->type==EnterNotify)||(tmsg->type==LeaveNotify)) {
        Window root,child;
        int root_x,root_y,win_x,win_y;
        unsigned int keys_buttons;
        XQueryPointer(aguix->getDisplay(),msg->window,&root,&child,&root_x,&root_y,&win_x,
                      &win_y,&keys_buttons);
	if ( ( keys_buttons & Button1Mask ) == 0 ) {
	  // Release before Release-Msg from X
	  // this really happens
	  ignore4end = true;
	} else {
	  my=win_y;
	  my+=dely;
	  newelement=my/elementh;
	  if(my<0) newelement--;
	}
      } else if((tmsg->type==ButtonPress)&&(tmsg->button==Button3)) {
	int xw,yw,xr,yr;
	Window root,child;
	unsigned int keys_button;
	XQueryPointer(aguix->getDisplay(),win,&root,&child,&xr,&yr,&xw,&yw,&keys_button);
	tlvc=(ListViewContent*)lvcs->getElementAt(element+yoffset);
	if(tlvc!=NULL) {
	  int ti;
	  ti=(tlvc->getActive()==true)?2:0;
	  ti+=(tlvc->getSelect()==true)?1:0;
	  char *tstr=(char*)dndtexts->getElementAt(element+yoffset);
	  if(tstr==NULL) tstr=(char*)tlvc->getText();
  	  DNDText *dnd1=new DNDText(aguix,this,xw,yw,(void*)(element+yoffset),tstr,tlvc->getFG(ti),tlvc->getBG(ti),font);
	  dnd1->handler();
	  delete dnd1;
	}
        ende=true;
	lasttime=tmsg->time;
      }
      _freesafe(tmsg);
    } else {
      waittime(50);
      Window root,child;
      int root_x,root_y,win_x,win_y;
      unsigned int keys_buttons;
      XQueryPointer(aguix->getDisplay(),msg->window,&root,&child,&root_x,&root_y,&win_x,
                    &win_y,&keys_buttons);
      if ( ( keys_buttons & Button1Mask ) == 0 ) {
	// Release before Release-Msg from X
	// this really happens
	ignore4end = true;
      } else {
	my=win_y;
	my+=dely;
	newelement=my/elementh;
	if(my<0) newelement--;
      }
    }
    if ( ignore4end == false ) {
      if((element!=newelement)||(newelement<0)||(newelement>=maxdisplayv)) {
	dest=newelement;
	if(newelement<0) {
	  scrollV1(-1);
	  dest=0;
	  element++;
	} else if(newelement>=maxdisplayv) {
	  scrollV1(1);
	  dest=maxdisplayv-1;
	  element--;
	}
	source=element;
	if(source<0) source=0;
	if(source>=maxdisplayv) source=maxdisplayv-1;
	int starte,tende,dire;
	starte=source;
	tende=dest;
	if(starte<tende) {
	  starte++;
	  dire=1;
	} else if(starte>tende) {
	  starte--;
	  dire=-1;
	} else dire=0;
	// for i = starte to tende step dire
	for(i=starte;;i+=dire) {
	  if((i+yoffset)>=elements) break;
	  tlvc=vislvcs[i];
	  if(tlvc!=NULL) {
	    tlvc->setSelect(state);
	    runSelectHandler(tlvc,i+yoffset);
	    selected++;
	  }
	  if(i==tende) break;
	}
	element=dest;
	if((element+yoffset)>=elements) {
	  element=elements-yoffset-1;
	}
	tlvc=vislvcs[element];
	if(tlvc!=NULL) {
	  tlvc->setActive(true);
	  runSelectHandler(tlvc,element+yoffset);
	}
      }
    }
  }
  AGMessage *agmsg=(AGMessage*)_allocsafe(sizeof(AGMessage));
  agmsg->listview.lv=this;
  agmsg->listview.lvc=firstselect;
  agmsg->listview.time=lasttime;
  if(selected==1) {
    agmsg->type=AG_LISTVIEW_ONESELECT;
  } else {
    agmsg->type=AG_LISTVIEW_MULTISELECT;
  }
  aguix->putAGMsg(agmsg);
}

const char *ListViewDND::getType()
{
  return type;
}

bool ListViewDND::isType(const char *qtype)
{
  if(strcmp(type,qtype)==0) return true;
  return false;
}

void ListViewDND::removealldndtexts()
{
  int id=dndtexts->initEnum();
  char *tstr=(char*)dndtexts->getFirstElement(id);
  while(tstr!=NULL) {
    _freesafe(tstr);
    dndtexts->removeFirstElement();
    tstr=(char*)dndtexts->getFirstElement(id);
  }
  dndtexts->closeEnum(id);
}

void ListViewDND::removedndtextat(int index2)
{
  char *tstr=(char*)dndtexts->getElementAt(index2);
  dndtexts->removeElementAt(index2);
  if(tstr!=NULL) _freesafe(tstr);
}

void ListViewDND::replacedndtext(int index2,char *tstr)
{
  if((index2<0)||(index2>=dndtexts->size())) return;
  char *tstr2=(char*)dndtexts->exchangeElement(index2,dupstring(tstr));
  if(tstr2!=NULL) _freesafe(tstr2);
}

void ListViewDND::insertdndtext(int index2,char *tstr)
{
  dndtexts->addElementAt(index2,dupstring(tstr));
}

void ListViewDND::adddndtext(char *tstr)
{
  dndtexts->addElement(dupstring(tstr));
}

void ListViewDND::setSizeDNDText(int ns)
{
  int elems=dndtexts->size();
  char *tstr;
  while(elems<ns) {
    dndtexts->addElement(NULL);
    elems++;
  }
  while(elems>ns) {
    tstr=(char*)dndtexts->getElementAt(elems-1);
    dndtexts->removeElementAt(elems-1);
    elems--;
    if(tstr!=NULL) _freesafe(tstr);
  }
}
